/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.pgwire;

import io.questdb.MessageBus;
import io.questdb.cairo.CairoEngine;
import io.questdb.cutlass.pgwire.BadProtocolException;
import io.questdb.cutlass.pgwire.PGConnectionContext;
import io.questdb.cutlass.pgwire.PGWireConfiguration;
import io.questdb.cutlass.pgwire.TypesAndSelect;
import io.questdb.griffin.FunctionFactoryCache;
import io.questdb.griffin.SqlCompiler;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;
import io.questdb.network.PeerIsSlowToWriteException;
import io.questdb.std.AssociativeCache;
import io.questdb.std.Misc;
import io.questdb.std.WeakAutoClosableObjectPool;
import java.io.Closeable;

public class PGJobContext
implements Closeable {
    private final SqlCompiler compiler;
    private final AssociativeCache<TypesAndSelect> selectAndTypesCache;
    private final WeakAutoClosableObjectPool<TypesAndSelect> selectAndTypesPool;

    public PGJobContext(PGWireConfiguration configuration, CairoEngine engine, MessageBus messageBus, FunctionFactoryCache functionFactoryCache) {
        this.compiler = new SqlCompiler(engine, messageBus, functionFactoryCache);
        this.selectAndTypesCache = new AssociativeCache(configuration.getFactoryCacheColumnCount(), configuration.getFactoryCacheRowCount());
        this.selectAndTypesPool = new WeakAutoClosableObjectPool<TypesAndSelect>(TypesAndSelect::new, configuration.getFactoryCacheColumnCount() * configuration.getFactoryCacheRowCount());
    }

    @Override
    public void close() {
        Misc.free(this.compiler);
        Misc.free(this.selectAndTypesCache);
    }

    public void handleClientOperation(PGConnectionContext context, int operation) throws PeerIsSlowToWriteException, PeerIsSlowToReadException, PeerDisconnectedException, BadProtocolException {
        context.handleClientOperation(this.compiler, this.selectAndTypesCache, this.selectAndTypesPool, operation);
    }
}

