/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.CairoSecurityContext;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.TableStructure;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.TableWriterMetadata;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.vm.AppendOnlyVirtualMemory;
import io.questdb.cutlass.text.TextException;
import io.questdb.cutlass.text.TextLexer;
import io.questdb.cutlass.text.types.BadDateAdapter;
import io.questdb.cutlass.text.types.BadTimestampAdapter;
import io.questdb.cutlass.text.types.OtherToTimestampAdapter;
import io.questdb.cutlass.text.types.TimestampAdapter;
import io.questdb.cutlass.text.types.TimestampCompatibleAdapter;
import io.questdb.cutlass.text.types.TypeAdapter;
import io.questdb.cutlass.text.types.TypeManager;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.log.LogRecord;
import io.questdb.std.Chars;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectPool;
import io.questdb.std.str.DirectByteCharSequence;
import io.questdb.std.str.Path;
import java.io.Closeable;

public class CairoTextWriter
implements Closeable,
Mutable {
    private static final Log LOG = LogFactory.getLog(CairoTextWriter.class);
    private final CairoConfiguration configuration;
    private final CairoEngine engine;
    private final LongList columnErrorCounts = new LongList();
    private final AppendOnlyVirtualMemory appendMemory = new AppendOnlyVirtualMemory();
    private final Path path;
    private final TableStructureAdapter tableStructureAdapter = new TableStructureAdapter();
    private final TypeManager typeManager;
    private final ObjectPool<OtherToTimestampAdapter> otherToTimestampAdapterPool = new ObjectPool<OtherToTimestampAdapter>(OtherToTimestampAdapter::new, 4);
    private CharSequence tableName;
    private TableWriter writer;
    private long _size;
    private boolean overwrite;
    private boolean durable;
    private int atomicity;
    private int partitionBy;
    private int timestampIndex = -1;
    private CharSequence importedTimestampColumnName;
    private CharSequence designatedTimestampColumnName;
    private int designatedTimestampIndex;
    private ObjList<TypeAdapter> types;
    private final TextLexer.Listener nonPartitionedListener = this::onFieldsNonPartitioned;
    private TimestampAdapter timestampAdapter;
    private final TextLexer.Listener partitionedListener = this::onFieldsPartitioned;
    private int warnings;

    public CairoTextWriter(CairoEngine engine, Path path, TypeManager typeManager) {
        this.engine = engine;
        this.configuration = engine.getConfiguration();
        this.path = path;
        this.typeManager = typeManager;
    }

    @Override
    public void clear() {
        this.otherToTimestampAdapterPool.clear();
        this.writer = Misc.free(this.writer);
        this.columnErrorCounts.clear();
        this.timestampAdapter = null;
        this._size = 0L;
        this.warnings = 0;
        this.designatedTimestampColumnName = null;
        this.designatedTimestampIndex = -1;
        this.importedTimestampColumnName = null;
    }

    @Override
    public void close() {
        this.clear();
        this.appendMemory.close();
    }

    public void closeWriter() {
        this.writer = Misc.free(this.writer);
    }

    public void commit() {
        if (this.writer != null) {
            if (this.durable) {
                assert (false);
            } else {
                this.writer.commit();
            }
        }
    }

    public LongList getColumnErrorCounts() {
        return this.columnErrorCounts;
    }

    public RecordMetadata getMetadata() {
        return this.writer == null ? null : this.writer.getMetadata();
    }

    public int getPartitionBy() {
        return this.partitionBy;
    }

    public CharSequence getTableName() {
        return this.tableName;
    }

    public TextLexer.Listener getTextListener() {
        return this.timestampAdapter != null ? this.partitionedListener : this.nonPartitionedListener;
    }

    public CharSequence getTimestampCol() {
        return this.designatedTimestampColumnName;
    }

    public int getWarnings() {
        return this.warnings;
    }

    public long getWrittenLineCount() {
        return this.writer == null ? 0L : this.writer.size() - this._size;
    }

    public void of(CharSequence name, boolean overwrite, boolean durable, int atomicity, int partitionBy, CharSequence timestampIndexCol) {
        this.tableName = name;
        this.overwrite = overwrite;
        this.durable = durable;
        this.atomicity = atomicity;
        this.partitionBy = partitionBy;
        this.importedTimestampColumnName = timestampIndexCol;
    }

    public void onFieldsNonPartitioned(long line, ObjList<DirectByteCharSequence> values, int valuesLength) {
        TableWriter.Row w = this.writer.newRow();
        for (int i = 0; i < valuesLength; ++i) {
            DirectByteCharSequence dbcs = values.getQuick(i);
            if (dbcs.length() == 0 || !this.onField(line, dbcs, w, i)) continue;
            return;
        }
        w.append();
    }

    public void onFieldsPartitioned(long line, ObjList<DirectByteCharSequence> values, int valuesLength) {
        int timestampIndex = this.timestampIndex;
        DirectByteCharSequence dbcs = values.getQuick(timestampIndex);
        try {
            TableWriter.Row w = this.writer.newRow(this.timestampAdapter.getTimestamp(dbcs));
            for (int i = 0; i < valuesLength; ++i) {
                dbcs = values.getQuick(i);
                if (i == timestampIndex || dbcs.length() == 0 || !this.onField(line, dbcs, w, i)) continue;
                return;
            }
            w.append();
        }
        catch (Exception e) {
            this.logError(line, timestampIndex, dbcs);
        }
    }

    private void createTable(ObjList<CharSequence> names, ObjList<TypeAdapter> detectedTypes, CairoSecurityContext cairoSecurityContext) throws TextException {
        this.engine.createTable(cairoSecurityContext, this.appendMemory, this.path, this.tableStructureAdapter.of(names, detectedTypes));
        this.types = detectedTypes;
    }

    private void logError(long line, int i, DirectByteCharSequence dbcs) {
        LogRecord logRecord = LOG.error().$("type syntax [type=").$(ColumnType.nameOf(this.types.getQuick(i).getType())).$("]\n\t");
        logRecord.$('[').$(line).$(':').$(i).$("] -> ").$(dbcs).$();
        this.columnErrorCounts.increment(i);
    }

    private void logTypeError(int i) {
        LOG.info().$("mis-detected [table=").$(this.tableName).$(", column=").$(i).$(", type=").$(ColumnType.nameOf(this.types.getQuick(i).getType())).$(']').$();
    }

    private boolean onField(long line, DirectByteCharSequence dbcs, TableWriter.Row w, int i) {
        try {
            this.types.getQuick(i).write(w, i, dbcs);
        }
        catch (Exception ignore) {
            this.logError(line, i, dbcs);
            switch (this.atomicity) {
                case 0: {
                    this.writer.rollback();
                    throw CairoException.instance(0).put("bad syntax [line=").put(line).put(", col=").put(i).put(']');
                }
                case 1: {
                    w.cancel();
                    return true;
                }
            }
        }
        return false;
    }

    private TableWriter openWriterAndOverrideImportTypes(CairoSecurityContext cairoSecurityContext, ObjList<TypeAdapter> detectedTypes) {
        TableWriter writer = this.engine.getWriter(cairoSecurityContext, this.tableName);
        TableWriterMetadata metadata = writer.getMetadata();
        if (metadata.getColumnCount() < detectedTypes.size()) {
            writer.close();
            throw CairoException.instance(0).put("column count mismatch [textColumnCount=").put(detectedTypes.size()).put(", tableColumnCount=").put(metadata.getColumnCount()).put(", table=").put(this.tableName).put(']');
        }
        this.types = detectedTypes;
        int n = this.types.size();
        block5: for (int i = 0; i < n; ++i) {
            int columnType = metadata.getColumnType(i);
            TypeAdapter detectedAdapter = this.types.getQuick(i);
            int detectedType = detectedAdapter.getType();
            if (detectedType == columnType) continue;
            switch (columnType) {
                case 6: {
                    this.logTypeError(i);
                    this.types.setQuick(i, BadDateAdapter.INSTANCE);
                    continue block5;
                }
                case 7: {
                    if (detectedAdapter instanceof TimestampCompatibleAdapter) {
                        this.types.setQuick(i, this.otherToTimestampAdapterPool.next().of((TimestampCompatibleAdapter)detectedAdapter));
                        continue block5;
                    }
                    this.logTypeError(i);
                    this.types.setQuick(i, BadTimestampAdapter.INSTANCE);
                    continue block5;
                }
                case 13: {
                    writer.close();
                    throw CairoException.instance(0).put("cannot import text into BINARY column [index=").put(i).put(']');
                }
                default: {
                    this.types.setQuick(i, this.typeManager.getTypeAdapter(columnType));
                }
            }
        }
        return writer;
    }

    void prepareTable(CairoSecurityContext cairoSecurityContext, ObjList<CharSequence> names, ObjList<TypeAdapter> detectedTypes) throws TextException {
        assert (this.writer == null);
        if (detectedTypes.size() == 0) {
            throw CairoException.instance(0).put("cannot determine text structure");
        }
        switch (this.engine.getStatus(cairoSecurityContext, this.path, this.tableName)) {
            case 1: {
                this.createTable(names, detectedTypes, cairoSecurityContext);
                this.writer = this.engine.getWriter(cairoSecurityContext, this.tableName);
                break;
            }
            case 0: {
                if (this.overwrite) {
                    this.engine.remove(cairoSecurityContext, this.path, this.tableName);
                    this.createTable(names, detectedTypes, cairoSecurityContext);
                    this.writer = this.engine.getWriter(cairoSecurityContext, this.tableName);
                    break;
                }
                this.writer = this.openWriterAndOverrideImportTypes(cairoSecurityContext, detectedTypes);
                this.designatedTimestampColumnName = this.writer.getDesignatedTimestampColumnName();
                this.designatedTimestampIndex = this.writer.getMetadata().getTimestampIndex();
                if (this.importedTimestampColumnName != null && !Chars.equalsNc(this.importedTimestampColumnName, this.designatedTimestampColumnName)) {
                    this.warnings |= 1;
                }
                if (this.partitionBy != 3 && this.partitionBy != this.writer.getPartitionBy()) {
                    this.warnings |= 2;
                }
                this.partitionBy = this.writer.getPartitionBy();
                this.tableStructureAdapter.of(names, detectedTypes);
                break;
            }
            default: {
                throw CairoException.instance(0).put("name is reserved [table=").put(this.tableName).put(']');
            }
        }
        this._size = this.writer.size();
        this.columnErrorCounts.seed(this.writer.getMetadata().getColumnCount(), 0L);
        this.timestampAdapter = this.timestampIndex != -1 && this.types.getQuick(this.timestampIndex).getType() == 7 ? (TimestampAdapter)this.types.getQuick(this.timestampIndex) : null;
    }

    private class TableStructureAdapter
    implements TableStructure {
        private ObjList<CharSequence> names;
        private ObjList<TypeAdapter> types;

        private TableStructureAdapter() {
        }

        @Override
        public int getColumnCount() {
            return this.types.size();
        }

        @Override
        public CharSequence getColumnName(int columnIndex) {
            return this.names.getQuick(columnIndex);
        }

        @Override
        public int getColumnType(int columnIndex) {
            return this.types.getQuick(columnIndex).getType();
        }

        @Override
        public int getIndexBlockCapacity(int columnIndex) {
            return 0;
        }

        @Override
        public boolean isIndexed(int columnIndex) {
            return false;
        }

        @Override
        public boolean isSequential(int columnIndex) {
            return false;
        }

        @Override
        public int getPartitionBy() {
            return CairoTextWriter.this.partitionBy;
        }

        @Override
        public boolean getSymbolCacheFlag(int columnIndex) {
            return CairoTextWriter.this.configuration.getDefaultSymbolCacheFlag();
        }

        @Override
        public int getSymbolCapacity(int columnIndex) {
            return CairoTextWriter.this.configuration.getDefaultSymbolCapacity();
        }

        @Override
        public CharSequence getTableName() {
            return CairoTextWriter.this.tableName;
        }

        @Override
        public int getTimestampIndex() {
            return CairoTextWriter.this.timestampIndex;
        }

        @Override
        public int getO3MaxUncommittedRows() {
            return CairoTextWriter.this.configuration.getO3MaxUncommittedRows();
        }

        @Override
        public long getO3CommitHysteresisInMicros() {
            return CairoTextWriter.this.configuration.getO3CommitHysteresis();
        }

        TableStructureAdapter of(ObjList<CharSequence> names, ObjList<TypeAdapter> types) throws TextException {
            TypeAdapter timestampAdapter;
            this.names = names;
            this.types = types;
            if (CairoTextWriter.this.importedTimestampColumnName == null && CairoTextWriter.this.designatedTimestampColumnName == null) {
                CairoTextWriter.this.timestampIndex = -1;
            } else if (CairoTextWriter.this.importedTimestampColumnName != null) {
                CairoTextWriter.this.timestampIndex = names.indexOf(CairoTextWriter.this.importedTimestampColumnName);
                if (CairoTextWriter.this.timestampIndex == -1) {
                    throw TextException.$("invalid timestamp column '").put(CairoTextWriter.this.importedTimestampColumnName).put('\'');
                }
            } else {
                CairoTextWriter.this.timestampIndex = names.indexOf(CairoTextWriter.this.designatedTimestampColumnName);
                if (CairoTextWriter.this.timestampIndex == -1) {
                    CairoTextWriter.this.timestampIndex = CairoTextWriter.this.designatedTimestampIndex;
                }
            }
            if (CairoTextWriter.this.timestampIndex > -1 && ((timestampAdapter = types.getQuick(CairoTextWriter.this.timestampIndex)).getType() != 5 && timestampAdapter.getType() != 7 || timestampAdapter == BadTimestampAdapter.INSTANCE)) {
                throw TextException.$("not a timestamp '").put(CairoTextWriter.this.importedTimestampColumnName).put('\'');
            }
            return this;
        }
    }
}

