/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text;

import io.questdb.cutlass.text.TextConfiguration;
import io.questdb.cutlass.text.TextLexer;
import io.questdb.cutlass.text.types.TypeAdapter;
import io.questdb.cutlass.text.types.TypeManager;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.ObjList;
import io.questdb.std.str.DirectByteCharSequence;
import io.questdb.std.str.DirectCharSink;
import io.questdb.std.str.StringSink;
import java.io.Closeable;

public class TextMetadataDetector
implements TextLexer.Listener,
Mutable,
Closeable {
    private static final Log LOG = LogFactory.getLog(TextMetadataDetector.class);
    private final StringSink tempSink = new StringSink();
    private final ObjList<TypeAdapter> columnTypes = new ObjList();
    private final ObjList<CharSequence> columnNames = new ObjList();
    private final IntList _blanks = new IntList();
    private final IntList _histogram = new IntList();
    private final CharSequenceObjHashMap<TypeAdapter> schemaColumns = new CharSequenceObjHashMap();
    private final TypeManager typeManager;
    private final DirectCharSink utf8Sink;
    private int fieldCount;
    private boolean header = false;
    private boolean forceHeader = false;
    private CharSequence tableName;

    public TextMetadataDetector(TypeManager typeManager, TextConfiguration textConfiguration) {
        this.typeManager = typeManager;
        this.utf8Sink = new DirectCharSink(textConfiguration.getUtf8SinkSize());
    }

    @Override
    public void clear() {
        this.tempSink.clear();
        this.columnNames.clear();
        this._blanks.clear();
        this._histogram.clear();
        this.fieldCount = 0;
        this.header = false;
        this.columnTypes.clear();
        this.schemaColumns.clear();
        this.forceHeader = false;
    }

    @Override
    public void close() {
        Misc.free(this.utf8Sink);
    }

    public void evaluateResults(long lineCount, long errorCount) {
        int i;
        if (this.calcTypes(lineCount - errorCount, true) && !this.calcTypes(lineCount - errorCount - 1L, false) || this.forceHeader) {
            this.header = true;
        } else {
            LOG.info().$("no header [table=").$(this.tableName).$(", lineCount=").$(lineCount).$(", errorCount=").$(errorCount).$(", forceHeader=").$(this.forceHeader).$(']').$();
        }
        for (i = 0; i < this.fieldCount; ++i) {
            if (this.header && this.columnNames.getQuick(i).length() != 0) continue;
            this.tempSink.clear();
            this.tempSink.put('f').put(i);
            this.columnNames.setQuick(i, this.tempSink.toString());
        }
        if (this.schemaColumns.size() > 0) {
            int k = this.columnNames.size();
            for (i = 0; i < k; ++i) {
                TypeAdapter type = this.schemaColumns.get(this.columnNames.getQuick(i));
                if (type == null) continue;
                this.columnTypes.setQuick(i, type);
            }
        }
    }

    public boolean isHeader() {
        return this.header;
    }

    public void of(ObjList<CharSequence> names, ObjList<TypeAdapter> types, boolean forceHeader) {
        this.clear();
        if (names != null && types != null) {
            int n = names.size();
            assert (n == types.size());
            for (int i = 0; i < n; ++i) {
                this.schemaColumns.put(names.getQuick(i), types.getQuick(i));
            }
        }
        this.forceHeader = forceHeader;
    }

    @Override
    public void onFields(long line, ObjList<DirectByteCharSequence> values, int fieldCount) {
        if (line == 0L) {
            this.seedFields(fieldCount);
            this.stashPossibleHeader(values, fieldCount);
        }
        int count = this.typeManager.getProbeCount();
        for (int i = 0; i < fieldCount; ++i) {
            DirectByteCharSequence cs = values.getQuick(i);
            if (cs.length() == 0) {
                this._blanks.increment(i);
            }
            int offset = i * count;
            for (int k = 0; k < count; ++k) {
                TypeAdapter probe = this.typeManager.getProbe(k);
                if (!probe.probe(cs)) continue;
                this._histogram.increment(k + offset);
            }
        }
    }

    private boolean calcTypes(long count, boolean setDefault) {
        boolean allStrings = true;
        int probeCount = this.typeManager.getProbeCount();
        for (int i = 0; i < this.fieldCount; ++i) {
            int offset = i * probeCount;
            int blanks = this._blanks.getQuick(i);
            boolean unprobed = true;
            for (int k = 0; k < probeCount; ++k) {
                if ((long)(this._histogram.getQuick(k + offset) + blanks) != count || (long)blanks >= count) continue;
                unprobed = false;
                this.columnTypes.setQuick(i, this.typeManager.getProbe(k));
                if (!allStrings) break;
                allStrings = false;
                break;
            }
            if (!setDefault || !unprobed) continue;
            this.columnTypes.setQuick(i, this.typeManager.getTypeAdapter(10));
        }
        return allStrings;
    }

    ObjList<CharSequence> getColumnNames() {
        return this.columnNames;
    }

    ObjList<TypeAdapter> getColumnTypes() {
        return this.columnTypes;
    }

    private String normalise(CharSequence seq) {
        boolean capNext = false;
        this.tempSink.clear();
        int l = seq.length();
        block4: for (int i = 0; i < l; ++i) {
            char c = seq.charAt(i);
            switch (c) {
                case '\u0000': 
                case ' ': 
                case '\"': 
                case '%': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case '?': 
                case '\\': 
                case '~': {
                    capNext = true;
                }
                case '\ufeff': {
                    continue block4;
                }
                default: {
                    if (this.tempSink.length() == 0 && Character.isDigit(c)) {
                        this.tempSink.put('_');
                    }
                    if (capNext) {
                        this.tempSink.put(Character.toUpperCase(c));
                        capNext = false;
                        continue block4;
                    }
                    this.tempSink.put(c);
                }
            }
        }
        return Chars.toString(this.tempSink);
    }

    private void seedFields(int count) {
        this.fieldCount = count;
        this._histogram.setAll(this.fieldCount * this.typeManager.getProbeCount(), 0);
        this._blanks.setAll(count, 0);
        this.columnTypes.extendAndSet(count - 1, null);
        this.columnNames.setAll(count, "");
    }

    void setTableName(CharSequence tableName) {
        this.tableName = tableName;
    }

    private void stashPossibleHeader(ObjList<DirectByteCharSequence> values, int hi) {
        for (int i = 0; i < hi; ++i) {
            DirectByteCharSequence value = values.getQuick(i);
            this.utf8Sink.clear();
            if (Chars.utf8Decode(value.getLo(), value.getHi(), this.utf8Sink)) {
                this.columnNames.setQuick(i, this.normalise(this.utf8Sink));
                continue;
            }
            LOG.info().$("utf8 error [table=").$(this.tableName).$(", line=0, col=").$(i).$(']').$();
        }
    }
}

