/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.griffin.CharacterStoreEntry;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.ObjectPool;
import io.questdb.std.str.AbstractCharSequence;
import io.questdb.std.str.AbstractCharSink;
import io.questdb.std.str.CharSink;

public class CharacterStore
extends AbstractCharSink
implements CharacterStoreEntry,
Mutable {
    private static final Log LOG = LogFactory.getLog(CharacterStore.class);
    private final ObjectPool<NameAssemblerCharSequence> csPool;
    private int capacity;
    private char[] chars;
    private int size = 0;
    private NameAssemblerCharSequence next = null;

    public CharacterStore(int capacity, int poolCapacity) {
        this.capacity = capacity;
        this.chars = new char[Numbers.ceilPow2(capacity)];
        this.csPool = new ObjectPool<NameAssemblerCharSequence>(() -> new NameAssemblerCharSequence(), poolCapacity);
    }

    @Override
    public int length() {
        return this.size;
    }

    @Override
    public CharSequence toImmutable() {
        this.next.hi = this.size;
        return this.next;
    }

    @Override
    public void trimTo(int size) {
        this.size = size;
    }

    public CharacterStoreEntry newEntry() {
        this.next = this.csPool.next();
        this.next.lo = this.size;
        return this;
    }

    @Override
    public CharSink put(CharSequence cs) {
        assert (cs != null);
        return this.put(cs, 0, cs.length());
    }

    @Override
    public CharSink put(CharSequence cs, int lo, int hi) {
        for (int i = lo; i < hi; ++i) {
            this.put(cs.charAt(i));
        }
        return this;
    }

    @Override
    public CharSink put(char c) {
        if (this.size < this.capacity) {
            this.chars[this.size++] = c;
        } else {
            this.resizeAndPut(c);
        }
        return this;
    }

    @Override
    public CharSink put(char[] chars, int start, int len) {
        for (int i = 0; i < len; ++i) {
            this.put(chars[start + i]);
        }
        return this;
    }

    private void resizeAndPut(char c) {
        char[] next = new char[this.capacity * 2];
        System.arraycopy(this.chars, 0, next, 0, this.capacity);
        this.chars = next;
        this.capacity *= 2;
        this.chars[this.size++] = c;
        LOG.info().$("resize [capacity=").$(this.capacity).$(']').$();
    }

    @Override
    public void clear() {
        this.csPool.clear();
        this.size = 0;
        this.next = null;
    }

    public class NameAssemblerCharSequence
    extends AbstractCharSequence
    implements Mutable {
        int lo;
        int hi;

        @Override
        public void clear() {
        }

        @Override
        public int length() {
            return this.hi - this.lo;
        }

        @Override
        public char charAt(int index) {
            return CharacterStore.this.chars[this.lo + index];
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            NameAssemblerCharSequence that = (NameAssemblerCharSequence)CharacterStore.this.csPool.next();
            that.lo = this.lo + start;
            that.hi = this.lo + end;
            assert (that.lo < that.hi);
            return that;
        }
    }
}

