/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.ColumnType;
import io.questdb.griffin.CharacterStore;
import io.questdb.griffin.CharacterStoreEntry;
import io.questdb.griffin.ExpressionParserListener;
import io.questdb.griffin.OperatorExpression;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlKeywords;
import io.questdb.griffin.SqlParser;
import io.questdb.griffin.SqlUtil;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.std.Chars;
import io.questdb.std.GenericLexer;
import io.questdb.std.IntHashSet;
import io.questdb.std.IntStack;
import io.questdb.std.LowerCaseAsciiCharSequenceIntHashMap;
import io.questdb.std.LowerCaseAsciiCharSequenceObjHashMap;
import io.questdb.std.ObjStack;
import io.questdb.std.ObjectPool;

class ExpressionParser {
    private static final IntHashSet nonLiteralBranches = new IntHashSet();
    private static final int BRANCH_NONE = 0;
    private static final int BRANCH_COMMA = 1;
    private static final int BRANCH_LEFT_BRACE = 2;
    private static final int BRANCH_RIGHT_BRACE = 3;
    private static final int BRANCH_CONSTANT = 4;
    private static final int BRANCH_OPERATOR = 5;
    private static final int BRANCH_LITERAL = 6;
    private static final int BRANCH_LAMBDA = 7;
    private static final int BRANCH_CASE_START = 9;
    private static final int BRANCH_CASE_CONTROL = 10;
    private static final int BRANCH_CAST_AS = 11;
    private static final int BRANCH_DOT = 12;
    private static final int BRANCH_BETWEEN_START = 13;
    private static final int BRANCH_BETWEEN_END = 14;
    private static final int BRANCH_LEFT_BRACKET = 15;
    private static final int BRANCH_RIGHT_BRACKET = 16;
    private static final int BRANCH_DOT_DEREFERENCE = 17;
    private static final LowerCaseAsciiCharSequenceIntHashMap caseKeywords = new LowerCaseAsciiCharSequenceIntHashMap();
    private static final LowerCaseAsciiCharSequenceObjHashMap<CharSequence> allFunctions = new LowerCaseAsciiCharSequenceObjHashMap();
    private final ObjStack<ExpressionNode> opStack = new ObjStack();
    private final IntStack paramCountStack = new IntStack();
    private final IntStack argStackDepthStack = new IntStack();
    private final IntStack castBraceCountStack = new IntStack();
    private final IntStack caseBraceCountStack = new IntStack();
    private final IntStack braceCountStack = new IntStack();
    private final IntStack bracketCountStack = new IntStack();
    private final IntStack backupParamCountStack = new IntStack();
    private final IntStack backupArgStackDepthStack = new IntStack();
    private final IntStack backupCastBraceCountStack = new IntStack();
    private final IntStack backupCaseBraceCountStack = new IntStack();
    private final ObjectPool<ExpressionNode> expressionNodePool;
    private final SqlParser sqlParser;
    private final CharacterStore characterStore;

    ExpressionParser(ObjectPool<ExpressionNode> expressionNodePool, SqlParser sqlParser, CharacterStore characterStore) {
        this.expressionNodePool = expressionNodePool;
        this.sqlParser = sqlParser;
        this.characterStore = characterStore;
    }

    private static SqlException missingArgs(int position) {
        return SqlException.$(position, "missing arguments");
    }

    private int copyToBackup(IntStack paramCountStack, IntStack backupParamCountStack) {
        int size = paramCountStack.size();
        paramCountStack.copyTo(backupParamCountStack, size);
        return size;
    }

    private boolean isCount() {
        return this.opStack.size() == 2 && Chars.equals(this.opStack.peek().token, '(') && SqlKeywords.isCountKeyword(this.opStack.peek((int)1).token);
    }

    private boolean isTypeQualifier() {
        return this.opStack.size() >= 2 && SqlKeywords.isColonColonKeyword(this.opStack.peek((int)1).token);
    }

    private int onNode(ExpressionParserListener listener, ExpressionNode node, int argStackDepth) throws SqlException {
        if (argStackDepth < node.paramCount) {
            throw SqlException.position(node.position).put("too few arguments for '").put(node.token).put("' [found=").put(argStackDepth).put(",expected=").put(node.paramCount).put(']');
        }
        listener.onNode(node);
        return argStackDepth - node.paramCount + 1;
    }

    void parseExpr(GenericLexer lexer, ExpressionParserListener listener) throws SqlException {
        try {
            ExpressionNode node;
            CharSequence tok;
            int paramCount = 0;
            int braceCount = 0;
            int bracketCount = 0;
            int betweenCount = 0;
            int betweenAndCount = 0;
            int caseCount = 0;
            int argStackDepth = 0;
            int castAsCount = 0;
            int betweenStartCaseCount = 0;
            int thisBranch = 0;
            boolean asPoppedNull = false;
            block32: while ((tok = SqlUtil.fetchNext(lexer)) != null) {
                char thisChar = tok.charAt(0);
                int prevBranch = thisBranch;
                boolean processDefaultBranch = false;
                int position = lexer.lastTokenPosition();
                switch (thisChar) {
                    case '+': 
                    case '-': {
                        char c;
                        processDefaultBranch = true;
                        if (prevBranch != 4 || position <= 0 || (c = lexer.getContent().charAt(position - 1)) != 'e' && c != 'E') break;
                        ExpressionNode en = this.opStack.peek();
                        ((GenericLexer.FloatingSequence)en.token).setHi(position + 1);
                        processDefaultBranch = false;
                        break;
                    }
                    case '.': {
                        if (thisBranch == 6 || thisBranch == 4) {
                            char c = lexer.getContent().charAt(position - 1);
                            if (GenericLexer.WHITESPACE_CH.contains(c)) {
                                lexer.unparse();
                                break block32;
                            }
                            if (Chars.isQuote(c)) {
                                ExpressionNode en = this.opStack.pop();
                                CharacterStoreEntry cse = this.characterStore.newEntry();
                                cse.put(GenericLexer.unquote(en.token)).put('.');
                                this.opStack.push(this.expressionNodePool.next().of(4, cse.toImmutable(), Integer.MIN_VALUE, en.position));
                            } else {
                                ExpressionNode en = this.opStack.peek();
                                ((GenericLexer.FloatingSequence)en.token).setHi(position + 1);
                            }
                        }
                        if (prevBranch == 12 || prevBranch == 17) {
                            throw SqlException.$(position, "too many dots");
                        }
                        if (prevBranch == 3) {
                            thisBranch = 17;
                            break;
                        }
                        thisBranch = 12;
                        break;
                    }
                    case ',': {
                        if (prevBranch == 1 || prevBranch == 2) {
                            throw ExpressionParser.missingArgs(position);
                        }
                        thisBranch = 1;
                        if (braceCount == 0) {
                            lexer.unparse();
                            break block32;
                        }
                        if (this.castBraceCountStack.peek() == braceCount) {
                            throw SqlException.$(position, "',' is not expected here");
                        }
                        while ((node = this.opStack.pop()) != null && node.token.charAt(0) != '(') {
                            argStackDepth = this.onNode(listener, node, argStackDepth);
                        }
                        if (node != null) {
                            this.opStack.push(node);
                        }
                        ++paramCount;
                        break;
                    }
                    case '[': {
                        ExpressionNode other;
                        if (this.isTypeQualifier()) {
                            ExpressionNode en = this.opStack.peek();
                            ((GenericLexer.FloatingSequence)en.token).setHi(position + 1);
                            break;
                        }
                        thisBranch = 15;
                        this.paramCountStack.push(paramCount);
                        paramCount = 0;
                        this.argStackDepthStack.push(argStackDepth);
                        argStackDepth = 0;
                        while ((other = this.opStack.peek()) != null && 2 > other.precedence) {
                            argStackDepth = this.onNode(listener, other, argStackDepth);
                            this.opStack.pop();
                        }
                        this.opStack.push(this.expressionNodePool.next().of(16, "[", Integer.MAX_VALUE, position));
                        ++bracketCount;
                        this.braceCountStack.push(braceCount);
                        braceCount = 0;
                        break;
                    }
                    case ']': {
                        if (this.isTypeQualifier()) {
                            ExpressionNode en = this.opStack.peek();
                            ((GenericLexer.FloatingSequence)en.token).setHi(position + 1);
                            break;
                        }
                        if (bracketCount == 0) {
                            lexer.unparse();
                            break block32;
                        }
                        thisBranch = 16;
                        if (prevBranch == 15) {
                            throw SqlException.$(position, "missing array index");
                        }
                        --bracketCount;
                        while ((node = this.opStack.pop()) != null && (node.type != 16 || node.token.charAt(0) != '[')) {
                            argStackDepth = this.onNode(listener, node, argStackDepth);
                        }
                        if (this.argStackDepthStack.notEmpty()) {
                            argStackDepth += this.argStackDepthStack.pop();
                        }
                        if (this.paramCountStack.notEmpty()) {
                            paramCount = this.paramCountStack.pop();
                        }
                        if (this.braceCountStack.notEmpty()) {
                            braceCount = this.braceCountStack.pop();
                        }
                        node = this.expressionNodePool.next().of(9, "[]", 2, position);
                        node.paramCount = 2;
                        this.opStack.push(node);
                        break;
                    }
                    case '(': {
                        if (prevBranch == 3) {
                            throw SqlException.$(position, "not a method call");
                        }
                        thisBranch = 2;
                        this.paramCountStack.push(paramCount);
                        paramCount = 0;
                        this.argStackDepthStack.push(argStackDepth);
                        argStackDepth = 0;
                        this.bracketCountStack.push(bracketCount);
                        bracketCount = 0;
                        this.opStack.push(this.expressionNodePool.next().of(16, "(", Integer.MAX_VALUE, position));
                        if (this.castBraceCountStack.size() > 0 && this.castBraceCountStack.peek() == -1) {
                            this.castBraceCountStack.update(braceCount + 1);
                        }
                        ++braceCount;
                        break;
                    }
                    case ')': {
                        boolean thisWasCast;
                        int localParamCount;
                        if (prevBranch == 1) {
                            throw ExpressionParser.missingArgs(position);
                        }
                        if (braceCount == 0) {
                            lexer.unparse();
                            break block32;
                        }
                        thisBranch = 3;
                        int n = localParamCount = prevBranch == 2 ? 0 : paramCount + 1;
                        if (this.castBraceCountStack.size() > 0 && this.castBraceCountStack.peek() == braceCount) {
                            if (castAsCount == 0) {
                                throw SqlException.$(position, "'as' missing");
                            }
                            --castAsCount;
                            this.castBraceCountStack.pop();
                            thisWasCast = true;
                        } else {
                            thisWasCast = false;
                        }
                        --braceCount;
                        while ((node = this.opStack.pop()) != null && node.token.charAt(0) != '(') {
                            if (Chars.equals(node.token, '*') && argStackDepth == 0 && this.isCount()) {
                                argStackDepth = this.onNode(listener, node, 2);
                                continue;
                            }
                            if (thisWasCast) {
                                int columnType = ColumnType.columnTypeOf(node.token);
                                if (!(columnType >= 0 && columnType <= 12 || asPoppedNull)) {
                                    throw SqlException.$(node.position, "invalid type");
                                }
                                node.type = 2;
                            }
                            argStackDepth = this.onNode(listener, node, argStackDepth);
                        }
                        if (this.argStackDepthStack.notEmpty()) {
                            argStackDepth += this.argStackDepthStack.pop();
                        }
                        if ((node = this.opStack.peek()) != null && (node.type == 4 || node.type == 32)) {
                            if (!SqlKeywords.isBetweenKeyword(node.token) || betweenCount == betweenAndCount) {
                                node.paramCount = localParamCount + Math.max(0, node.paramCount - 1);
                                node.type = 8;
                                argStackDepth = this.onNode(listener, node, argStackDepth);
                                this.opStack.pop();
                            }
                        } else if (localParamCount > 1 && (node = this.opStack.peek()) != null && node.token.charAt(0) == '(') {
                            throw SqlException.$(position, "no function or operator?");
                        }
                        if (this.paramCountStack.notEmpty()) {
                            paramCount = this.paramCountStack.pop();
                        }
                        if (!this.bracketCountStack.notEmpty()) break;
                        bracketCount = this.bracketCountStack.pop();
                        break;
                    }
                    case 'C': 
                    case 'c': {
                        if (SqlKeywords.isCastKeyword(tok)) {
                            if (prevBranch != 17) {
                                this.castBraceCountStack.push(-1);
                                thisBranch = 5;
                                this.opStack.push(this.expressionNodePool.next().of(4, "cast", Integer.MIN_VALUE, position));
                                break;
                            }
                            throw SqlException.$(position, "'cast' is not allowed here");
                        }
                        processDefaultBranch = true;
                        break;
                    }
                    case 'A': 
                    case 'a': {
                        if (SqlKeywords.isAsKeyword(tok)) {
                            if (castAsCount < this.castBraceCountStack.size()) {
                                thisBranch = 11;
                                int nodeCount = 0;
                                while ((node = this.opStack.pop()) != null && node.token.charAt(0) != '(') {
                                    ++nodeCount;
                                    asPoppedNull = SqlKeywords.isNullKeyword(node.token);
                                    argStackDepth = this.onNode(listener, node, argStackDepth);
                                }
                                if (nodeCount != 1) {
                                    asPoppedNull = false;
                                }
                                if (node != null) {
                                    this.opStack.push(node);
                                }
                                ++paramCount;
                                ++castAsCount;
                                break;
                            }
                            processDefaultBranch = true;
                            break;
                        }
                        if (SqlKeywords.isAndKeyword(tok)) {
                            if (caseCount == betweenStartCaseCount && betweenCount > betweenAndCount) {
                                ++betweenAndCount;
                                thisBranch = 14;
                                while ((node = this.opStack.pop()) != null && !SqlKeywords.isBetweenKeyword(node.token)) {
                                    argStackDepth = this.onNode(listener, node, argStackDepth);
                                }
                                if (node == null) break;
                                this.opStack.push(node);
                                break;
                            }
                            processDefaultBranch = true;
                            break;
                        }
                        if (SqlKeywords.isAllKeyword(tok)) {
                            ExpressionNode operator = this.opStack.peek();
                            if (operator == null || operator.type != 1) {
                                throw SqlException.$(position, "missing operator");
                            }
                            CharSequence funcName = allFunctions.get(operator.token);
                            if (funcName != null && operator.paramCount == 2) {
                                operator.type = 8;
                                operator.token = funcName;
                                break;
                            }
                            throw SqlException.$(operator.position, "unexpected operator");
                        }
                        processDefaultBranch = true;
                        break;
                    }
                    case 'B': 
                    case 'b': {
                        if (SqlKeywords.isBetweenKeyword(tok)) {
                            thisBranch = 13;
                            if (betweenCount > betweenAndCount) {
                                throw SqlException.$(position, "between statements cannot be nested");
                            }
                            ++betweenCount;
                            betweenStartCaseCount = caseCount;
                        }
                        processDefaultBranch = true;
                        break;
                    }
                    case 'S': 
                    case 's': {
                        if (SqlKeywords.isSelectKeyword(tok)) {
                            thisBranch = 7;
                            if (betweenCount > 0) {
                                throw SqlException.$(position, "constant expected");
                            }
                            argStackDepth = this.processLambdaQuery(lexer, listener, argStackDepth);
                            break;
                        }
                        processDefaultBranch = true;
                        break;
                    }
                    case '\'': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                    case 'E': {
                        if (prevBranch != 17) {
                            char prevChar;
                            if (thisChar == 'E' && (tok.length() < 3 || tok.charAt(1) != '\'')) {
                                processDefaultBranch = true;
                                break;
                            }
                            thisBranch = 4;
                            if (prevBranch == 4 && position > 0 && ((prevChar = lexer.getContent().charAt(position - 1)) == '-' || prevChar == '+')) {
                                ExpressionNode en = this.opStack.peek();
                                if (en.token instanceof GenericLexer.FloatingSequence) {
                                    ((GenericLexer.FloatingSequence)en.token).setHi(lexer.getTokenHi());
                                    break;
                                }
                            }
                            if (prevBranch == 12) {
                                ExpressionNode en = this.opStack.peek();
                                if (en != null && en.type != 16 && en.type != 1) {
                                    if (position > 0 && lexer.getContent().charAt(position - 1) == '.') {
                                        if (en.token instanceof GenericLexer.FloatingSequence) {
                                            ((GenericLexer.FloatingSequence)en.token).setHi(lexer.getTokenHi());
                                            break;
                                        }
                                        this.opStack.pop();
                                        CharacterStoreEntry cse = this.characterStore.newEntry();
                                        cse.put(en.token).put(GenericLexer.unquote(tok));
                                        this.opStack.push(this.expressionNodePool.next().of(4, cse.toImmutable(), Integer.MIN_VALUE, en.position));
                                        break;
                                    }
                                } else {
                                    this.opStack.push(this.expressionNodePool.next().of(2, lexer.immutableBetween(position - 1, lexer.getTokenHi()), 0, position));
                                    break;
                                }
                            }
                            if (prevBranch != 12 && nonLiteralBranches.excludes(prevBranch)) {
                                this.opStack.push(this.expressionNodePool.next().of(2, GenericLexer.immutableOf(tok), 0, position));
                                break;
                            }
                            if (this.opStack.size() > 1) {
                                throw SqlException.$(position, "dangling expression");
                            }
                            lexer.unparse();
                            break block32;
                        }
                        throw SqlException.$(position, "constant is not allowed here");
                    }
                    case 'N': 
                    case 'n': {
                        ExpressionNode nn;
                        if (SqlKeywords.isNotKeyword(tok) && (nn = this.opStack.peek()) != null && nn.type == 4) {
                            this.opStack.pop();
                            node = this.expressionNodePool.next().of(1, GenericLexer.immutableOf(tok), 11, position);
                            node.paramCount = 1;
                            this.opStack.push(node);
                            this.opStack.push(nn);
                            break;
                        }
                    }
                    case 'F': 
                    case 'T': 
                    case 'f': 
                    case 't': {
                        if (SqlKeywords.isNanKeyword(tok) || SqlKeywords.isNullKeyword(tok) || SqlKeywords.isTrueKeyword(tok) || SqlKeywords.isFalseKeyword(tok)) {
                            if (prevBranch != 17) {
                                thisBranch = 4;
                                this.opStack.push(this.expressionNodePool.next().of(2, GenericLexer.immutableOf(tok), 0, position));
                                break;
                            }
                            throw SqlException.$(position, "constant is not allowed here");
                        }
                        processDefaultBranch = true;
                        break;
                    }
                    case '*': {
                        if (prevBranch == 12) {
                            thisBranch = 6;
                            ExpressionNode en = this.opStack.peek();
                            if (en != null && en.type != 16) {
                                GenericLexer.FloatingSequence fs = (GenericLexer.FloatingSequence)en.token;
                                if (GenericLexer.WHITESPACE_CH.excludes(lexer.getContent().charAt(position - 1))) {
                                    fs.setHi(position + 1);
                                    break;
                                }
                                processDefaultBranch = true;
                                break;
                            }
                            this.opStack.push(this.expressionNodePool.next().of(2, lexer.immutableBetween(position - 1, lexer.getTokenHi()), 0, position));
                            break;
                        }
                    }
                    default: {
                        processDefaultBranch = true;
                    }
                }
                if (!processDefaultBranch) continue;
                OperatorExpression op = OperatorExpression.opMap.get(tok);
                if (op != null) {
                    ExpressionNode other;
                    thisBranch = 5;
                    int operatorType = op.type;
                    if (thisChar == '-') {
                        switch (prevBranch) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 5: 
                            case 10: {
                                operatorType = 1;
                                break;
                            }
                        }
                    }
                    while ((other = this.opStack.peek()) != null) {
                        boolean greaterPrecedence;
                        boolean bl = greaterPrecedence = op.leftAssociative && op.precedence >= other.precedence || !op.leftAssociative && op.precedence > other.precedence;
                        if (!greaterPrecedence || operatorType == 1 && (operatorType != 1 || other.paramCount != 1)) break;
                        argStackDepth = this.onNode(listener, other, argStackDepth);
                        this.opStack.pop();
                    }
                    node = this.expressionNodePool.next().of(op.type == 3 ? 32 : 1, op.token, op.precedence, position);
                    node.paramCount = operatorType == 1 ? 1 : (SqlKeywords.isBetweenKeyword(node.token) ? 3 : 2);
                    this.opStack.push(node);
                    continue;
                }
                if (caseCount > 0 || nonLiteralBranches.excludes(thisBranch)) {
                    if (Chars.toLowerCaseAscii(thisChar) == 'c' && SqlKeywords.isCaseKeyword(tok)) {
                        if (prevBranch != 17) {
                            ++caseCount;
                            this.paramCountStack.push(paramCount);
                            paramCount = 0;
                            this.caseBraceCountStack.push(braceCount);
                            braceCount = 0;
                            this.argStackDepthStack.push(argStackDepth);
                            argStackDepth = 0;
                            this.opStack.push(this.expressionNodePool.next().of(8, "case", Integer.MAX_VALUE, position));
                            thisBranch = 9;
                            continue;
                        }
                        throw SqlException.$(position, "'case' is not allowed here");
                    }
                    thisBranch = 6;
                    if (caseCount > 0) {
                        switch (Chars.toLowerCaseAscii(thisChar)) {
                            case 'e': {
                                if (SqlKeywords.isEndKeyword(tok)) {
                                    if (prevBranch == 10) {
                                        throw ExpressionParser.missingArgs(position);
                                    }
                                    if (paramCount == 0) {
                                        throw SqlException.$(position, "'when' expected");
                                    }
                                    while ((node = this.opStack.pop()) != null && !SqlKeywords.isCaseKeyword(node.token)) {
                                        argStackDepth = this.onNode(listener, node, argStackDepth);
                                    }
                                    if (this.argStackDepthStack.notEmpty()) {
                                        argStackDepth += this.argStackDepthStack.pop();
                                    }
                                    if (this.caseBraceCountStack.notEmpty()) {
                                        braceCount = this.caseBraceCountStack.pop();
                                    }
                                    node.paramCount = paramCount;
                                    argStackDepth = this.onNode(listener, node, argStackDepth + paramCount);
                                    if (this.paramCountStack.notEmpty()) {
                                        paramCount = this.paramCountStack.pop();
                                    }
                                    --caseCount;
                                    continue block32;
                                }
                            }
                            case 't': 
                            case 'w': {
                                int keywordIndex = caseKeywords.get(tok);
                                if (keywordIndex <= -1) break;
                                if (prevBranch == 10) {
                                    throw ExpressionParser.missingArgs(position);
                                }
                                int argCount = 0;
                                while ((node = this.opStack.pop()) != null && !SqlKeywords.isCaseKeyword(node.token)) {
                                    argStackDepth = this.onNode(listener, node, argStackDepth);
                                    ++argCount;
                                }
                                if (paramCount == 0) {
                                    if (argCount == 0) {
                                        this.onNode(listener, this.expressionNodePool.next().of(4, null, Integer.MIN_VALUE, -1), argStackDepth);
                                    }
                                    ++paramCount;
                                }
                                switch (keywordIndex) {
                                    case 0: 
                                    case 2: {
                                        if (paramCount % 2 != 0) break;
                                        throw SqlException.$(position, "'then' expected");
                                    }
                                    default: {
                                        if (paramCount % 2 == 0) break;
                                        throw SqlException.$(position, "'when' expected");
                                    }
                                }
                                if (node != null) {
                                    this.opStack.push(node);
                                }
                                argStackDepth = 0;
                                ++paramCount;
                                thisBranch = 10;
                                continue block32;
                            }
                        }
                    }
                    if (prevBranch == 12) {
                        ExpressionNode en = this.opStack.peek();
                        if (en == null) {
                            throw SqlException.$(position, "qualifier expected");
                        }
                        if (GenericLexer.WHITESPACE_CH.contains(lexer.getContent().charAt(position - 1))) {
                            lexer.unparse();
                            break;
                        }
                        if (Chars.isQuoted(tok) || en.token instanceof CharacterStore.NameAssemblerCharSequence) {
                            this.opStack.pop();
                            CharacterStoreEntry cse = this.characterStore.newEntry();
                            cse.put(en.token).put(GenericLexer.unquote(tok));
                            this.opStack.push(this.expressionNodePool.next().of(4, cse.toImmutable(), Integer.MIN_VALUE, en.position));
                            continue;
                        }
                        GenericLexer.FloatingSequence fsA = (GenericLexer.FloatingSequence)en.token;
                        fsA.setHi(lexer.getTokenHi());
                        continue;
                    }
                    if (prevBranch != 17) {
                        this.opStack.push(this.expressionNodePool.next().of(4, GenericLexer.unquote(tok), Integer.MIN_VALUE, position));
                        continue;
                    }
                    ++argStackDepth;
                    ExpressionNode dotDereference = this.expressionNodePool.next().of(1, ".", 1, position);
                    dotDereference.paramCount = 2;
                    this.opStack.push(dotDereference);
                    this.opStack.push(this.expressionNodePool.next().of(5, GenericLexer.unquote(tok), Integer.MIN_VALUE, position));
                    continue;
                }
                lexer.unparse();
                break;
            }
            while ((node = this.opStack.pop()) != null) {
                if (node.token.charAt(0) == '(') {
                    throw SqlException.$(node.position, "unbalanced (");
                }
                if (node.type == 16 && node.token.charAt(0) == '[') {
                    throw SqlException.$(node.position, "unbalanced ]");
                }
                if (SqlKeywords.isCaseKeyword(node.token)) {
                    throw SqlException.$(node.position, "unbalanced 'case'");
                }
                if (node.type == 16) {
                    this.opStack.push(node);
                    break;
                }
                argStackDepth = this.onNode(listener, node, argStackDepth);
            }
        }
        catch (SqlException e) {
            this.opStack.clear();
            this.backupCastBraceCountStack.clear();
            this.backupParamCountStack.clear();
            this.backupArgStackDepthStack.clear();
            throw e;
        }
        finally {
            this.argStackDepthStack.clear();
            this.paramCountStack.clear();
            this.castBraceCountStack.clear();
            this.caseBraceCountStack.clear();
        }
    }

    private int processLambdaQuery(GenericLexer lexer, ExpressionParserListener listener, int argStackDepth) throws SqlException {
        this.opStack.push(this.expressionNodePool.next().of(16, "|", Integer.MAX_VALUE, lexer.lastTokenPosition()));
        int paramCountStackSize = this.copyToBackup(this.paramCountStack, this.backupParamCountStack);
        int argStackDepthStackSize = this.copyToBackup(this.argStackDepthStack, this.backupArgStackDepthStack);
        int castBraceCountStackSize = this.copyToBackup(this.castBraceCountStack, this.backupCastBraceCountStack);
        int caseBraceCountStackSize = this.copyToBackup(this.caseBraceCountStack, this.backupCaseBraceCountStack);
        int pos = lexer.lastTokenPosition();
        lexer.unparse();
        ExpressionNode node = this.expressionNodePool.next().of(65, null, 0, pos);
        this.onNode(listener, node, argStackDepth);
        node.queryModel = this.sqlParser.parseAsSubQuery(lexer, null);
        argStackDepth = this.onNode(listener, node, argStackDepth);
        ExpressionNode control = this.opStack.peek();
        if (control != null && control.type == 16 && Chars.equals(control.token, '|')) {
            this.opStack.pop();
        }
        this.backupParamCountStack.copyTo(this.paramCountStack, paramCountStackSize);
        this.backupArgStackDepthStack.copyTo(this.argStackDepthStack, argStackDepthStackSize);
        this.backupCastBraceCountStack.copyTo(this.castBraceCountStack, castBraceCountStackSize);
        this.backupCaseBraceCountStack.copyTo(this.caseBraceCountStack, caseBraceCountStackSize);
        lexer.unparse();
        return argStackDepth;
    }

    static {
        nonLiteralBranches.add(3);
        nonLiteralBranches.add(4);
        nonLiteralBranches.add(6);
        nonLiteralBranches.add(7);
        caseKeywords.put("when", 0);
        caseKeywords.put("then", 1);
        caseKeywords.put("else", 2);
        allFunctions.put("<>", "<>all");
        allFunctions.put("!=", "<>all");
    }
}

