/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.griffin.ExpressionParserListener;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.QueryModel;
import java.util.ArrayDeque;
import java.util.Deque;

final class ExpressionTreeBuilder
implements ExpressionParserListener {
    private final Deque<ExpressionNode> stack = new ArrayDeque<ExpressionNode>();
    private final Deque<QueryModel> modelStack = new ArrayDeque<QueryModel>();
    private QueryModel model;

    ExpressionTreeBuilder() {
    }

    @Override
    public void onNode(ExpressionNode node) throws SqlException {
        if (node.type == 65 && node.queryModel == null) {
            if (this.model == null) {
                throw SqlException.$(node.position, "query is not allowed here");
            }
            return;
        }
        if (node.queryModel != null) {
            this.model.addExpressionModel(node);
        }
        switch (node.paramCount) {
            case 0: {
                break;
            }
            case 1: {
                node.rhs = this.stack.poll();
                break;
            }
            case 2: {
                node.rhs = this.stack.poll();
                node.lhs = this.stack.poll();
                break;
            }
            default: {
                for (int i = 0; i < node.paramCount; ++i) {
                    node.args.add(this.stack.poll());
                }
            }
        }
        this.stack.push(node);
    }

    ExpressionNode poll() {
        return this.stack.poll();
    }

    void popModel() {
        this.model = this.modelStack.poll();
    }

    void pushModel(QueryModel model) {
        if (this.model != null) {
            this.modelStack.push(this.model);
        }
        this.model = model;
    }

    void reset() {
        this.stack.clear();
        this.modelStack.clear();
    }

    int size() {
        return this.stack.size();
    }
}

