/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.BindVariableService;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.ScalarFunction;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.FunctionFactoryCache;
import io.questdb.griffin.FunctionFactoryDescriptor;
import io.questdb.griffin.PostOrderTreeTraversalAlgo;
import io.questdb.griffin.SqlCodeGenerator;
import io.questdb.griffin.SqlCompiler;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlKeywords;
import io.questdb.griffin.engine.functions.CursorFunction;
import io.questdb.griffin.engine.functions.bind.IndexedParameterLinkFunction;
import io.questdb.griffin.engine.functions.bind.NamedParameterLinkFunction;
import io.questdb.griffin.engine.functions.cast.CastStrToTimestampFunctionFactory;
import io.questdb.griffin.engine.functions.columns.BinColumn;
import io.questdb.griffin.engine.functions.columns.BooleanColumn;
import io.questdb.griffin.engine.functions.columns.ByteColumn;
import io.questdb.griffin.engine.functions.columns.CharColumn;
import io.questdb.griffin.engine.functions.columns.DateColumn;
import io.questdb.griffin.engine.functions.columns.DoubleColumn;
import io.questdb.griffin.engine.functions.columns.FloatColumn;
import io.questdb.griffin.engine.functions.columns.IntColumn;
import io.questdb.griffin.engine.functions.columns.Long256Column;
import io.questdb.griffin.engine.functions.columns.LongColumn;
import io.questdb.griffin.engine.functions.columns.RecordColumn;
import io.questdb.griffin.engine.functions.columns.ShortColumn;
import io.questdb.griffin.engine.functions.columns.StrColumn;
import io.questdb.griffin.engine.functions.columns.SymbolColumn;
import io.questdb.griffin.engine.functions.columns.TimestampColumn;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.griffin.engine.functions.constants.ByteConstant;
import io.questdb.griffin.engine.functions.constants.CharConstant;
import io.questdb.griffin.engine.functions.constants.Constants;
import io.questdb.griffin.engine.functions.constants.DateConstant;
import io.questdb.griffin.engine.functions.constants.DoubleConstant;
import io.questdb.griffin.engine.functions.constants.FloatConstant;
import io.questdb.griffin.engine.functions.constants.IntConstant;
import io.questdb.griffin.engine.functions.constants.Long256Constant;
import io.questdb.griffin.engine.functions.constants.LongConstant;
import io.questdb.griffin.engine.functions.constants.NullStrConstant;
import io.questdb.griffin.engine.functions.constants.ShortConstant;
import io.questdb.griffin.engine.functions.constants.StrConstant;
import io.questdb.griffin.engine.functions.constants.SymbolConstant;
import io.questdb.griffin.engine.functions.constants.TimestampConstant;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.IntervalUtils;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import java.util.ArrayDeque;
import org.jetbrains.annotations.NotNull;

public class FunctionParser
implements PostOrderTreeTraversalAlgo.Visitor {
    private static final Log LOG = LogFactory.getLog(FunctionParser.class);
    private static final int MATCH_NO_MATCH = 0;
    private static final int MATCH_FUZZY_MATCH = 1;
    private static final int MATCH_PARTIAL_MATCH = 2;
    private static final int MATCH_EXACT_MATCH = 3;
    private final ObjList<Function> mutableArgs = new ObjList();
    private final ArrayDeque<Function> stack = new ArrayDeque();
    private final PostOrderTreeTraversalAlgo traverseAlgo = new PostOrderTreeTraversalAlgo();
    private final CairoConfiguration configuration;
    private final ArrayDeque<RecordMetadata> metadataStack = new ArrayDeque();
    private final FunctionFactoryCache functionFactoryCache;
    private final IntList undefinedVariables = new IntList();
    private RecordMetadata metadata;
    private SqlCodeGenerator sqlCodeGenerator;
    private SqlExecutionContext sqlExecutionContext;

    public FunctionParser(CairoConfiguration configuration, FunctionFactoryCache functionFactoryCache) {
        this.configuration = configuration;
        this.functionFactoryCache = functionFactoryCache;
    }

    @NotNull
    public static ScalarFunction createColumn(int position, CharSequence name, RecordMetadata metadata) throws SqlException {
        int index = metadata.getColumnIndexQuiet(name);
        if (index == -1) {
            throw SqlException.invalidColumn(position, name);
        }
        switch (metadata.getColumnType(index)) {
            case 0: {
                return new BooleanColumn(position, index);
            }
            case 1: {
                return new ByteColumn(position, index);
            }
            case 2: {
                return new ShortColumn(position, index);
            }
            case 3: {
                return new CharColumn(position, index);
            }
            case 4: {
                return new IntColumn(position, index);
            }
            case 5: {
                return new LongColumn(position, index);
            }
            case 8: {
                return new FloatColumn(position, index);
            }
            case 9: {
                return new DoubleColumn(position, index);
            }
            case 10: {
                return new StrColumn(position, index);
            }
            case 11: {
                return new SymbolColumn(position, index, metadata.isSymbolTableStatic(index));
            }
            case 13: {
                return new BinColumn(position, index);
            }
            case 6: {
                return new DateColumn(position, index);
            }
            case 7: {
                return new TimestampColumn(position, index);
            }
            case 17: {
                return new RecordColumn(position, index, metadata.getMetadata(index));
            }
        }
        return new Long256Column(position, index);
    }

    public Function createBindVariable(int position, CharSequence name) throws SqlException {
        if (name != null && name.length() > 0) {
            switch (name.charAt(0)) {
                case ':': {
                    return this.createNamedParameter(position, name);
                }
                case '$': {
                    return this.parseIndexedParameter(position, name);
                }
            }
            return new StrConstant(position, name);
        }
        return new NullStrConstant(position);
    }

    public Function createBindVariable0(int position, CharSequence name) throws SqlException {
        if (name.charAt(0) != ':') {
            return this.parseIndexedParameter(position, name);
        }
        return this.createNamedParameter(position, name);
    }

    private Function parseIndexedParameter(int position, CharSequence name) throws SqlException {
        try {
            int variableIndex = Numbers.parseInt(name, 1, name.length());
            if (variableIndex < 1) {
                throw SqlException.$(position, "invalid bind variable index [value=").put(variableIndex).put(']');
            }
            return this.createIndexParameter(variableIndex - 1, position);
        }
        catch (NumericException e) {
            throw SqlException.$(position, "invalid bind variable index [value=").put(name).put(']');
        }
    }

    public Function createIndexParameter(int variableIndex, int position) throws SqlException {
        Function function = this.getBindVariableService().getFunction(variableIndex);
        if (function == null) {
            return new IndexedParameterLinkFunction(variableIndex, -1, position);
        }
        return new IndexedParameterLinkFunction(variableIndex, function.getType(), position);
    }

    public Function createNamedParameter(int position, CharSequence name) throws SqlException {
        Function function = this.getBindVariableService().getFunction(name);
        if (function == null) {
            throw SqlException.position(position).put("undefined bind variable: ").put(name);
        }
        return new NamedParameterLinkFunction(Chars.toString(name), function.getType(), position);
    }

    public int getFunctionCount() {
        return this.functionFactoryCache.getFunctionCount();
    }

    public FunctionFactoryCache getFunctionFactoryCache() {
        return this.functionFactoryCache;
    }

    public boolean isCursor(CharSequence token) {
        return this.functionFactoryCache.isCursor(token);
    }

    public boolean isGroupBy(CharSequence token) {
        return this.functionFactoryCache.isGroupBy(token);
    }

    public boolean isValidNoArgFunction(ExpressionNode node) {
        ObjList<FunctionFactoryDescriptor> overload = this.functionFactoryCache.getOverloadList(node.token);
        if (overload == null) {
            return false;
        }
        int n = overload.size();
        for (int i = 0; i < n; ++i) {
            FunctionFactoryDescriptor ffd = overload.getQuick(i);
            if (ffd.getSigArgCount() != 0) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Function parseFunction(ExpressionNode node, RecordMetadata metadata, SqlExecutionContext executionContext) throws SqlException {
        this.sqlExecutionContext = executionContext;
        if (this.metadata != null) {
            this.metadataStack.push(this.metadata);
        }
        try {
            this.metadata = metadata;
            this.traverseAlgo.traverse(node, this);
            Function function = this.stack.poll();
            if (function != null && function.isConstant() && function instanceof ScalarFunction) {
                try {
                    Function function2 = this.functionToConstant(function);
                    return function2;
                }
                finally {
                    function.close();
                }
            }
            Function function3 = function;
            return function3;
        }
        finally {
            this.metadata = this.metadataStack.size() == 0 ? null : this.metadataStack.poll();
        }
    }

    public void setSqlCodeGenerator(SqlCodeGenerator sqlCodeGenerator) {
        this.sqlCodeGenerator = sqlCodeGenerator;
    }

    @Override
    public void visit(ExpressionNode node) throws SqlException {
        int argCount = node.paramCount;
        if (argCount == 0) {
            switch (node.type) {
                case 4: {
                    this.stack.push(this.createColumn(node.position, node.token));
                    break;
                }
                case 6: {
                    this.stack.push(this.createBindVariable0(node.position, node.token));
                    break;
                }
                case 5: {
                    this.stack.push(new StrConstant(node.position, node.token));
                    break;
                }
                case 2: {
                    this.stack.push(this.createConstant(node.position, node.token));
                    break;
                }
                case 65: {
                    this.stack.push(this.createCursorFunction(node));
                    break;
                }
                default: {
                    this.stack.push(this.createFunction(node, null));
                    break;
                }
            }
        } else {
            this.mutableArgs.clear();
            this.mutableArgs.setPos(argCount);
            for (int n = 0; n < argCount; ++n) {
                this.mutableArgs.setQuick(n, this.stack.poll());
            }
            this.stack.push(this.createFunction(node, this.mutableArgs));
        }
    }

    private static SqlException invalidFunction(ExpressionNode node, ObjList<Function> args) {
        SqlException ex = SqlException.position(node.position);
        ex.put("unknown function name");
        ex.put(": ");
        ex.put(node.token);
        ex.put('(');
        if (args != null) {
            int n = args.size();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    ex.put(',');
                }
                ex.put(ColumnType.nameOf(args.getQuick(i).getType()));
            }
        }
        ex.put(')');
        return ex;
    }

    private static SqlException invalidArgument(ExpressionNode node, ObjList<Function> args, FunctionFactoryDescriptor descriptor) {
        int i;
        int n;
        SqlException ex = SqlException.position(node.position);
        ex.put("unexpected argument for function: ");
        ex.put(node.token);
        ex.put(". expected args: ");
        ex.put('(');
        if (descriptor != null) {
            n = descriptor.getSigArgCount();
            for (i = 0; i < n; ++i) {
                if (i > 0) {
                    ex.put(',');
                }
                int mask = descriptor.getArgTypeMask(i);
                ex.put(ColumnType.nameOf(FunctionFactoryDescriptor.toType(mask)));
                if (FunctionFactoryDescriptor.isArray(mask)) {
                    ex.put("[]");
                }
                if (!FunctionFactoryDescriptor.isConstant(mask)) continue;
                ex.put(" constant");
            }
        }
        ex.put("). actual args: ");
        ex.put('(');
        if (args != null) {
            n = args.size();
            for (i = 0; i < n; ++i) {
                if (i > 0) {
                    ex.put(',');
                }
                Function arg = args.getQuick(i);
                ex.put(ColumnType.nameOf(arg.getType()));
                if (!arg.isConstant()) continue;
                ex.put(" constant");
            }
        }
        ex.put(')');
        return ex;
    }

    private Function checkAndCreateFunction(FunctionFactory factory, ObjList<Function> args, int position, CairoConfiguration configuration) throws SqlException {
        Function function;
        try {
            function = factory.newInstance(args, position, configuration, this.sqlExecutionContext);
        }
        catch (SqlException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error().$("exception in function factory: ").$(e).$();
            throw SqlException.position(position).put("exception in function factory");
        }
        if (function == null) {
            LOG.error().$("NULL function").$(" [signature=").$(factory.getSignature()).$(",class=").$(factory.getClass().getName()).$(']').$();
            throw SqlException.position(position).put("bad function factory (NULL), check log");
        }
        return function;
    }

    private Function createColumn(int position, CharSequence columnName) throws SqlException {
        return FunctionParser.createColumn(position, columnName, this.metadata);
    }

    private Function createConstant(int position, CharSequence tok) throws SqlException {
        int len = tok.length();
        if (SqlKeywords.isNullKeyword(tok)) {
            return new NullStrConstant(position);
        }
        if (Chars.isQuoted(tok)) {
            if (len == 3) {
                return new CharConstant(position, tok.charAt(1));
            }
            if (len == 2) {
                return new CharConstant(position, '\u0000');
            }
            return new StrConstant(position, tok);
        }
        if (len > 2 && tok.charAt(0) == 'E' && tok.charAt(1) == '\'') {
            return new StrConstant(position, Chars.toString(tok, 2, len - 1));
        }
        if (SqlKeywords.isTrueKeyword(tok)) {
            return new BooleanConstant(position, true);
        }
        if (SqlKeywords.isFalseKeyword(tok)) {
            return new BooleanConstant(position, false);
        }
        try {
            return new IntConstant(position, Numbers.parseInt(tok));
        }
        catch (NumericException numericException) {
            try {
                return new LongConstant(position, Numbers.parseLong(tok));
            }
            catch (NumericException numericException2) {
                try {
                    return new DoubleConstant(position, Numbers.parseDouble(tok));
                }
                catch (NumericException numericException3) {
                    try {
                        return new FloatConstant(position, Numbers.parseFloat(tok));
                    }
                    catch (NumericException numericException4) {
                        int columnType = ColumnType.columnTypeOf(tok);
                        if (columnType > -1) {
                            return Constants.getTypeConstant(columnType);
                        }
                        throw SqlException.position(position).put("invalid constant: ").put(tok);
                    }
                }
            }
        }
    }

    private Function createCursorFunction(ExpressionNode node) throws SqlException {
        assert (node.queryModel != null);
        return new CursorFunction(node.position, this.sqlCodeGenerator.generate(node.queryModel, this.sqlExecutionContext));
    }

    private Function createFunction(ExpressionNode node, ObjList<Function> args) throws SqlException {
        int k;
        int i;
        ObjList<FunctionFactoryDescriptor> overload = this.functionFactoryCache.getOverloadList(node.token);
        if (overload == null) {
            throw FunctionParser.invalidFunction(node, args);
        }
        int argCount = args == null ? 0 : args.size();
        FunctionFactory candidate = null;
        FunctionFactoryDescriptor candidateDescriptor = null;
        boolean candidateSigVarArgConst = false;
        int candidateSigArgCount = 0;
        int candidateSigArgTypeSum = -1;
        int bestMatch = 0;
        this.undefinedVariables.clear();
        for (i = 0; i < argCount; ++i) {
            if (!args.getQuick(i).isUndefined()) continue;
            this.undefinedVariables.add(i);
        }
        int n = overload.size();
        for (i = 0; i < n; ++i) {
            boolean sigVarArgConst;
            boolean sigVarArg;
            FunctionFactoryDescriptor descriptor = overload.getQuick(i);
            FunctionFactory factory = descriptor.getFactory();
            int sigArgCount = descriptor.getSigArgCount();
            if (candidateDescriptor == null) {
                candidateDescriptor = descriptor;
            }
            if (sigArgCount > 0) {
                int lastSigArgMask = descriptor.getArgTypeMask(sigArgCount - 1);
                sigVarArg = FunctionFactoryDescriptor.toType(lastSigArgMask) == 16;
                sigVarArgConst = FunctionFactoryDescriptor.isConstant(lastSigArgMask);
            } else {
                sigVarArg = false;
                sigVarArgConst = false;
            }
            if (sigVarArg) {
                --sigArgCount;
            }
            if (argCount == 0 && sigArgCount == 0) {
                return this.checkAndCreateFunction(factory, args, node.position, this.configuration);
            }
            if (sigArgCount != argCount && (!sigVarArg || argCount < sigArgCount)) continue;
            int match = 0;
            if (sigArgCount == 0) {
                match = 3;
            }
            int sigArgTypeSum = 0;
            for (int k2 = 0; k2 < sigArgCount; ++k2) {
                boolean overloadPossible;
                Function arg = args.getQuick(k2);
                boolean undefined = arg.isUndefined();
                int sigArgTypeMask = descriptor.getArgTypeMask(k2);
                if (FunctionFactoryDescriptor.isConstant(sigArgTypeMask) && !arg.isConstant()) {
                    match = 0;
                    break;
                }
                boolean isArray = FunctionFactoryDescriptor.isArray(sigArgTypeMask);
                boolean isScalar = arg instanceof ScalarFunction;
                if (isArray && isScalar || !isArray && !isScalar) {
                    match = 0;
                    break;
                }
                int sigArgType = FunctionFactoryDescriptor.toType(sigArgTypeMask);
                sigArgTypeSum += ColumnType.widthPrecedenceOf(sigArgType);
                if (sigArgType == arg.getType()) {
                    switch (match) {
                        case 0: {
                            match = 3;
                            break;
                        }
                        case 1: {
                            match = 2;
                            break;
                        }
                    }
                    continue;
                }
                int argType = arg.getType();
                boolean bl = overloadPossible = argType >= 1 && sigArgType >= 1 && sigArgType <= 9 && argType < sigArgType || argType == 9 && arg.isConstant() && Double.isNaN(arg.getDouble(null)) && (sigArgType == 5 || sigArgType == 4) || argType == 3 && sigArgType == 10 || argType == 10 && sigArgType == 7 || undefined;
                if (overloadPossible) {
                    switch (match) {
                        case 0: {
                            match = 1;
                            break;
                        }
                        case 3: {
                            match = 2;
                            break;
                        }
                    }
                    continue;
                }
                match = 0;
                break;
            }
            if (match == 0 || match != 3 && match < bestMatch) continue;
            if (match != 3) {
                if (candidateSigArgTypeSum < sigArgTypeSum || bestMatch < match) {
                    candidate = factory;
                    candidateDescriptor = descriptor;
                    candidateSigArgCount = sigArgCount;
                    candidateSigVarArgConst = sigVarArgConst;
                    candidateSigArgTypeSum = sigArgTypeSum;
                }
                bestMatch = match;
                continue;
            }
            candidate = factory;
            candidateDescriptor = descriptor;
            candidateSigArgCount = sigArgCount;
            candidateSigVarArgConst = sigVarArgConst;
            break;
        }
        if (candidate == null) {
            throw FunctionParser.invalidArgument(node, args, candidateDescriptor);
        }
        if (candidateSigVarArgConst) {
            for (k = candidateSigArgCount; k < argCount; ++k) {
                Function func = args.getQuick(k);
                if (func.isConstant()) continue;
                throw SqlException.$(func.getPosition(), "constant expected");
            }
        }
        for (k = 0; k < candidateSigArgCount; ++k) {
            Function arg = args.getQuick(k);
            int sigArgType = FunctionFactoryDescriptor.toType(candidateDescriptor.getArgTypeMask(k));
            if (arg.getType() != 9 || !arg.isConstant() || !Double.isNaN(arg.getDouble(null))) continue;
            if (sigArgType == 5) {
                args.setQuick(k, new LongConstant(arg.getPosition(), Long.MIN_VALUE));
                continue;
            }
            if (sigArgType != 4) continue;
            args.setQuick(k, new IntConstant(arg.getPosition(), Integer.MIN_VALUE));
        }
        n = this.undefinedVariables.size();
        for (i = 0; i < n; ++i) {
            int pos = this.undefinedVariables.getQuick(i);
            if (pos < candidateSigArgCount) {
                int sigArgType = FunctionFactoryDescriptor.toType(candidateDescriptor.getArgTypeMask(pos));
                args.getQuick(pos).assignType(sigArgType, this.sqlExecutionContext.getBindVariableService());
                continue;
            }
            args.getQuick(pos).assignType(16, this.sqlExecutionContext.getBindVariableService());
        }
        for (k = 0; k < candidateSigArgCount; ++k) {
            Function arg = args.getQuick(k);
            int sigArgType = FunctionFactoryDescriptor.toType(candidateDescriptor.getArgTypeMask(k));
            if (arg.getType() != 10 || sigArgType != 7) continue;
            int position = arg.getPosition();
            if (arg.isConstant()) {
                long timestamp = this.convertToTimestamp(arg.getStr(null), position);
                args.set(k, new TimestampConstant(position, timestamp));
                continue;
            }
            args.set(k, new CastStrToTimestampFunctionFactory.Func(position, arg));
        }
        LOG.debug().$("call ").$(node).$(" -> ").$(candidate.getSignature()).$();
        return this.checkAndCreateFunction(candidate, args, node.position, this.configuration);
    }

    private long convertToTimestamp(CharSequence str, int position) throws SqlException {
        try {
            return IntervalUtils.parseFloorPartialDate(str);
        }
        catch (NumericException e) {
            throw SqlException.invalidDate(position);
        }
    }

    private Function functionToConstant(Function function) {
        int position = function.getPosition();
        switch (function.getType()) {
            case 4: {
                if (function instanceof IntConstant) {
                    return function;
                }
                return new IntConstant(position, function.getInt(null));
            }
            case 0: {
                if (function instanceof BooleanConstant) {
                    return function;
                }
                return new BooleanConstant(position, function.getBool(null));
            }
            case 1: {
                if (function instanceof ByteConstant) {
                    return function;
                }
                return new ByteConstant(position, function.getByte(null));
            }
            case 2: {
                if (function instanceof ShortConstant) {
                    return function;
                }
                return new ShortConstant(position, function.getShort(null));
            }
            case 3: {
                if (function instanceof CharConstant) {
                    return function;
                }
                return new CharConstant(position, function.getChar(null));
            }
            case 8: {
                if (function instanceof FloatConstant) {
                    return function;
                }
                return new FloatConstant(position, function.getFloat(null));
            }
            case 9: {
                if (function instanceof DoubleConstant) {
                    return function;
                }
                return new DoubleConstant(position, function.getDouble(null));
            }
            case 5: {
                if (function instanceof LongConstant) {
                    return function;
                }
                return new LongConstant(position, function.getLong(null));
            }
            case 12: {
                if (function instanceof Long256Constant) {
                    return function;
                }
                return new Long256Constant(position, function.getLong256A(null));
            }
            case 6: {
                if (function instanceof DateConstant) {
                    return function;
                }
                return new DateConstant(position, function.getDate(null));
            }
            case 10: {
                if (function instanceof StrConstant || function instanceof NullStrConstant) {
                    return function;
                }
                CharSequence value = function.getStr(null);
                if (value == null) {
                    return new NullStrConstant(position);
                }
                return new StrConstant(position, value);
            }
            case 11: {
                if (function instanceof SymbolConstant) {
                    return function;
                }
                return new SymbolConstant(position, Chars.toString(function.getSymbol(null)), 0);
            }
            case 7: {
                if (function instanceof TimestampConstant) {
                    return function;
                }
                return new TimestampConstant(position, function.getTimestamp(null));
            }
        }
        return function;
    }

    @NotNull
    private BindVariableService getBindVariableService() throws SqlException {
        BindVariableService bindVariableService = this.sqlExecutionContext.getBindVariableService();
        if (bindVariableService == null) {
            throw SqlException.$(0, "bind variable service is not provided");
        }
        return bindVariableService;
    }

    static {
        int n = SqlCompiler.sqlControlSymbols.size();
        for (int i = 0; i < n; ++i) {
            FunctionFactoryCache.invalidFunctionNames.add(SqlCompiler.sqlControlSymbols.getQuick(i));
        }
        FunctionFactoryCache.invalidFunctionNameChars.add(32);
        FunctionFactoryCache.invalidFunctionNameChars.add(34);
        FunctionFactoryCache.invalidFunctionNameChars.add(39);
    }
}

