/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.CairoException;
import io.questdb.griffin.SqlExecutionInterruptor;
import io.questdb.griffin.SqlInterruptorConfiguration;
import io.questdb.network.NetworkFacade;
import io.questdb.std.Unsafe;
import java.io.Closeable;

public class HttpSqlExecutionInterruptor
implements SqlExecutionInterruptor,
Closeable {
    private final NetworkFacade nf;
    private final int nIterationsPerCheck;
    private final int bufferSize;
    private long buffer;
    private int nIterationsSinceCheck;
    private long fd = -1L;

    public static HttpSqlExecutionInterruptor create(SqlInterruptorConfiguration configuration) {
        if (configuration.isEnabled()) {
            return new HttpSqlExecutionInterruptor(configuration);
        }
        return null;
    }

    public HttpSqlExecutionInterruptor(SqlInterruptorConfiguration configuration) {
        this.nf = configuration.getNetworkFacade();
        this.nIterationsPerCheck = configuration.getCountOfIterationsPerCheck();
        this.bufferSize = configuration.getBufferSize();
        this.buffer = Unsafe.malloc(this.bufferSize);
    }

    @Override
    public void checkInterrupted() {
        assert (this.fd != -1L);
        if (this.nIterationsSinceCheck == this.nIterationsPerCheck) {
            this.nIterationsSinceCheck = 0;
            this.checkConnection();
        } else {
            ++this.nIterationsSinceCheck;
        }
    }

    private void checkConnection() {
        byte b;
        int index;
        int nRead = this.nf.peek(this.fd, this.buffer, this.bufferSize);
        if (nRead == 0) {
            return;
        }
        if (nRead < 0) {
            throw CairoException.instance(0).put("client fd ").put(this.fd).put(" is closed").setInterruption(true);
        }
        long ptr = this.buffer;
        for (index = 0; index < nRead && ((b = Unsafe.getUnsafe().getByte(ptr + (long)index)) == 13 || b == 10); ++index) {
        }
        if (index > 0) {
            this.nf.recv(this.fd, this.buffer, index);
        }
    }

    public HttpSqlExecutionInterruptor of(long fd) {
        assert (this.buffer != 0L);
        this.nIterationsSinceCheck = 0;
        this.fd = fd;
        return this;
    }

    @Override
    public void close() {
        Unsafe.free(this.buffer, this.bufferSize);
        this.buffer = 0L;
        this.fd = -1L;
    }
}

