/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.pool.WriterSource;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.InsertMethod;
import io.questdb.cairo.sql.InsertStatement;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.cairo.sql.WriterOutOfDateException;
import io.questdb.griffin.SqlCompiler;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.model.IntervalUtils;
import io.questdb.std.Misc;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;

public class InsertStatementImpl
implements InsertStatement {
    private final VirtualRecord virtualRecord;
    private final SqlCompiler.RecordToRowCopier copier;
    private final Function timestampFunction;
    private final RowFactory rowFactory;
    private final long structureVersion;
    private final String tableName;
    private final InsertMethodImpl insertMethod = new InsertMethodImpl();
    private final CairoEngine engine;

    public InsertStatementImpl(CairoEngine engine, String tableName, VirtualRecord virtualRecord, SqlCompiler.RecordToRowCopier copier, Function timestampFunction, long structureVersion) {
        this.engine = engine;
        this.tableName = tableName;
        this.virtualRecord = virtualRecord;
        this.copier = copier;
        this.timestampFunction = timestampFunction;
        this.rowFactory = timestampFunction != null ? (timestampFunction.getType() != 10 ? this::getRowWithTimestamp : this::getRowWithStringTimestamp) : this::getRowWithoutTimestamp;
        this.structureVersion = structureVersion;
    }

    @Override
    public void close() {
        this.detachWriter();
    }

    @Override
    public InsertMethod createMethod(SqlExecutionContext executionContext) {
        return this.createMethod(executionContext, this.engine);
    }

    @Override
    public InsertMethod createMethod(SqlExecutionContext executionContext, WriterSource writerSource) {
        this.initContext(executionContext);
        if (this.insertMethod.writer == null) {
            TableWriter writer = writerSource.getWriter(executionContext.getCairoSecurityContext(), this.tableName);
            if (writer.getStructureVersion() != this.getStructureVersion()) {
                writer.close();
                throw WriterOutOfDateException.INSTANCE;
            }
            this.insertMethod.writer = writer;
        }
        return this.insertMethod;
    }

    @Override
    public long getStructureVersion() {
        return this.structureVersion;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public void detachWriter() {
        this.insertMethod.close();
    }

    private TableWriter.Row getRowWithTimestamp(TableWriter tableWriter) {
        long timestamp = this.timestampFunction.getTimestamp(null);
        return tableWriter.newRow(timestamp);
    }

    private TableWriter.Row getRowWithStringTimestamp(TableWriter tableWriter) {
        CharSequence tsStr = this.timestampFunction.getStr(null);
        try {
            long timestamp = IntervalUtils.parseFloorPartialDate(tsStr);
            return tableWriter.newRow(timestamp);
        }
        catch (NumericException e) {
            throw CairoException.instance(0).put("Invalid timestamp: ").put(tsStr);
        }
    }

    private TableWriter.Row getRowWithoutTimestamp(TableWriter tableWriter) {
        return tableWriter.newRow();
    }

    private void initContext(SqlExecutionContext executionContext) {
        ObjList<? extends Function> functions = this.virtualRecord.getFunctions();
        Function.init(functions, null, executionContext);
        if (this.timestampFunction != null) {
            this.timestampFunction.init(null, executionContext);
        }
    }

    private class InsertMethodImpl
    implements InsertMethod {
        private TableWriter writer = null;

        private InsertMethodImpl() {
        }

        @Override
        public long execute() {
            TableWriter.Row row = InsertStatementImpl.this.rowFactory.getRow(this.writer);
            InsertStatementImpl.this.copier.copy(InsertStatementImpl.this.virtualRecord, row);
            row.append();
            return 1L;
        }

        @Override
        public void commit() {
            this.writer.commit();
        }

        @Override
        public void rollback() {
            this.writer.rollback();
        }

        @Override
        public TableWriter popWriter() {
            TableWriter w = this.writer;
            this.writer = null;
            return w;
        }

        @Override
        public void close() {
            this.writer = Misc.free(this.writer);
        }
    }

    @FunctionalInterface
    private static interface RowFactory {
        public TableWriter.Row getRow(TableWriter var1);
    }
}

