/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.AbstractDataFrameCursorFactory;
import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.BaseRecordMetadata;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.EntityColumnFilter;
import io.questdb.cairo.FullBwdDataFrameCursorFactory;
import io.questdb.cairo.FullFwdDataFrameCursorFactory;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.IntervalBwdDataFrameCursorFactory;
import io.questdb.cairo.IntervalFwdDataFrameCursorFactory;
import io.questdb.cairo.ListColumnFilter;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.RecordSinkFactory;
import io.questdb.cairo.SymbolMapReader;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableReaderMetadata;
import io.questdb.cairo.TableReaderRecordCursorFactory;
import io.questdb.cairo.map.RecordValueSink;
import io.questdb.cairo.map.RecordValueSinkFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.RowCursorFactory;
import io.questdb.cairo.sql.ScalarFunction;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.griffin.EmptyRecordMetadata;
import io.questdb.griffin.FunctionParser;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlKeywords;
import io.questdb.griffin.WhereClauseParser;
import io.questdb.griffin.engine.EmptyTableRecordCursorFactory;
import io.questdb.griffin.engine.LimitRecordCursorFactory;
import io.questdb.griffin.engine.RecordComparator;
import io.questdb.griffin.engine.analytic.AnalyticFunction;
import io.questdb.griffin.engine.analytic.CachedAnalyticRecordCursorFactory;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.griffin.engine.functions.constants.LongConstant;
import io.questdb.griffin.engine.groupby.CountRecordCursorFactory;
import io.questdb.griffin.engine.groupby.DistinctRecordCursorFactory;
import io.questdb.griffin.engine.groupby.DistinctSymbolRecordCursorFactory;
import io.questdb.griffin.engine.groupby.GroupByNotKeyedRecordCursorFactory;
import io.questdb.griffin.engine.groupby.GroupByUtils;
import io.questdb.griffin.engine.groupby.SampleByFillNoneNotKeyedRecordCursorFactory;
import io.questdb.griffin.engine.groupby.SampleByFillNoneRecordCursorFactory;
import io.questdb.griffin.engine.groupby.SampleByFillNullNotKeyedRecordCursorFactory;
import io.questdb.griffin.engine.groupby.SampleByFillNullRecordCursorFactory;
import io.questdb.griffin.engine.groupby.SampleByFillPrevNotKeyedRecordCursorFactory;
import io.questdb.griffin.engine.groupby.SampleByFillPrevRecordCursorFactory;
import io.questdb.griffin.engine.groupby.SampleByFillValueNotKeyedRecordCursorFactory;
import io.questdb.griffin.engine.groupby.SampleByFillValueRecordCursorFactory;
import io.questdb.griffin.engine.groupby.SampleByInterpolateRecordCursorFactory;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.griffin.engine.groupby.TimestampSamplerFactory;
import io.questdb.griffin.engine.groupby.vect.AvgDoubleVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.AvgIntVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.AvgLongVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.CountVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.GroupByNotKeyedVectorRecordCursorFactory;
import io.questdb.griffin.engine.groupby.vect.GroupByRecordCursorFactory;
import io.questdb.griffin.engine.groupby.vect.KSumDoubleVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.MaxDateVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.MaxDoubleVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.MaxIntVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.MaxLongVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.MaxTimestampVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.MinDateVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.MinDoubleVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.MinIntVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.MinLongVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.MinTimestampVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.NSumDoubleVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.SumDateVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.SumDoubleVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.SumIntVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.SumLongVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.SumTimestampVectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateFunction;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateFunctionConstructor;
import io.questdb.griffin.engine.join.AsOfJoinLightRecordCursorFactory;
import io.questdb.griffin.engine.join.AsOfJoinNoKeyRecordCursorFactory;
import io.questdb.griffin.engine.join.AsOfJoinRecordCursorFactory;
import io.questdb.griffin.engine.join.CrossJoinRecordCursorFactory;
import io.questdb.griffin.engine.join.HashJoinLightRecordCursorFactory;
import io.questdb.griffin.engine.join.HashJoinRecordCursorFactory;
import io.questdb.griffin.engine.join.HashOuterJoinLightRecordCursorFactory;
import io.questdb.griffin.engine.join.HashOuterJoinRecordCursorFactory;
import io.questdb.griffin.engine.join.JoinRecordMetadata;
import io.questdb.griffin.engine.join.LtJoinLightRecordCursorFactory;
import io.questdb.griffin.engine.join.LtJoinNoKeyRecordCursorFactory;
import io.questdb.griffin.engine.join.LtJoinRecordCursorFactory;
import io.questdb.griffin.engine.join.RecordAsAFieldRecordCursorFactory;
import io.questdb.griffin.engine.join.SpliceJoinLightRecordCursorFactory;
import io.questdb.griffin.engine.orderby.RecordComparatorCompiler;
import io.questdb.griffin.engine.orderby.SortedLightRecordCursorFactory;
import io.questdb.griffin.engine.orderby.SortedRecordCursorFactory;
import io.questdb.griffin.engine.table.DataFrameRecordCursorFactory;
import io.questdb.griffin.engine.table.DataFrameRowCursorFactory;
import io.questdb.griffin.engine.table.DeferredSymbolIndexFilteredRowCursorFactory;
import io.questdb.griffin.engine.table.DeferredSymbolIndexRowCursorFactory;
import io.questdb.griffin.engine.table.FilterOnExcludedValuesRecordCursorFactory;
import io.questdb.griffin.engine.table.FilterOnSubQueryRecordCursorFactory;
import io.questdb.griffin.engine.table.FilterOnValuesRecordCursorFactory;
import io.questdb.griffin.engine.table.FilteredRecordCursorFactory;
import io.questdb.griffin.engine.table.FunctionBasedRowCursorFactory;
import io.questdb.griffin.engine.table.LatestByAllFilteredRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByAllIndexedFilteredRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestBySubQueryRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByValueDeferredFilteredRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByValueDeferredIndexedFilteredRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByValueDeferredIndexedRowCursorFactory;
import io.questdb.griffin.engine.table.LatestByValueFilteredRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByValueIndexedFilteredRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByValueIndexedRowCursorFactory;
import io.questdb.griffin.engine.table.LatestByValuesFilteredRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByValuesIndexedFilteredRecordCursorFactory;
import io.questdb.griffin.engine.table.SelectedRecordCursorFactory;
import io.questdb.griffin.engine.table.SortedSymbolIndexRecordCursorFactory;
import io.questdb.griffin.engine.table.SymbolIndexFilteredRowCursorFactory;
import io.questdb.griffin.engine.table.SymbolIndexRowCursorFactory;
import io.questdb.griffin.engine.table.VirtualRecordCursorFactory;
import io.questdb.griffin.engine.union.ExceptRecordCursorFactory;
import io.questdb.griffin.engine.union.IntersectRecordCursorFactory;
import io.questdb.griffin.engine.union.SetRecordCursorFactoryConstructor;
import io.questdb.griffin.engine.union.UnionAllRecordCursorFactory;
import io.questdb.griffin.engine.union.UnionRecordCursorFactory;
import io.questdb.griffin.model.AnalyticColumn;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.IntrinsicModel;
import io.questdb.griffin.model.JoinContext;
import io.questdb.griffin.model.QueryColumn;
import io.questdb.griffin.model.QueryModel;
import io.questdb.griffin.model.RuntimeIntrinsicIntervalModel;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.Chars;
import io.questdb.std.IntHashSet;
import io.questdb.std.IntList;
import io.questdb.std.IntObjHashMap;
import io.questdb.std.LowerCaseCharSequenceIntHashMap;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.ObjObjHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCodeGenerator
implements Mutable {
    public static final int GKK_VANILLA_INT = 0;
    public static final int GKK_HOUR_INT = 1;
    private static final IntHashSet limitTypes = new IntHashSet();
    private static final FullFatJoinGenerator CREATE_FULL_FAT_LT_JOIN = SqlCodeGenerator::createFullFatLtJoin;
    private static final FullFatJoinGenerator CREATE_FULL_FAT_AS_OF_JOIN = SqlCodeGenerator::createFullFatAsOfJoin;
    private static final boolean[] joinsRequiringTimestamp = new boolean[]{false, false, false, true, true, false, true};
    private static final IntObjHashMap<VectorAggregateFunctionConstructor> sumConstructors = new IntObjHashMap();
    private static final IntObjHashMap<VectorAggregateFunctionConstructor> ksumConstructors = new IntObjHashMap();
    private static final IntObjHashMap<VectorAggregateFunctionConstructor> nsumConstructors = new IntObjHashMap();
    private static final IntObjHashMap<VectorAggregateFunctionConstructor> avgConstructors = new IntObjHashMap();
    private static final IntObjHashMap<VectorAggregateFunctionConstructor> minConstructors = new IntObjHashMap();
    private static final IntObjHashMap<VectorAggregateFunctionConstructor> maxConstructors = new IntObjHashMap();
    private static final IntObjHashMap<VectorAggregateFunctionConstructor> countConstructors = new IntObjHashMap();
    private static final SetRecordCursorFactoryConstructor SET_UNION_CONSTRUCTOR = UnionRecordCursorFactory::new;
    private static final SetRecordCursorFactoryConstructor SET_INTERSECT_CONSTRUCTOR = IntersectRecordCursorFactory::new;
    private static final SetRecordCursorFactoryConstructor SET_EXCEPT_CONSTRUCTOR = ExceptRecordCursorFactory::new;
    private final WhereClauseParser whereClauseParser = new WhereClauseParser();
    private final FunctionParser functionParser;
    private final CairoEngine engine;
    private final BytecodeAssembler asm = new BytecodeAssembler();
    private final ListColumnFilter listColumnFilterA = new ListColumnFilter();
    private final ListColumnFilter listColumnFilterB = new ListColumnFilter();
    private final CairoConfiguration configuration;
    private final RecordComparatorCompiler recordComparatorCompiler;
    private final IntHashSet intHashSet = new IntHashSet();
    private final ArrayColumnTypes keyTypes = new ArrayColumnTypes();
    private final ArrayColumnTypes valueTypes = new ArrayColumnTypes();
    private final EntityColumnFilter entityColumnFilter = new EntityColumnFilter();
    private final ObjList<Function> symbolValueList = new ObjList();
    private final ObjList<VectorAggregateFunction> tempVaf = new ObjList();
    private final GenericRecordMetadata tempMetadata = new GenericRecordMetadata();
    private final ArrayColumnTypes arrayColumnTypes = new ArrayColumnTypes();
    private final IntList tempKeyIndexesInBase = new IntList();
    private final IntList tempSymbolSkewIndexes = new IntList();
    private final IntList tempKeyIndex = new IntList();
    private final IntList tempAggIndex = new IntList();
    private final ObjList<VectorAggregateFunctionConstructor> tempVecConstructors = new ObjList();
    private final IntList tempVecConstructorArgIndexes = new IntList();
    private final IntList tempKeyKinds = new IntList();
    private final ObjObjHashMap<IntList, ObjList<AnalyticFunction>> grouppedAnalytic = new ObjObjHashMap();
    private boolean fullFatJoins = false;

    public SqlCodeGenerator(CairoEngine engine, CairoConfiguration configuration, FunctionParser functionParser) {
        this.engine = engine;
        this.configuration = configuration;
        this.functionParser = functionParser;
        this.recordComparatorCompiler = new RecordComparatorCompiler(this.asm);
    }

    @Override
    public void clear() {
        this.whereClauseParser.clear();
    }

    @NotNull
    public Function compileFilter(ExpressionNode expr, RecordMetadata metadata, SqlExecutionContext executionContext) throws SqlException {
        Function filter = this.functionParser.parseFunction(expr, metadata, executionContext);
        if (filter.getType() == 0) {
            return filter;
        }
        Misc.free(filter);
        throw SqlException.$(expr.position, "boolean expression expected");
    }

    private static RecordCursorFactory createFullFatAsOfJoin(CairoConfiguration configuration, RecordMetadata metadata, RecordCursorFactory masterFactory, RecordCursorFactory slaveFactory, ColumnTypes mapKeyTypes, ColumnTypes mapValueTypes, ColumnTypes slaveColumnTypes, RecordSink masterKeySink, RecordSink slaveKeySink, int columnSplit, RecordValueSink slaveValueSink, IntList columnIndex) {
        return new AsOfJoinRecordCursorFactory(configuration, metadata, masterFactory, slaveFactory, mapKeyTypes, mapValueTypes, slaveColumnTypes, masterKeySink, slaveKeySink, columnSplit, slaveValueSink, columnIndex);
    }

    private static RecordCursorFactory createFullFatLtJoin(CairoConfiguration configuration, RecordMetadata metadata, RecordCursorFactory masterFactory, RecordCursorFactory slaveFactory, ColumnTypes mapKeyTypes, ColumnTypes mapValueTypes, ColumnTypes slaveColumnTypes, RecordSink masterKeySink, RecordSink slaveKeySink, int columnSplit, RecordValueSink slaveValueSink, IntList columnIndex) {
        return new LtJoinRecordCursorFactory(configuration, metadata, masterFactory, slaveFactory, mapKeyTypes, mapValueTypes, slaveColumnTypes, masterKeySink, slaveKeySink, columnSplit, slaveValueSink, columnIndex);
    }

    private static void addCountConstructor(int type) {
        countConstructors.put(type, (position, keyKind, columnIndex, workerCount) -> new CountVectorAggregateFunction(position, keyKind, ColumnType.pow2SizeOf(type)));
    }

    private VectorAggregateFunctionConstructor assembleFunctionReference(RecordMetadata metadata, ExpressionNode ast) {
        if (ast.type == 8 && ast.paramCount == 1 && SqlKeywords.isSumKeyword(ast.token) && ast.rhs.type == 4) {
            int columnIndex = metadata.getColumnIndex(ast.rhs.token);
            this.tempVecConstructorArgIndexes.add(columnIndex);
            return sumConstructors.get(metadata.getColumnType(columnIndex));
        }
        if (ast.type == 8 && ast.paramCount == 0 && SqlKeywords.isCountKeyword(ast.token)) {
            this.tempVecConstructorArgIndexes.add(-1);
            return countConstructors.get(ColumnType.pow2SizeOf(this.tempKeyIndexesInBase.getQuick(0)));
        }
        if (this.isSingleColumnFunction(ast, "ksum")) {
            int columnIndex = metadata.getColumnIndex(ast.rhs.token);
            this.tempVecConstructorArgIndexes.add(columnIndex);
            return ksumConstructors.get(metadata.getColumnType(columnIndex));
        }
        if (this.isSingleColumnFunction(ast, "nsum")) {
            int columnIndex = metadata.getColumnIndex(ast.rhs.token);
            this.tempVecConstructorArgIndexes.add(columnIndex);
            return nsumConstructors.get(metadata.getColumnType(columnIndex));
        }
        if (this.isSingleColumnFunction(ast, "avg")) {
            int columnIndex = metadata.getColumnIndex(ast.rhs.token);
            this.tempVecConstructorArgIndexes.add(columnIndex);
            return avgConstructors.get(metadata.getColumnType(columnIndex));
        }
        if (this.isSingleColumnFunction(ast, "min")) {
            int columnIndex = metadata.getColumnIndex(ast.rhs.token);
            this.tempVecConstructorArgIndexes.add(columnIndex);
            return minConstructors.get(metadata.getColumnType(columnIndex));
        }
        if (this.isSingleColumnFunction(ast, "max")) {
            int columnIndex = metadata.getColumnIndex(ast.rhs.token);
            this.tempVecConstructorArgIndexes.add(columnIndex);
            return maxConstructors.get(metadata.getColumnType(columnIndex));
        }
        return null;
    }

    private boolean assembleKeysAndFunctionReferences(ObjList<QueryColumn> columns, RecordMetadata metadata, boolean checkLiterals) {
        this.tempVaf.clear();
        this.tempMetadata.clear();
        this.tempSymbolSkewIndexes.clear();
        this.tempVecConstructors.clear();
        this.tempVecConstructorArgIndexes.clear();
        this.tempAggIndex.clear();
        int n = columns.size();
        for (int i = 0; i < n; ++i) {
            QueryColumn qc = columns.getQuick(i);
            ExpressionNode ast = qc.getAst();
            if (ast.type == 4) {
                if (!checkLiterals) continue;
                int columnIndex = metadata.getColumnIndex(ast.token);
                int type = metadata.getColumnType(columnIndex);
                if (type == 4) {
                    this.tempKeyIndexesInBase.add(columnIndex);
                    this.tempKeyIndex.add(i);
                    this.arrayColumnTypes.add(4);
                    this.tempKeyKinds.add(0);
                    continue;
                }
                if (type == 11) {
                    this.tempKeyIndexesInBase.add(columnIndex);
                    this.tempKeyIndex.add(i);
                    this.tempSymbolSkewIndexes.extendAndSet(i, columnIndex);
                    this.arrayColumnTypes.add(11);
                    this.tempKeyKinds.add(0);
                    continue;
                }
                return false;
            }
            VectorAggregateFunctionConstructor constructor = this.assembleFunctionReference(metadata, ast);
            if (constructor != null) {
                this.tempVecConstructors.add(constructor);
                this.tempAggIndex.add(i);
                continue;
            }
            return false;
        }
        return true;
    }

    private RecordMetadata calculateSetMetadata(RecordMetadata masterMetadata) {
        return GenericRecordMetadata.removeTimestamp(masterMetadata);
    }

    @Nullable
    private Function compileFilter(IntrinsicModel intrinsicModel, RecordMetadata readerMeta, SqlExecutionContext executionContext) throws SqlException {
        if (intrinsicModel.filter != null) {
            return this.compileFilter(intrinsicModel.filter, readerMeta, executionContext);
        }
        return null;
    }

    private RecordCursorFactory createAsOfJoin(RecordMetadata metadata, RecordCursorFactory master, RecordSink masterKeySink, RecordCursorFactory slave, RecordSink slaveKeySink, int columnSplit) {
        this.valueTypes.clear();
        this.valueTypes.add(5);
        this.valueTypes.add(5);
        return new AsOfJoinLightRecordCursorFactory(this.configuration, metadata, master, slave, this.keyTypes, this.valueTypes, masterKeySink, slaveKeySink, columnSplit);
    }

    @NotNull
    private RecordCursorFactory createFullFatJoin(RecordCursorFactory master, RecordMetadata masterMetadata, CharSequence masterAlias, RecordCursorFactory slave, RecordMetadata slaveMetadata, CharSequence slaveAlias, int joinPosition, FullFatJoinGenerator generator) throws SqlException {
        this.intHashSet.clear();
        int n = this.listColumnFilterA.getColumnCount();
        for (int i = 0; i < n; ++i) {
            this.intHashSet.add(this.listColumnFilterA.getColumnIndexFactored(i));
        }
        int m = slaveMetadata.getColumnCount();
        for (int k = 0; k < m; ++k) {
            int type;
            if (!this.intHashSet.excludes(k) || (type = slaveMetadata.getColumnType(k)) != 10 && type != 13) continue;
            throw SqlException.position(joinPosition).put("right side column '").put(slaveMetadata.getColumnName(k)).put("' is of unsupported type");
        }
        RecordSink masterSink = RecordSinkFactory.getInstance(this.asm, masterMetadata, this.listColumnFilterB, true);
        JoinRecordMetadata metadata = new JoinRecordMetadata(this.configuration, masterMetadata.getColumnCount() + slaveMetadata.getColumnCount());
        metadata.copyColumnMetadataFrom(masterAlias, masterMetadata);
        IntList columnIndex = new IntList(slaveMetadata.getColumnCount());
        this.listColumnFilterB.clear();
        this.valueTypes.clear();
        ArrayColumnTypes slaveTypes = new ArrayColumnTypes();
        if (slaveMetadata instanceof BaseRecordMetadata) {
            int i;
            int n2 = slaveMetadata.getColumnCount();
            for (i = 0; i < n2; ++i) {
                if (!this.intHashSet.excludes(i)) continue;
                TableColumnMetadata m2 = ((BaseRecordMetadata)slaveMetadata).getColumnQuick(i);
                metadata.add(slaveAlias, m2);
                this.listColumnFilterB.add(i + 1);
                columnIndex.add(i);
                this.valueTypes.add(m2.getType());
                slaveTypes.add(m2.getType());
            }
            n2 = this.listColumnFilterA.getColumnCount();
            for (i = 0; i < n2; ++i) {
                int index = this.listColumnFilterA.getColumnIndexFactored(i);
                TableColumnMetadata m3 = ((BaseRecordMetadata)slaveMetadata).getColumnQuick(index);
                if (m3.getType() == 11) {
                    metadata.add(slaveAlias, m3.getName(), 10, false, 0, false, null);
                    slaveTypes.add(10);
                } else {
                    metadata.add(slaveAlias, m3);
                    slaveTypes.add(m3.getType());
                }
                columnIndex.add(index);
            }
        } else {
            int i;
            int n3 = slaveMetadata.getColumnCount();
            for (i = 0; i < n3; ++i) {
                if (!this.intHashSet.excludes(i)) continue;
                int type = slaveMetadata.getColumnType(i);
                metadata.add(slaveAlias, slaveMetadata.getColumnName(i), type, slaveMetadata.isColumnIndexed(i), slaveMetadata.getIndexValueBlockCapacity(i), slaveMetadata.isSymbolTableStatic(i), slaveMetadata.getMetadata(i));
                this.listColumnFilterB.add(i + 1);
                columnIndex.add(i);
                this.valueTypes.add(type);
                slaveTypes.add(type);
            }
            n3 = this.listColumnFilterA.getColumnCount();
            for (i = 0; i < n3; ++i) {
                int index = this.listColumnFilterA.getColumnIndexFactored(i);
                int type = slaveMetadata.getColumnType(index);
                if (type == 11) {
                    type = 10;
                }
                metadata.add(slaveAlias, slaveMetadata.getColumnName(index), type, slaveMetadata.isColumnIndexed(i), slaveMetadata.getIndexValueBlockCapacity(i), slaveMetadata.isSymbolTableStatic(i), slaveMetadata.getMetadata(i));
                columnIndex.add(index);
                slaveTypes.add(type);
            }
        }
        if (masterMetadata.getTimestampIndex() != -1) {
            metadata.setTimestampIndex(masterMetadata.getTimestampIndex());
        }
        return generator.create(this.configuration, metadata, master, slave, this.keyTypes, this.valueTypes, slaveTypes, masterSink, RecordSinkFactory.getInstance(this.asm, slaveMetadata, this.listColumnFilterA, true), masterMetadata.getColumnCount(), RecordValueSinkFactory.getInstance(this.asm, slaveMetadata, this.listColumnFilterB), columnIndex);
    }

    private RecordCursorFactory createHashJoin(RecordMetadata metadata, RecordCursorFactory master, RecordCursorFactory slave, int joinType) {
        RecordMetadata masterMetadata = master.getMetadata();
        RecordMetadata slaveMetadata = slave.getMetadata();
        RecordSink masterKeySink = RecordSinkFactory.getInstance(this.asm, masterMetadata, this.listColumnFilterB, true);
        RecordSink slaveKeySink = RecordSinkFactory.getInstance(this.asm, slaveMetadata, this.listColumnFilterA, true);
        this.valueTypes.clear();
        this.valueTypes.add(5);
        this.valueTypes.add(5);
        if (slave.recordCursorSupportsRandomAccess() && !this.fullFatJoins) {
            if (joinType == 1) {
                return new HashJoinLightRecordCursorFactory(this.configuration, metadata, master, slave, this.keyTypes, this.valueTypes, masterKeySink, slaveKeySink, masterMetadata.getColumnCount());
            }
            return new HashOuterJoinLightRecordCursorFactory(this.configuration, metadata, master, slave, this.keyTypes, this.valueTypes, masterKeySink, slaveKeySink, masterMetadata.getColumnCount());
        }
        this.entityColumnFilter.of(slaveMetadata.getColumnCount());
        RecordSink slaveSink = RecordSinkFactory.getInstance(this.asm, slaveMetadata, this.entityColumnFilter, false);
        if (joinType == 1) {
            return new HashJoinRecordCursorFactory(this.configuration, metadata, master, slave, this.keyTypes, this.valueTypes, masterKeySink, slaveKeySink, slaveSink, masterMetadata.getColumnCount());
        }
        return new HashOuterJoinRecordCursorFactory(this.configuration, metadata, master, slave, this.keyTypes, this.valueTypes, masterKeySink, slaveKeySink, slaveSink, masterMetadata.getColumnCount());
    }

    @NotNull
    private JoinRecordMetadata createJoinMetadata(CharSequence masterAlias, RecordMetadata masterMetadata, CharSequence slaveAlias, RecordMetadata slaveMetadata) {
        return this.createJoinMetadata(masterAlias, masterMetadata, slaveAlias, slaveMetadata, masterMetadata.getTimestampIndex());
    }

    @NotNull
    private JoinRecordMetadata createJoinMetadata(CharSequence masterAlias, RecordMetadata masterMetadata, CharSequence slaveAlias, RecordMetadata slaveMetadata, int timestampIndex) {
        JoinRecordMetadata metadata = new JoinRecordMetadata(this.configuration, masterMetadata.getColumnCount() + slaveMetadata.getColumnCount());
        metadata.copyColumnMetadataFrom(masterAlias, masterMetadata);
        metadata.copyColumnMetadataFrom(slaveAlias, slaveMetadata);
        if (timestampIndex != -1) {
            metadata.setTimestampIndex(timestampIndex);
        }
        return metadata;
    }

    private RecordCursorFactory createLtJoin(RecordMetadata metadata, RecordCursorFactory master, RecordSink masterKeySink, RecordCursorFactory slave, RecordSink slaveKeySink, int columnSplit) {
        this.valueTypes.clear();
        this.valueTypes.add(5);
        this.valueTypes.add(5);
        return new LtJoinLightRecordCursorFactory(this.configuration, metadata, master, slave, this.keyTypes, this.valueTypes, masterKeySink, slaveKeySink, columnSplit);
    }

    private RecordCursorFactory createSpliceJoin(RecordMetadata metadata, RecordCursorFactory master, RecordSink masterKeySink, RecordCursorFactory slave, RecordSink slaveKeySink, int columnSplit) {
        this.valueTypes.clear();
        this.valueTypes.add(5);
        this.valueTypes.add(5);
        this.valueTypes.add(5);
        this.valueTypes.add(5);
        return new SpliceJoinLightRecordCursorFactory(this.configuration, metadata, master, slave, this.keyTypes, this.valueTypes, masterKeySink, slaveKeySink, columnSplit);
    }

    RecordCursorFactory generate(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        return this.generateQuery(model, executionContext, true);
    }

    private RecordCursorFactory generateFilter(RecordCursorFactory factory, QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        ExpressionNode filter = model.getWhereClause();
        return filter == null ? factory : this.generateFilter0(factory, model, executionContext, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private RecordCursorFactory generateFilter0(RecordCursorFactory factory, QueryModel model, SqlExecutionContext executionContext, ExpressionNode filter) throws SqlException {
        model.setWhereClause(null);
        Function f = this.compileFilter(filter, factory.getMetadata(), executionContext);
        if (f.isConstant()) {
            try {
                if (f.getBool(null)) {
                    RecordCursorFactory recordCursorFactory = factory;
                    return recordCursorFactory;
                }
                EmptyTableRecordCursorFactory emptyTableRecordCursorFactory = new EmptyTableRecordCursorFactory(factory.getMetadata());
                return emptyTableRecordCursorFactory;
            }
            finally {
                f.close();
            }
        }
        return new FilteredRecordCursorFactory(factory, f);
    }

    private RecordCursorFactory generateFunctionQuery(QueryModel model) throws SqlException {
        Function function = model.getTableNameFunction();
        assert (function != null);
        if (function.getType() != 15) {
            throw SqlException.position(model.getTableName().position).put("function must return CURSOR [actual=").put(ColumnType.nameOf(function.getType())).put(']');
        }
        return function.getRecordCursorFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RecordCursorFactory generateJoins(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        ObjList<QueryModel> joinModels = model.getJoinModels();
        IntList ordered = model.getOrderedJoinModels();
        RecordCursorFactory master = null;
        CharSequence masterAlias = null;
        try {
            Function function;
            int n = ordered.size();
            assert (n > 0);
            for (int i = 0; i < n; ++i) {
                int index = ordered.getQuick(i);
                QueryModel slaveModel = joinModels.getQuick(index);
                RecordCursorFactory slave = this.generateQuery(slaveModel, executionContext, index > 0);
                if (master == null) {
                    master = slave;
                    masterAlias = slaveModel.getName();
                } else {
                    int joinType = slaveModel.getJoinType();
                    RecordMetadata masterMetadata = master.getMetadata();
                    RecordMetadata slaveMetadata = slave.getMetadata();
                    switch (joinType) {
                        case 3: {
                            master = new CrossJoinRecordCursorFactory(this.createJoinMetadata(masterAlias, masterMetadata, slaveModel.getName(), slaveMetadata), master, slave, masterMetadata.getColumnCount());
                            masterAlias = null;
                            break;
                        }
                        case 4: {
                            executionContext.pushTimestampRequiredFlag(true);
                            try {
                                this.validateBothTimestamps(slaveModel, masterMetadata, slaveMetadata);
                                this.processJoinContext(index == 1, slaveModel.getContext(), masterMetadata, slaveMetadata);
                                master = slave.recordCursorSupportsRandomAccess() && !this.fullFatJoins ? (this.listColumnFilterA.size() > 0 && this.listColumnFilterB.size() > 0 ? this.createAsOfJoin(this.createJoinMetadata(masterAlias, masterMetadata, slaveModel.getName(), slaveMetadata), master, RecordSinkFactory.getInstance(this.asm, masterMetadata, this.listColumnFilterB, true), slave, RecordSinkFactory.getInstance(this.asm, slaveMetadata, this.listColumnFilterA, true), masterMetadata.getColumnCount()) : new AsOfJoinNoKeyRecordCursorFactory(this.createJoinMetadata(masterAlias, masterMetadata, slaveModel.getName(), slaveMetadata), master, slave, masterMetadata.getColumnCount())) : this.createFullFatJoin(master, masterMetadata, masterAlias, slave, slaveMetadata, slaveModel.getName(), slaveModel.getJoinKeywordPosition(), CREATE_FULL_FAT_AS_OF_JOIN);
                                masterAlias = null;
                                break;
                            }
                            finally {
                                executionContext.popTimestampRequiredFlag();
                            }
                        }
                        case 6: {
                            executionContext.pushTimestampRequiredFlag(true);
                            try {
                                this.validateBothTimestamps(slaveModel, masterMetadata, slaveMetadata);
                                this.processJoinContext(index == 1, slaveModel.getContext(), masterMetadata, slaveMetadata);
                                master = slave.recordCursorSupportsRandomAccess() && !this.fullFatJoins ? (this.listColumnFilterA.size() > 0 && this.listColumnFilterB.size() > 0 ? this.createLtJoin(this.createJoinMetadata(masterAlias, masterMetadata, slaveModel.getName(), slaveMetadata), master, RecordSinkFactory.getInstance(this.asm, masterMetadata, this.listColumnFilterB, true), slave, RecordSinkFactory.getInstance(this.asm, slaveMetadata, this.listColumnFilterA, true), masterMetadata.getColumnCount()) : new LtJoinNoKeyRecordCursorFactory(this.createJoinMetadata(masterAlias, masterMetadata, slaveModel.getName(), slaveMetadata), master, slave, masterMetadata.getColumnCount())) : this.createFullFatJoin(master, masterMetadata, masterAlias, slave, slaveMetadata, slaveModel.getName(), slaveModel.getJoinKeywordPosition(), CREATE_FULL_FAT_LT_JOIN);
                                masterAlias = null;
                                break;
                            }
                            finally {
                                executionContext.popTimestampRequiredFlag();
                            }
                        }
                        case 5: {
                            executionContext.pushTimestampRequiredFlag(true);
                            try {
                                this.validateBothTimestamps(slaveModel, masterMetadata, slaveMetadata);
                                this.processJoinContext(index == 1, slaveModel.getContext(), masterMetadata, slaveMetadata);
                                if (slave.recordCursorSupportsRandomAccess() && master.recordCursorSupportsRandomAccess() && !this.fullFatJoins) {
                                    master = this.createSpliceJoin(this.createJoinMetadata(masterAlias, masterMetadata, slaveModel.getName(), slaveMetadata, -1), master, RecordSinkFactory.getInstance(this.asm, masterMetadata, this.listColumnFilterB, true), slave, RecordSinkFactory.getInstance(this.asm, slaveMetadata, this.listColumnFilterA, true), masterMetadata.getColumnCount());
                                } else assert (false);
                                break;
                            }
                            finally {
                                executionContext.popTimestampRequiredFlag();
                            }
                        }
                        default: {
                            this.processJoinContext(index == 1, slaveModel.getContext(), masterMetadata, slaveMetadata);
                            master = this.createHashJoin(this.createJoinMetadata(masterAlias, masterMetadata, slaveModel.getName(), slaveMetadata), master, slave, joinType);
                            masterAlias = null;
                        }
                    }
                }
                ExpressionNode filter = slaveModel.getPostJoinWhereClause();
                if (filter == null) continue;
                master = new FilteredRecordCursorFactory(master, this.functionParser.parseFunction(filter, master.getMetadata(), executionContext));
            }
            ExpressionNode constFilter = model.getConstWhereClause();
            if (constFilter != null && !(function = this.functionParser.parseFunction(constFilter, null, executionContext)).getBool(null)) {
                JoinRecordMetadata metadata = (JoinRecordMetadata)master.getMetadata();
                metadata.incrementRefCount();
                EmptyTableRecordCursorFactory factory = new EmptyTableRecordCursorFactory(metadata);
                Misc.free(master);
                return factory;
            }
            return master;
        }
        catch (Throwable e) {
            Misc.free(master);
            throw e;
        }
    }

    @NotNull
    private RecordCursorFactory generateLatestByQuery(QueryModel model, TableReader reader, RecordMetadata metadata, String tableName, IntrinsicModel intrinsicModel, Function filter, SqlExecutionContext executionContext, int timestampIndex, @NotNull IntList columnIndexes) throws SqlException {
        AbstractDataFrameCursorFactory dataFrameCursorFactory = intrinsicModel.hasIntervalFilters() ? new IntervalBwdDataFrameCursorFactory(this.engine, tableName, model.getTableVersion(), intrinsicModel.buildIntervalModel(), timestampIndex) : new FullBwdDataFrameCursorFactory(this.engine, tableName, model.getTableVersion());
        model.setWhereClause(null);
        if (this.listColumnFilterA.size() == 1) {
            int latestByIndex = this.listColumnFilterA.getColumnIndexFactored(0);
            boolean indexed = metadata.isColumnIndexed(latestByIndex);
            if (metadata.getColumnType(latestByIndex) != 11) {
                return new LatestByAllFilteredRecordCursorFactory(metadata, this.configuration, dataFrameCursorFactory, RecordSinkFactory.getInstance(this.asm, metadata, this.listColumnFilterA, false), this.keyTypes, filter, columnIndexes);
            }
            if (intrinsicModel.keyColumn != null) {
                assert (latestByIndex == metadata.getColumnIndexQuiet(intrinsicModel.keyColumn));
                if (intrinsicModel.keySubQuery != null) {
                    RecordCursorFactory rcf = this.generate(intrinsicModel.keySubQuery, executionContext);
                    Record.CharSequenceFunction func = this.validateSubQueryColumnAndGetGetter(intrinsicModel, rcf.getMetadata());
                    return new LatestBySubQueryRecordCursorFactory(this.configuration, metadata, dataFrameCursorFactory, latestByIndex, rcf, filter, indexed, func, columnIndexes);
                }
                int nKeyValues = intrinsicModel.keyValues.size();
                if (indexed) {
                    assert (nKeyValues > 0);
                    SymbolMapReader symbolMapReader = reader.getSymbolMapReader(latestByIndex);
                    if (nKeyValues == 1) {
                        CharSequence symbolValue = intrinsicModel.keyValues.get(0);
                        int symbol = symbolMapReader.keyOf(symbolValue);
                        if (filter == null) {
                            RowCursorFactory rcf = symbol == -2 ? new LatestByValueDeferredIndexedRowCursorFactory(latestByIndex, Chars.toString(symbolValue), false) : new LatestByValueIndexedRowCursorFactory(latestByIndex, symbol, false);
                            return new DataFrameRecordCursorFactory(metadata, dataFrameCursorFactory, rcf, false, null, false, columnIndexes, null);
                        }
                        if (symbol == -2) {
                            return new LatestByValueDeferredIndexedFilteredRecordCursorFactory(metadata, dataFrameCursorFactory, latestByIndex, Chars.toString(symbolValue), filter, columnIndexes);
                        }
                        return new LatestByValueIndexedFilteredRecordCursorFactory(metadata, dataFrameCursorFactory, latestByIndex, symbol, filter, columnIndexes);
                    }
                    return new LatestByValuesIndexedFilteredRecordCursorFactory(this.configuration, metadata, dataFrameCursorFactory, latestByIndex, intrinsicModel.keyValues, symbolMapReader, filter, columnIndexes);
                }
                assert (nKeyValues > 0);
                SymbolMapReader symbolMapReader = reader.getSymbolMapReader(latestByIndex);
                if (nKeyValues > 1) {
                    return new LatestByValuesFilteredRecordCursorFactory(this.configuration, metadata, dataFrameCursorFactory, latestByIndex, intrinsicModel.keyValues, symbolMapReader, filter, columnIndexes);
                }
                int symbolKey = symbolMapReader.keyOf(intrinsicModel.keyValues.get(0));
                if (symbolKey == -2) {
                    return new LatestByValueDeferredFilteredRecordCursorFactory(metadata, dataFrameCursorFactory, latestByIndex, Chars.toString(intrinsicModel.keyValues.get(0)), filter, columnIndexes);
                }
                return new LatestByValueFilteredRecordCursorFactory(metadata, dataFrameCursorFactory, latestByIndex, symbolKey, filter, columnIndexes);
            }
            assert (intrinsicModel.keyValues.size() == 0);
            if (indexed) {
                return new LatestByAllIndexedFilteredRecordCursorFactory(this.configuration, metadata, dataFrameCursorFactory, latestByIndex, filter, columnIndexes);
            }
        }
        return new LatestByAllFilteredRecordCursorFactory(metadata, this.configuration, dataFrameCursorFactory, RecordSinkFactory.getInstance(this.asm, metadata, this.listColumnFilterA, false), this.keyTypes, filter, columnIndexes);
    }

    private RecordCursorFactory generateLimit(RecordCursorFactory factory, QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        Function hiFunc;
        int type;
        Function loFunc;
        ExpressionNode limitLo = model.getLimitLo();
        ExpressionNode limitHi = model.getLimitHi();
        if (limitLo == null && limitHi == null) {
            return factory;
        }
        if (limitLo == null) {
            loFunc = new LongConstant(0, 0L);
        } else {
            loFunc = this.functionParser.parseFunction(limitLo, EmptyRecordMetadata.INSTANCE, executionContext);
            type = loFunc.getType();
            if (limitTypes.excludes(type)) {
                throw SqlException.$(limitLo.position, "invalid type: ").put(ColumnType.nameOf(type));
            }
        }
        if (limitHi != null) {
            hiFunc = this.functionParser.parseFunction(limitHi, EmptyRecordMetadata.INSTANCE, executionContext);
            type = hiFunc.getType();
            if (limitTypes.excludes(type)) {
                throw SqlException.$(limitHi.position, "invalid type: ").put(ColumnType.nameOf(type));
            }
        } else {
            hiFunc = null;
        }
        return new LimitRecordCursorFactory(factory, loFunc, hiFunc);
    }

    private RecordCursorFactory generateNoSelect(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        ExpressionNode tableName = model.getTableName();
        if (tableName != null) {
            if (tableName.type == 8) {
                return this.generateFunctionQuery(model);
            }
            return this.generateTableQuery(model, executionContext);
        }
        return this.generateSubQuery(model, executionContext);
    }

    private RecordCursorFactory generateOrderBy(RecordCursorFactory recordCursorFactory, QueryModel model) throws SqlException {
        if (recordCursorFactory.followedOrderByAdvice()) {
            return recordCursorFactory;
        }
        try {
            LowerCaseCharSequenceIntHashMap orderBy = model.getOrderHash();
            ObjList<CharSequence> columnNames = orderBy.keys();
            int size = columnNames.size();
            if (size > 0) {
                int index;
                CharSequence column;
                RecordMetadata metadata = recordCursorFactory.getMetadata();
                this.listColumnFilterA.clear();
                this.intHashSet.clear();
                for (int i = 0; i < size; ++i) {
                    column = columnNames.getQuick(i);
                    index = metadata.getColumnIndexQuiet(column);
                    if (metadata.getColumnType(index) == 13) {
                        ObjList<ExpressionNode> nodes = model.getOrderBy();
                        int position = 0;
                        int y = nodes.size();
                        for (int j = 0; j < y; ++j) {
                            if (!Chars.equals(column, nodes.getQuick((int)i).token)) continue;
                            position = nodes.getQuick((int)i).position;
                            break;
                        }
                        throw SqlException.$(position, "unsupported column type: ").put(ColumnType.nameOf(metadata.getColumnType(index)));
                    }
                    if (!this.intHashSet.add(index)) continue;
                    if (orderBy.get(column) == 1) {
                        this.listColumnFilterA.add(-index - 1);
                        continue;
                    }
                    this.listColumnFilterA.add(index + 1);
                }
                if (metadata.getTimestampIndex() != -1 && (index = metadata.getColumnIndexQuiet(column = columnNames.getQuick(0))) == metadata.getTimestampIndex() && size == 1 && orderBy.get(column) == 0) {
                    return recordCursorFactory;
                }
                GenericRecordMetadata orderedMetadata = GenericRecordMetadata.copyOfSansTimestamp(metadata);
                if (recordCursorFactory.recordCursorSupportsRandomAccess()) {
                    return new SortedLightRecordCursorFactory(this.configuration, orderedMetadata, recordCursorFactory, this.recordComparatorCompiler.compile(metadata, this.listColumnFilterA));
                }
                this.entityColumnFilter.of(orderedMetadata.getColumnCount());
                return new SortedRecordCursorFactory(this.configuration, orderedMetadata, recordCursorFactory, orderedMetadata, RecordSinkFactory.getInstance(this.asm, orderedMetadata, this.entityColumnFilter, false), this.recordComparatorCompiler.compile(metadata, this.listColumnFilterA));
            }
            return recordCursorFactory;
        }
        catch (CairoException | SqlException e) {
            recordCursorFactory.close();
            throw e;
        }
    }

    private RecordCursorFactory generateQuery(QueryModel model, SqlExecutionContext executionContext, boolean processJoins) throws SqlException {
        RecordCursorFactory factory = this.generateQuery0(model, executionContext, processJoins);
        if (model.getUnionModel() != null) {
            return this.generateSetFactory(model, factory, executionContext);
        }
        return factory;
    }

    private RecordCursorFactory generateQuery0(QueryModel model, SqlExecutionContext executionContext, boolean processJoins) throws SqlException {
        return this.generateLimit(this.generateOrderBy(this.generateFilter(this.generateSelect(model, executionContext, processJoins), model, executionContext), model), model, executionContext);
    }

    @NotNull
    private RecordCursorFactory generateSampleBy(QueryModel model, SqlExecutionContext executionContext, ExpressionNode sampleByNode) throws SqlException {
        executionContext.pushTimestampRequiredFlag(true);
        try {
            int fillCount;
            TimestampSampler timestampSampler;
            ObjList<ExpressionNode> sampleByFill;
            RecordMetadata metadata;
            int timestampIndex;
            RecordCursorFactory factory;
            block23: {
                factory = this.generateSubQuery(model, executionContext);
                timestampIndex = this.getTimestampIndex(model, factory);
                if (timestampIndex == -1) {
                    Misc.free(factory);
                    throw SqlException.$(model.getModelPosition(), "base query does not provide dedicated TIMESTAMP column");
                }
                metadata = factory.getMetadata();
                sampleByFill = model.getSampleByFill();
                timestampSampler = TimestampSamplerFactory.getInstance(sampleByNode.token, sampleByNode.position);
                fillCount = sampleByFill.size();
                try {
                    this.keyTypes.clear();
                    this.valueTypes.clear();
                    this.listColumnFilterA.clear();
                    if (fillCount != 1 || !Chars.equalsLowerCaseAscii(sampleByFill.getQuick((int)0).token, "linear")) break block23;
                    SampleByInterpolateRecordCursorFactory sampleByInterpolateRecordCursorFactory = new SampleByInterpolateRecordCursorFactory(this.configuration, factory, timestampSampler, model, this.listColumnFilterA, this.functionParser, executionContext, this.asm, this.keyTypes, this.valueTypes, this.entityColumnFilter, timestampIndex);
                    return sampleByInterpolateRecordCursorFactory;
                }
                catch (CairoException | SqlException e) {
                    factory.close();
                    throw e;
                }
            }
            int columnCount = model.getColumns().size();
            ObjList<GroupByFunction> groupByFunctions = new ObjList<GroupByFunction>(columnCount);
            this.valueTypes.add(7);
            GroupByUtils.prepareGroupByFunctions(model, metadata, this.functionParser, executionContext, groupByFunctions, this.valueTypes);
            ObjList<Function> recordFunctions = new ObjList<Function>(columnCount);
            GenericRecordMetadata groupByMetadata = new GenericRecordMetadata();
            GroupByUtils.prepareGroupByRecordFunctions(model, metadata, this.listColumnFilterA, groupByFunctions, recordFunctions, groupByMetadata, this.keyTypes, this.valueTypes.getColumnCount(), false, timestampIndex);
            if (fillCount == 1 && Chars.equalsLowerCaseAscii(sampleByFill.getQuick((int)0).token, "prev")) {
                if (this.keyTypes.getColumnCount() == 0) {
                    SampleByFillPrevNotKeyedRecordCursorFactory sampleByFillPrevNotKeyedRecordCursorFactory = new SampleByFillPrevNotKeyedRecordCursorFactory(factory, timestampSampler, groupByMetadata, groupByFunctions, recordFunctions, timestampIndex, this.valueTypes.getColumnCount());
                    return sampleByFillPrevNotKeyedRecordCursorFactory;
                }
                SampleByFillPrevRecordCursorFactory sampleByFillPrevRecordCursorFactory = new SampleByFillPrevRecordCursorFactory(this.configuration, factory, timestampSampler, this.listColumnFilterA, this.asm, this.keyTypes, this.valueTypes, groupByMetadata, groupByFunctions, recordFunctions, timestampIndex);
                return sampleByFillPrevRecordCursorFactory;
            }
            if (fillCount == 0 || fillCount == 1 && Chars.equalsLowerCaseAscii(sampleByFill.getQuick((int)0).token, "none")) {
                if (this.keyTypes.getColumnCount() == 0) {
                    SampleByFillNoneNotKeyedRecordCursorFactory sampleByFillNoneNotKeyedRecordCursorFactory = new SampleByFillNoneNotKeyedRecordCursorFactory(factory, timestampSampler, groupByMetadata, groupByFunctions, recordFunctions, this.valueTypes.getColumnCount(), timestampIndex);
                    return sampleByFillNoneNotKeyedRecordCursorFactory;
                }
                SampleByFillNoneRecordCursorFactory sampleByFillNoneRecordCursorFactory = new SampleByFillNoneRecordCursorFactory(this.configuration, factory, groupByMetadata, groupByFunctions, recordFunctions, timestampSampler, this.listColumnFilterA, this.asm, this.keyTypes, this.valueTypes, timestampIndex);
                return sampleByFillNoneRecordCursorFactory;
            }
            if (fillCount == 1 && SqlKeywords.isNullKeyword(sampleByFill.getQuick((int)0).token)) {
                if (this.keyTypes.getColumnCount() == 0) {
                    SampleByFillNullNotKeyedRecordCursorFactory sampleByFillNullNotKeyedRecordCursorFactory = new SampleByFillNullNotKeyedRecordCursorFactory(factory, timestampSampler, groupByMetadata, groupByFunctions, recordFunctions, this.valueTypes.getColumnCount(), timestampIndex);
                    return sampleByFillNullNotKeyedRecordCursorFactory;
                }
                SampleByFillNullRecordCursorFactory sampleByFillNullRecordCursorFactory = new SampleByFillNullRecordCursorFactory(this.configuration, factory, timestampSampler, this.listColumnFilterA, this.asm, this.keyTypes, this.valueTypes, groupByMetadata, groupByFunctions, recordFunctions, timestampIndex);
                return sampleByFillNullRecordCursorFactory;
            }
            assert (fillCount > 0);
            if (this.keyTypes.getColumnCount() == 0) {
                SampleByFillValueNotKeyedRecordCursorFactory sampleByFillValueNotKeyedRecordCursorFactory = new SampleByFillValueNotKeyedRecordCursorFactory(factory, timestampSampler, sampleByFill, groupByMetadata, groupByFunctions, recordFunctions, this.valueTypes.getColumnCount(), timestampIndex);
                return sampleByFillValueNotKeyedRecordCursorFactory;
            }
            SampleByFillValueRecordCursorFactory sampleByFillValueRecordCursorFactory = new SampleByFillValueRecordCursorFactory(this.configuration, factory, timestampSampler, this.listColumnFilterA, this.asm, sampleByFill, this.keyTypes, this.valueTypes, groupByMetadata, groupByFunctions, recordFunctions, timestampIndex);
            return sampleByFillValueRecordCursorFactory;
        }
        finally {
            executionContext.popTimestampRequiredFlag();
        }
    }

    private RecordCursorFactory generateSelect(QueryModel model, SqlExecutionContext executionContext, boolean processJoins) throws SqlException {
        switch (model.getSelectModelType()) {
            case 1: {
                return this.generateSelectChoose(model, executionContext);
            }
            case 4: {
                return this.generateSelectGroupBy(model, executionContext);
            }
            case 2: {
                return this.generateSelectVirtual(model, executionContext);
            }
            case 3: {
                return this.generateSelectAnalytic(model, executionContext);
            }
            case 5: {
                return this.generateSelectDistinct(model, executionContext);
            }
            case 6: {
                return this.generateSelectCursor(model, executionContext);
            }
        }
        if (model.getJoinModels().size() > 1 && processJoins) {
            return this.generateJoins(model, executionContext);
        }
        return this.generateNoSelect(model, executionContext);
    }

    private RecordCursorFactory generateSelectAnalytic(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        int i;
        TableColumnMetadata m;
        RecordCursorFactory base = this.generateSubQuery(model, executionContext);
        RecordMetadata baseMetadata = base.getMetadata();
        ObjList<QueryColumn> columns = model.getColumns();
        int columnCount = columns.size();
        this.grouppedAnalytic.clear();
        ObjList<AnalyticFunction> naturalOrderFunctions = null;
        this.valueTypes.clear();
        ArrayColumnTypes chainTypes = this.valueTypes;
        GenericRecordMetadata chainMetadata = new GenericRecordMetadata();
        GenericRecordMetadata factoryMetadata = new GenericRecordMetadata();
        this.listColumnFilterA.clear();
        this.listColumnFilterB.clear();
        IntHashSet columnSet = new IntHashSet();
        for (int i2 = 0; i2 < columnCount; ++i2) {
            QueryColumn qc = columns.getQuick(i2);
            if (qc instanceof AnalyticColumn) continue;
            int columnIndex = baseMetadata.getColumnIndexQuiet(qc.getAst().token);
            m = BaseRecordMetadata.copyOf(baseMetadata, columnIndex);
            chainMetadata.add(i2, m);
            factoryMetadata.add(i2, m);
            chainTypes.add(i2, m.getType());
            this.listColumnFilterA.extendAndSet(i2, i2 + 1);
            this.listColumnFilterB.extendAndSet(i2, columnIndex);
            columnSet.add(columnIndex);
        }
        int addAt = columnCount;
        int n = baseMetadata.getColumnCount();
        for (int i3 = 0; i3 < n; ++i3) {
            if (!columnSet.excludes(i3)) continue;
            m = BaseRecordMetadata.copyOf(baseMetadata, i3);
            chainMetadata.add(addAt, m);
            chainTypes.add(addAt, m.getType());
            this.listColumnFilterA.extendAndSet(addAt, addAt + 1);
            this.listColumnFilterB.extendAndSet(addAt, i3);
            ++addAt;
        }
        ObjList<TableColumnMetadata> deferredAnalyticMetadata = new ObjList<TableColumnMetadata>();
        for (i = 0; i < columnCount; ++i) {
            boolean dismissOrder;
            RecordSink partitionBySink;
            VirtualRecord partitionByRecord;
            QueryColumn qc = columns.getQuick(i);
            if (!(qc instanceof AnalyticColumn)) continue;
            AnalyticColumn ac = (AnalyticColumn)qc;
            ExpressionNode expressionNode = qc.getAst();
            if (expressionNode.paramCount > 1) {
                throw SqlException.$(expressionNode.position, "Too many arguments");
            }
            ObjList<Function> partitionBy = null;
            int psz = ac.getPartitionBy().size();
            if (psz > 0) {
                partitionBy = new ObjList<Function>(psz);
                for (int j = 0; j < psz; ++j) {
                    partitionBy.add(this.functionParser.parseFunction(ac.getPartitionBy().getQuick(j), chainMetadata, executionContext));
                }
            }
            if (partitionBy != null) {
                partitionByRecord = new VirtualRecord(partitionBy);
                this.keyTypes.clear();
                int partitionByCount = partitionBy.size();
                for (int j = 0; j < partitionByCount; ++j) {
                    this.keyTypes.add(((Function)partitionBy.getQuick(j)).getType());
                }
                this.entityColumnFilter.of(partitionByCount);
                partitionBySink = RecordSinkFactory.getInstance(this.asm, this.keyTypes, this.entityColumnFilter, false);
            } else {
                partitionByRecord = null;
                partitionBySink = null;
            }
            int osz = ac.getOrderBy().size();
            executionContext.configureAnalyticContext(partitionByRecord, partitionBySink, this.keyTypes, osz > 0, base.recordCursorSupportsRandomAccess());
            Function f = this.functionParser.parseFunction(ac.getAst(), baseMetadata, executionContext);
            assert (f instanceof AnalyticFunction);
            AnalyticFunction analyticFunction = (AnalyticFunction)f;
            LowerCaseCharSequenceIntHashMap orderHash = model.getOrderHash();
            if (osz > 0 && orderHash.size() > 0) {
                dismissOrder = true;
                for (int j = 0; j < osz; ++j) {
                    ExpressionNode node = ac.getOrderBy().getQuick(j);
                    int direction = ac.getOrderByDirection().getQuick(j);
                    if (orderHash.get(node.token) == direction) continue;
                    dismissOrder = false;
                    break;
                }
            } else {
                dismissOrder = false;
            }
            if (osz > 0 && !dismissOrder) {
                IntList order = this.toOrderIndices(chainMetadata, ac.getOrderBy(), ac.getOrderByDirection());
                ObjList<AnalyticFunction> funcs = this.grouppedAnalytic.get(order);
                if (funcs == null) {
                    funcs = new ObjList();
                    this.grouppedAnalytic.put(order, funcs);
                }
                funcs.add(analyticFunction);
            } else {
                if (naturalOrderFunctions == null) {
                    naturalOrderFunctions = new ObjList<AnalyticFunction>();
                }
                naturalOrderFunctions.add(analyticFunction);
            }
            analyticFunction.setColumnIndex(i);
            deferredAnalyticMetadata.extendAndSet(i, new TableColumnMetadata(Chars.toString(qc.getAlias()), analyticFunction.getType(), false, 0, false, null));
            this.listColumnFilterA.extendAndSet(i, -i - 1);
        }
        int n2 = deferredAnalyticMetadata.size();
        for (i = 0; i < n2; ++i) {
            TableColumnMetadata m2 = (TableColumnMetadata)deferredAnalyticMetadata.getQuick(i);
            if (m2 == null) continue;
            chainTypes.add(i, m2.getType());
            factoryMetadata.add(i, m2);
        }
        ObjList<RecordComparator> analyticComparators = new ObjList<RecordComparator>(this.grouppedAnalytic.size());
        ObjList<ObjList<AnalyticFunction>> functionGroups = new ObjList<ObjList<AnalyticFunction>>(this.grouppedAnalytic.size());
        for (ObjObjHashMap.Entry entry : this.grouppedAnalytic) {
            analyticComparators.add(this.recordComparatorCompiler.compile(chainTypes, (IntList)entry.key));
            functionGroups.add((ObjList<AnalyticFunction>)entry.value);
        }
        RecordSink recordSink = RecordSinkFactory.getInstance(this.asm, chainTypes, this.listColumnFilterA, false, this.listColumnFilterB);
        return new CachedAnalyticRecordCursorFactory(this.configuration, base, recordSink, factoryMetadata, chainTypes, analyticComparators, functionGroups, naturalOrderFunctions);
    }

    private RecordCursorFactory generateSelectChoose(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        boolean entity;
        RecordCursorFactory factory = this.generateSubQuery(model, executionContext);
        RecordMetadata metadata = factory.getMetadata();
        ObjList<QueryColumn> columns = model.getColumns();
        int selectColumnCount = columns.size();
        ExpressionNode timestamp = model.getTimestamp();
        if (timestamp == null && metadata.getColumnCount() == selectColumnCount) {
            entity = true;
            for (int i = 0; i < selectColumnCount; ++i) {
                QueryColumn qc = columns.getQuick(i);
                if (Chars.equals((CharSequence)metadata.getColumnName(i), qc.getAst().token) && (qc.getAlias() == null || Chars.equals(qc.getAlias(), qc.getAst().token))) continue;
                entity = false;
                break;
            }
        } else {
            entity = false;
        }
        if (entity) {
            return factory;
        }
        int timestampIndex = this.getTimestampIndex(model, factory);
        if (timestampIndex == -1 && executionContext.isTimestampRequired()) {
            Misc.free(factory);
            throw SqlException.$(model.getModelPosition(), "TIMESTAMP column is required but not provided");
        }
        IntList columnCrossIndex = new IntList(selectColumnCount);
        GenericRecordMetadata selectMetadata = new GenericRecordMetadata();
        boolean timestampSet = false;
        for (int i = 0; i < selectColumnCount; ++i) {
            QueryColumn queryColumn = columns.getQuick(i);
            int index = metadata.getColumnIndexQuiet(queryColumn.getAst().token);
            assert (index > -1) : "wtf? " + queryColumn.getAst().token;
            columnCrossIndex.add(index);
            if (queryColumn.getAlias() == null) {
                selectMetadata.add(BaseRecordMetadata.copyOf(metadata, index));
            } else {
                selectMetadata.add(new TableColumnMetadata(Chars.toString(queryColumn.getAlias()), metadata.getColumnType(index), metadata.isColumnIndexed(index), metadata.getIndexValueBlockCapacity(index), metadata.isSymbolTableStatic(index), metadata.getMetadata(index)));
            }
            if (index != timestampIndex) continue;
            selectMetadata.setTimestampIndex(i);
            timestampSet = true;
        }
        if (!timestampSet && executionContext.isTimestampRequired()) {
            selectMetadata.add(BaseRecordMetadata.copyOf(metadata, timestampIndex));
            selectMetadata.setTimestampIndex(selectMetadata.getColumnCount() - 1);
            columnCrossIndex.add(timestampIndex);
        }
        return new SelectedRecordCursorFactory(selectMetadata, columnCrossIndex, factory);
    }

    private RecordCursorFactory generateSelectCursor(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        return new RecordAsAFieldRecordCursorFactory(this.generate(model.getNestedModel(), executionContext), model.getColumns().getQuick(0).getAlias());
    }

    private RecordCursorFactory generateSelectDistinct(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        ExpressionNode tableNameEn;
        QueryModel twoDeepNested;
        if (model.getColumns().size() == 1 && model.getNestedModel() != null && model.getNestedModel().getSelectModelType() == 1 && (twoDeepNested = model.getNestedModel().getNestedModel()) != null && twoDeepNested.getWhereClause() == null && twoDeepNested.getLatestBy().size() == 0 && (tableNameEn = twoDeepNested.getTableName()) != null) {
            CharSequence tableName = tableNameEn.token;
            try (TableReader reader = this.engine.getReader(executionContext.getCairoSecurityContext(), tableName);){
                CharSequence columnName = model.getBottomUpColumnNames().get(0);
                TableReaderMetadata readerMetadata = reader.getMetadata();
                int columnIndex = readerMetadata.getColumnIndex(columnName);
                int columnType = readerMetadata.getColumnType(columnIndex);
                if (readerMetadata.getVersion() >= 416 && columnType == 11) {
                    GenericRecordMetadata distinctSymbolMetadata = new GenericRecordMetadata();
                    distinctSymbolMetadata.add(BaseRecordMetadata.copyOf(readerMetadata, columnIndex));
                    DistinctSymbolRecordCursorFactory distinctSymbolRecordCursorFactory = new DistinctSymbolRecordCursorFactory(this.engine, distinctSymbolMetadata, Chars.toString(tableName), columnIndex, reader.getVersion());
                    return distinctSymbolRecordCursorFactory;
                }
            }
        }
        RecordCursorFactory factory = this.generateSubQuery(model, executionContext);
        try {
            return new DistinctRecordCursorFactory(this.configuration, factory, this.entityColumnFilter, this.asm);
        }
        catch (Throwable e) {
            factory.close();
            throw e;
        }
    }

    private RecordCursorFactory generateSelectGroupBy(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        ExpressionNode sampleByNode = model.getSampleBy();
        if (sampleByNode != null) {
            return this.generateSampleBy(model, executionContext, sampleByNode);
        }
        RecordCursorFactory factory = null;
        try {
            ExpressionNode columnExpr;
            ObjList<QueryColumn> columns = model.getColumns();
            if (columns.size() == 1) {
                CharSequence columnName = columns.getQuick(0).getName();
                columnExpr = columns.getQuick(0).getAst();
                if (columnExpr.type == 8 && columnExpr.paramCount == 0 && SqlKeywords.isCountKeyword(columnExpr.token)) {
                    GenericRecordMetadata metadata = SqlKeywords.isCountKeyword(columnName) ? CountRecordCursorFactory.DEFAULT_COUNT_METADATA : new GenericRecordMetadata().add(new TableColumnMetadata(Chars.toString(columnName), 5, null));
                    return new CountRecordCursorFactory(metadata, this.generateSubQuery(model, executionContext));
                }
            }
            this.tempKeyIndexesInBase.clear();
            this.tempKeyIndex.clear();
            this.arrayColumnTypes.clear();
            this.tempKeyKinds.clear();
            boolean pageFramingSupported = false;
            boolean specialCaseKeys = false;
            QueryModel nested = model.getNestedModel();
            assert (nested != null);
            if (nested.getSelectModelType() == 2) {
                columnExpr = nested.getColumns().getQuick(0).getAst();
                if (columnExpr.type == 8 && SqlKeywords.isHourKeyword(columnExpr.token) && columnExpr.paramCount == 1 && columnExpr.rhs.type == 4) {
                    specialCaseKeys = true;
                    factory = this.generateSubQuery(nested, executionContext);
                    pageFramingSupported = factory.supportPageFrameCursor();
                    if (pageFramingSupported) {
                        this.tempKeyIndexesInBase.add(factory.getMetadata().getColumnIndex(columnExpr.rhs.token));
                        CharSequence functionColumnName = columns.getQuick(0).getName();
                        int n = columns.size();
                        for (int i = 0; i < n; ++i) {
                            columnExpr = columns.getQuick(i).getAst();
                            if (columnExpr.type != 4) continue;
                            if (Chars.equals(columnExpr.token, functionColumnName)) {
                                this.tempKeyIndex.add(i);
                                this.tempKeyKinds.add(1);
                                this.arrayColumnTypes.add(4);
                                continue;
                            }
                            pageFramingSupported = false;
                            break;
                        }
                    } else {
                        factory = Misc.free(factory);
                    }
                }
            }
            if (factory == null) {
                factory = this.generateSubQuery(model, executionContext);
                pageFramingSupported = factory.supportPageFrameCursor();
            }
            RecordMetadata metadata = factory.getMetadata();
            if (pageFramingSupported && this.assembleKeysAndFunctionReferences(columns, metadata, !specialCaseKeys)) {
                int indexInBase;
                int i;
                GenericRecordMetadata meta = new GenericRecordMetadata();
                int n = this.tempKeyIndex.size();
                for (i = 0; i < n; ++i) {
                    int indexInThis = this.tempKeyIndex.getQuick(i);
                    indexInBase = this.tempKeyIndexesInBase.getQuick(i);
                    int type = this.arrayColumnTypes.getColumnType(i);
                    if (type == 11) {
                        meta.add(indexInThis, new TableColumnMetadata(Chars.toString(columns.getQuick(indexInThis).getName()), type, false, 0, metadata.isSymbolTableStatic(indexInBase), null));
                        continue;
                    }
                    meta.add(indexInThis, new TableColumnMetadata(Chars.toString(columns.getQuick(indexInThis).getName()), type, null));
                }
                n = this.tempVecConstructors.size();
                for (i = 0; i < n; ++i) {
                    VectorAggregateFunctionConstructor constructor = this.tempVecConstructors.getQuick(i);
                    indexInBase = this.tempVecConstructorArgIndexes.getQuick(i);
                    int indexInThis = this.tempAggIndex.getQuick(i);
                    VectorAggregateFunction vaf = constructor.create(0, this.tempKeyKinds.size() == 0 ? 0 : this.tempKeyKinds.getQuick(0), indexInBase, executionContext.getWorkerCount());
                    this.tempVaf.add(vaf);
                    meta.add(indexInThis, new TableColumnMetadata(Chars.toString(columns.getQuick(indexInThis).getName()), vaf.getType(), null));
                }
                if (this.tempKeyIndexesInBase.size() == 0) {
                    return new GroupByNotKeyedVectorRecordCursorFactory(this.configuration, factory, meta, this.tempVaf);
                }
                if (this.tempKeyIndexesInBase.size() == 1) {
                    n = this.tempVaf.size();
                    for (i = 0; i < n; ++i) {
                        this.tempVaf.getQuick(i).pushValueTypes(this.arrayColumnTypes);
                    }
                    GroupByUtils.validateGroupByColumns(model, 1);
                    return new GroupByRecordCursorFactory(this.configuration, factory, meta, this.arrayColumnTypes, executionContext.getWorkerCount(), this.tempVaf, this.tempKeyIndexesInBase.getQuick(0), this.tempKeyIndex.getQuick(0), this.tempSymbolSkewIndexes);
                }
            }
            if (specialCaseKeys) {
                Misc.free(factory);
                factory = this.generateSubQuery(model, executionContext);
                metadata = factory.getMetadata();
            }
            int timestampIndex = this.getTimestampIndex(model, factory);
            this.keyTypes.clear();
            this.valueTypes.clear();
            this.listColumnFilterA.clear();
            int columnCount = model.getColumns().size();
            ObjList<GroupByFunction> groupByFunctions = new ObjList<GroupByFunction>(columnCount);
            GroupByUtils.prepareGroupByFunctions(model, metadata, this.functionParser, executionContext, groupByFunctions, this.valueTypes);
            ObjList<Function> recordFunctions = new ObjList<Function>(columnCount);
            GenericRecordMetadata groupByMetadata = new GenericRecordMetadata();
            GroupByUtils.prepareGroupByRecordFunctions(model, metadata, this.listColumnFilterA, groupByFunctions, recordFunctions, groupByMetadata, this.keyTypes, this.valueTypes.getColumnCount(), true, timestampIndex);
            if (this.keyTypes.getColumnCount() == 0) {
                return new GroupByNotKeyedRecordCursorFactory(factory, groupByMetadata, groupByFunctions, recordFunctions, this.valueTypes.getColumnCount());
            }
            return new io.questdb.griffin.engine.groupby.GroupByRecordCursorFactory(this.configuration, factory, this.listColumnFilterA, this.asm, this.keyTypes, this.valueTypes, groupByMetadata, groupByFunctions, recordFunctions);
        }
        catch (Throwable e) {
            Misc.free(factory);
            throw e;
        }
    }

    private RecordCursorFactory generateSelectVirtual(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        RecordCursorFactory factory = this.generateSubQuery(model, executionContext);
        try {
            ObjList<QueryColumn> columns = model.getColumns();
            int columnCount = columns.size();
            RecordMetadata metadata = factory.getMetadata();
            ObjList<Function> functions = new ObjList<Function>(columnCount);
            GenericRecordMetadata virtualMetadata = new GenericRecordMetadata();
            int timestampIndex = metadata.getTimestampIndex();
            String timestampColumn = timestampIndex > -1 ? metadata.getColumnName(timestampIndex) : null;
            for (int i = 0; i < columnCount; ++i) {
                Function function;
                QueryColumn column = columns.getQuick(i);
                ExpressionNode node = column.getAst();
                if (node.type == 4 && Chars.equalsNc(node.token, timestampColumn)) {
                    virtualMetadata.setTimestampIndex(i);
                }
                if ((function = this.functionParser.parseFunction(column.getAst(), metadata, executionContext)).isUndefined()) {
                    function.assignType(10, executionContext.getBindVariableService());
                }
                functions.add(function);
                if (function instanceof SymbolFunction) {
                    virtualMetadata.add(new TableColumnMetadata(Chars.toString(column.getAlias()), function.getType(), false, 0, ((SymbolFunction)function).isSymbolTableStatic(), function.getMetadata()));
                    continue;
                }
                virtualMetadata.add(new TableColumnMetadata(Chars.toString(column.getAlias()), function.getType(), function.getMetadata()));
            }
            if (executionContext.isTimestampRequired() && timestampColumn != null && virtualMetadata.getTimestampIndex() == -1) {
                ScalarFunction timestampFunction = FunctionParser.createColumn(0, timestampColumn, metadata);
                functions.add(timestampFunction);
                int n = model.getBottomUpColumns().size();
                for (int i = 0; i < n; ++i) {
                    QueryColumn qc = model.getBottomUpColumns().getQuick(i);
                    if (qc.getAst().type != 4 || !Chars.equals((CharSequence)timestampColumn, qc.getAst().token)) continue;
                    virtualMetadata.setTimestampIndex(virtualMetadata.getColumnCount());
                    virtualMetadata.add(new TableColumnMetadata(Chars.toString(qc.getAlias()), timestampFunction.getType(), timestampFunction.getMetadata()));
                    break;
                }
            }
            return new VirtualRecordCursorFactory(virtualMetadata, functions, factory);
        }
        catch (CairoException | SqlException e) {
            factory.close();
            throw e;
        }
    }

    private RecordCursorFactory generateSetFactory(QueryModel model, RecordCursorFactory masterFactory, SqlExecutionContext executionContext) throws SqlException {
        RecordCursorFactory slaveFactory = this.generateQuery0(model.getUnionModel(), executionContext, true);
        switch (model.getSetOperationType()) {
            case 1: {
                return this.generateUnionFactory(model, masterFactory, executionContext, slaveFactory, SET_UNION_CONSTRUCTOR);
            }
            case 0: {
                return this.generateUnionAllFactory(model, masterFactory, executionContext, slaveFactory);
            }
            case 2: {
                return this.generateUnionFactory(model, masterFactory, executionContext, slaveFactory, SET_EXCEPT_CONSTRUCTOR);
            }
            case 3: {
                return this.generateUnionFactory(model, masterFactory, executionContext, slaveFactory, SET_INTERSECT_CONSTRUCTOR);
            }
        }
        assert (false);
        return null;
    }

    private RecordCursorFactory generateSubQuery(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        assert (model.getNestedModel() != null);
        return this.generateQuery(model.getNestedModel(), executionContext, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RecordCursorFactory generateTableQuery(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        ObjList<ExpressionNode> latestBy = model.getLatestBy();
        ExpressionNode whereClause = model.getWhereClause();
        try (TableReader reader = this.engine.getReader(executionContext.getCairoSecurityContext(), model.getTableName().token, model.getTableVersion());){
            boolean framingSupported;
            int readerTimestampIndex;
            TableReaderMetadata readerMeta = reader.getMetadata();
            ObjList<QueryColumn> topDownColumns = model.getTopDownColumns();
            int topDownColumnCount = topDownColumns.size();
            IntList columnIndexes = new IntList();
            IntList columnSizes = new IntList();
            try {
                readerTimestampIndex = this.getTimestampIndex(model, readerMeta);
            }
            catch (SqlException e) {
                Misc.free(reader);
                throw e;
            }
            boolean requiresTimestamp = joinsRequiringTimestamp[model.getJoinType()];
            GenericRecordMetadata myMeta = new GenericRecordMetadata();
            try {
                if (requiresTimestamp) {
                    executionContext.pushTimestampRequiredFlag(true);
                }
                if (topDownColumnCount > 0) {
                    framingSupported = true;
                    for (int i = 0; i < topDownColumnCount; ++i) {
                        int columnIndex = readerMeta.getColumnIndexQuiet(topDownColumns.getQuick(i).getName());
                        int type = readerMeta.getColumnType(columnIndex);
                        int typeSize = ColumnType.sizeOf(type);
                        if (framingSupported && (typeSize < 1 || typeSize > 8)) {
                            framingSupported = false;
                        }
                        columnIndexes.add(columnIndex);
                        columnSizes.add(Numbers.msb(typeSize));
                        myMeta.add(new TableColumnMetadata(Chars.toString(topDownColumns.getQuick(i).getName()), type, readerMeta.isColumnIndexed(columnIndex), readerMeta.getIndexValueBlockCapacity(columnIndex), readerMeta.isSymbolTableStatic(columnIndex), readerMeta.getMetadata(columnIndex)));
                        if (columnIndex != readerTimestampIndex) continue;
                        myMeta.setTimestampIndex(myMeta.getColumnCount() - 1);
                    }
                    if (readerTimestampIndex != -1 && myMeta.getTimestampIndex() == -1 && executionContext.isTimestampRequired()) {
                        myMeta.add(new TableColumnMetadata(readerMeta.getColumnName(readerTimestampIndex), readerMeta.getColumnType(readerTimestampIndex), readerMeta.getMetadata(readerTimestampIndex)));
                        myMeta.setTimestampIndex(myMeta.getColumnCount() - 1);
                        columnIndexes.add(readerTimestampIndex);
                        columnSizes.add(Numbers.msb(7));
                    }
                } else {
                    framingSupported = false;
                }
            }
            finally {
                if (requiresTimestamp) {
                    executionContext.popTimestampRequiredFlag();
                }
            }
            this.listColumnFilterA.clear();
            int latestByColumnCount = latestBy.size();
            if (latestByColumnCount > 0) {
                for (int i = 0; i < latestByColumnCount; ++i) {
                    int index = myMeta.getColumnIndexQuiet(latestBy.getQuick((int)i).token);
                    if (index == -1) {
                        throw SqlException.invalidColumn(latestBy.getQuick((int)i).position, latestBy.getQuick((int)i).token);
                    }
                    this.keyTypes.add(myMeta.getColumnType(index));
                    this.listColumnFilterA.add(index + 1);
                }
            }
            String tableName = reader.getTableName();
            if (whereClause != null) {
                ObjList<ExpressionNode> orderByAdvice;
                int orderByAdviceSize;
                int indexDirection;
                boolean orderByKeyColumn;
                boolean intervalHitsOnlyOnePartition;
                AbstractDataFrameCursorFactory dfcFactory;
                int latestByIndex;
                CharSequence preferredKeyColumn = null;
                if (this.listColumnFilterA.size() == 1 && myMeta.getColumnType(latestByIndex = this.listColumnFilterA.getColumnIndexFactored(0)) == 11) {
                    preferredKeyColumn = latestBy.getQuick((int)0).token;
                }
                IntrinsicModel intrinsicModel = this.whereClauseParser.extract(model, whereClause, readerMeta, preferredKeyColumn, readerTimestampIndex, this.functionParser, myMeta, executionContext);
                model.setWhereClause(null);
                if (intrinsicModel.intrinsicValue == 2) {
                    EmptyTableRecordCursorFactory emptyTableRecordCursorFactory = new EmptyTableRecordCursorFactory(myMeta);
                    return emptyTableRecordCursorFactory;
                }
                if (latestByColumnCount > 0) {
                    Function f = this.compileFilter(intrinsicModel, (RecordMetadata)myMeta, executionContext);
                    if (f != null && f.isConstant() && !f.getBool(null)) {
                        EmptyTableRecordCursorFactory emptyTableRecordCursorFactory = new EmptyTableRecordCursorFactory(myMeta);
                        return emptyTableRecordCursorFactory;
                    }
                    RecordCursorFactory recordCursorFactory = this.generateLatestByQuery(model, reader, myMeta, tableName, intrinsicModel, f, executionContext, readerTimestampIndex, columnIndexes);
                    return recordCursorFactory;
                }
                if (intrinsicModel.hasIntervalFilters()) {
                    RuntimeIntrinsicIntervalModel intervalModel = intrinsicModel.buildIntervalModel();
                    dfcFactory = new IntervalFwdDataFrameCursorFactory(this.engine, tableName, model.getTableVersion(), intervalModel, readerTimestampIndex);
                    intervalHitsOnlyOnePartition = intervalModel.allIntervalsHitOnePartition(reader.getPartitionedBy());
                } else {
                    dfcFactory = new FullFwdDataFrameCursorFactory(this.engine, tableName, model.getTableVersion());
                    intervalHitsOnlyOnePartition = false;
                }
                if (intrinsicModel.keyColumn != null) {
                    ObjList<ExpressionNode> orderByAdvice2;
                    int orderByAdviceSize22;
                    int keyColumnIndex = reader.getMetadata().getColumnIndexQuiet(intrinsicModel.keyColumn);
                    int nKeyValues = intrinsicModel.keyValues.size();
                    int nKeyExcludedValues = intrinsicModel.keyExcludedValues.size();
                    if (intrinsicModel.keySubQuery != null) {
                        RecordCursorFactory rcf = this.generate(intrinsicModel.keySubQuery, executionContext);
                        Record.CharSequenceFunction func = this.validateSubQueryColumnAndGetGetter(intrinsicModel, rcf.getMetadata());
                        Function f = this.compileFilter(intrinsicModel, (RecordMetadata)myMeta, executionContext);
                        if (f != null && f.isConstant() && !f.getBool(null)) {
                            EmptyTableRecordCursorFactory emptyTableRecordCursorFactory = new EmptyTableRecordCursorFactory(myMeta);
                            return emptyTableRecordCursorFactory;
                        }
                        FilterOnSubQueryRecordCursorFactory filterOnSubQueryRecordCursorFactory = new FilterOnSubQueryRecordCursorFactory(myMeta, dfcFactory, rcf, keyColumnIndex, f, func, columnIndexes);
                        return filterOnSubQueryRecordCursorFactory;
                    }
                    assert (nKeyValues > 0 || nKeyExcludedValues > 0);
                    orderByKeyColumn = false;
                    indexDirection = 1;
                    if (intervalHitsOnlyOnePartition && (orderByAdviceSize22 = (orderByAdvice2 = model.getOrderByAdvice()).size()) > 0 && orderByAdviceSize22 < 3 && Chars.equals(orderByAdvice2.getQuick((int)0).token, intrinsicModel.keyColumn)) {
                        myMeta.setTimestampIndex(-1);
                        if (orderByAdviceSize22 == 1) {
                            orderByKeyColumn = true;
                        } else if (Chars.equals(orderByAdvice2.getQuick((int)1).token, model.getTimestamp().token)) {
                            orderByKeyColumn = true;
                            if (SqlCodeGenerator.getOrderByDirectionOrDefault(model, 1) == 1) {
                                indexDirection = 2;
                            }
                        }
                    }
                    if (intrinsicModel.keyExcludedValues.size() == 0) {
                        Function f = this.compileFilter(intrinsicModel, (RecordMetadata)myMeta, executionContext);
                        if (f != null && f.isConstant()) {
                            try {
                                if (!f.getBool(null)) {
                                    EmptyTableRecordCursorFactory orderByAdviceSize22 = new EmptyTableRecordCursorFactory(myMeta);
                                    return orderByAdviceSize22;
                                }
                            }
                            finally {
                                f = Misc.free(f);
                            }
                        }
                        if (nKeyValues == 1) {
                            CharSequence symbol = intrinsicModel.keyValues.get(0);
                            int symbolKey = reader.getSymbolMapReader(keyColumnIndex).keyOf(symbol);
                            FunctionBasedRowCursorFactory rcf = symbolKey == -2 ? (f == null ? new DeferredSymbolIndexRowCursorFactory(keyColumnIndex, this.functionParser.createBindVariable(intrinsicModel.keyValuePositions.getQuick(0), symbol), true, indexDirection) : new DeferredSymbolIndexFilteredRowCursorFactory(keyColumnIndex, this.functionParser.createBindVariable(intrinsicModel.keyValuePositions.getQuick(0), symbol), f, true, indexDirection, columnIndexes)) : (f == null ? new SymbolIndexRowCursorFactory(keyColumnIndex, symbolKey, true, indexDirection, null) : new SymbolIndexFilteredRowCursorFactory(keyColumnIndex, symbolKey, f, true, indexDirection, columnIndexes, null));
                            DataFrameRecordCursorFactory dataFrameRecordCursorFactory = new DataFrameRecordCursorFactory(myMeta, dfcFactory, rcf, orderByKeyColumn, f, false, columnIndexes, columnSizes);
                            return dataFrameRecordCursorFactory;
                        }
                        this.symbolValueList.clear();
                        int n = intrinsicModel.keyValues.size();
                        for (int i = 0; i < n; ++i) {
                            this.symbolValueList.add(this.functionParser.createBindVariable(intrinsicModel.keyValuePositions.getQuick(i), intrinsicModel.keyValues.get(i)));
                        }
                        if (orderByKeyColumn) {
                            myMeta.setTimestampIndex(-1);
                        }
                        FilterOnValuesRecordCursorFactory i = new FilterOnValuesRecordCursorFactory(myMeta, dfcFactory, this.symbolValueList, keyColumnIndex, reader, f, model.getOrderByAdviceMnemonic(), orderByKeyColumn, SqlCodeGenerator.getOrderByDirectionOrDefault(model, 0), indexDirection, columnIndexes);
                        return i;
                    }
                    if (intrinsicModel.keyExcludedValues.size() > 0 && reader.getSymbolMapReader(keyColumnIndex).size() < this.configuration.getMaxSymbolNotEqualsCount()) {
                        this.symbolValueList.clear();
                        int n = intrinsicModel.keyExcludedValues.size();
                        for (int i = 0; i < n; ++i) {
                            this.symbolValueList.add(this.functionParser.createBindVariable(intrinsicModel.keyExcludedValuePositions.getQuick(i), intrinsicModel.keyExcludedValues.get(i)));
                        }
                        Function f = this.compileFilter(intrinsicModel, (RecordMetadata)myMeta, executionContext);
                        if (f != null && f.isConstant()) {
                            try {
                                if (!f.getBool(null)) {
                                    EmptyTableRecordCursorFactory emptyTableRecordCursorFactory = new EmptyTableRecordCursorFactory(myMeta);
                                    return emptyTableRecordCursorFactory;
                                }
                            }
                            finally {
                                f = Misc.free(f);
                            }
                        }
                        FilterOnExcludedValuesRecordCursorFactory filterOnExcludedValuesRecordCursorFactory = new FilterOnExcludedValuesRecordCursorFactory(myMeta, dfcFactory, this.symbolValueList, keyColumnIndex, f, model.getOrderByAdviceMnemonic(), orderByKeyColumn, indexDirection, columnIndexes, this.configuration.getMaxSymbolNotEqualsCount());
                        return filterOnExcludedValuesRecordCursorFactory;
                    }
                }
                if (intervalHitsOnlyOnePartition && intrinsicModel.filter == null && (orderByAdviceSize = (orderByAdvice = model.getOrderByAdvice()).size()) > 0 && orderByAdviceSize < 3 && intrinsicModel.hasIntervalFilters()) {
                    int columnIndex = myMeta.getColumnIndexQuiet(model.getOrderByAdvice().getQuick((int)0).token);
                    assert (columnIndex > -1);
                    if (myMeta.isColumnIndexed(columnIndex)) {
                        orderByKeyColumn = false;
                        indexDirection = 1;
                        if (orderByAdviceSize == 1) {
                            orderByKeyColumn = true;
                        } else if (Chars.equals(orderByAdvice.getQuick((int)1).token, model.getTimestamp().token)) {
                            orderByKeyColumn = true;
                            if (SqlCodeGenerator.getOrderByDirectionOrDefault(model, 1) == 1) {
                                indexDirection = 2;
                            }
                        }
                        if (orderByKeyColumn) {
                            myMeta.setTimestampIndex(-1);
                            SortedSymbolIndexRecordCursorFactory sortedSymbolIndexRecordCursorFactory = new SortedSymbolIndexRecordCursorFactory(myMeta, dfcFactory, columnIndex, SqlCodeGenerator.getOrderByDirectionOrDefault(model, 0) == 0, indexDirection, columnIndexes);
                            return sortedSymbolIndexRecordCursorFactory;
                        }
                    }
                }
                model.setWhereClause(intrinsicModel.filter);
                DataFrameRecordCursorFactory dataFrameRecordCursorFactory = new DataFrameRecordCursorFactory(myMeta, dfcFactory, new DataFrameRowCursorFactory(), false, null, framingSupported, columnIndexes, columnSizes);
                return dataFrameRecordCursorFactory;
            }
            if (latestByColumnCount == 0) {
                TableReaderRecordCursorFactory tableReaderRecordCursorFactory = new TableReaderRecordCursorFactory(myMeta, this.engine, tableName, model.getTableVersion(), columnIndexes, columnSizes, framingSupported);
                return tableReaderRecordCursorFactory;
            }
            if (latestByColumnCount == 1 && myMeta.isColumnIndexed(this.listColumnFilterA.getColumnIndexFactored(0))) {
                LatestByAllIndexedFilteredRecordCursorFactory latestByAllIndexedFilteredRecordCursorFactory = new LatestByAllIndexedFilteredRecordCursorFactory(this.configuration, myMeta, new FullBwdDataFrameCursorFactory(this.engine, tableName, model.getTableVersion()), columnIndexes.getQuick(this.listColumnFilterA.getColumnIndexFactored(0)), null, columnIndexes);
                return latestByAllIndexedFilteredRecordCursorFactory;
            }
            LatestByAllFilteredRecordCursorFactory latestByAllFilteredRecordCursorFactory = new LatestByAllFilteredRecordCursorFactory(myMeta, this.configuration, new FullBwdDataFrameCursorFactory(this.engine, tableName, model.getTableVersion()), RecordSinkFactory.getInstance(this.asm, myMeta, this.listColumnFilterA, false), this.keyTypes, null, columnIndexes);
            return latestByAllFilteredRecordCursorFactory;
        }
    }

    private static int getOrderByDirectionOrDefault(QueryModel model, int index) {
        IntList direction = model.getOrderByDirectionAdvice();
        if (index >= direction.size()) {
            return 0;
        }
        return model.getOrderByDirectionAdvice().getQuick(index);
    }

    private RecordCursorFactory generateUnionAllFactory(QueryModel model, RecordCursorFactory masterFactory, SqlExecutionContext executionContext, RecordCursorFactory slaveFactory) throws SqlException {
        this.validateJoinColumnTypes(model, masterFactory, slaveFactory);
        UnionAllRecordCursorFactory unionAllFactory = new UnionAllRecordCursorFactory(this.calculateSetMetadata(masterFactory.getMetadata()), masterFactory, slaveFactory);
        if (model.getUnionModel().getUnionModel() != null) {
            return this.generateSetFactory(model.getUnionModel(), unionAllFactory, executionContext);
        }
        return unionAllFactory;
    }

    private RecordCursorFactory generateUnionFactory(QueryModel model, RecordCursorFactory masterFactory, SqlExecutionContext executionContext, RecordCursorFactory slaveFactory, SetRecordCursorFactoryConstructor constructor) throws SqlException {
        this.validateJoinColumnTypes(model, masterFactory, slaveFactory);
        this.entityColumnFilter.of(masterFactory.getMetadata().getColumnCount());
        RecordSink recordSink = RecordSinkFactory.getInstance(this.asm, masterFactory.getMetadata(), this.entityColumnFilter, true);
        this.valueTypes.clear();
        RecordCursorFactory unionFactory = constructor.create(this.configuration, this.calculateSetMetadata(masterFactory.getMetadata()), masterFactory, slaveFactory, recordSink, this.valueTypes);
        if (model.getUnionModel().getUnionModel() != null) {
            return this.generateSetFactory(model.getUnionModel(), unionFactory, executionContext);
        }
        return unionFactory;
    }

    private int getTimestampIndex(QueryModel model, RecordCursorFactory factory) throws SqlException {
        RecordMetadata metadata = factory.getMetadata();
        try {
            return this.getTimestampIndex(model, metadata);
        }
        catch (SqlException e) {
            Misc.free(factory);
            throw e;
        }
    }

    private int getTimestampIndex(QueryModel model, RecordMetadata metadata) throws SqlException {
        ExpressionNode timestamp = model.getTimestamp();
        if (timestamp != null) {
            int timestampIndex = metadata.getColumnIndexQuiet(timestamp.token);
            if (timestampIndex == -1) {
                throw SqlException.invalidColumn(timestamp.position, timestamp.token);
            }
            if (metadata.getColumnType(timestampIndex) != 7) {
                throw SqlException.$(timestamp.position, "not a TIMESTAMP");
            }
            return timestampIndex;
        }
        return metadata.getTimestampIndex();
    }

    private boolean isSingleColumnFunction(ExpressionNode ast, CharSequence name) {
        return ast.type == 8 && ast.paramCount == 1 && Chars.equals(ast.token, name) && ast.rhs.type == 4;
    }

    private void lookupColumnIndexes(ListColumnFilter filter, ObjList<ExpressionNode> columnNames, RecordMetadata metadata) throws SqlException {
        filter.clear();
        int n = columnNames.size();
        for (int i = 0; i < n; ++i) {
            CharSequence columnName = columnNames.getQuick((int)i).token;
            int columnIndex = metadata.getColumnIndexQuiet(columnName);
            if (columnIndex <= -1) {
                int dot = Chars.indexOf(columnName, '.');
                if (dot > -1 && (columnIndex = metadata.getColumnIndexQuiet(columnName, dot + 1, columnName.length())) > -1) {
                    filter.add(columnIndex + 1);
                    return;
                }
                throw SqlException.invalidColumn(columnNames.getQuick((int)i).position, columnName);
            }
            filter.add(columnIndex + 1);
        }
    }

    private void lookupColumnIndexesUsingVanillaNames(ListColumnFilter filter, ObjList<CharSequence> columnNames, RecordMetadata metadata) {
        filter.clear();
        int n = columnNames.size();
        for (int i = 0; i < n; ++i) {
            filter.add(metadata.getColumnIndex(columnNames.getQuick(i)) + 1);
        }
    }

    private void processJoinContext(boolean vanillaMaster, JoinContext jc, RecordMetadata masterMetadata, RecordMetadata slaveMetadata) throws SqlException {
        this.lookupColumnIndexesUsingVanillaNames(this.listColumnFilterA, jc.aNames, slaveMetadata);
        if (vanillaMaster) {
            this.lookupColumnIndexesUsingVanillaNames(this.listColumnFilterB, jc.bNames, masterMetadata);
        } else {
            this.lookupColumnIndexes(this.listColumnFilterB, jc.bNodes, masterMetadata);
        }
        this.keyTypes.clear();
        int m = this.listColumnFilterA.getColumnCount();
        for (int k = 0; k < m; ++k) {
            int columnType = masterMetadata.getColumnType(this.listColumnFilterB.getColumnIndexFactored(k));
            if (columnType != slaveMetadata.getColumnType(this.listColumnFilterA.getColumnIndexFactored(k))) {
                throw SqlException.$(jc.aNodes.getQuick((int)k).position, "join column type mismatch");
            }
            this.keyTypes.add(columnType == 11 ? 10 : columnType);
        }
    }

    void setFullFatJoins(boolean fullFatJoins) {
        this.fullFatJoins = fullFatJoins;
    }

    private IntList toOrderIndices(RecordMetadata m, ObjList<ExpressionNode> orderBy, IntList orderByDirection) throws SqlException {
        IntList indices = new IntList();
        int n = orderBy.size();
        for (int i = 0; i < n; ++i) {
            ExpressionNode tok = orderBy.getQuick(i);
            int index = m.getColumnIndexQuiet(tok.token);
            if (index == -1) {
                throw SqlException.invalidColumn(tok.position, tok.token);
            }
            ++index;
            if (orderByDirection.getQuick(i) == 1) {
                index = -index;
            }
            indices.add(index);
        }
        return indices;
    }

    private void validateBothTimestamps(QueryModel slaveModel, RecordMetadata masterMetadata, RecordMetadata slaveMetadata) throws SqlException {
        if (masterMetadata.getTimestampIndex() == -1) {
            throw SqlException.$(slaveModel.getJoinKeywordPosition(), "left side of time series join has no timestamp");
        }
        if (slaveMetadata.getTimestampIndex() == -1) {
            throw SqlException.$(slaveModel.getJoinKeywordPosition(), "right side of time series join has no timestamp");
        }
    }

    private void validateJoinColumnTypes(QueryModel model, RecordCursorFactory masterFactory, RecordCursorFactory slaveFactory) throws SqlException {
        RecordMetadata metadata = masterFactory.getMetadata();
        RecordMetadata slaveMetadata = slaveFactory.getMetadata();
        int columnCount = metadata.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            if (metadata.getColumnType(i) == slaveMetadata.getColumnType(i)) continue;
            throw SqlException.$(model.getUnionModel().getModelPosition(), "column type mismatch [index=").put(i).put(", A=").put(ColumnType.nameOf(metadata.getColumnType(i))).put(", B=").put(ColumnType.nameOf(slaveMetadata.getColumnType(i))).put(']');
        }
    }

    private Record.CharSequenceFunction validateSubQueryColumnAndGetGetter(IntrinsicModel intrinsicModel, RecordMetadata metadata) throws SqlException {
        int zeroColumnType = metadata.getColumnType(0);
        if (zeroColumnType != 10 && zeroColumnType != 11) {
            assert (intrinsicModel.keySubQuery.getColumns() != null);
            assert (intrinsicModel.keySubQuery.getColumns().size() > 0);
            throw SqlException.position(intrinsicModel.keySubQuery.getColumns().getQuick((int)0).getAst().position).put("unsupported column type: ").put(metadata.getColumnName(0)).put(": ").put(ColumnType.nameOf(zeroColumnType));
        }
        return zeroColumnType == 10 ? Record.GET_STR : Record.GET_SYM;
    }

    static {
        limitTypes.add(5);
        limitTypes.add(1);
        limitTypes.add(2);
        limitTypes.add(4);
        limitTypes.add(5);
        limitTypes.add(1);
        limitTypes.add(2);
        limitTypes.add(4);
        sumConstructors.put(9, SumDoubleVectorAggregateFunction::new);
        sumConstructors.put(4, SumIntVectorAggregateFunction::new);
        sumConstructors.put(5, SumLongVectorAggregateFunction::new);
        sumConstructors.put(6, SumDateVectorAggregateFunction::new);
        sumConstructors.put(7, SumTimestampVectorAggregateFunction::new);
        ksumConstructors.put(9, KSumDoubleVectorAggregateFunction::new);
        nsumConstructors.put(9, NSumDoubleVectorAggregateFunction::new);
        avgConstructors.put(9, AvgDoubleVectorAggregateFunction::new);
        avgConstructors.put(5, AvgLongVectorAggregateFunction::new);
        avgConstructors.put(7, AvgLongVectorAggregateFunction::new);
        avgConstructors.put(6, AvgLongVectorAggregateFunction::new);
        avgConstructors.put(4, AvgIntVectorAggregateFunction::new);
        minConstructors.put(9, MinDoubleVectorAggregateFunction::new);
        minConstructors.put(5, MinLongVectorAggregateFunction::new);
        minConstructors.put(6, MinDateVectorAggregateFunction::new);
        minConstructors.put(7, MinTimestampVectorAggregateFunction::new);
        minConstructors.put(4, MinIntVectorAggregateFunction::new);
        maxConstructors.put(9, MaxDoubleVectorAggregateFunction::new);
        maxConstructors.put(5, MaxLongVectorAggregateFunction::new);
        maxConstructors.put(6, MaxDateVectorAggregateFunction::new);
        maxConstructors.put(7, MaxTimestampVectorAggregateFunction::new);
        maxConstructors.put(4, MaxIntVectorAggregateFunction::new);
        SqlCodeGenerator.addCountConstructor(9);
        SqlCodeGenerator.addCountConstructor(5);
        SqlCodeGenerator.addCountConstructor(6);
        SqlCodeGenerator.addCountConstructor(7);
        SqlCodeGenerator.addCountConstructor(4);
    }

    @FunctionalInterface
    public static interface FullFatJoinGenerator {
        public RecordCursorFactory create(CairoConfiguration var1, RecordMetadata var2, RecordCursorFactory var3, RecordCursorFactory var4, ColumnTypes var5, ColumnTypes var6, ColumnTypes var7, RecordSink var8, RecordSink var9, int var10, RecordValueSink var11, IntList var12);
    }
}

