/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.MessageBus;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoError;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.CairoSecurityContext;
import io.questdb.cairo.ColumnFilter;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.DefaultLifecycleManager;
import io.questdb.cairo.EntityColumnFilter;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.ListColumnFilter;
import io.questdb.cairo.SymbolMapReader;
import io.questdb.cairo.SymbolMapWriter;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableReaderMetadata;
import io.questdb.cairo.TableReaderRecordCursor;
import io.questdb.cairo.TableStructure;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.TableWriterMetadata;
import io.questdb.cairo.sql.BindVariableService;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.ReaderOutOfDateException;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.cairo.vm.AppendOnlyVirtualMemory;
import io.questdb.cutlass.text.TextException;
import io.questdb.cutlass.text.TextLoader;
import io.questdb.griffin.CharacterStore;
import io.questdb.griffin.CompiledQuery;
import io.questdb.griffin.CompiledQueryImpl;
import io.questdb.griffin.EmptyRecordMetadata;
import io.questdb.griffin.ExpressionParserListener;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.FunctionFactoryCache;
import io.questdb.griffin.FunctionParser;
import io.questdb.griffin.InsertStatementImpl;
import io.questdb.griffin.OperatorExpression;
import io.questdb.griffin.PostOrderTreeTraversalAlgo;
import io.questdb.griffin.SqlCodeGenerator;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlKeywords;
import io.questdb.griffin.SqlOptimiser;
import io.questdb.griffin.SqlParser;
import io.questdb.griffin.SqlUtil;
import io.questdb.griffin.engine.functions.catalogue.ShowSearchPathCursorFactory;
import io.questdb.griffin.engine.functions.catalogue.ShowStandardConformingStringsCursorFactory;
import io.questdb.griffin.engine.functions.catalogue.ShowTransactionIsolationLevelCursorFactory;
import io.questdb.griffin.engine.table.ShowColumnsRecordCursorFactory;
import io.questdb.griffin.engine.table.TableListRecordCursorFactory;
import io.questdb.griffin.model.ColumnCastModel;
import io.questdb.griffin.model.CopyModel;
import io.questdb.griffin.model.CreateTableModel;
import io.questdb.griffin.model.ExecutionModel;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.InsertModel;
import io.questdb.griffin.model.IntervalUtils;
import io.questdb.griffin.model.QueryColumn;
import io.questdb.griffin.model.QueryModel;
import io.questdb.griffin.model.RenameTableModel;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.CharSequenceHashSet;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.Chars;
import io.questdb.std.FilesFacade;
import io.questdb.std.FindVisitor;
import io.questdb.std.GenericLexer;
import io.questdb.std.IntIntHashMap;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjHashSet;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectPool;
import io.questdb.std.Os;
import io.questdb.std.Sinkable;
import io.questdb.std.Unsafe;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.str.NativeLPSZ;
import io.questdb.std.str.Path;
import java.io.Closeable;
import java.util.ServiceLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCompiler
implements Closeable {
    public static final ObjList<String> sqlControlSymbols = new ObjList(8);
    private static final Log LOG = LogFactory.getLog(SqlCompiler.class);
    private static final IntList castGroups = new IntList();
    protected final GenericLexer lexer;
    protected final Path path = new Path();
    protected final CairoEngine engine;
    protected final CharSequenceObjHashMap<KeywordBasedExecutor> keywordBasedExecutors = new CharSequenceObjHashMap();
    protected final CompiledQueryImpl compiledQuery = new CompiledQueryImpl();
    private final SqlOptimiser optimiser;
    private final SqlParser parser;
    private final ObjectPool<ExpressionNode> sqlNodePool;
    private final CharacterStore characterStore;
    private final ObjectPool<QueryColumn> queryColumnPool;
    private final ObjectPool<QueryModel> queryModelPool;
    private final SqlCodeGenerator codeGenerator;
    private final CairoConfiguration configuration;
    private final Path renamePath = new Path();
    private final AppendOnlyVirtualMemory mem = new AppendOnlyVirtualMemory();
    private final BytecodeAssembler asm = new BytecodeAssembler();
    private final MessageBus messageBus;
    private final ListColumnFilter listColumnFilter = new ListColumnFilter();
    private final EntityColumnFilter entityColumnFilter = new EntityColumnFilter();
    private final IntIntHashMap typeCast = new IntIntHashMap();
    private final ObjList<TableWriter> tableWriters = new ObjList();
    private final TableStructureAdapter tableStructureAdapter = new TableStructureAdapter();
    private final FunctionParser functionParser;
    private final ExecutableMethod insertAsSelectMethod = this::insertAsSelect;
    private final ExecutableMethod createTableMethod = this::createTable;
    private final TextLoader textLoader;
    private final FilesFacade ff;
    private final ObjHashSet<CharSequence> tableNames = new ObjHashSet();
    private final NativeLPSZ nativeLPSZ = new NativeLPSZ();
    private final CharSequenceObjHashMap<RecordToRowCopier> tableBackupRowCopieCache = new CharSequenceObjHashMap();
    private transient SqlExecutionContext currentExecutionContext;
    private transient String cachedTmpBackupRoot;
    private final FindVisitor sqlDatabaseBackupOnFind = (file, type) -> {
        this.nativeLPSZ.of(file);
        if (type == 4 && this.nativeLPSZ.charAt(0) != '.') {
            try {
                this.backupTable(this.nativeLPSZ, this.currentExecutionContext);
            }
            catch (CairoException ex) {
                LOG.error().$("could not backup [path=").$(this.nativeLPSZ).$(", ex=").$(ex.getFlyweightMessage()).$(", errno=").$(ex.getErrno()).$(']').$();
            }
        }
    };

    public SqlCompiler(CairoEngine engine) {
        this(engine, engine.getMessageBus(), null);
    }

    public SqlCompiler(CairoEngine engine, @Nullable MessageBus messageBus, @Nullable FunctionFactoryCache functionFactoryCache) {
        this.engine = engine;
        this.configuration = engine.getConfiguration();
        this.ff = this.configuration.getFilesFacade();
        this.messageBus = messageBus;
        this.sqlNodePool = new ObjectPool<ExpressionNode>(ExpressionNode.FACTORY, this.configuration.getSqlExpressionPoolCapacity());
        this.queryColumnPool = new ObjectPool<QueryColumn>(QueryColumn.FACTORY, this.configuration.getSqlColumnPoolCapacity());
        this.queryModelPool = new ObjectPool<QueryModel>(QueryModel.FACTORY, this.configuration.getSqlModelPoolCapacity());
        this.characterStore = new CharacterStore(this.configuration.getSqlCharacterStoreCapacity(), this.configuration.getSqlCharacterStoreSequencePoolCapacity());
        this.lexer = new GenericLexer(this.configuration.getSqlLexerPoolCapacity());
        this.functionParser = new FunctionParser(this.configuration, functionFactoryCache != null ? functionFactoryCache : new FunctionFactoryCache(engine.getConfiguration(), ServiceLoader.load(FunctionFactory.class)));
        this.codeGenerator = new SqlCodeGenerator(engine, this.configuration, this.functionParser);
        this.functionParser.setSqlCodeGenerator(this.codeGenerator);
        KeywordBasedExecutor compileSet = this::compileSet;
        KeywordBasedExecutor truncateTables = this::truncateTables;
        KeywordBasedExecutor alterTable = this::alterTable;
        KeywordBasedExecutor repairTables = this::repairTables;
        KeywordBasedExecutor dropTable = this::dropTable;
        KeywordBasedExecutor sqlBackup = this::sqlBackup;
        KeywordBasedExecutor sqlShow = this::sqlShow;
        this.keywordBasedExecutors.put("truncate", truncateTables);
        this.keywordBasedExecutors.put("TRUNCATE", truncateTables);
        this.keywordBasedExecutors.put("alter", alterTable);
        this.keywordBasedExecutors.put("ALTER", alterTable);
        this.keywordBasedExecutors.put("repair", repairTables);
        this.keywordBasedExecutors.put("REPAIR", repairTables);
        this.keywordBasedExecutors.put("set", compileSet);
        this.keywordBasedExecutors.put("SET", compileSet);
        this.keywordBasedExecutors.put("begin", compileSet);
        this.keywordBasedExecutors.put("BEGIN", compileSet);
        this.keywordBasedExecutors.put("commit", compileSet);
        this.keywordBasedExecutors.put("COMMIT", compileSet);
        this.keywordBasedExecutors.put("rollback", compileSet);
        this.keywordBasedExecutors.put("ROLLBACK", compileSet);
        this.keywordBasedExecutors.put("discard", compileSet);
        this.keywordBasedExecutors.put("DISCARD", compileSet);
        this.keywordBasedExecutors.put("drop", dropTable);
        this.keywordBasedExecutors.put("DROP", dropTable);
        this.keywordBasedExecutors.put("backup", sqlBackup);
        this.keywordBasedExecutors.put("BACKUP", sqlBackup);
        this.keywordBasedExecutors.put("show", sqlShow);
        this.keywordBasedExecutors.put("SHOW", sqlShow);
        SqlCompiler.configureLexer(this.lexer);
        PostOrderTreeTraversalAlgo postOrderTreeTraversalAlgo = new PostOrderTreeTraversalAlgo();
        this.optimiser = new SqlOptimiser(this.configuration, engine, this.characterStore, this.sqlNodePool, this.queryColumnPool, this.queryModelPool, postOrderTreeTraversalAlgo, this.functionParser, this.path);
        this.parser = new SqlParser(this.configuration, this.optimiser, this.characterStore, this.sqlNodePool, this.queryColumnPool, this.queryModelPool, postOrderTreeTraversalAlgo);
        this.textLoader = new TextLoader(engine);
    }

    public static RecordToRowCopier assembleRecordToRowCopier(BytecodeAssembler asm, ColumnTypes from, RecordMetadata to, ColumnFilter toColumnFilter) {
        int timestampIndex = to.getTimestampIndex();
        asm.init(RecordToRowCopier.class);
        asm.setupPool();
        int thisClassIndex = asm.poolClass(asm.poolUtf8("io/questdb/griffin/rowcopier"));
        int interfaceClassIndex = asm.poolClass(RecordToRowCopier.class);
        int rGetInt = asm.poolInterfaceMethod(Record.class, "getInt", "(I)I");
        int rGetLong = asm.poolInterfaceMethod(Record.class, "getLong", "(I)J");
        int rGetLong256 = asm.poolInterfaceMethod(Record.class, "getLong256A", "(I)Lio/questdb/std/Long256;");
        int rGetDate = asm.poolInterfaceMethod(Record.class, "getDate", "(I)J");
        int rGetTimestamp = asm.poolInterfaceMethod(Record.class, "getTimestamp", "(I)J");
        int rGetByte = asm.poolInterfaceMethod(Record.class, "getByte", "(I)B");
        int rGetShort = asm.poolInterfaceMethod(Record.class, "getShort", "(I)S");
        int rGetChar = asm.poolInterfaceMethod(Record.class, "getChar", "(I)C");
        int rGetBool = asm.poolInterfaceMethod(Record.class, "getBool", "(I)Z");
        int rGetFloat = asm.poolInterfaceMethod(Record.class, "getFloat", "(I)F");
        int rGetDouble = asm.poolInterfaceMethod(Record.class, "getDouble", "(I)D");
        int rGetSym = asm.poolInterfaceMethod(Record.class, "getSym", "(I)Ljava/lang/CharSequence;");
        int rGetStr = asm.poolInterfaceMethod(Record.class, "getStr", "(I)Ljava/lang/CharSequence;");
        int rGetBin = asm.poolInterfaceMethod(Record.class, "getBin", "(I)Lio/questdb/std/BinarySequence;");
        int wPutInt = asm.poolMethod(TableWriter.Row.class, (CharSequence)"putInt", (CharSequence)"(II)V");
        int wPutLong = asm.poolMethod(TableWriter.Row.class, (CharSequence)"putLong", (CharSequence)"(IJ)V");
        int wPutLong256 = asm.poolMethod(TableWriter.Row.class, (CharSequence)"putLong256", (CharSequence)"(ILio/questdb/std/Long256;)V");
        int wPutDate = asm.poolMethod(TableWriter.Row.class, (CharSequence)"putDate", (CharSequence)"(IJ)V");
        int wPutTimestamp = asm.poolMethod(TableWriter.Row.class, (CharSequence)"putTimestamp", (CharSequence)"(IJ)V");
        int wPutByte = asm.poolMethod(TableWriter.Row.class, (CharSequence)"putByte", (CharSequence)"(IB)V");
        int wPutShort = asm.poolMethod(TableWriter.Row.class, (CharSequence)"putShort", (CharSequence)"(IS)V");
        int wPutBool = asm.poolMethod(TableWriter.Row.class, (CharSequence)"putBool", (CharSequence)"(IZ)V");
        int wPutFloat = asm.poolMethod(TableWriter.Row.class, (CharSequence)"putFloat", (CharSequence)"(IF)V");
        int wPutDouble = asm.poolMethod(TableWriter.Row.class, (CharSequence)"putDouble", (CharSequence)"(ID)V");
        int wPutSym = asm.poolMethod(TableWriter.Row.class, (CharSequence)"putSym", (CharSequence)"(ILjava/lang/CharSequence;)V");
        int wPutSymChar = asm.poolMethod(TableWriter.Row.class, (CharSequence)"putSym", (CharSequence)"(IC)V");
        int wPutStr = asm.poolMethod(TableWriter.Row.class, (CharSequence)"putStr", (CharSequence)"(ILjava/lang/CharSequence;)V");
        int wPutTimestampStr = asm.poolMethod(TableWriter.Row.class, (CharSequence)"putTimestamp", (CharSequence)"(ILjava/lang/CharSequence;)V");
        int wPutStrChar = asm.poolMethod(TableWriter.Row.class, (CharSequence)"putStr", (CharSequence)"(IC)V");
        int wPutChar = asm.poolMethod(TableWriter.Row.class, (CharSequence)"putChar", (CharSequence)"(IC)V");
        int wPutBin = asm.poolMethod(TableWriter.Row.class, (CharSequence)"putBin", (CharSequence)"(ILio/questdb/std/BinarySequence;)V");
        int copyNameIndex = asm.poolUtf8("copy");
        int copySigIndex = asm.poolUtf8("(Lio/questdb/cairo/sql/Record;Lio/questdb/cairo/TableWriter$Row;)V");
        asm.finishPool();
        asm.defineClass(thisClassIndex);
        asm.interfaceCount(1);
        asm.putShort(interfaceClassIndex);
        asm.fieldCount(0);
        asm.methodCount(2);
        asm.defineDefaultConstructor();
        asm.startMethod(copyNameIndex, copySigIndex, 4, 3);
        int n = toColumnFilter.getColumnCount();
        block96: for (int i = 0; i < n; ++i) {
            int toColumnIndex = toColumnFilter.getColumnIndexFactored(i);
            if (toColumnIndex == timestampIndex) continue;
            asm.aload(2);
            asm.iconst(toColumnIndex);
            asm.aload(1);
            asm.iconst(i);
            switch (from.getColumnType(i)) {
                case 4: {
                    asm.invokeInterface(rGetInt, 1);
                    switch (to.getColumnType(toColumnIndex)) {
                        case 5: {
                            asm.i2l();
                            asm.invokeVirtual(wPutLong);
                            continue block96;
                        }
                        case 6: {
                            asm.i2l();
                            asm.invokeVirtual(wPutDate);
                            continue block96;
                        }
                        case 7: {
                            asm.i2l();
                            asm.invokeVirtual(wPutTimestamp);
                            continue block96;
                        }
                        case 2: {
                            asm.i2s();
                            asm.invokeVirtual(wPutShort);
                            continue block96;
                        }
                        case 1: {
                            asm.i2b();
                            asm.invokeVirtual(wPutByte);
                            continue block96;
                        }
                        case 8: {
                            asm.i2f();
                            asm.invokeVirtual(wPutFloat);
                            continue block96;
                        }
                        case 9: {
                            asm.i2d();
                            asm.invokeVirtual(wPutDouble);
                            continue block96;
                        }
                    }
                    asm.invokeVirtual(wPutInt);
                    continue block96;
                }
                case 5: {
                    asm.invokeInterface(rGetLong, 1);
                    switch (to.getColumnType(toColumnIndex)) {
                        case 4: {
                            asm.l2i();
                            asm.invokeVirtual(wPutInt);
                            continue block96;
                        }
                        case 6: {
                            asm.invokeVirtual(wPutDate);
                            continue block96;
                        }
                        case 7: {
                            asm.invokeVirtual(wPutTimestamp);
                            continue block96;
                        }
                        case 2: {
                            asm.l2i();
                            asm.i2s();
                            asm.invokeVirtual(wPutShort);
                            continue block96;
                        }
                        case 1: {
                            asm.l2i();
                            asm.i2b();
                            asm.invokeVirtual(wPutByte);
                            continue block96;
                        }
                        case 8: {
                            asm.l2f();
                            asm.invokeVirtual(wPutFloat);
                            continue block96;
                        }
                        case 9: {
                            asm.l2d();
                            asm.invokeVirtual(wPutDouble);
                            continue block96;
                        }
                    }
                    asm.invokeVirtual(wPutLong);
                    continue block96;
                }
                case 6: {
                    asm.invokeInterface(rGetDate, 1);
                    switch (to.getColumnType(toColumnIndex)) {
                        case 4: {
                            asm.l2i();
                            asm.invokeVirtual(wPutInt);
                            continue block96;
                        }
                        case 5: {
                            asm.invokeVirtual(wPutLong);
                            continue block96;
                        }
                        case 7: {
                            asm.invokeVirtual(wPutTimestamp);
                            continue block96;
                        }
                        case 2: {
                            asm.l2i();
                            asm.i2s();
                            asm.invokeVirtual(wPutShort);
                            continue block96;
                        }
                        case 1: {
                            asm.l2i();
                            asm.i2b();
                            asm.invokeVirtual(wPutByte);
                            continue block96;
                        }
                        case 8: {
                            asm.l2f();
                            asm.invokeVirtual(wPutFloat);
                            continue block96;
                        }
                        case 9: {
                            asm.l2d();
                            asm.invokeVirtual(wPutDouble);
                            continue block96;
                        }
                    }
                    asm.invokeVirtual(wPutDate);
                    continue block96;
                }
                case 7: {
                    asm.invokeInterface(rGetTimestamp, 1);
                    switch (to.getColumnType(toColumnIndex)) {
                        case 4: {
                            asm.l2i();
                            asm.invokeVirtual(wPutInt);
                            continue block96;
                        }
                        case 5: {
                            asm.invokeVirtual(wPutLong);
                            continue block96;
                        }
                        case 2: {
                            asm.l2i();
                            asm.i2s();
                            asm.invokeVirtual(wPutShort);
                            continue block96;
                        }
                        case 1: {
                            asm.l2i();
                            asm.i2b();
                            asm.invokeVirtual(wPutByte);
                            continue block96;
                        }
                        case 8: {
                            asm.l2f();
                            asm.invokeVirtual(wPutFloat);
                            continue block96;
                        }
                        case 9: {
                            asm.l2d();
                            asm.invokeVirtual(wPutDouble);
                            continue block96;
                        }
                        case 6: {
                            asm.invokeVirtual(wPutDate);
                            continue block96;
                        }
                    }
                    asm.invokeVirtual(wPutTimestamp);
                    continue block96;
                }
                case 1: {
                    asm.invokeInterface(rGetByte, 1);
                    switch (to.getColumnType(toColumnIndex)) {
                        case 4: {
                            asm.invokeVirtual(wPutInt);
                            continue block96;
                        }
                        case 5: {
                            asm.i2l();
                            asm.invokeVirtual(wPutLong);
                            continue block96;
                        }
                        case 6: {
                            asm.i2l();
                            asm.invokeVirtual(wPutDate);
                            continue block96;
                        }
                        case 7: {
                            asm.i2l();
                            asm.invokeVirtual(wPutTimestamp);
                            continue block96;
                        }
                        case 2: {
                            asm.i2s();
                            asm.invokeVirtual(wPutShort);
                            continue block96;
                        }
                        case 8: {
                            asm.i2f();
                            asm.invokeVirtual(wPutFloat);
                            continue block96;
                        }
                        case 9: {
                            asm.i2d();
                            asm.invokeVirtual(wPutDouble);
                            continue block96;
                        }
                    }
                    asm.invokeVirtual(wPutByte);
                    continue block96;
                }
                case 2: {
                    asm.invokeInterface(rGetShort, 1);
                    switch (to.getColumnType(toColumnIndex)) {
                        case 4: {
                            asm.invokeVirtual(wPutInt);
                            continue block96;
                        }
                        case 5: {
                            asm.i2l();
                            asm.invokeVirtual(wPutLong);
                            continue block96;
                        }
                        case 6: {
                            asm.i2l();
                            asm.invokeVirtual(wPutDate);
                            continue block96;
                        }
                        case 7: {
                            asm.i2l();
                            asm.invokeVirtual(wPutTimestamp);
                            continue block96;
                        }
                        case 1: {
                            asm.i2b();
                            asm.invokeVirtual(wPutByte);
                            continue block96;
                        }
                        case 8: {
                            asm.i2f();
                            asm.invokeVirtual(wPutFloat);
                            continue block96;
                        }
                        case 9: {
                            asm.i2d();
                            asm.invokeVirtual(wPutDouble);
                            continue block96;
                        }
                    }
                    asm.invokeVirtual(wPutShort);
                    continue block96;
                }
                case 0: {
                    asm.invokeInterface(rGetBool, 1);
                    asm.invokeVirtual(wPutBool);
                    continue block96;
                }
                case 8: {
                    asm.invokeInterface(rGetFloat, 1);
                    switch (to.getColumnType(toColumnIndex)) {
                        case 4: {
                            asm.f2i();
                            asm.invokeVirtual(wPutInt);
                            continue block96;
                        }
                        case 5: {
                            asm.f2l();
                            asm.invokeVirtual(wPutLong);
                            continue block96;
                        }
                        case 6: {
                            asm.f2l();
                            asm.invokeVirtual(wPutDate);
                            continue block96;
                        }
                        case 7: {
                            asm.f2l();
                            asm.invokeVirtual(wPutTimestamp);
                            continue block96;
                        }
                        case 2: {
                            asm.f2i();
                            asm.i2s();
                            asm.invokeVirtual(wPutShort);
                            continue block96;
                        }
                        case 1: {
                            asm.f2i();
                            asm.i2b();
                            asm.invokeVirtual(wPutByte);
                            continue block96;
                        }
                        case 9: {
                            asm.f2d();
                            asm.invokeVirtual(wPutDouble);
                            continue block96;
                        }
                    }
                    asm.invokeVirtual(wPutFloat);
                    continue block96;
                }
                case 9: {
                    asm.invokeInterface(rGetDouble, 1);
                    switch (to.getColumnType(toColumnIndex)) {
                        case 4: {
                            asm.d2i();
                            asm.invokeVirtual(wPutInt);
                            continue block96;
                        }
                        case 5: {
                            asm.d2l();
                            asm.invokeVirtual(wPutLong);
                            continue block96;
                        }
                        case 6: {
                            asm.d2l();
                            asm.invokeVirtual(wPutDate);
                            continue block96;
                        }
                        case 7: {
                            asm.d2l();
                            asm.invokeVirtual(wPutTimestamp);
                            continue block96;
                        }
                        case 2: {
                            asm.d2i();
                            asm.i2s();
                            asm.invokeVirtual(wPutShort);
                            continue block96;
                        }
                        case 1: {
                            asm.d2i();
                            asm.i2b();
                            asm.invokeVirtual(wPutByte);
                            continue block96;
                        }
                        case 8: {
                            asm.d2f();
                            asm.invokeVirtual(wPutFloat);
                            continue block96;
                        }
                    }
                    asm.invokeVirtual(wPutDouble);
                    continue block96;
                }
                case 3: {
                    asm.invokeInterface(rGetChar, 1);
                    switch (to.getColumnType(toColumnIndex)) {
                        case 10: {
                            asm.invokeVirtual(wPutStrChar);
                            continue block96;
                        }
                        case 11: {
                            asm.invokeVirtual(wPutSymChar);
                            continue block96;
                        }
                    }
                    asm.invokeVirtual(wPutChar);
                    continue block96;
                }
                case 11: {
                    asm.invokeInterface(rGetSym, 1);
                    if (to.getColumnType(toColumnIndex) == 10) {
                        asm.invokeVirtual(wPutStr);
                        continue block96;
                    }
                    asm.invokeVirtual(wPutSym);
                    continue block96;
                }
                case 10: {
                    asm.invokeInterface(rGetStr, 1);
                    switch (to.getColumnType(toColumnIndex)) {
                        case 11: {
                            asm.invokeVirtual(wPutSym);
                            continue block96;
                        }
                        case 7: {
                            asm.invokeVirtual(wPutTimestampStr);
                            continue block96;
                        }
                    }
                    asm.invokeVirtual(wPutStr);
                    continue block96;
                }
                case 13: {
                    asm.invokeInterface(rGetBin, 1);
                    asm.invokeVirtual(wPutBin);
                    continue block96;
                }
                case 12: {
                    asm.invokeInterface(rGetLong256, 1);
                    asm.invokeVirtual(wPutLong256);
                    continue block96;
                }
            }
        }
        asm.return_();
        asm.endMethodCode();
        asm.putShort(0);
        asm.putShort(0);
        asm.endMethod();
        asm.putShort(0);
        return (RecordToRowCopier)asm.newInstance();
    }

    public static void configureLexer(GenericLexer lexer) {
        int i;
        int k = sqlControlSymbols.size();
        for (i = 0; i < k; ++i) {
            lexer.defineSymbol(sqlControlSymbols.getQuick(i));
        }
        k = OperatorExpression.operators.size();
        for (i = 0; i < k; ++i) {
            OperatorExpression op = OperatorExpression.operators.getQuick(i);
            if (!op.symbol) continue;
            lexer.defineSymbol(op.token);
        }
    }

    public static boolean isAssignableFrom(int to, int from) {
        return to == from || from >= 1 && to >= 1 && to <= 9 && from < to || from == 10 && to == 11 || from == 11 && to == 10 || from == 3 && to == 11 || from == 3 && to == 10 || from == 10 && to == 7;
    }

    @Override
    public void close() {
        assert (null == this.currentExecutionContext);
        assert (this.tableNames.isEmpty());
        Misc.free(this.path);
        Misc.free(this.renamePath);
        Misc.free(this.textLoader);
    }

    @NotNull
    public CompiledQuery compile(@NotNull CharSequence query, @NotNull SqlExecutionContext executionContext) throws SqlException {
        this.clear();
        this.lexer.of(query);
        CharSequence tok = SqlUtil.fetchNext(this.lexer);
        if (tok == null) {
            throw SqlException.$(0, "empty query");
        }
        KeywordBasedExecutor executor = this.keywordBasedExecutors.get(tok);
        if (executor == null) {
            return this.compileUsingModel(executionContext);
        }
        return executor.execute(executionContext);
    }

    public CairoEngine getEngine() {
        return this.engine;
    }

    public FunctionFactoryCache getFunctionFactoryCache() {
        return this.functionParser.getFunctionFactoryCache();
    }

    private static boolean isCompatibleCase(int from, int to) {
        return castGroups.getQuick(from) == castGroups.getQuick(to);
    }

    private static void expectKeyword(GenericLexer lexer, CharSequence keyword) throws SqlException {
        CharSequence tok = SqlUtil.fetchNext(lexer);
        if (tok == null) {
            throw SqlException.position(lexer.getPosition()).put('\'').put(keyword).put("' expected");
        }
        if (!Chars.equalsLowerCaseAscii(tok, keyword)) {
            throw SqlException.position(lexer.lastTokenPosition()).put('\'').put(keyword).put("' expected");
        }
    }

    private static CharSequence expectToken(GenericLexer lexer, CharSequence expected) throws SqlException {
        CharSequence tok = SqlUtil.fetchNext(lexer);
        if (tok == null) {
            throw SqlException.position(lexer.getPosition()).put(expected).put(" expected");
        }
        return tok;
    }

    private void alterSystemLockWriter(SqlExecutionContext executionContext) throws SqlException {
        int tableNamePosition = this.lexer.getPosition();
        CharSequence tok = GenericLexer.unquote(SqlCompiler.expectToken(this.lexer, "table name"));
        this.tableExistsOrFail(tableNamePosition, tok, executionContext);
        try {
            if (!this.engine.lockWriter(tok)) {
                throw SqlException.$(tableNamePosition, "could not lock, busy [table=`").put(tok).put("`]");
            }
        }
        catch (CairoException e) {
            throw SqlException.position(tableNamePosition).put(e.getFlyweightMessage()).put("[errno=").put(e.getErrno()).put(']');
        }
    }

    private void alterSystemUnlockWriter(SqlExecutionContext executionContext) throws SqlException {
        int tableNamePosition = this.lexer.getPosition();
        CharSequence tok = GenericLexer.unquote(SqlCompiler.expectToken(this.lexer, "table name"));
        this.tableExistsOrFail(tableNamePosition, tok, executionContext);
        try {
            this.engine.unlockWriter(tok);
        }
        catch (CairoException e) {
            throw SqlException.position(tableNamePosition).put(e.getFlyweightMessage()).put("[errno=").put(e.getErrno()).put(']');
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CompiledQuery alterTable(SqlExecutionContext executionContext) throws SqlException {
        CharSequence tok = SqlCompiler.expectToken(this.lexer, "'table' or 'system'");
        if (SqlKeywords.isTableKeyword(tok)) {
            int tableNamePosition = this.lexer.getPosition();
            tok = GenericLexer.unquote(SqlCompiler.expectToken(this.lexer, "table name"));
            this.tableExistsOrFail(tableNamePosition, tok, executionContext);
            CharSequence tableName = GenericLexer.immutableOf(tok);
            try (TableWriter writer = this.engine.getWriter(executionContext.getCairoSecurityContext(), tableName);){
                tok = SqlCompiler.expectToken(this.lexer, "'add', 'alter' or 'drop'");
                if (SqlKeywords.isAddKeyword(tok)) {
                    this.alterTableAddColumn(tableNamePosition, writer);
                    return this.compiledQuery.ofAlter();
                } else if (SqlKeywords.isDropKeyword(tok)) {
                    tok = SqlCompiler.expectToken(this.lexer, "'column' or 'partition'");
                    if (SqlKeywords.isColumnKeyword(tok)) {
                        this.alterTableDropColumn(tableNamePosition, writer);
                        return this.compiledQuery.ofAlter();
                    } else {
                        if (!SqlKeywords.isPartitionKeyword(tok)) throw SqlException.$(this.lexer.lastTokenPosition(), "'column' or 'partition' expected");
                        this.alterTableDropOrAttachPartition(writer, 1, executionContext);
                    }
                    return this.compiledQuery.ofAlter();
                } else if (SqlKeywords.isAttachKeyword(tok)) {
                    tok = SqlCompiler.expectToken(this.lexer, "'partition'");
                    if (!SqlKeywords.isPartitionKeyword(tok)) throw SqlException.$(this.lexer.lastTokenPosition(), "'column' or 'partition' expected");
                    this.alterTableDropOrAttachPartition(writer, 2, executionContext);
                    return this.compiledQuery.ofAlter();
                } else if (SqlKeywords.isRenameKeyword(tok)) {
                    tok = SqlCompiler.expectToken(this.lexer, "'column'");
                    if (!SqlKeywords.isColumnKeyword(tok)) throw SqlException.$(this.lexer.lastTokenPosition(), "'column' expected");
                    this.alterTableRenameColumn(tableNamePosition, writer);
                    return this.compiledQuery.ofAlter();
                } else if (SqlKeywords.isAlterKeyword(tok)) {
                    tok = SqlCompiler.expectToken(this.lexer, "'column'");
                    if (!SqlKeywords.isColumnKeyword(tok)) throw SqlException.$(this.lexer.lastTokenPosition(), "'column' or 'partition' expected");
                    int columnNameNamePosition = this.lexer.getPosition();
                    tok = SqlCompiler.expectToken(this.lexer, "column name");
                    CharSequence columnName = GenericLexer.immutableOf(tok);
                    tok = SqlCompiler.expectToken(this.lexer, "'add index' or 'cache' or 'nocache'");
                    if (SqlKeywords.isAddKeyword(tok)) {
                        SqlCompiler.expectKeyword(this.lexer, "index");
                        this.alterTableColumnAddIndex(tableNamePosition, columnNameNamePosition, columnName, writer);
                        return this.compiledQuery.ofAlter();
                    } else if (SqlKeywords.isCacheKeyword(tok)) {
                        this.alterTableColumnCacheFlag(tableNamePosition, columnName, writer, true);
                        return this.compiledQuery.ofAlter();
                    } else {
                        if (!SqlKeywords.isNoCacheKeyword(tok)) throw SqlException.$(this.lexer.lastTokenPosition(), "'cache' or 'nocache' expected");
                        this.alterTableColumnCacheFlag(tableNamePosition, columnName, writer, false);
                    }
                    return this.compiledQuery.ofAlter();
                } else {
                    if (!SqlKeywords.isSetKeyword(tok)) throw SqlException.$(this.lexer.lastTokenPosition(), "'add', 'drop', 'attach', 'set' or 'rename' expected");
                    tok = SqlCompiler.expectToken(this.lexer, "'param'");
                    if (!SqlKeywords.isParamKeyword(tok)) throw SqlException.$(this.lexer.lastTokenPosition(), "'param' expected");
                    int paramNameNamePosition = this.lexer.getPosition();
                    tok = SqlCompiler.expectToken(this.lexer, "param name");
                    CharSequence paramName = GenericLexer.immutableOf(tok);
                    tok = SqlCompiler.expectToken(this.lexer, "'='");
                    if (tok.length() != 1 || tok.charAt(0) != '=') throw SqlException.$(this.lexer.lastTokenPosition(), "'=' expected");
                    CharSequence value = GenericLexer.immutableOf(SqlUtil.fetchNext(this.lexer));
                    this.alterTableSetParam(paramName, value, paramNameNamePosition, writer);
                }
                return this.compiledQuery.ofAlter();
            }
            catch (CairoException e) {
                LOG.info().$("could not alter table [table=").$(tableName).$(", ex=").$(e).$();
                throw SqlException.$(tableNamePosition, "table '").put(tableName).put("' could not be altered: ").put(e);
            }
        }
        if (!SqlKeywords.isSystemKeyword(tok)) throw SqlException.$(this.lexer.lastTokenPosition(), "'table' or 'system' expected");
        tok = SqlCompiler.expectToken(this.lexer, "'lock' or 'unlock'");
        if (SqlKeywords.isLockKeyword(tok)) {
            tok = SqlCompiler.expectToken(this.lexer, "'writer'");
            if (!SqlKeywords.isWriterKeyword(tok)) return this.compiledQuery.ofAlter();
            this.alterSystemLockWriter(executionContext);
            return this.compiledQuery.ofAlter();
        } else {
            if (!SqlKeywords.isUnlockKeyword(tok)) throw SqlException.$(this.lexer.lastTokenPosition(), "'lock' or 'unlock' expected");
            tok = SqlCompiler.expectToken(this.lexer, "'writer'");
            if (!SqlKeywords.isWriterKeyword(tok)) return this.compiledQuery.ofAlter();
            this.alterSystemUnlockWriter(executionContext);
        }
        return this.compiledQuery.ofAlter();
    }

    private void alterTableSetParam(CharSequence paramName, CharSequence value, int paramNameNamePosition, TableWriter writer) throws SqlException {
        if (SqlKeywords.isO3MaxUncommittedRowsParam(paramName)) {
            int maxUncommittedRows;
            try {
                maxUncommittedRows = Numbers.parseInt(value);
            }
            catch (NumericException e) {
                throw SqlException.$(paramNameNamePosition, "invalid value [value=").put(value).put(",parameter=").put(paramName).put(']');
            }
            if (maxUncommittedRows < 0) {
                throw SqlException.$(paramNameNamePosition, "O3MaxUncommittedRows must be non negative");
            }
            writer.setMetaO3MaxUncommittedRows(maxUncommittedRows);
        } else if (SqlKeywords.isO3CommitHysteresis(paramName)) {
            long o3CommitHysteresisInMicros = SqlUtil.expectMicros(value, paramNameNamePosition);
            if (o3CommitHysteresisInMicros < 0L) {
                throw SqlException.$(paramNameNamePosition, "O3CommitHysteresis must be non negative");
            }
            writer.setMetaO3CommitHysteresis(o3CommitHysteresisInMicros);
        } else {
            throw SqlException.$(paramNameNamePosition, "unknown parameter '").put(paramName).put('\'');
        }
    }

    private void alterTableAddColumn(int tableNamePosition, TableWriter writer) throws SqlException {
        block27: {
            CharSequence tok = SqlUtil.fetchNext(this.lexer);
            if (tok != null && !SqlKeywords.isColumnKeyword(tok)) {
                this.lexer.unparse();
            }
            do {
                int indexValueBlockCapacity;
                boolean indexed;
                boolean cache;
                int symbolCapacity;
                tok = SqlCompiler.expectToken(this.lexer, "'column' or column name");
                int index = writer.getMetadata().getColumnIndexQuiet(tok);
                if (index != -1) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), "column '").put(tok).put("' already exists");
                }
                CharSequence columnName = GenericLexer.immutableOf(GenericLexer.unquote(tok));
                if (!TableUtils.isValidColumnName(columnName)) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), " new column name contains invalid characters");
                }
                tok = SqlCompiler.expectToken(this.lexer, "column type");
                int type = ColumnType.columnTypeOf(tok);
                if (type == -1) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), "invalid type");
                }
                tok = SqlUtil.fetchNext(this.lexer);
                if (type == 11 && tok != null && !Chars.equals(tok, ',')) {
                    if (SqlKeywords.isCapacityKeyword(tok)) {
                        boolean negative;
                        tok = SqlCompiler.expectToken(this.lexer, "symbol capacity");
                        int errorPos = this.lexer.lastTokenPosition();
                        if (Chars.equals(tok, '-')) {
                            negative = true;
                            tok = SqlCompiler.expectToken(this.lexer, "symbol capacity");
                        } else {
                            negative = false;
                        }
                        try {
                            symbolCapacity = Numbers.parseInt(tok);
                        }
                        catch (NumericException e) {
                            throw SqlException.$(this.lexer.lastTokenPosition(), "numeric capacity expected");
                        }
                        if (negative) {
                            symbolCapacity = -symbolCapacity;
                        }
                        TableUtils.validateSymbolCapacity(errorPos, symbolCapacity);
                        tok = SqlUtil.fetchNext(this.lexer);
                    } else {
                        symbolCapacity = this.configuration.getDefaultSymbolCapacity();
                    }
                    if (Chars.equalsLowerCaseAsciiNc(tok, "cache")) {
                        cache = true;
                        tok = SqlUtil.fetchNext(this.lexer);
                    } else if (Chars.equalsLowerCaseAsciiNc(tok, "nocache")) {
                        cache = false;
                        tok = SqlUtil.fetchNext(this.lexer);
                    } else {
                        cache = this.configuration.getDefaultSymbolCacheFlag();
                    }
                    TableUtils.validateSymbolCapacityCached(cache, symbolCapacity, this.lexer.lastTokenPosition());
                    indexed = Chars.equalsLowerCaseAsciiNc(tok, "index");
                    if (indexed) {
                        tok = SqlUtil.fetchNext(this.lexer);
                    }
                    if (Chars.equalsLowerCaseAsciiNc(tok, "capacity")) {
                        tok = SqlCompiler.expectToken(this.lexer, "symbol index capacity");
                        try {
                            indexValueBlockCapacity = Numbers.parseInt(tok);
                        }
                        catch (NumericException e) {
                            throw SqlException.$(this.lexer.lastTokenPosition(), "numeric capacity expected");
                        }
                        tok = SqlUtil.fetchNext(this.lexer);
                    } else {
                        indexValueBlockCapacity = this.configuration.getIndexValueBlockSize();
                    }
                } else {
                    if (tok != null && SqlKeywords.isNotKeyword(tok)) {
                        tok = SqlUtil.fetchNext(this.lexer);
                    }
                    if (tok != null && SqlKeywords.isNullKeyword(tok)) {
                        tok = SqlUtil.fetchNext(this.lexer);
                    }
                    cache = this.configuration.getDefaultSymbolCacheFlag();
                    indexValueBlockCapacity = this.configuration.getIndexValueBlockSize();
                    symbolCapacity = this.configuration.getDefaultSymbolCapacity();
                    indexed = false;
                }
                try {
                    writer.addColumn(columnName, type, Numbers.ceilPow2(symbolCapacity), cache, indexed, Numbers.ceilPow2(indexValueBlockCapacity), false);
                }
                catch (CairoException e) {
                    LOG.error().$("Cannot add column '").$(writer.getTableName()).$('.').$(columnName).$("'. Exception: ").$(e).$();
                    throw SqlException.$(tableNamePosition, "could add column [error=").put(e.getFlyweightMessage()).put(", errno=").put(e.getErrno()).put(']');
                }
                if (tok == null) break block27;
            } while (Chars.equals(tok, ','));
            throw SqlException.$(this.lexer.lastTokenPosition(), "',' expected");
        }
    }

    private void alterTableColumnAddIndex(int tableNamePosition, int columnNamePosition, CharSequence columnName, TableWriter w) throws SqlException {
        try {
            if (w.getMetadata().getColumnIndexQuiet(columnName) == -1) {
                throw SqlException.invalidColumn(columnNamePosition, columnName);
            }
            w.addIndex(columnName, this.configuration.getIndexValueBlockSize());
        }
        catch (CairoException e) {
            throw SqlException.position(tableNamePosition).put(e.getFlyweightMessage()).put("[errno=").put(e.getErrno()).put(']');
        }
    }

    private void alterTableColumnCacheFlag(int tableNamePosition, CharSequence columnName, TableWriter writer, boolean cache) throws SqlException {
        try {
            TableWriterMetadata metadata = writer.getMetadata();
            int columnIndex = metadata.getColumnIndexQuiet(columnName);
            if (columnIndex == -1) {
                throw SqlException.invalidColumn(this.lexer.lastTokenPosition(), columnName);
            }
            if (metadata.getColumnType(columnIndex) != 11) {
                throw SqlException.$(this.lexer.lastTokenPosition(), "Invalid column type - Column should be of type symbol");
            }
            writer.changeCacheFlag(columnIndex, cache);
        }
        catch (CairoException e) {
            throw SqlException.position(tableNamePosition).put(e.getFlyweightMessage()).put("[errno=").put(e.getErrno()).put(']');
        }
    }

    private void alterTableDropColumn(int tableNamePosition, TableWriter writer) throws SqlException {
        block4: {
            CharSequence tok;
            TableWriterMetadata metadata = writer.getMetadata();
            do {
                if (metadata.getColumnIndexQuiet(tok = GenericLexer.unquote(SqlCompiler.expectToken(this.lexer, "column name"))) == -1) {
                    throw SqlException.invalidColumn(this.lexer.lastTokenPosition(), tok);
                }
                try {
                    writer.removeColumn(tok);
                }
                catch (CairoException e) {
                    LOG.error().$("cannot drop column '").$(writer.getTableName()).$('.').$(tok).$("'. Exception: ").$(e).$();
                    throw SqlException.$(tableNamePosition, "cannot drop column. Try again later [errno=").put(e.getErrno()).put(']');
                }
                tok = SqlUtil.fetchNext(this.lexer);
                if (tok == null) break block4;
            } while (Chars.equals(tok, ','));
            throw SqlException.$(this.lexer.lastTokenPosition(), "',' expected");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void alterTableDropOrAttachPartition(TableWriter writer, int action, SqlExecutionContext executionContext) throws SqlException {
        int pos = this.lexer.lastTokenPosition();
        CharSequence tok = SqlCompiler.expectToken(this.lexer, "'list' or 'where'");
        if (SqlKeywords.isListKeyword(tok)) {
            this.alterTableDropOrAttachPartitionByList(writer, action);
            return;
        } else {
            if (!SqlKeywords.isWhereKeyword(tok)) throw SqlException.$(this.lexer.lastTokenPosition(), "'list' or 'where' expected");
            ExpressionNode expr = this.parser.expr(this.lexer, (QueryModel)null);
            String designatedTimestampColumnName = writer.getDesignatedTimestampColumnName();
            if (designatedTimestampColumnName == null) throw SqlException.$(this.lexer.lastTokenPosition(), "this table does not have a designated timestamp column");
            GenericRecordMetadata metadata = new GenericRecordMetadata();
            metadata.add(new TableColumnMetadata(designatedTimestampColumnName, 7, null));
            Function function = this.functionParser.parseFunction(expr, metadata, this.currentExecutionContext);
            if (function == null || function.getType() != 0) throw SqlException.$(this.lexer.lastTokenPosition(), "boolean expression expected");
            function.init(null, executionContext);
            writer.removePartition(function, pos);
        }
    }

    private void alterTableDropOrAttachPartitionByList(TableWriter writer, int action) throws SqlException {
        block15: {
            CharSequence tok;
            do {
                long timestamp;
                if (Chars.equals(tok = SqlCompiler.expectToken(this.lexer, "partition name"), ',')) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), "partition name missing");
                }
                CharSequence unquoted = GenericLexer.unquote(tok);
                try {
                    timestamp = writer.partitionNameToTimestamp(unquoted);
                }
                catch (CairoException e) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), e.getFlyweightMessage()).put("[errno=").put(e.getErrno()).put(']');
                }
                block1 : switch (action) {
                    case 1: {
                        if (writer.removePartition(timestamp)) break;
                        throw SqlException.$(this.lexer.lastTokenPosition(), "could not remove partition '").put(unquoted).put('\'');
                    }
                    case 2: {
                        int statusCode = writer.attachPartition(timestamp);
                        switch (statusCode) {
                            case 0: {
                                break block1;
                            }
                            case 4: {
                                throw SqlException.$(this.lexer.lastTokenPosition(), "attach partition failed, folder '").put(unquoted).put("' does not exist");
                            }
                            case 2: {
                                throw SqlException.$(this.lexer.lastTokenPosition(), "attaching partitions to tables with symbol columns not supported");
                            }
                            case 1: {
                                throw SqlException.$(this.lexer.lastTokenPosition(), "failed to attach partition '").put(unquoted).put("', data does not correspond to the partition folder or partition is empty");
                            }
                            case 5: {
                                throw SqlException.$(this.lexer.lastTokenPosition(), "failed to attach partition '").put(unquoted).put("', partition already attached to the table");
                            }
                        }
                        throw SqlException.$(this.lexer.lastTokenPosition(), "attach partition '").put(unquoted).put("', failed with error ").put(statusCode);
                    }
                    default: {
                        throw SqlException.$(this.lexer.lastTokenPosition(), "unsupported partition action");
                    }
                }
                if ((tok = SqlUtil.fetchNext(this.lexer)) == null || Chars.equals(tok, ';')) break block15;
            } while (Chars.equals(tok, ','));
            throw SqlException.$(this.lexer.lastTokenPosition(), "',' expected");
        }
    }

    private void alterTableRenameColumn(int tableNamePosition, TableWriter writer) throws SqlException {
        block8: {
            CharSequence tok;
            TableWriterMetadata metadata = writer.getMetadata();
            do {
                if (metadata.getColumnIndexQuiet(tok = GenericLexer.unquote(SqlCompiler.expectToken(this.lexer, "current column name"))) == -1) {
                    throw SqlException.invalidColumn(this.lexer.lastTokenPosition(), tok);
                }
                CharSequence existingName = GenericLexer.immutableOf(tok);
                tok = SqlCompiler.expectToken(this.lexer, "'to' expected");
                if (!SqlKeywords.isToKeyword(tok)) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), "'to' expected'");
                }
                tok = GenericLexer.unquote(SqlCompiler.expectToken(this.lexer, "new column name"));
                if (Chars.equals(existingName, tok)) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), "new column name is identical to existing name");
                }
                if (metadata.getColumnIndexQuiet(tok) > -1) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), " column already exists");
                }
                if (!TableUtils.isValidColumnName(tok)) {
                    throw SqlException.$(this.lexer.lastTokenPosition(), " new column name contains invalid characters");
                }
                CharSequence newName = GenericLexer.immutableOf(tok);
                try {
                    writer.renameColumn(existingName, newName);
                }
                catch (CairoException e) {
                    LOG.error().$("cannot rename column '").$(writer.getTableName()).$('.').$(tok).$("'. Exception: ").$(e).$();
                    throw SqlException.$(tableNamePosition, "cannot rename column. Try again later [errno=").put(e.getErrno()).put(']');
                }
                tok = SqlUtil.fetchNext(this.lexer);
                if (tok == null) break block8;
            } while (Chars.equals(tok, ','));
            throw SqlException.$(this.lexer.lastTokenPosition(), "',' expected");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backupTable(@NotNull CharSequence tableName, @NotNull SqlExecutionContext executionContext) {
        LOG.info().$("Starting backup of ").$(tableName).$();
        if (null == this.cachedTmpBackupRoot) {
            if (null == this.configuration.getBackupRoot()) {
                throw CairoException.instance(0).put("Backup is disabled, no backup root directory is configured in the server configuration ['cairo.sql.backup.root' property]");
            }
            this.path.of(this.configuration.getBackupRoot()).concat(this.configuration.getBackupTempDirName()).slash$();
            this.cachedTmpBackupRoot = Chars.toString(this.path);
        }
        int renameRootLen = this.renamePath.length();
        try {
            CairoSecurityContext securityContext = executionContext.getCairoSecurityContext();
            try (TableReader reader = this.engine.getReader(securityContext, tableName);){
                this.cloneMetaData(tableName, this.cachedTmpBackupRoot, this.configuration.getBackupMkDirMode(), reader);
                try (TableWriter backupWriter = this.engine.getBackupWriter(securityContext, tableName, this.cachedTmpBackupRoot);){
                    TableWriterMetadata writerMetadata = backupWriter.getMetadata();
                    this.path.of(tableName).slash().put(reader.getVersion()).$();
                    RecordToRowCopier recordToRowCopier = this.tableBackupRowCopieCache.get(this.path);
                    if (null == recordToRowCopier) {
                        this.entityColumnFilter.of(writerMetadata.getColumnCount());
                        recordToRowCopier = SqlCompiler.assembleRecordToRowCopier(this.asm, reader.getMetadata(), writerMetadata, this.entityColumnFilter);
                        this.tableBackupRowCopieCache.put(this.path.toString(), recordToRowCopier);
                    }
                    TableReaderRecordCursor cursor = reader.getCursor();
                    this.copyTableData(cursor, reader.getMetadata(), backupWriter, writerMetadata, recordToRowCopier);
                    backupWriter.commit();
                }
            }
            this.path.of(this.configuration.getBackupRoot()).concat(this.configuration.getBackupTempDirName()).concat(tableName).$();
            try {
                this.renamePath.trimTo(renameRootLen).concat(tableName).$();
                TableUtils.renameOrFail(this.ff, this.path, this.renamePath);
                LOG.info().$("backup complete [table=").$(tableName).$(", to=").$(this.renamePath).$(']').$();
            }
            finally {
                this.renamePath.trimTo(renameRootLen).$();
            }
        }
        catch (CairoException ex) {
            LOG.info().$("could not backup [table=").$(tableName).$(", ex=").$(ex.getFlyweightMessage()).$(", errno=").$(ex.getErrno()).$(']').$();
            this.path.of(this.cachedTmpBackupRoot).concat(tableName).slash$();
            int errno = this.ff.rmdir(this.path);
            if (errno != 0) {
                LOG.error().$("could not delete directory [path=").$(this.path).$(", errno=").$(errno).$(']').$();
            }
            throw ex;
        }
    }

    private void clear() {
        this.sqlNodePool.clear();
        this.characterStore.clear();
        this.queryColumnPool.clear();
        this.queryModelPool.clear();
        this.optimiser.clear();
        this.parser.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cloneMetaData(CharSequence tableName, CharSequence backupRoot, int mkDirMode, TableReader reader) {
        this.path.of(backupRoot).concat(tableName).slash$();
        if (this.ff.exists(this.path)) {
            throw CairoException.instance(0).put("Backup dir for table \"").put(tableName).put("\" already exists [dir=").put(this.path).put(']');
        }
        if (this.ff.mkdirs(this.path, mkDirMode) != 0) {
            throw CairoException.instance(this.ff.errno()).put("Could not create [dir=").put(this.path).put(']');
        }
        int rootLen = this.path.length();
        TableReaderMetadata sourceMetaData = reader.getMetadata();
        try {
            this.mem.of(this.ff, this.path.trimTo(rootLen).concat("_meta").$(), this.ff.getPageSize());
            sourceMetaData.cloneTo(this.mem);
            this.path.trimTo(rootLen).$();
            int symbolMapCount = 0;
            int sz = sourceMetaData.getColumnCount();
            for (int i = 0; i < sz; ++i) {
                if (sourceMetaData.getColumnType(i) != 11) continue;
                SymbolMapReader mapReader = reader.getSymbolMapReader(i);
                SymbolMapWriter.createSymbolMapFiles(this.ff, this.mem, this.path, sourceMetaData.getColumnName(i), mapReader.getSymbolCapacity(), mapReader.isCached());
                ++symbolMapCount;
            }
            this.mem.of(this.ff, this.path.trimTo(rootLen).concat("_txn").$(), this.ff.getPageSize());
            TableUtils.resetTxn(this.mem, symbolMapCount, 0L, 0L, 0L);
            this.path.trimTo(rootLen).concat("_txn_scoreboard").$();
        }
        finally {
            this.mem.close();
        }
    }

    private ExecutionModel compileExecutionModel(SqlExecutionContext executionContext) throws SqlException {
        ExecutionModel model = this.parser.parse(this.lexer, executionContext);
        switch (model.getModelType()) {
            case 1: {
                return this.optimiser.optimise((QueryModel)model, executionContext);
            }
            case 4: {
                InsertModel insertModel = (InsertModel)model;
                if (insertModel.getQueryModel() != null) {
                    return this.validateAndOptimiseInsertAsSelect(insertModel, executionContext);
                }
                return this.lightlyValidateInsertModel(insertModel);
            }
        }
        return model;
    }

    private CompiledQuery compileSet(SqlExecutionContext executionContext) {
        return this.compiledQuery.ofSet();
    }

    @NotNull
    private CompiledQuery compileUsingModel(SqlExecutionContext executionContext) throws SqlException {
        this.lexer.unparse();
        this.codeGenerator.clear();
        ExecutionModel executionModel = this.compileExecutionModel(executionContext);
        switch (executionModel.getModelType()) {
            case 1: {
                LOG.info().$("plan [q=`").$((QueryModel)executionModel).$("`, fd=").$(executionContext.getRequestFd()).$(']').$();
                return this.compiledQuery.of(this.generate((QueryModel)executionModel, executionContext));
            }
            case 2: {
                return this.createTableWithRetries(executionModel, executionContext);
            }
            case 5: {
                return this.executeCopy(executionContext, (CopyModel)executionModel);
            }
            case 3: {
                RenameTableModel rtm = (RenameTableModel)executionModel;
                this.engine.rename(executionContext.getCairoSecurityContext(), this.path, GenericLexer.unquote(rtm.getFrom().token), this.renamePath, GenericLexer.unquote(rtm.getTo().token));
                return this.compiledQuery.ofRenameTable();
            }
        }
        InsertModel insertModel = (InsertModel)executionModel;
        if (insertModel.getQueryModel() != null) {
            return this.executeWithRetries(this.insertAsSelectMethod, executionModel, this.configuration.getCreateAsSelectRetryCount(), executionContext);
        }
        return this.insert(executionModel, executionContext);
    }

    private void copyOrdered(TableWriter writer, RecordMetadata metadata, RecordCursor cursor, RecordToRowCopier copier, int cursorTimestampIndex) {
        int timestampType = metadata.getColumnType(cursorTimestampIndex);
        if (timestampType == 10 || timestampType == 11) {
            this.copyOrderedStrTimestamp(writer, cursor, copier, cursorTimestampIndex);
        } else {
            this.copyOrdered0(writer, cursor, copier, cursorTimestampIndex);
        }
        writer.commit();
    }

    private void copyOrdered0(TableWriter writer, RecordCursor cursor, RecordToRowCopier copier, int cursorTimestampIndex) {
        Record record = cursor.getRecord();
        while (cursor.hasNext()) {
            TableWriter.Row row = writer.newRow(record.getTimestamp(cursorTimestampIndex));
            copier.copy(record, row);
            row.append();
        }
    }

    private void copyOrderedBatched(TableWriter writer, RecordMetadata metadata, RecordCursor cursor, RecordToRowCopier copier, int cursorTimestampIndex, long batchSize, long hysteresis) {
        int timestampType = metadata.getColumnType(cursorTimestampIndex);
        if (timestampType == 10 || timestampType == 11) {
            this.copyOrderedBatchedStrTimestamp(writer, cursor, copier, cursorTimestampIndex, batchSize, hysteresis);
        } else {
            this.copyOrderedBatched0(writer, cursor, copier, cursorTimestampIndex, batchSize, hysteresis);
        }
        writer.commit();
    }

    private void copyOrderedBatched0(TableWriter writer, RecordCursor cursor, RecordToRowCopier copier, int cursorTimestampIndex, long batchSize, long hysteresis) {
        long deadline = batchSize;
        long rowCount = 0L;
        Record record = cursor.getRecord();
        while (cursor.hasNext()) {
            TableWriter.Row row = writer.newRow(record.getTimestamp(cursorTimestampIndex));
            copier.copy(record, row);
            row.append();
            if (++rowCount <= deadline) continue;
            writer.commitHysteresis(hysteresis);
            deadline = rowCount + batchSize;
        }
    }

    private void copyOrderedBatchedStrTimestamp(TableWriter writer, RecordCursor cursor, RecordToRowCopier copier, int cursorTimestampIndex, long batchSize, long hysteresis) {
        long deadline = batchSize;
        long rowCount = 0L;
        Record record = cursor.getRecord();
        while (cursor.hasNext()) {
            CharSequence str = record.getStr(cursorTimestampIndex);
            try {
                TableWriter.Row row = writer.newRow(IntervalUtils.parseFloorPartialDate(str));
                copier.copy(record, row);
                row.append();
                if (++rowCount <= deadline) continue;
                writer.commitHysteresis(hysteresis);
                deadline = rowCount + batchSize;
            }
            catch (NumericException numericException) {
                throw CairoException.instance(0).put("Invalid timestamp: ").put(str);
            }
        }
    }

    private void copyOrderedStrTimestamp(TableWriter writer, RecordCursor cursor, RecordToRowCopier copier, int cursorTimestampIndex) {
        Record record = cursor.getRecord();
        while (cursor.hasNext()) {
            CharSequence str = record.getStr(cursorTimestampIndex);
            try {
                TableWriter.Row row = writer.newRow(IntervalUtils.parseFloorPartialDate(str));
                copier.copy(record, row);
                row.append();
            }
            catch (NumericException numericException) {
                throw CairoException.instance(0).put("Invalid timestamp: ").put(str);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyTable(SqlExecutionContext executionContext, CopyModel model) throws SqlException {
        try {
            int len = this.configuration.getSqlCopyBufferSize();
            long buf = Unsafe.malloc(len);
            try {
                CharSequence name = GenericLexer.assertNoDots(GenericLexer.unquote(model.getFileName().token), model.getFileName().position);
                this.path.of(this.configuration.getInputRoot()).concat(name).$();
                long fd = this.ff.openRO(this.path);
                if (fd == -1L) {
                    throw SqlException.$(model.getFileName().position, "could not open file [errno=").put(Os.errno()).put(", path=").put(this.path).put(']');
                }
                try {
                    long n;
                    long fileLen = this.ff.length(fd);
                    if (n > 0L) {
                        int read;
                        this.textLoader.setForceHeaders(model.isHeader());
                        this.textLoader.setSkipRowsWithExtraValues(false);
                        this.textLoader.parse(buf, buf + n, executionContext.getCairoSecurityContext());
                        this.textLoader.setState(2);
                        for (n = this.ff.read(fd, buf, len, 0L); n < fileLen; n += (long)read) {
                            read = (int)this.ff.read(fd, buf, len, n);
                            if (read < 1) {
                                throw SqlException.$(model.getFileName().position, "could not read file [errno=").put(this.ff.errno()).put(']');
                            }
                            this.textLoader.parse(buf, buf + (long)read, executionContext.getCairoSecurityContext());
                        }
                        this.textLoader.wrapUp();
                    }
                }
                finally {
                    this.ff.close(fd);
                }
            }
            finally {
                this.textLoader.clear();
                Unsafe.free(buf, len);
            }
        }
        catch (TextException textException) {
        }
        finally {
            LOG.info().$("copied").$();
        }
    }

    private TableWriter copyTableData(CharSequence tableName, RecordCursor cursor, RecordMetadata cursorMetadata) {
        TableWriter writer = new TableWriter(this.configuration, tableName, this.messageBus, false, DefaultLifecycleManager.INSTANCE);
        try {
            TableWriterMetadata writerMetadata = writer.getMetadata();
            this.entityColumnFilter.of(writerMetadata.getColumnCount());
            RecordToRowCopier recordToRowCopier = SqlCompiler.assembleRecordToRowCopier(this.asm, cursorMetadata, writerMetadata, this.entityColumnFilter);
            this.copyTableData(cursor, cursorMetadata, writer, writerMetadata, recordToRowCopier);
            return writer;
        }
        catch (Throwable e) {
            writer.close();
            throw e;
        }
    }

    private void copyTableData(RecordCursor cursor, RecordMetadata metadata, TableWriter writer, RecordMetadata writerMetadata, RecordToRowCopier recordToRowCopier) {
        int timestampIndex = writerMetadata.getTimestampIndex();
        if (timestampIndex == -1) {
            this.copyUnordered(cursor, writer, recordToRowCopier);
        } else {
            this.copyOrdered(writer, metadata, cursor, recordToRowCopier, timestampIndex);
        }
    }

    private void copyUnordered(RecordCursor cursor, TableWriter writer, RecordToRowCopier copier) {
        Record record = cursor.getRecord();
        while (cursor.hasNext()) {
            TableWriter.Row row = writer.newRow();
            copier.copy(record, row);
            row.append();
        }
        writer.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CompiledQuery createTable(ExecutionModel model, SqlExecutionContext executionContext) throws SqlException {
        CreateTableModel createTableModel = (CreateTableModel)model;
        ExpressionNode name = createTableModel.getName();
        if (!this.engine.lock(executionContext.getCairoSecurityContext(), name.token)) throw SqlException.$(name.position, "cannot acquire table lock");
        TableWriter writer = null;
        boolean newTable = false;
        try {
            if (this.engine.getStatus(executionContext.getCairoSecurityContext(), this.path, name.token, 0, name.token.length()) != 1) {
                if (!createTableModel.isIgnoreIfExists()) throw SqlException.$(name.position, "table already exists");
                CompiledQuery compiledQuery = this.compiledQuery.ofCreateTable();
                this.engine.unlock(executionContext.getCairoSecurityContext(), name.token, writer, newTable);
                return compiledQuery;
            }
        }
        catch (Throwable throwable) {
            this.engine.unlock(executionContext.getCairoSecurityContext(), name.token, writer, newTable);
            throw throwable;
        }
        {
            try {
                if (createTableModel.getQueryModel() == null) {
                    this.engine.createTableUnsafe(executionContext.getCairoSecurityContext(), this.mem, this.path, createTableModel);
                    newTable = true;
                } else {
                    writer = this.createTableFromCursor(createTableModel, executionContext);
                }
            }
            catch (CairoException e) {
                LOG.error().$("could not create table [error=").$(e).$(']').$();
                throw SqlException.$(name.position, "Could not create table. See log for details.");
            }
            this.engine.unlock(executionContext.getCairoSecurityContext(), name.token, writer, newTable);
            return this.compiledQuery.ofCreateTable();
        }
    }

    /*
     * Exception decompiling
     */
    private TableWriter createTableFromCursor(CreateTableModel model, SqlExecutionContext executionContext) throws SqlException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private CompiledQuery createTableWithRetries(ExecutionModel executionModel, SqlExecutionContext executionContext) throws SqlException {
        return this.executeWithRetries(this.createTableMethod, executionModel, this.configuration.getCreateAsSelectRetryCount(), executionContext);
    }

    private CompiledQuery dropTable(SqlExecutionContext executionContext) throws SqlException {
        SqlCompiler.expectKeyword(this.lexer, "table");
        int tableNamePosition = this.lexer.getPosition();
        CharSequence tableName = GenericLexer.unquote(SqlCompiler.expectToken(this.lexer, "table name"));
        CharSequence tok = SqlUtil.fetchNext(this.lexer);
        if (tok != null && !Chars.equals(tok, ';')) {
            throw SqlException.$(this.lexer.lastTokenPosition(), "unexpected token");
        }
        this.tableExistsOrFail(tableNamePosition, tableName, executionContext);
        this.engine.remove(executionContext.getCairoSecurityContext(), this.path, tableName);
        return this.compiledQuery.ofDrop();
    }

    @NotNull
    private CompiledQuery executeCopy(SqlExecutionContext executionContext, CopyModel executionModel) throws SqlException {
        this.setupTextLoaderFromModel(executionModel);
        if (Chars.equalsLowerCaseAscii(executionModel.getFileName().token, "stdin")) {
            return this.compiledQuery.ofCopyRemote(this.textLoader);
        }
        this.copyTable(executionContext, executionModel);
        return this.compiledQuery.ofCopyLocal();
    }

    private CompiledQuery executeWithRetries(ExecutableMethod method, ExecutionModel executionModel, int retries, SqlExecutionContext executionContext) throws SqlException {
        int attemptsLeft = retries;
        while (true) {
            try {
                return method.execute(executionModel, executionContext);
            }
            catch (ReaderOutOfDateException e) {
                this.clear();
                this.lexer.restart();
                executionModel = this.compileExecutionModel(executionContext);
                if (--attemptsLeft > 0) continue;
                throw SqlException.position(0).put("underlying cursor is extremely volatile");
            }
            break;
        }
    }

    RecordCursorFactory generate(QueryModel queryModel, SqlExecutionContext executionContext) throws SqlException {
        return this.codeGenerator.generate(queryModel, executionContext);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CompiledQuery insert(ExecutionModel executionModel, SqlExecutionContext executionContext) throws SqlException {
        InsertModel model = (InsertModel)executionModel;
        ExpressionNode name = model.getTableName();
        this.tableExistsOrFail(name.position, name.token, executionContext);
        ObjList<Function> valueFunctions = null;
        try (TableReader reader = this.engine.getReader(executionContext.getCairoSecurityContext(), name.token, -1L);){
            long structureVersion = reader.getVersion();
            TableReaderMetadata metadata = reader.getMetadata();
            int writerTimestampIndex = metadata.getTimestampIndex();
            CharSequenceHashSet columnSet = model.getColumnSet();
            int columnSetSize = columnSet.size();
            Function timestampFunction = null;
            this.listColumnFilter.clear();
            if (columnSetSize > 0) {
                this.listColumnFilter.clear();
                valueFunctions = new ObjList<Function>(columnSetSize);
                for (int i = 0; i < columnSetSize; ++i) {
                    int index = metadata.getColumnIndexQuiet(columnSet.get(i));
                    if (index <= -1) throw SqlException.invalidColumn(model.getColumnPosition(i), columnSet.get(i));
                    ExpressionNode node = model.getColumnValues().getQuick(i);
                    Function function = this.functionParser.parseFunction(node, GenericRecordMetadata.EMPTY, executionContext);
                    this.validateAndConsume(model, valueFunctions, metadata, writerTimestampIndex, i, index, function, executionContext.getBindVariableService());
                    if (writerTimestampIndex != index) continue;
                    timestampFunction = function;
                }
            } else {
                ObjList<ExpressionNode> values;
                int valueCount;
                int columnCount = metadata.getColumnCount();
                if (columnCount != (valueCount = (values = model.getColumnValues()).size())) {
                    throw SqlException.$(model.getEndOfValuesPosition(), "not enough values [expected=").put(columnCount).put(", actual=").put(values.size()).put(']');
                }
                valueFunctions = new ObjList(columnCount);
                for (int i = 0; i < columnCount; ++i) {
                    ExpressionNode node = values.getQuick(i);
                    Function function = this.functionParser.parseFunction(node, EmptyRecordMetadata.INSTANCE, executionContext);
                    this.validateAndConsume(model, valueFunctions, metadata, writerTimestampIndex, i, i, function, executionContext.getBindVariableService());
                    if (writerTimestampIndex != i) continue;
                    timestampFunction = function;
                }
            }
            if (writerTimestampIndex > -1 && timestampFunction == null) {
                throw SqlException.$(0, "insert statement must populate timestamp");
            }
            VirtualRecord record = new VirtualRecord(valueFunctions);
            RecordToRowCopier copier = SqlCompiler.assembleRecordToRowCopier(this.asm, record, metadata, this.listColumnFilter);
            CompiledQuery compiledQuery = this.compiledQuery.ofInsert(new InsertStatementImpl(this.engine, Chars.toString(name.token), record, copier, timestampFunction, structureVersion));
            return compiledQuery;
        }
        catch (SqlException e) {
            Misc.freeObjList(valueFunctions);
            throw e;
        }
    }

    private CompiledQuery insertAsSelect(ExecutionModel executionModel, SqlExecutionContext executionContext) throws SqlException {
        InsertModel model = (InsertModel)executionModel;
        ExpressionNode name = model.getTableName();
        this.tableExistsOrFail(name.position, name.token, executionContext);
        try (TableWriter writer = this.engine.getWriter(executionContext.getCairoSecurityContext(), name.token);
             RecordCursorFactory factory = this.generate(model.getQueryModel(), executionContext);){
            RecordToRowCopier copier;
            RecordMetadata cursorMetadata = factory.getMetadata();
            TableWriterMetadata writerMetadata = writer.getMetadata();
            int writerTimestampIndex = writerMetadata.getTimestampIndex();
            int cursorTimestampIndex = cursorMetadata.getTimestampIndex();
            int cursorColumnCount = cursorMetadata.getColumnCount();
            if (writerTimestampIndex > -1 && cursorTimestampIndex == -1) {
                if (cursorColumnCount <= writerTimestampIndex) {
                    throw SqlException.$(name.position, "select clause must provide timestamp column");
                }
                int columnType = cursorMetadata.getColumnType(writerTimestampIndex);
                if (columnType != 7 && columnType != 10) {
                    throw SqlException.$(name.position, "expected timestamp column but type is ").put(ColumnType.nameOf(columnType));
                }
            }
            if (writerTimestampIndex > -1 && cursorTimestampIndex > -1 && writerTimestampIndex != cursorTimestampIndex) {
                throw SqlException.$(name.position, "nominated column of existing table (").put(writerTimestampIndex).put(") does not match nominated column in select query (").put(cursorTimestampIndex).put(')');
            }
            CharSequenceHashSet columnSet = model.getColumnSet();
            int columnSetSize = columnSet.size();
            if (columnSetSize > 0) {
                this.listColumnFilter.clear();
                for (int i = 0; i < columnSetSize; ++i) {
                    CharSequence columnName = columnSet.get(i);
                    int index = writerMetadata.getColumnIndexQuiet(columnName);
                    if (index == -1) {
                        throw SqlException.invalidColumn(model.getColumnPosition(i), columnName);
                    }
                    int fromType = cursorMetadata.getColumnType(i);
                    int toType = writerMetadata.getColumnType(index);
                    if (!SqlCompiler.isAssignableFrom(toType, fromType)) {
                        throw SqlException.inconvertibleTypes(model.getColumnPosition(i), fromType, cursorMetadata.getColumnName(i), toType, writerMetadata.getColumnName(i));
                    }
                    this.listColumnFilter.add(index + 1);
                }
                copier = SqlCompiler.assembleRecordToRowCopier(this.asm, cursorMetadata, writerMetadata, this.listColumnFilter);
            } else {
                int n = writerMetadata.getColumnCount();
                if (n > cursorMetadata.getColumnCount()) {
                    throw SqlException.$(model.getSelectKeywordPosition(), "not enough columns selected");
                }
                for (int i = 0; i < n; ++i) {
                    int fromType = cursorMetadata.getColumnType(i);
                    int toType = writerMetadata.getColumnType(i);
                    if (SqlCompiler.isAssignableFrom(toType, fromType)) continue;
                    assert (i < model.getQueryModel().getBottomUpColumns().size());
                    throw SqlException.inconvertibleTypes(model.getQueryModel().getBottomUpColumns().getQuick((int)i).getAst().position, fromType, cursorMetadata.getColumnName(i), toType, writerMetadata.getColumnName(i));
                }
                this.entityColumnFilter.of(writerMetadata.getColumnCount());
                copier = SqlCompiler.assembleRecordToRowCopier(this.asm, cursorMetadata, writerMetadata, this.entityColumnFilter);
            }
            try (RecordCursor cursor = factory.getCursor(executionContext);){
                try {
                    if (writerTimestampIndex == -1) {
                        this.copyUnordered(cursor, writer, copier);
                    } else if (model.getBatchSize() != -1L) {
                        this.copyOrderedBatched(writer, factory.getMetadata(), cursor, copier, writerTimestampIndex, model.getBatchSize(), model.getHysteresis());
                    } else {
                        this.copyOrdered(writer, factory.getMetadata(), cursor, copier, writerTimestampIndex);
                    }
                }
                catch (Throwable e) {
                    writer.rollback();
                    throw e;
                }
            }
        }
        return this.compiledQuery.ofInsertAsSelect();
    }

    private ExecutionModel lightlyValidateInsertModel(InsertModel model) throws SqlException {
        ExpressionNode tableName = model.getTableName();
        if (tableName.type != 4) {
            throw SqlException.$(tableName.position, "literal expected");
        }
        int columnSetSize = model.getColumnSet().size();
        if (columnSetSize > 0 && columnSetSize != model.getColumnValues().size()) {
            throw SqlException.$(model.getColumnPosition(0), "value count does not match column count");
        }
        return model;
    }

    private boolean removeTableDirectory(CreateTableModel model) {
        int errno = this.engine.removeDirectory(this.path, model.getName().token);
        if (errno == 0) {
            return true;
        }
        LOG.error().$("could not clean up after create table failure [path=").$(this.path).$(", errno=").$(errno).$(']').$();
        return false;
    }

    private CompiledQuery repairTables(SqlExecutionContext executionContext) throws SqlException {
        CharSequence tok = SqlUtil.fetchNext(this.lexer);
        if (tok == null || !SqlKeywords.isTableKeyword(tok)) {
            throw SqlException.$(this.lexer.lastTokenPosition(), "'table' expected");
        }
        do {
            if ((tok = SqlUtil.fetchNext(this.lexer)) == null || Chars.equals(tok, ',')) {
                throw SqlException.$(this.lexer.getPosition(), "table name expected");
            }
            if (Chars.isQuoted(tok)) {
                tok = GenericLexer.unquote(tok);
            }
            this.tableExistsOrFail(this.lexer.lastTokenPosition(), tok, executionContext);
            try {
                this.engine.migrateNullFlag(executionContext.getCairoSecurityContext(), tok);
            }
            catch (CairoException e) {
                LOG.info().$("table busy [table=").$(tok).$(", e=").$(e).$(']').$();
                throw SqlException.$(this.lexer.lastTokenPosition(), "table '").put(tok).put("' is busy");
            }
        } while ((tok = SqlUtil.fetchNext(this.lexer)) != null && Chars.equals(tok, ','));
        return this.compiledQuery.ofRepair();
    }

    void setFullSatJoins(boolean value) {
        this.codeGenerator.setFullFatJoins(value);
    }

    private void setupBackupRenamePath() {
        DateFormat format = this.configuration.getBackupDirTimestampFormat();
        long epochMicros = this.configuration.getMicrosecondClock().getTicks();
        int n = 0;
        this.renamePath.of(this.configuration.getBackupRoot()).slash();
        int plen = this.renamePath.length();
        do {
            this.renamePath.trimTo(plen);
            format.format(epochMicros, this.configuration.getDefaultDateLocale(), null, this.renamePath);
            if (n > 0) {
                this.renamePath.put('.').put(n);
            }
            this.renamePath.slash$();
            ++n;
        } while (this.ff.exists(this.renamePath));
        if (this.ff.mkdirs(this.renamePath, this.configuration.getBackupMkDirMode()) != 0) {
            throw CairoException.instance(this.ff.errno()).put("could not create [dir=").put(this.renamePath).put(']');
        }
    }

    private void setupTextLoaderFromModel(CopyModel model) {
        this.textLoader.clear();
        this.textLoader.setState(1);
        this.textLoader.configureDestination(model.getTableName().token, false, false, 1, 3, null);
    }

    private CompiledQuery sqlBackup(SqlExecutionContext executionContext) throws SqlException {
        executionContext.getCairoSecurityContext().checkWritePermission();
        if (null == this.configuration.getBackupRoot()) {
            throw CairoException.instance(0).put("Backup is disabled, no backup root directory is configured in the server configuration ['cairo.sql.backup.root' property]");
        }
        CharSequence tok = SqlUtil.fetchNext(this.lexer);
        if (null != tok) {
            if (SqlKeywords.isTableKeyword(tok)) {
                return this.sqlTableBackup(executionContext);
            }
            if (SqlKeywords.isDatabaseKeyword(tok)) {
                return this.sqlDatabaseBackup(executionContext);
            }
        }
        throw SqlException.position(this.lexer.lastTokenPosition()).put("expected 'table' or 'database'");
    }

    private CompiledQuery sqlDatabaseBackup(SqlExecutionContext executionContext) {
        this.currentExecutionContext = executionContext;
        try {
            this.setupBackupRenamePath();
            this.ff.iterateDir(this.path.of(this.configuration.getRoot()).$(), this.sqlDatabaseBackupOnFind);
            CompiledQuery compiledQuery = this.compiledQuery.ofBackupTable();
            return compiledQuery;
        }
        finally {
            this.currentExecutionContext = null;
        }
    }

    private CompiledQuery sqlShow(SqlExecutionContext executionContext) throws SqlException {
        CharSequence tok = SqlUtil.fetchNext(this.lexer);
        if (null != tok) {
            if (SqlKeywords.isTablesKeyword(tok)) {
                return this.compiledQuery.of(new TableListRecordCursorFactory(this.configuration.getFilesFacade(), this.configuration.getRoot()));
            }
            if (SqlKeywords.isColumnsKeyword(tok)) {
                return this.sqlShowColumns(executionContext);
            }
            if (SqlKeywords.isTransactionKeyword(tok)) {
                return this.sqlShowTransaction();
            }
            if (SqlKeywords.isStandardConformingStringsKeyword(tok)) {
                return this.compiledQuery.of(new ShowStandardConformingStringsCursorFactory());
            }
            if (SqlKeywords.isSearchPath(tok)) {
                return this.compiledQuery.of(new ShowSearchPathCursorFactory());
            }
        }
        throw SqlException.position(this.lexer.lastTokenPosition()).put("expected 'tables' or 'columns'");
    }

    private CompiledQuery sqlShowColumns(SqlExecutionContext executionContext) throws SqlException {
        CharSequence tok = SqlUtil.fetchNext(this.lexer);
        if (null == tok || !SqlKeywords.isFromKeyword(tok)) {
            throw SqlException.position(this.lexer.getPosition()).put("expected 'from'");
        }
        tok = SqlUtil.fetchNext(this.lexer);
        if (null == tok) {
            throw SqlException.position(this.lexer.getPosition()).put("expected a table name");
        }
        CharSequence tableName = GenericLexer.assertNoDotsAndSlashes(GenericLexer.unquote(tok), this.lexer.lastTokenPosition());
        int status = this.engine.getStatus(executionContext.getCairoSecurityContext(), this.path, tableName, 0, tableName.length());
        if (status != 0) {
            throw SqlException.position(this.lexer.lastTokenPosition()).put('\'').put(tableName).put("' is not a valid table");
        }
        return this.compiledQuery.of(new ShowColumnsRecordCursorFactory(tableName));
    }

    private CompiledQuery sqlShowTransaction() throws SqlException {
        CharSequence tok = SqlUtil.fetchNext(this.lexer);
        if (tok != null && SqlKeywords.isIsolationKeyword(tok)) {
            tok = SqlUtil.fetchNext(this.lexer);
            if (tok != null && SqlKeywords.isLevelKeyword(tok)) {
                return this.compiledQuery.of(new ShowTransactionIsolationLevelCursorFactory());
            }
            throw SqlException.position(tok != null ? this.lexer.lastTokenPosition() : this.lexer.getPosition()).put("expected 'level'");
        }
        throw SqlException.position(tok != null ? this.lexer.lastTokenPosition() : this.lexer.getPosition()).put("expected 'isolation'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompiledQuery sqlTableBackup(SqlExecutionContext executionContext) throws SqlException {
        this.setupBackupRenamePath();
        try {
            block7: {
                CharSequence tok;
                this.tableNames.clear();
                do {
                    if (null == (tok = SqlUtil.fetchNext(this.lexer))) {
                        throw SqlException.position(this.lexer.getPosition()).put("expected a table name");
                    }
                    CharSequence tableName = GenericLexer.assertNoDotsAndSlashes(GenericLexer.unquote(tok), this.lexer.lastTokenPosition());
                    int status = this.engine.getStatus(executionContext.getCairoSecurityContext(), this.path, tableName, 0, tableName.length());
                    if (status != 0) {
                        throw SqlException.position(this.lexer.lastTokenPosition()).put('\'').put(tableName).put("' is not  a valid table");
                    }
                    this.tableNames.add(tableName);
                    tok = SqlUtil.fetchNext(this.lexer);
                    if (null == tok || Chars.equals(tok, ';')) break block7;
                } while (Chars.equals(tok, ','));
                throw SqlException.position(this.lexer.lastTokenPosition()).put("expected ','");
            }
            for (int n = 0; n < this.tableNames.size(); ++n) {
                this.backupTable(this.tableNames.get(n), executionContext);
            }
            CompiledQuery compiledQuery = this.compiledQuery.ofBackupTable();
            return compiledQuery;
        }
        finally {
            this.tableNames.clear();
        }
    }

    private void tableExistsOrFail(int position, CharSequence tableName, SqlExecutionContext executionContext) throws SqlException {
        if (this.engine.getStatus(executionContext.getCairoSecurityContext(), this.path, tableName) == 1) {
            throw SqlException.$(position, "table '").put(tableName).put("' does not exist");
        }
    }

    ExecutionModel testCompileModel(CharSequence query, SqlExecutionContext executionContext) throws SqlException {
        this.clear();
        this.lexer.of(query);
        return this.compileExecutionModel(executionContext);
    }

    ExpressionNode testParseExpression(CharSequence expression, QueryModel model) throws SqlException {
        this.clear();
        this.lexer.of(expression);
        return this.parser.expr(this.lexer, model);
    }

    void testParseExpression(CharSequence expression, ExpressionParserListener listener) throws SqlException {
        this.clear();
        this.lexer.of(expression);
        this.parser.expr(this.lexer, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompiledQuery truncateTables(SqlExecutionContext executionContext) throws SqlException {
        CharSequence tok = SqlUtil.fetchNext(this.lexer);
        if (tok == null) {
            throw SqlException.$(this.lexer.getPosition(), "'table' expected");
        }
        if (!SqlKeywords.isTableKeyword(tok)) {
            throw SqlException.$(this.lexer.lastTokenPosition(), "'table' expected");
        }
        tok = SqlUtil.fetchNext(this.lexer);
        if (tok != null && SqlKeywords.isOnlyKeyword(tok)) {
            tok = SqlUtil.fetchNext(this.lexer);
        }
        this.tableWriters.clear();
        try {
            try {
                while (true) {
                    if (tok == null || Chars.equals(tok, ',')) {
                        throw SqlException.$(this.lexer.getPosition(), "table name expected");
                    }
                    if (Chars.isQuoted(tok)) {
                        tok = GenericLexer.unquote(tok);
                    }
                    this.tableExistsOrFail(this.lexer.lastTokenPosition(), tok, executionContext);
                    try {
                        this.tableWriters.add(this.engine.getWriter(executionContext.getCairoSecurityContext(), tok));
                    }
                    catch (CairoException e) {
                        LOG.info().$("table busy [table=").$(tok).$(", e=").$(e).$(']').$();
                        throw SqlException.$(this.lexer.lastTokenPosition(), "table '").put(tok).put("' is busy");
                    }
                    tok = SqlUtil.fetchNext(this.lexer);
                    if (tok != null && !Chars.equals(tok, ';')) {
                        if (!Chars.equalsNc(tok, ',')) continue;
                        tok = SqlUtil.fetchNext(this.lexer);
                        continue;
                    }
                    break;
                }
            }
            catch (SqlException e) {
                int n = this.tableWriters.size();
                for (int i = 0; i < n; ++i) {
                    this.tableWriters.getQuick(i).close();
                }
                throw e;
            }
            int n = this.tableWriters.size();
            for (int i = 0; i < n; ++i) {
                try (TableWriter writer = this.tableWriters.getQuick(i);){
                    try {
                        if (this.engine.lockReaders(writer.getTableName())) {
                            try {
                                writer.truncate();
                                continue;
                            }
                            finally {
                                this.engine.unlockReaders(writer.getTableName());
                            }
                        }
                        throw SqlException.$(0, "there is an active query against '").put(writer.getTableName()).put("'. Try again.");
                    }
                    catch (CairoError | CairoException e) {
                        LOG.error().$("could truncate [table=").$(writer.getTableName()).$(", e=").$((Sinkable)((Object)e)).$(']').$();
                        throw e;
                    }
                }
            }
        }
        finally {
            this.tableWriters.clear();
        }
        return this.compiledQuery.ofTruncate();
    }

    private void validateAndConsume(InsertModel model, ObjList<Function> valueFunctions, RecordMetadata metadata, int writerTimestampIndex, int bottomUpColumnIndex, int metadataColumnIndex, Function function, BindVariableService bindVariableService) throws SqlException {
        int columnType = metadata.getColumnType(metadataColumnIndex);
        if (function.isUndefined()) {
            function.assignType(columnType, bindVariableService);
        }
        if (SqlCompiler.isAssignableFrom(columnType, function.getType())) {
            if (metadataColumnIndex == writerTimestampIndex) {
                return;
            }
            valueFunctions.add(function);
            this.listColumnFilter.add(metadataColumnIndex + 1);
            return;
        }
        throw SqlException.inconvertibleTypes(function.getPosition(), function.getType(), model.getColumnValues().getQuick((int)bottomUpColumnIndex).token, metadata.getColumnType(metadataColumnIndex), metadata.getColumnName(metadataColumnIndex));
    }

    private InsertModel validateAndOptimiseInsertAsSelect(InsertModel model, SqlExecutionContext executionContext) throws SqlException {
        QueryModel queryModel = this.optimiser.optimise(model.getQueryModel(), executionContext);
        int targetColumnCount = model.getColumnSet().size();
        if (targetColumnCount > 0 && queryModel.getBottomUpColumns().size() != targetColumnCount) {
            throw SqlException.$(model.getTableName().position, "column count mismatch");
        }
        model.setQueryModel(queryModel);
        return model;
    }

    private void validateTableModelAndCreateTypeCast(CreateTableModel model, RecordMetadata metadata, IntIntHashMap typeCast) throws SqlException {
        CharSequenceObjHashMap<ColumnCastModel> castModels = model.getColumnCastModels();
        ObjList<CharSequence> castColumnNames = castModels.keys();
        int n = castColumnNames.size();
        for (int i = 0; i < n; ++i) {
            int to;
            CharSequence columnName = castColumnNames.getQuick(i);
            int index = metadata.getColumnIndexQuiet(columnName);
            if (index == -1) {
                throw SqlException.invalidColumn(castModels.get(columnName).getColumnNamePos(), columnName);
            }
            ColumnCastModel ccm = castModels.get(columnName);
            int from = metadata.getColumnType(index);
            if (!SqlCompiler.isCompatibleCase(from, to = ccm.getColumnType())) {
                throw SqlException.$(ccm.getColumnTypePos(), "unsupported cast [from=").put(ColumnType.nameOf(from)).put(",to=").put(ColumnType.nameOf(to)).put(']');
            }
            typeCast.put(index, to);
        }
        ExpressionNode timestamp = model.getTimestamp();
        if (timestamp != null && metadata.getColumnType(timestamp.token) != 7) {
            throw SqlException.position(timestamp.position).put("TIMESTAMP column expected [actual=").put(ColumnType.nameOf(metadata.getColumnType(timestamp.token))).put(']');
        }
        if (model.getPartitionBy() != 3 && model.getTimestampIndex() == -1 && metadata.getTimestampIndex() == -1) {
            throw SqlException.position(0).put("timestamp is not defined");
        }
    }

    static {
        castGroups.extendAndSet(0, 2);
        castGroups.extendAndSet(1, 1);
        castGroups.extendAndSet(2, 1);
        castGroups.extendAndSet(3, 1);
        castGroups.extendAndSet(4, 1);
        castGroups.extendAndSet(5, 1);
        castGroups.extendAndSet(8, 1);
        castGroups.extendAndSet(9, 1);
        castGroups.extendAndSet(6, 1);
        castGroups.extendAndSet(7, 1);
        castGroups.extendAndSet(10, 3);
        castGroups.extendAndSet(11, 3);
        castGroups.extendAndSet(13, 4);
        sqlControlSymbols.add("(");
        sqlControlSymbols.add(";");
        sqlControlSymbols.add(")");
        sqlControlSymbols.add(",");
        sqlControlSymbols.add("/*");
        sqlControlSymbols.add("*/");
        sqlControlSymbols.add("--");
        sqlControlSymbols.add("[");
        sqlControlSymbols.add("]");
    }

    private static class TableStructureAdapter
    implements TableStructure {
        private CreateTableModel model;
        private RecordMetadata metadata;
        private IntIntHashMap typeCast;
        private int timestampIndex;

        private TableStructureAdapter() {
        }

        @Override
        public int getColumnCount() {
            return this.model.getColumnCount();
        }

        @Override
        public CharSequence getColumnName(int columnIndex) {
            return this.model.getColumnName(columnIndex);
        }

        @Override
        public int getColumnType(int columnIndex) {
            int castIndex = this.typeCast.keyIndex(columnIndex);
            if (castIndex < 0) {
                return this.typeCast.valueAt(castIndex);
            }
            return this.metadata.getColumnType(columnIndex);
        }

        @Override
        public int getIndexBlockCapacity(int columnIndex) {
            return this.model.getIndexBlockCapacity(columnIndex);
        }

        @Override
        public boolean isIndexed(int columnIndex) {
            return this.model.isIndexed(columnIndex);
        }

        @Override
        public boolean isSequential(int columnIndex) {
            return this.model.isSequential(columnIndex);
        }

        @Override
        public int getPartitionBy() {
            return this.model.getPartitionBy();
        }

        @Override
        public boolean getSymbolCacheFlag(int columnIndex) {
            ColumnCastModel ccm = this.model.getColumnCastModels().get(this.metadata.getColumnName(columnIndex));
            if (ccm != null) {
                return ccm.getSymbolCacheFlag();
            }
            return this.model.getSymbolCacheFlag(columnIndex);
        }

        @Override
        public int getSymbolCapacity(int columnIndex) {
            ColumnCastModel ccm = this.model.getColumnCastModels().get(this.metadata.getColumnName(columnIndex));
            if (ccm != null) {
                return ccm.getSymbolCapacity();
            }
            return this.model.getSymbolCapacity(columnIndex);
        }

        @Override
        public CharSequence getTableName() {
            return this.model.getTableName();
        }

        @Override
        public int getTimestampIndex() {
            return this.timestampIndex;
        }

        @Override
        public int getO3MaxUncommittedRows() {
            return this.model.getO3MaxUncommittedRows();
        }

        @Override
        public long getO3CommitHysteresisInMicros() {
            return this.model.getO3CommitHysteresisInMicros();
        }

        TableStructureAdapter of(CreateTableModel model, RecordMetadata metadata, IntIntHashMap typeCast) {
            this.timestampIndex = model.getTimestampIndex() != -1 ? model.getTimestampIndex() : metadata.getTimestampIndex();
            this.model = model;
            this.metadata = metadata;
            this.typeCast = typeCast;
            return this;
        }
    }

    public static final class PartitionAction {
        public static final int NONE = 0;
        public static final int DROP = 1;
        public static final int ATTACH = 2;
    }

    public static interface RecordToRowCopier {
        public void copy(Record var1, TableWriter.Row var2);
    }

    @FunctionalInterface
    private static interface ExecutableMethod {
        public CompiledQuery execute(ExecutionModel var1, SqlExecutionContext var2) throws SqlException;
    }

    @FunctionalInterface
    protected static interface KeywordBasedExecutor {
        public CompiledQuery execute(SqlExecutionContext var1) throws SqlException;
    }
}

