/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.MessageBus;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoSecurityContext;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.security.AllowAllCairoSecurityContext;
import io.questdb.cairo.sql.BindVariableService;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlExecutionInterruptor;
import io.questdb.griffin.engine.analytic.AnalyticContext;
import io.questdb.griffin.engine.analytic.AnalyticContextImpl;
import io.questdb.griffin.engine.functions.rnd.SharedRandom;
import io.questdb.mp.RingQueue;
import io.questdb.mp.Sequence;
import io.questdb.std.IntStack;
import io.questdb.std.Rnd;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.tasks.TelemetryTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlExecutionContextImpl
implements SqlExecutionContext {
    private final IntStack timestampRequiredStack = new IntStack();
    private final int workerCount;
    private final CairoConfiguration cairoConfiguration;
    private final CairoEngine cairoEngine;
    @Nullable
    private final MessageBus messageBus;
    private final MicrosecondClock clock;
    private final AnalyticContextImpl analyticContext = new AnalyticContextImpl();
    private RingQueue<TelemetryTask> telemetryQueue;
    private Sequence telemetryPubSeq;
    private TelemetryMethod telemetryMethod = this::storeTelemetryNoop;
    private BindVariableService bindVariableService;
    private CairoSecurityContext cairoSecurityContext;
    private Rnd random;
    private long requestFd = -1L;
    private SqlExecutionInterruptor interruptor = SqlExecutionInterruptor.NOP_INTERRUPTOR;
    private long now;

    public SqlExecutionContextImpl(CairoEngine cairoEngine, int workerCount) {
        this(cairoEngine, workerCount, cairoEngine.getMessageBus());
    }

    public SqlExecutionContextImpl(CairoEngine cairoEngine, int workerCount, @Nullable MessageBus messageBus) {
        this.cairoConfiguration = cairoEngine.getConfiguration();
        this.messageBus = messageBus;
        this.workerCount = workerCount;
        assert (workerCount > 0);
        this.cairoEngine = cairoEngine;
        this.clock = this.cairoConfiguration.getMicrosecondClock();
        this.cairoSecurityContext = AllowAllCairoSecurityContext.INSTANCE;
        if (messageBus != null) {
            this.telemetryQueue = cairoEngine.getTelemetryQueue();
            this.telemetryPubSeq = cairoEngine.getTelemetryPubSequence();
            this.telemetryMethod = this::doStoreTelemetry;
        }
    }

    @Override
    public BindVariableService getBindVariableService() {
        return this.bindVariableService;
    }

    @Override
    public CairoSecurityContext getCairoSecurityContext() {
        return this.cairoSecurityContext;
    }

    @Override
    @Nullable
    public MessageBus getMessageBus() {
        return this.messageBus;
    }

    @Override
    public boolean isTimestampRequired() {
        return this.timestampRequiredStack.notEmpty() && this.timestampRequiredStack.peek() == 1;
    }

    @Override
    public void popTimestampRequiredFlag() {
        this.timestampRequiredStack.pop();
    }

    @Override
    public void pushTimestampRequiredFlag(boolean flag) {
        this.timestampRequiredStack.push(flag ? 1 : 0);
    }

    @Override
    public int getWorkerCount() {
        return this.workerCount;
    }

    @Override
    public Rnd getRandom() {
        return this.random != null ? this.random : SharedRandom.getRandom(this.cairoConfiguration);
    }

    @Override
    public void setRandom(Rnd rnd) {
        this.random = rnd;
    }

    @Override
    public CairoEngine getCairoEngine() {
        return this.cairoEngine;
    }

    @Override
    public long getRequestFd() {
        return this.requestFd;
    }

    @Override
    public SqlExecutionInterruptor getSqlExecutionInterruptor() {
        return this.interruptor;
    }

    @Override
    public void storeTelemetry(short event, short origin) {
        this.telemetryMethod.store(event, origin);
    }

    @Override
    public AnalyticContext getAnalyticContext() {
        return this.analyticContext;
    }

    @Override
    public void configureAnalyticContext(@Nullable VirtualRecord partitionByRecord, @Nullable RecordSink partitionBySink, @Nullable ColumnTypes partitionByKeyTypes, boolean ordered, boolean baseSupportsRandomAccess) {
        this.analyticContext.of(partitionByRecord, partitionBySink, partitionByKeyTypes, ordered, baseSupportsRandomAccess);
    }

    @Override
    public void initNow() {
        this.now = this.cairoConfiguration.getMicrosecondClock().getTicks();
    }

    @Override
    public long getNow() {
        return this.now;
    }

    public SqlExecutionContextImpl with(@NotNull CairoSecurityContext cairoSecurityContext, @Nullable BindVariableService bindVariableService, @Nullable Rnd rnd) {
        this.cairoSecurityContext = cairoSecurityContext;
        this.bindVariableService = bindVariableService;
        this.random = rnd;
        return this;
    }

    public SqlExecutionContextImpl with(long requestFd) {
        this.requestFd = requestFd;
        return this;
    }

    public SqlExecutionContextImpl with(@NotNull CairoSecurityContext cairoSecurityContext, @Nullable BindVariableService bindVariableService, @Nullable Rnd rnd, long requestFd, @Nullable SqlExecutionInterruptor interruptor) {
        this.cairoSecurityContext = cairoSecurityContext;
        this.bindVariableService = bindVariableService;
        this.random = rnd;
        this.requestFd = requestFd;
        this.interruptor = null == interruptor ? SqlExecutionInterruptor.NOP_INTERRUPTOR : interruptor;
        return this;
    }

    private void doStoreTelemetry(short event, short origin) {
        long cursor = this.telemetryPubSeq.next();
        while (cursor == -2L) {
            cursor = this.telemetryPubSeq.next();
        }
        if (cursor > -1L) {
            TelemetryTask row = this.telemetryQueue.get(cursor);
            row.created = this.clock.getTicks();
            row.event = event;
            row.origin = origin;
            this.telemetryPubSeq.done(cursor);
        }
    }

    private void storeTelemetryNoop(short event, short origin) {
    }

    @FunctionalInterface
    private static interface TelemetryMethod {
        public void store(short var1, short var2);
    }
}

