/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.TableUtils;
import io.questdb.griffin.CharacterStore;
import io.questdb.griffin.ExpressionParser;
import io.questdb.griffin.ExpressionParserListener;
import io.questdb.griffin.ExpressionTreeBuilder;
import io.questdb.griffin.PostOrderTreeTraversalAlgo;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlKeywords;
import io.questdb.griffin.SqlOptimiser;
import io.questdb.griffin.SqlUtil;
import io.questdb.griffin.model.AnalyticColumn;
import io.questdb.griffin.model.ColumnCastModel;
import io.questdb.griffin.model.CopyModel;
import io.questdb.griffin.model.CreateTableModel;
import io.questdb.griffin.model.ExecutionModel;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.InsertModel;
import io.questdb.griffin.model.QueryColumn;
import io.questdb.griffin.model.QueryModel;
import io.questdb.griffin.model.RenameTableModel;
import io.questdb.griffin.model.WithClauseModel;
import io.questdb.std.Chars;
import io.questdb.std.GenericLexer;
import io.questdb.std.LowerCaseAsciiCharSequenceHashSet;
import io.questdb.std.LowerCaseAsciiCharSequenceIntHashMap;
import io.questdb.std.LowerCaseCharSequenceObjHashMap;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectPool;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlParser {
    public static final int MAX_ORDER_BY_COLUMNS = 1560;
    private static final LowerCaseAsciiCharSequenceHashSet tableAliasStop = new LowerCaseAsciiCharSequenceHashSet();
    private static final LowerCaseAsciiCharSequenceHashSet columnAliasStop = new LowerCaseAsciiCharSequenceHashSet();
    private static final LowerCaseAsciiCharSequenceHashSet groupByStopSet = new LowerCaseAsciiCharSequenceHashSet();
    private static final LowerCaseAsciiCharSequenceIntHashMap joinStartSet = new LowerCaseAsciiCharSequenceIntHashMap();
    private static final LowerCaseAsciiCharSequenceHashSet setOperations = new LowerCaseAsciiCharSequenceHashSet();
    private final ObjectPool<ExpressionNode> expressionNodePool;
    private final ExpressionTreeBuilder expressionTreeBuilder;
    private final ObjectPool<QueryModel> queryModelPool;
    private final ObjectPool<QueryColumn> queryColumnPool;
    private final ObjectPool<AnalyticColumn> analyticColumnPool;
    private final ObjectPool<CreateTableModel> createTableModelPool;
    private final ObjectPool<ColumnCastModel> columnCastModelPool;
    private final ObjectPool<RenameTableModel> renameTableModelPool;
    private final ObjectPool<WithClauseModel> withClauseModelPool;
    private final ObjectPool<InsertModel> insertModelPool;
    private final ObjectPool<CopyModel> copyModelPool;
    private final ExpressionParser expressionParser;
    private final CairoConfiguration configuration;
    private final PostOrderTreeTraversalAlgo traversalAlgo;
    private final ObjList<ExpressionNode> tempExprNodes = new ObjList();
    private final CharacterStore characterStore;
    private final SqlOptimiser optimiser;
    private final PostOrderTreeTraversalAlgo.Visitor rewriteCase0Ref = this::rewriteCase0;
    private final PostOrderTreeTraversalAlgo.Visitor rewriteCount0Ref = this::rewriteCount0;
    private final PostOrderTreeTraversalAlgo.Visitor rewriteConcat0Ref = this::rewriteConcat0;
    private final PostOrderTreeTraversalAlgo.Visitor rewriteTypeQualifier0Ref = this::rewriteTypeQualifier0;
    private boolean subQueryMode = false;

    SqlParser(CairoConfiguration configuration, SqlOptimiser optimiser, CharacterStore characterStore, ObjectPool<ExpressionNode> expressionNodePool, ObjectPool<QueryColumn> queryColumnPool, ObjectPool<QueryModel> queryModelPool, PostOrderTreeTraversalAlgo traversalAlgo) {
        this.expressionNodePool = expressionNodePool;
        this.queryModelPool = queryModelPool;
        this.queryColumnPool = queryColumnPool;
        this.expressionTreeBuilder = new ExpressionTreeBuilder();
        this.analyticColumnPool = new ObjectPool<AnalyticColumn>(AnalyticColumn.FACTORY, configuration.getAnalyticColumnPoolCapacity());
        this.createTableModelPool = new ObjectPool<CreateTableModel>(CreateTableModel.FACTORY, configuration.getCreateTableModelPoolCapacity());
        this.columnCastModelPool = new ObjectPool<ColumnCastModel>(ColumnCastModel.FACTORY, configuration.getColumnCastModelPoolCapacity());
        this.renameTableModelPool = new ObjectPool<RenameTableModel>(RenameTableModel.FACTORY, configuration.getRenameTableModelPoolCapacity());
        this.withClauseModelPool = new ObjectPool<WithClauseModel>(WithClauseModel.FACTORY, configuration.getWithClauseModelPoolCapacity());
        this.insertModelPool = new ObjectPool<InsertModel>(InsertModel.FACTORY, configuration.getInsertPoolCapacity());
        this.copyModelPool = new ObjectPool<CopyModel>(CopyModel.FACTORY, configuration.getCopyPoolCapacity());
        this.configuration = configuration;
        this.traversalAlgo = traversalAlgo;
        this.characterStore = characterStore;
        this.optimiser = optimiser;
        this.expressionParser = new ExpressionParser(expressionNodePool, this, characterStore);
    }

    private static SqlException err(GenericLexer lexer, String msg) {
        return SqlException.$(lexer.lastTokenPosition(), msg);
    }

    private static SqlException errUnexpected(GenericLexer lexer, CharSequence token) {
        return SqlException.unexpectedToken(lexer.lastTokenPosition(), token);
    }

    private void addConcatArgs(ObjList<ExpressionNode> args, ExpressionNode leaf) {
        if (leaf.type != 8 || !SqlKeywords.isConcatFunction(leaf.token)) {
            args.add(leaf);
            return;
        }
        if (leaf.args.size() > 0) {
            args.addAll(leaf.args);
        } else {
            args.add(leaf.rhs);
            args.add(leaf.lhs);
        }
    }

    private void assertNotDot(GenericLexer lexer, CharSequence tok) throws SqlException {
        if (Chars.indexOf(tok, '.') != -1) {
            throw SqlException.$(lexer.lastTokenPosition(), "'.' is not allowed here");
        }
    }

    void clear() {
        this.queryModelPool.clear();
        this.queryColumnPool.clear();
        this.expressionNodePool.clear();
        this.analyticColumnPool.clear();
        this.createTableModelPool.clear();
        this.columnCastModelPool.clear();
        this.renameTableModelPool.clear();
        this.withClauseModelPool.clear();
        this.subQueryMode = false;
        this.characterStore.clear();
        this.insertModelPool.clear();
        this.expressionTreeBuilder.reset();
        this.copyModelPool.clear();
    }

    private CharSequence createColumnAlias(ExpressionNode node, QueryModel model) {
        return SqlUtil.createColumnAlias(this.characterStore, GenericLexer.unquote(node.token), Chars.indexOf(node.token, '.'), model.getAliasToColumnMap());
    }

    private void expectBy(GenericLexer lexer) throws SqlException {
        if (SqlKeywords.isByKeyword(this.tok(lexer, "by"))) {
            return;
        }
        throw SqlException.$(lexer.getPosition(), "'by' expected");
    }

    private ExpressionNode expectExpr(GenericLexer lexer) throws SqlException {
        ExpressionNode n = this.expr(lexer, (QueryModel)null);
        if (n != null) {
            return n;
        }
        throw SqlException.$(lexer.getUnparsed() == null ? lexer.getPosition() : lexer.lastTokenPosition(), "Expression expected");
    }

    private int expectInt(GenericLexer lexer) throws SqlException {
        boolean negative;
        CharSequence tok = this.tok(lexer, "integer");
        if (Chars.equals(tok, '-')) {
            negative = true;
            tok = this.tok(lexer, "integer");
        } else {
            negative = false;
        }
        try {
            int result = Numbers.parseInt(tok);
            return negative ? -result : result;
        }
        catch (NumericException e) {
            throw SqlParser.err(lexer, "bad integer");
        }
    }

    private long expectLong(GenericLexer lexer) throws SqlException {
        boolean negative;
        CharSequence tok = this.tok(lexer, "long integer");
        if (Chars.equals(tok, '-')) {
            negative = true;
            tok = this.tok(lexer, "long integer");
        } else {
            negative = false;
        }
        try {
            long result = Numbers.parseLong(tok);
            return negative ? -result : result;
        }
        catch (NumericException e) {
            throw SqlParser.err(lexer, "bad long integer");
        }
    }

    private ExpressionNode expectLiteral(GenericLexer lexer) throws SqlException {
        CharSequence tok = this.tok(lexer, "literal");
        int pos = lexer.lastTokenPosition();
        this.validateLiteral(pos, tok);
        return this.nextLiteral(GenericLexer.immutableOf(GenericLexer.unquote(tok)), pos);
    }

    private CharSequence expectTableNameOrSubQuery(GenericLexer lexer) throws SqlException {
        return this.tok(lexer, "table name or sub-query");
    }

    private void expectTok(GenericLexer lexer, CharSequence tok, CharSequence expected) throws SqlException {
        if (tok == null || !Chars.equalsLowerCaseAscii(tok, expected)) {
            throw SqlException.position(lexer.lastTokenPosition()).put('\'').put(expected).put("' expected");
        }
    }

    private void expectTok(GenericLexer lexer, CharSequence expected) throws SqlException {
        CharSequence tok = this.optTok(lexer);
        if (tok == null) {
            throw SqlException.position(lexer.getPosition()).put('\'').put(expected).put("' expected");
        }
        this.expectTok(lexer, tok, expected);
    }

    private void expectTok(GenericLexer lexer, char expected) throws SqlException {
        CharSequence tok = this.optTok(lexer);
        if (tok == null) {
            throw SqlException.position(lexer.getPosition()).put('\'').put(expected).put("' expected");
        }
        this.expectTok(tok, lexer.lastTokenPosition(), expected);
    }

    private void expectTok(CharSequence tok, int pos, char expected) throws SqlException {
        if (tok == null || !Chars.equals(tok, expected)) {
            throw SqlException.position(pos).put('\'').put(expected).put("' expected");
        }
    }

    ExpressionNode expr(GenericLexer lexer, QueryModel model) throws SqlException {
        try {
            this.expressionTreeBuilder.pushModel(model);
            this.expressionParser.parseExpr(lexer, this.expressionTreeBuilder);
            ExpressionNode expressionNode = this.rewriteKnownStatements(this.expressionTreeBuilder.poll());
            return expressionNode;
        }
        catch (SqlException e) {
            this.expressionTreeBuilder.reset();
            throw e;
        }
        finally {
            this.expressionTreeBuilder.popModel();
        }
    }

    void expr(GenericLexer lexer, ExpressionParserListener listener) throws SqlException {
        this.expressionParser.parseExpr(lexer, listener);
    }

    private int getCreateTableColumnIndex(CreateTableModel model, CharSequence columnName, int position) throws SqlException {
        int index = model.getColumnIndex(columnName);
        if (index == -1) {
            throw SqlException.invalidColumn(position, columnName);
        }
        return index;
    }

    private boolean isFieldTerm(CharSequence tok) {
        return Chars.equals(tok, ')') || Chars.equals(tok, ',');
    }

    private ExpressionNode literal(GenericLexer lexer, CharSequence name) {
        return this.literal(name, lexer.lastTokenPosition());
    }

    private ExpressionNode literal(CharSequence name, int position) {
        return this.expressionNodePool.next().of(4, GenericLexer.unquote(name), 0, position);
    }

    private ExpressionNode nextLiteral(CharSequence token, int position) {
        return SqlUtil.nextLiteral(this.expressionNodePool, token, position);
    }

    private CharSequence notTermTok(GenericLexer lexer) throws SqlException {
        CharSequence tok = this.tok(lexer, "')' or ','");
        if (this.isFieldTerm(tok)) {
            throw SqlParser.err(lexer, "missing column definition");
        }
        return tok;
    }

    private CharSequence optTok(GenericLexer lexer) {
        CharSequence tok = SqlUtil.fetchNext(lexer);
        if (tok == null || this.subQueryMode && Chars.equals(tok, ')')) {
            return null;
        }
        return tok;
    }

    ExecutionModel parse(GenericLexer lexer, SqlExecutionContext executionContext) throws SqlException {
        CharSequence tok = this.tok(lexer, "'create', 'rename' or 'select'");
        if (SqlKeywords.isSelectKeyword(tok)) {
            return this.parseSelect(lexer);
        }
        if (SqlKeywords.isCreateKeyword(tok)) {
            return this.parseCreateStatement(lexer, executionContext);
        }
        if (SqlKeywords.isRenameKeyword(tok)) {
            return this.parseRenameStatement(lexer);
        }
        if (SqlKeywords.isInsertKeyword(tok)) {
            return this.parseInsert(lexer);
        }
        if (SqlKeywords.isCopyKeyword(tok)) {
            return this.parseCopy(lexer);
        }
        return this.parseSelect(lexer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    QueryModel parseAsSubQuery(GenericLexer lexer, @Nullable LowerCaseCharSequenceObjHashMap<WithClauseModel> withClauses) throws SqlException {
        QueryModel model;
        this.subQueryMode = true;
        try {
            model = this.parseDml(lexer, withClauses);
        }
        finally {
            this.subQueryMode = false;
        }
        return model;
    }

    private QueryModel parseAsSubQueryAndExpectClosingBrace(GenericLexer lexer, LowerCaseCharSequenceObjHashMap<WithClauseModel> withClauses) throws SqlException {
        QueryModel model = this.parseAsSubQuery(lexer, withClauses);
        this.expectTok(lexer, ')');
        return model;
    }

    private ExecutionModel parseCopy(GenericLexer lexer) throws SqlException {
        if (this.configuration.getInputRoot() == null) {
            throw SqlException.$(lexer.lastTokenPosition(), "COPY is disabled ['cairo.sql.copy.root' is not set?]");
        }
        ExpressionNode tableName = this.expectExpr(lexer);
        CharSequence tok = this.tok(lexer, "'from' or 'to'");
        if (SqlKeywords.isFromKeyword(tok)) {
            ExpressionNode fileName = this.expectExpr(lexer);
            if (fileName.token.length() < 3 && Chars.startsWith(fileName.token, '\'')) {
                throw SqlException.$(fileName.position, "file name expected");
            }
            CopyModel model = this.copyModelPool.next();
            model.setTableName(tableName);
            model.setFileName(fileName);
            tok = this.optTok(lexer);
            if (tok != null && SqlKeywords.isWithKeyword(tok)) {
                tok = this.tok(lexer, "copy option");
                while (tok != null) {
                    if (SqlKeywords.isHeaderKeyword(tok)) {
                        model.setHeader(SqlKeywords.isTrueKeyword(this.tok(lexer, "'true' or 'false'")));
                        tok = this.optTok(lexer);
                        continue;
                    }
                    throw SqlException.$(lexer.lastTokenPosition(), "unexpected option");
                }
            }
            return model;
        }
        throw SqlException.$(lexer.lastTokenPosition(), "'from' expected");
    }

    private ExecutionModel parseCreateStatement(GenericLexer lexer, SqlExecutionContext executionContext) throws SqlException {
        this.expectTok(lexer, "table");
        return this.parseCreateTable(lexer, executionContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ExecutionModel parseCreateTable(GenericLexer lexer, SqlExecutionContext executionContext) throws SqlException {
        CharSequence tableName;
        CreateTableModel model = this.createTableModelPool.next();
        CharSequence tok = this.tok(lexer, "table name or 'if'");
        if (SqlKeywords.isIfKeyword(tok)) {
            if (!SqlKeywords.isNotKeyword(this.tok(lexer, "'not'")) || !SqlKeywords.isExistsKeyword(this.tok(lexer, "'exists'"))) throw SqlException.$(lexer.lastTokenPosition(), "'if not exists' expected");
            model.setIgnoreIfExists(true);
            tableName = this.tok(lexer, "table name");
        } else {
            tableName = tok;
        }
        model.setName(this.nextLiteral(GenericLexer.assertNoDotsAndSlashes(GenericLexer.unquote(tableName), lexer.lastTokenPosition()), lexer.lastTokenPosition()));
        tok = this.tok(lexer, "'(' or 'as'");
        if (Chars.equals(tok, '(')) {
            lexer.unparse();
            this.parseCreateTableColumns(lexer, model);
        } else {
            if (!SqlKeywords.isAsKeyword(tok)) throw SqlParser.errUnexpected(lexer, tok);
            this.parseCreateTableAsSelect(lexer, model, executionContext);
        }
        while ((tok = this.optTok(lexer)) != null && Chars.equals(tok, ',')) {
            tok = this.tok(lexer, "'index' or 'cast'");
            if (SqlKeywords.isIndexKeyword(tok)) {
                this.parseCreateTableIndexDef(lexer, model);
                continue;
            }
            if (!SqlKeywords.isCastKeyword(tok)) throw SqlParser.errUnexpected(lexer, tok);
            this.parseCreateTableCastDef(lexer, model);
        }
        ExpressionNode timestamp = this.parseTimestamp(lexer, tok);
        if (timestamp != null) {
            this.getCreateTableColumnIndex(model, timestamp.token, timestamp.position);
            model.setTimestamp(timestamp);
            tok = this.optTok(lexer);
        }
        int o3MaxUncommittedRows = this.configuration.getO3MaxUncommittedRows();
        long o3CommitHysteresisInMicros = this.configuration.getO3CommitHysteresis();
        ExpressionNode partitionBy = this.parseCreateTablePartition(lexer, tok);
        if (partitionBy != null) {
            if (PartitionBy.fromString(partitionBy.token) == -1) {
                throw SqlException.$(partitionBy.position, "'NONE', 'DAY', 'MONTH' or 'YEAR' expected");
            }
            model.setPartitionBy(partitionBy);
            tok = this.optTok(lexer);
            if (tok != null && SqlKeywords.isWithKeyword(tok)) {
                ExpressionNode expr;
                while ((expr = this.expr(lexer, (QueryModel)null)) != null) {
                    if (!Chars.equals(expr.token, '=')) throw SqlException.position(lexer.getPosition()).put(" expected parameter after WITH");
                    if (SqlKeywords.isO3MaxUncommittedRowsParam(expr.lhs.token)) {
                        try {
                            o3MaxUncommittedRows = Numbers.parseInt(expr.rhs.token);
                        }
                        catch (NumericException e) {
                            throw SqlException.position(lexer.getPosition()).put(" could not parse o3MaxUncommittedRows value \"").put(expr.rhs.token).put('\"');
                        }
                    } else {
                        if (!SqlKeywords.isO3CommitHysteresis(expr.lhs.token)) throw SqlException.position(lexer.getPosition()).put(" unrecognized ").put(expr.lhs.token).put(" after WITH");
                        o3CommitHysteresisInMicros = SqlUtil.expectMicros(expr.rhs.token, lexer.getPosition());
                    }
                    tok = this.optTok(lexer);
                    if (null == tok || !Chars.equals(tok, ',')) break;
                }
            }
        }
        model.setO3MaxUncommittedRows(o3MaxUncommittedRows);
        model.setO3CommitHysteresisInMicros(o3CommitHysteresisInMicros);
        if (tok != null && !Chars.equals(tok, ';')) throw SqlParser.errUnexpected(lexer, tok);
        return model;
    }

    private void parseCreateTableAsSelect(GenericLexer lexer, CreateTableModel model, SqlExecutionContext executionContext) throws SqlException {
        this.expectTok(lexer, '(');
        QueryModel queryModel = this.optimiser.optimise(this.parseDml(lexer, null), executionContext);
        ObjList<QueryColumn> columns = queryModel.getBottomUpColumns();
        assert (columns.size() > 0);
        int n = columns.size();
        for (int i = 0; i < n; ++i) {
            model.addColumn(columns.getQuick(i).getName(), -1, this.configuration.getDefaultSymbolCapacity());
        }
        model.setQueryModel(queryModel);
        this.expectTok(lexer, ')');
    }

    private void parseCreateTableCastDef(GenericLexer lexer, CreateTableModel model) throws SqlException {
        if (model.getQueryModel() == null) {
            throw SqlException.$(lexer.lastTokenPosition(), "cast is only supported in 'create table as ...' context");
        }
        this.expectTok(lexer, '(');
        ColumnCastModel columnCastModel = this.columnCastModelPool.next();
        ExpressionNode columnName = this.expectLiteral(lexer);
        columnCastModel.setName(columnName);
        this.expectTok(lexer, "as");
        ExpressionNode columnType = this.expectLiteral(lexer);
        int type = this.toColumnType(lexer, columnType.token);
        columnCastModel.setType(type, columnName.position, columnType.position);
        if (type == 11) {
            boolean cached;
            int symbolCapacity;
            int capacityPosition;
            CharSequence tok = this.tok(lexer, "'capacity', 'nocache', 'cache', 'index' or ')'");
            if (SqlKeywords.isCapacityKeyword(tok)) {
                capacityPosition = lexer.getPosition();
                symbolCapacity = this.parseSymbolCapacity(lexer);
                columnCastModel.setSymbolCapacity(symbolCapacity);
                tok = this.tok(lexer, "'nocache', 'cache', 'index' or ')'");
            } else {
                columnCastModel.setSymbolCapacity(this.configuration.getDefaultSymbolCapacity());
                symbolCapacity = -1;
                capacityPosition = -1;
            }
            if (SqlKeywords.isNoCacheKeyword(tok)) {
                cached = false;
            } else if (SqlKeywords.isCacheKeyword(tok)) {
                cached = true;
            } else {
                cached = this.configuration.getDefaultSymbolCacheFlag();
                lexer.unparse();
            }
            columnCastModel.setSymbolCacheFlag(cached);
            if (cached && symbolCapacity != -1) {
                assert (capacityPosition != -1);
                TableUtils.validateSymbolCapacityCached(true, symbolCapacity, capacityPosition);
            }
            if (SqlKeywords.isIndexKeyword(tok = this.tok(lexer, "')', or 'index'"))) {
                columnCastModel.setIndexed(true);
                tok = this.tok(lexer, "')', or 'capacity'");
                if (SqlKeywords.isCapacityKeyword(tok)) {
                    int errorPosition = lexer.getPosition();
                    int indexValueBlockSize = this.expectInt(lexer);
                    TableUtils.validateIndexValueBlockSize(errorPosition, indexValueBlockSize);
                    columnCastModel.setIndexValueBlockSize(Numbers.ceilPow2(indexValueBlockSize));
                } else {
                    columnCastModel.setIndexValueBlockSize(this.configuration.getIndexValueBlockSize());
                }
            } else {
                columnCastModel.setIndexed(false);
                lexer.unparse();
            }
        }
        this.expectTok(lexer, ')');
        if (!model.addColumnCastModel(columnCastModel)) {
            throw SqlException.$(columnCastModel.getName().position, "duplicate cast");
        }
    }

    private void parseCreateTableColumns(GenericLexer lexer, CreateTableModel model) throws SqlException {
        block16: {
            CharSequence tok;
            this.expectTok(lexer, '(');
            do {
                int position = lexer.lastTokenPosition();
                CharSequence name = GenericLexer.immutableOf(GenericLexer.unquote(this.notTermTok(lexer)));
                int type = this.toColumnType(lexer, this.notTermTok(lexer));
                if (!TableUtils.isValidColumnName(name)) {
                    throw SqlException.$(position, " new column name contains invalid characters");
                }
                if (!model.addColumn(name, type, this.configuration.getDefaultSymbolCapacity())) {
                    throw SqlException.$(position, "Duplicate column");
                }
                if (type == 11) {
                    boolean cached;
                    int symbolCapacity;
                    tok = this.tok(lexer, "'capacity', 'nocache', 'cache', 'index' or ')'");
                    if (SqlKeywords.isCapacityKeyword(tok)) {
                        symbolCapacity = this.parseSymbolCapacity(lexer);
                        model.symbolCapacity(symbolCapacity);
                        tok = this.tok(lexer, "'nocache', 'cache', 'index' or ')'");
                    } else {
                        symbolCapacity = -1;
                    }
                    if (SqlKeywords.isNoCacheKeyword(tok)) {
                        cached = false;
                    } else if (SqlKeywords.isCacheKeyword(tok)) {
                        cached = true;
                    } else {
                        cached = this.configuration.getDefaultSymbolCacheFlag();
                        lexer.unparse();
                    }
                    model.cached(cached);
                    if (cached && symbolCapacity != -1) {
                        TableUtils.validateSymbolCapacityCached(true, symbolCapacity, lexer.lastTokenPosition());
                    }
                    tok = this.parseCreateTableInlineIndexDef(lexer, model);
                } else {
                    tok = null;
                }
                if (tok == null) {
                    tok = this.tok(lexer, "',' or ')'");
                }
                if (SqlKeywords.isPrecisionKeyword(tok)) {
                    tok = this.tok(lexer, "'NOT' or 'NULL' or ',' or ')'");
                }
                if (SqlKeywords.isNotKeyword(tok)) {
                    tok = this.tok(lexer, "'NULL'");
                }
                if (SqlKeywords.isNullKeyword(tok)) {
                    tok = this.tok(lexer, "','");
                }
                if (Chars.equals(tok, ')')) break block16;
            } while (Chars.equals(tok, ','));
            throw SqlParser.err(lexer, "',' or ')' expected");
        }
    }

    private void parseCreateTableIndexDef(GenericLexer lexer, CreateTableModel model) throws SqlException {
        this.expectTok(lexer, '(');
        int columnIndex = this.getCreateTableColumnIndex(model, this.expectLiteral((GenericLexer)lexer).token, lexer.lastTokenPosition());
        if (SqlKeywords.isCapacityKeyword(this.tok(lexer, "'capacity'"))) {
            int errorPosition = lexer.getPosition();
            int indexValueBlockSize = this.expectInt(lexer);
            TableUtils.validateIndexValueBlockSize(errorPosition, indexValueBlockSize);
            model.setIndexFlags(columnIndex, true, Numbers.ceilPow2(indexValueBlockSize));
        } else {
            model.setIndexFlags(columnIndex, true, this.configuration.getIndexValueBlockSize());
            lexer.unparse();
        }
        this.expectTok(lexer, ')');
    }

    private CharSequence parseCreateTableInlineIndexDef(GenericLexer lexer, CreateTableModel model) throws SqlException {
        CharSequence tok = this.tok(lexer, "')', or 'index'");
        if (this.isFieldTerm(tok)) {
            model.setIndexFlags(false, this.configuration.getIndexValueBlockSize());
            return tok;
        }
        this.expectTok(lexer, tok, "index");
        tok = this.tok(lexer, ") | , expected");
        if (this.isFieldTerm(tok)) {
            model.setIndexFlags(true, this.configuration.getIndexValueBlockSize());
            return tok;
        }
        this.expectTok(lexer, tok, "capacity");
        int errorPosition = lexer.getPosition();
        int indexValueBlockSize = this.expectInt(lexer);
        TableUtils.validateIndexValueBlockSize(errorPosition, indexValueBlockSize);
        model.setIndexFlags(true, Numbers.ceilPow2(indexValueBlockSize));
        return null;
    }

    private ExpressionNode parseCreateTablePartition(GenericLexer lexer, CharSequence tok) throws SqlException {
        if (tok != null && SqlKeywords.isPartitionKeyword(tok)) {
            this.expectTok(lexer, "by");
            return this.expectLiteral(lexer);
        }
        return null;
    }

    private QueryModel parseDml(GenericLexer lexer, @Nullable LowerCaseCharSequenceObjHashMap<WithClauseModel> withClauses) throws SqlException {
        QueryModel model = null;
        QueryModel prevModel = null;
        while (true) {
            QueryModel unionModel = this.parseDml0(lexer, prevModel != null ? prevModel.getWithClauses() : withClauses);
            if (prevModel == null) {
                prevModel = model = unionModel;
            } else {
                prevModel.setUnionModel(unionModel);
                prevModel = unionModel;
            }
            CharSequence tok = this.optTok(lexer);
            if (tok == null || setOperations.excludes(tok)) {
                lexer.unparse();
                return model;
            }
            if (SqlKeywords.isUnionKeyword(tok)) {
                tok = this.tok(lexer, "all or select");
                if (SqlKeywords.isAllKeyword(tok)) {
                    if (!model.isDistinct()) {
                        prevModel.setSetOperationType(0);
                    } else {
                        prevModel.setSetOperationType(1);
                    }
                } else {
                    prevModel.setSetOperationType(1);
                    lexer.unparse();
                }
            }
            if (SqlKeywords.isExceptKeyword(tok)) {
                prevModel.setSetOperationType(2);
            }
            if (!SqlKeywords.isIntersectKeyword(tok)) continue;
            prevModel.setSetOperationType(3);
        }
    }

    @NotNull
    private QueryModel parseDml0(GenericLexer lexer, @Nullable LowerCaseCharSequenceObjHashMap<WithClauseModel> parentWithClauses) throws SqlException {
        CharSequence tok;
        int modelPosition = lexer.getPosition();
        QueryModel model = this.queryModelPool.next();
        model.setModelPosition(modelPosition);
        if (parentWithClauses != null) {
            model.addWithClauses(parentWithClauses);
        }
        if (SqlKeywords.isWithKeyword(tok = this.tok(lexer, "'select', 'with' or table name expected"))) {
            this.parseWithClauses(lexer, model);
            tok = this.tok(lexer, "'select' or table name expected");
        }
        if (SqlKeywords.isSelectKeyword(tok)) {
            this.parseSelectClause(lexer, model);
            tok = this.optTok(lexer);
            if (tok != null && setOperations.contains(tok)) {
                tok = null;
            }
            if (tok == null) {
                QueryModel nestedModel = this.queryModelPool.next();
                nestedModel.setModelPosition(modelPosition);
                ExpressionNode func = this.expressionNodePool.next().of(8, "long_sequence", 0, lexer.lastTokenPosition());
                func.paramCount = 1;
                func.rhs = this.expressionNodePool.next().of(2, "1", 0, 0);
                nestedModel.setTableName(func);
                model.setSelectModelType(2);
                model.setNestedModel(nestedModel);
                lexer.unparse();
                return model;
            }
        } else {
            lexer.unparse();
            model.addBottomUpColumn(SqlUtil.nextColumn(this.queryColumnPool, this.expressionNodePool, "*", "*"));
        }
        QueryModel nestedModel = this.queryModelPool.next();
        nestedModel.setModelPosition(modelPosition);
        this.parseFromClause(lexer, nestedModel, model);
        if (nestedModel.getLimitHi() != null || nestedModel.getLimitLo() != null) {
            model.setLimit(nestedModel.getLimitLo(), nestedModel.getLimitHi());
            nestedModel.setLimit(null, null);
        }
        model.setSelectModelType(1);
        model.setNestedModel(nestedModel);
        ExpressionNode n = nestedModel.getAlias();
        if (n != null) {
            model.setAlias(n);
        }
        return model;
    }

    private void parseFromClause(GenericLexer lexer, QueryModel model, QueryModel masterModel) throws SqlException {
        ExpressionNode n;
        int joinType;
        CharSequence tok = this.expectTableNameOrSubQuery(lexer);
        if (Chars.equals(tok, '(')) {
            model.setNestedModel(this.parseAsSubQueryAndExpectClosingBrace(lexer, masterModel.getWithClauses()));
            model.setNestedModelIsSubQuery(true);
            tok = this.setModelAliasAndTimestamp(lexer, model);
        } else {
            lexer.unparse();
            this.parseSelectFrom(lexer, model, masterModel);
            tok = this.setModelAliasAndTimestamp(lexer, model);
            if (tok != null && SqlKeywords.isLatestKeyword(tok)) {
                this.parseLatestBy(lexer, model);
                tok = this.optTok(lexer);
            }
        }
        while (tok != null && (joinType = joinStartSet.get(tok)) != -1) {
            model.addJoinModel(this.parseJoin(lexer, tok, joinType, masterModel));
            tok = this.optTok(lexer);
        }
        if (tok != null && SqlKeywords.isWhereKeyword(tok)) {
            ExpressionNode expr = this.expr(lexer, model);
            if (expr != null) {
                model.setWhereClause(expr);
                tok = this.optTok(lexer);
            } else {
                throw SqlException.$(lexer.lastTokenPosition(), "empty where clause");
            }
        }
        if (tok != null && SqlKeywords.isSampleKeyword(tok)) {
            this.expectBy(lexer);
            model.setSampleBy(this.expectLiteral(lexer));
            tok = this.optTok(lexer);
            if (tok != null && SqlKeywords.isFillKeyword(tok)) {
                this.expectTok(lexer, '(');
                while (true) {
                    ExpressionNode fillNode;
                    if ((fillNode = this.expr(lexer, model)) == null) {
                        throw SqlException.$(lexer.lastTokenPosition(), "'none', 'prev', 'mid', 'null' or number expected");
                    }
                    model.addSampleByFill(fillNode);
                    tok = this.tokIncludingLocalBrace(lexer, "',' or ')'");
                    if (Chars.equals(tok, ')')) break;
                    this.expectTok(tok, lexer.lastTokenPosition(), ',');
                }
                tok = this.optTok(lexer);
            }
        }
        if (tok != null && SqlKeywords.isGroupKeyword(tok)) {
            this.expectBy(lexer);
            do {
                this.tokIncludingLocalBrace(lexer, "literal");
                lexer.unparse();
                n = this.expr(lexer, model);
                if (n == null || n.type != 4 && n.type != 2 && n.type != 8 && n.type != 1) {
                    throw SqlException.$(n == null ? lexer.lastTokenPosition() : n.position, "literal expected");
                }
                model.addGroupBy(n);
            } while ((tok = this.optTok(lexer)) != null && Chars.equals(tok, ','));
        }
        if (tok != null && SqlKeywords.isOrderKeyword(tok)) {
            this.expectBy(lexer);
            do {
                this.tokIncludingLocalBrace(lexer, "literal");
                lexer.unparse();
                n = this.expr(lexer, model);
                if (n == null || n.type != 4 && n.type != 2) {
                    throw SqlException.$(n == null ? lexer.lastTokenPosition() : n.position, "literal expected");
                }
                tok = this.optTok(lexer);
                if (tok != null && SqlKeywords.isDescKeyword(tok)) {
                    model.addOrderBy(n, 1);
                    tok = this.optTok(lexer);
                } else {
                    model.addOrderBy(n, 0);
                    if (tok != null && SqlKeywords.isAscKeyword(tok)) {
                        tok = this.optTok(lexer);
                    }
                }
                if (model.getOrderBy().size() < 1560) continue;
                throw SqlParser.err(lexer, "Too many columns");
            } while (tok != null && Chars.equals(tok, ','));
        }
        if (tok != null && SqlKeywords.isLimitKeyword(tok)) {
            ExpressionNode lo = this.expr(lexer, model);
            ExpressionNode hi = null;
            tok = this.optTok(lexer);
            if (tok != null && Chars.equals(tok, ',')) {
                hi = this.expr(lexer, model);
            } else {
                lexer.unparse();
            }
            model.setLimit(lo, hi);
        } else {
            lexer.unparse();
        }
    }

    private CharSequence setModelAliasAndTimestamp(GenericLexer lexer, QueryModel model) throws SqlException {
        CharSequence tok = this.setModelAliasAndGetOptTok(lexer, model);
        ExpressionNode timestamp = this.parseTimestamp(lexer, tok);
        if (timestamp != null) {
            model.setTimestamp(timestamp);
            tok = this.optTok(lexer);
        }
        return tok;
    }

    private ExecutionModel parseInsert(GenericLexer lexer) throws SqlException {
        InsertModel model = this.insertModelPool.next();
        CharSequence tok = this.tok(lexer, "into or batch");
        if (SqlKeywords.isBatch(tok)) {
            long val = this.expectLong(lexer);
            if (val <= 0L) {
                throw SqlException.$(lexer.lastTokenPosition(), "batch size must be positive integer");
            }
            model.setBatchSize(val);
            tok = this.tok(lexer, "into or hysteresis");
            if (SqlKeywords.isHysteresis(tok)) {
                val = this.expectLong(lexer);
                if (val <= 0L) {
                    throw SqlException.$(lexer.lastTokenPosition(), "hysteresis must be a positive integer microseconds");
                }
                model.setHysteresis(val);
                this.expectTok(lexer, "into");
            }
        }
        if (!SqlKeywords.isInto(tok)) {
            throw SqlException.$(lexer.lastTokenPosition(), "'into' expected");
        }
        model.setTableName(this.expectLiteral(lexer));
        tok = this.tok(lexer, "'(' or 'select'");
        if (Chars.equals(tok, '(')) {
            do {
                if (Chars.equals(tok = this.tok(lexer, "column"), ')')) {
                    throw SqlParser.err(lexer, "missing column name");
                }
                if (model.addColumn(GenericLexer.immutableOf(GenericLexer.unquote(tok)), lexer.lastTokenPosition())) continue;
                throw SqlException.position(lexer.lastTokenPosition()).put("duplicate column name: ").put(tok);
            } while (Chars.equals(tok = this.tok(lexer, "','"), ','));
            this.expectTok(tok, lexer.lastTokenPosition(), ')');
            tok = this.optTok(lexer);
        }
        if (tok == null) {
            throw SqlException.$(lexer.getPosition(), "'select' or 'values' expected");
        }
        if (SqlKeywords.isSelectKeyword(tok)) {
            model.setSelectKeywordPosition(lexer.lastTokenPosition());
            lexer.unparse();
            QueryModel queryModel = this.parseDml(lexer, null);
            model.setQueryModel(queryModel);
            return model;
        }
        if (SqlKeywords.isValuesKeyword(tok)) {
            this.expectTok(lexer, '(');
            do {
                ExpressionNode expr = this.expectExpr(lexer);
                if (Chars.equals(expr.token, ')')) {
                    throw SqlParser.err(lexer, "missing column value");
                }
                model.addColumnValue(expr);
            } while (Chars.equals(tok = this.tok(lexer, "','"), ','));
            this.expectTok(tok, lexer.lastTokenPosition(), ')');
            model.setEndOfValuesPosition(lexer.lastTokenPosition());
            return model;
        }
        throw SqlParser.err(lexer, "'select' or 'values' expected");
    }

    private QueryModel parseJoin(GenericLexer lexer, CharSequence tok, int joinType, QueryModel parent) throws SqlException {
        QueryModel joinModel = this.queryModelPool.next();
        int errorPos = lexer.lastTokenPosition();
        if (SqlKeywords.isNotJoinKeyword(tok) && !Chars.equals(tok, ',')) {
            if (SqlKeywords.isLeftKeyword(tok)) {
                tok = this.tok(lexer, "join");
                joinType = 2;
                if (SqlKeywords.isOuterKeyword(tok)) {
                    tok = this.tok(lexer, "join");
                }
            } else {
                tok = this.tok(lexer, "join");
            }
            if (SqlKeywords.isNotJoinKeyword(tok)) {
                throw SqlException.position(errorPos).put("'join' expected");
            }
        }
        joinModel.setJoinType(joinType);
        joinModel.setJoinKeywordPosition(errorPos);
        tok = this.expectTableNameOrSubQuery(lexer);
        if (Chars.equals(tok, '(')) {
            joinModel.setNestedModel(this.parseAsSubQueryAndExpectClosingBrace(lexer, parent.getWithClauses()));
        } else {
            lexer.unparse();
            this.parseSelectFrom(lexer, joinModel, parent);
        }
        tok = this.setModelAliasAndGetOptTok(lexer, joinModel);
        if (joinType == 3 && tok != null && SqlKeywords.isOnKeyword(tok)) {
            throw SqlException.$(lexer.lastTokenPosition(), "Cross joins cannot have join clauses");
        }
        block1 : switch (joinType) {
            case 4: 
            case 5: 
            case 6: {
                if (tok == null || !SqlKeywords.isOnKeyword(tok)) {
                    lexer.unparse();
                    break;
                }
            }
            case 1: 
            case 2: {
                this.expectTok(lexer, tok, "on");
                try {
                    this.expressionParser.parseExpr(lexer, this.expressionTreeBuilder);
                    switch (this.expressionTreeBuilder.size()) {
                        case 0: {
                            throw SqlException.$(lexer.lastTokenPosition(), "Expression expected");
                        }
                        case 1: {
                            ExpressionNode expr = this.expressionTreeBuilder.poll();
                            if (expr.type == 4) {
                                do {
                                    joinModel.addJoinColumn(expr);
                                } while ((expr = this.expressionTreeBuilder.poll()) != null);
                                break;
                            }
                            joinModel.setJoinCriteria(this.rewriteKnownStatements(expr));
                            break;
                        }
                        default: {
                            ExpressionNode expr;
                            while ((expr = this.expressionTreeBuilder.poll()) != null) {
                                if (expr.type != 4) {
                                    throw SqlException.$(lexer.lastTokenPosition(), "Column name expected");
                                }
                                joinModel.addJoinColumn(expr);
                            }
                            break block1;
                        }
                    }
                    break;
                }
                catch (SqlException e) {
                    this.expressionTreeBuilder.reset();
                    throw e;
                }
            }
            default: {
                lexer.unparse();
            }
        }
        return joinModel;
    }

    private CharSequence setModelAliasAndGetOptTok(GenericLexer lexer, QueryModel joinModel) throws SqlException {
        CharSequence tok = this.optTok(lexer);
        if (tok != null && tableAliasStop.excludes(tok)) {
            if (SqlKeywords.isAsKeyword(tok)) {
                tok = this.tok(lexer, "alias");
            }
            joinModel.setAlias(this.literal(lexer, tok));
            tok = this.optTok(lexer);
        }
        return tok;
    }

    private void parseLatestBy(GenericLexer lexer, QueryModel model) throws SqlException {
        CharSequence tok;
        this.expectBy(lexer);
        do {
            model.addLatestBy(this.expectLiteral(lexer));
        } while (Chars.equalsNc(tok = SqlUtil.fetchNext(lexer), ','));
        if (tok != null) {
            lexer.unparse();
        }
    }

    private ExecutionModel parseRenameStatement(GenericLexer lexer) throws SqlException {
        this.expectTok(lexer, "table");
        RenameTableModel model = this.renameTableModelPool.next();
        ExpressionNode e = this.expectExpr(lexer);
        if (e.type != 4 && e.type != 2) {
            throw SqlException.$(e.position, "literal or constant expected");
        }
        model.setFrom(e);
        this.expectTok(lexer, "to");
        e = this.expectExpr(lexer);
        if (e.type != 4 && e.type != 2) {
            throw SqlException.$(e.position, "literal or constant expected");
        }
        model.setTo(e);
        return model;
    }

    private ExecutionModel parseSelect(GenericLexer lexer) throws SqlException {
        lexer.unparse();
        QueryModel model = this.parseDml(lexer, null);
        CharSequence tok = this.optTok(lexer);
        if (tok == null || Chars.equals(tok, ';')) {
            return model;
        }
        throw SqlParser.errUnexpected(lexer, tok);
    }

    private void parseSelectClause(GenericLexer lexer, QueryModel model) throws SqlException {
        block25: {
            CharSequence tok = this.tok(lexer, "[distinct] column");
            if (SqlKeywords.isDistinctKeyword(tok)) {
                model.setDistinct(true);
            } else {
                lexer.unparse();
            }
            do {
                CharSequence alias;
                QueryColumn col;
                ExpressionNode expr;
                if (Chars.equals(tok = this.tok(lexer, "column"), '*')) {
                    expr = this.nextLiteral(GenericLexer.immutableOf(tok), lexer.lastTokenPosition());
                } else {
                    if (SqlKeywords.isFromKeyword(tok)) {
                        throw SqlException.$(lexer.getPosition(), "column name expected");
                    }
                    if (SqlKeywords.isSelectKeyword(tok)) {
                        throw SqlException.$(lexer.getPosition(), "reserved name");
                    }
                    lexer.unparse();
                    expr = this.expr(lexer, model);
                    if (expr == null) {
                        throw SqlException.$(lexer.lastTokenPosition(), "missing expression");
                    }
                    if (Chars.endsWith(expr.token, '.') && expr.type == 4) {
                        throw SqlException.$(expr.position + expr.token.length(), "'*' or column name expected");
                    }
                }
                tok = this.optTok(lexer);
                if (tok != null && SqlKeywords.isOverKeyword(tok)) {
                    this.expectTok(lexer, '(');
                    col = this.analyticColumnPool.next().of(null, expr);
                    tok = this.tok(lexer, "'");
                    if (SqlKeywords.isPartitionKeyword(tok)) {
                        this.expectTok(lexer, "by");
                        ObjList<ExpressionNode> partitionBy = ((AnalyticColumn)col).getPartitionBy();
                        do {
                            partitionBy.add(this.expectExpr(lexer));
                        } while (Chars.equals(tok = this.tok(lexer, "'order' or ')'"), ','));
                    }
                    if (SqlKeywords.isOrderKeyword(tok)) {
                        this.expectTok(lexer, "by");
                        do {
                            ExpressionNode orderByExpr = this.expectExpr(lexer);
                            tok = this.tokIncludingLocalBrace(lexer, "'asc' or 'desc'");
                            if (SqlKeywords.isDescKeyword(tok)) {
                                ((AnalyticColumn)col).addOrderBy(orderByExpr, 1);
                                tok = this.tok(lexer, "',' or ')'");
                                continue;
                            }
                            ((AnalyticColumn)col).addOrderBy(orderByExpr, 0);
                            if (!SqlKeywords.isAscKeyword(tok)) continue;
                            tok = this.tok(lexer, "',' or ')'");
                        } while (Chars.equals(tok, ','));
                    }
                    this.expectTok(tok, lexer.lastTokenPosition(), ')');
                    tok = this.optTok(lexer);
                } else {
                    if (expr.type == 65) {
                        throw SqlException.$(expr.position, "query is not expected, did you mean column?");
                    }
                    col = this.queryColumnPool.next().of(null, expr);
                }
                if (tok != null && Chars.equals(tok, ';')) {
                    alias = this.createColumnAlias(expr, model);
                    tok = this.optTok(lexer);
                } else if (tok != null && columnAliasStop.excludes(tok)) {
                    this.assertNotDot(lexer, tok);
                    alias = SqlKeywords.isAsKeyword(tok) ? GenericLexer.unquote(GenericLexer.immutableOf(this.tok(lexer, "alias"))) : GenericLexer.immutableOf(tok);
                    tok = this.optTok(lexer);
                } else {
                    alias = this.createColumnAlias(expr, model);
                }
                col.setAlias(alias);
                model.addBottomUpColumn(col);
                if (tok == null) {
                    lexer.unparse();
                } else if (SqlKeywords.isFromKeyword(tok)) {
                    lexer.unparse();
                } else {
                    if (!setOperations.contains(tok)) continue;
                    lexer.unparse();
                }
                break block25;
            } while (Chars.equals(tok, ','));
            throw SqlParser.err(lexer, "',', 'from' or 'over' expected");
        }
    }

    private void parseSelectFrom(GenericLexer lexer, QueryModel model, QueryModel masterModel) throws SqlException {
        ExpressionNode expr = this.expr(lexer, model);
        if (expr == null) {
            throw SqlException.position(lexer.lastTokenPosition()).put("table name expected");
        }
        CharSequence name = expr.token;
        switch (expr.type) {
            case 2: 
            case 4: {
                ExpressionNode literal = this.literal(name, expr.position);
                WithClauseModel withClause = masterModel.getWithClause(name);
                if (withClause != null) {
                    model.setNestedModel(this.parseWith(lexer, withClause, masterModel.getWithClauses()));
                    model.setAlias(literal);
                    break;
                }
                model.setTableName(literal);
                break;
            }
            case 8: {
                model.setTableName(expr);
                break;
            }
            default: {
                throw SqlException.$(expr.position, "function, literal or constant is expected");
            }
        }
    }

    private int parseSymbolCapacity(GenericLexer lexer) throws SqlException {
        int errorPosition = lexer.getPosition();
        int symbolCapacity = this.expectInt(lexer);
        TableUtils.validateSymbolCapacity(errorPosition, symbolCapacity);
        return Numbers.ceilPow2(symbolCapacity);
    }

    private ExpressionNode parseTimestamp(GenericLexer lexer, CharSequence tok) throws SqlException {
        if (tok != null && SqlKeywords.isTimestampKeyword(tok)) {
            this.expectTok(lexer, '(');
            ExpressionNode result = this.expectLiteral(lexer);
            this.tokIncludingLocalBrace(lexer, "')'");
            return result;
        }
        return null;
    }

    private QueryModel parseWith(GenericLexer lexer, WithClauseModel wcm, LowerCaseCharSequenceObjHashMap<WithClauseModel> withClauses) throws SqlException {
        QueryModel m = wcm.popModel();
        if (m != null) {
            return m;
        }
        int pos = lexer.getPosition();
        CharSequence unparsed = lexer.getUnparsed();
        lexer.goToPosition(wcm.getPosition(), null);
        m = this.parseAsSubQueryAndExpectClosingBrace(lexer, withClauses);
        lexer.goToPosition(pos, unparsed);
        return m;
    }

    private void parseWithClauses(GenericLexer lexer, QueryModel model) throws SqlException {
        CharSequence tok;
        do {
            ExpressionNode name = this.expectLiteral(lexer);
            if (model.getWithClause(name.token) != null) {
                throw SqlException.$(name.position, "duplicate name");
            }
            this.expectTok(lexer, "as");
            this.expectTok(lexer, '(');
            int lo = lexer.lastTokenPosition();
            WithClauseModel wcm = this.withClauseModelPool.next();
            wcm.of(lo + 1, this.parseAsSubQueryAndExpectClosingBrace(lexer, model.getWithClauses()));
            model.addWithClause(name.token, wcm);
        } while ((tok = this.optTok(lexer)) != null && Chars.equals(tok, ','));
        lexer.unparse();
    }

    private ExpressionNode rewriteCase(ExpressionNode parent) throws SqlException {
        this.traversalAlgo.traverse(parent, this.rewriteCase0Ref);
        return parent;
    }

    private void rewriteCase0(ExpressionNode node) {
        if (node.type == 8 && SqlKeywords.isCaseKeyword(node.token)) {
            int lim;
            ExpressionNode elseExpr;
            this.tempExprNodes.clear();
            ExpressionNode literal = null;
            boolean convertToSwitch = true;
            int paramCount = node.paramCount;
            if (node.paramCount == 2) {
                ExpressionNode that = node.rhs;
                node.of(that.type, that.token, that.precedence, that.position);
                node.paramCount = that.paramCount;
                if (that.paramCount == 2) {
                    node.lhs = that.lhs;
                    node.rhs = that.rhs;
                } else {
                    node.args.clear();
                    node.args.addAll(that.args);
                }
                return;
            }
            if ((paramCount & 1) == 0) {
                elseExpr = node.args.getQuick(0);
                lim = 0;
            } else {
                elseExpr = null;
                lim = -1;
            }
            ExpressionNode first = node.args.getQuick(paramCount - 1);
            if (first.token != null) {
                node.token = "switch";
                return;
            }
            for (int i = paramCount - 2; i > lim; --i) {
                if ((i & 1) == 1) {
                    this.tempExprNodes.add(node.args.getQuick(i));
                    continue;
                }
                ExpressionNode where = node.args.getQuick(i);
                if (where.type == 1 && where.token.charAt(0) == '=') {
                    ExpressionNode thisLiteral;
                    ExpressionNode thisConstant;
                    if (where.lhs.type == 2 && where.rhs.type == 4) {
                        thisConstant = where.lhs;
                        thisLiteral = where.rhs;
                    } else if (where.lhs.type == 4 && where.rhs.type == 2) {
                        thisConstant = where.rhs;
                        thisLiteral = where.lhs;
                    } else {
                        convertToSwitch = false;
                        break;
                    }
                    if (literal == null) {
                        literal = thisLiteral;
                        this.tempExprNodes.add(thisConstant);
                        continue;
                    }
                    if (Chars.equals(literal.token, thisLiteral.token)) {
                        this.tempExprNodes.add(thisConstant);
                        continue;
                    }
                    convertToSwitch = false;
                    break;
                }
                convertToSwitch = false;
                break;
            }
            if (convertToSwitch) {
                int n = this.tempExprNodes.size();
                node.token = "switch";
                node.args.clear();
                node.args.add(elseExpr);
                for (int i = n - 1; i > -1; --i) {
                    node.args.add(this.tempExprNodes.getQuick(i));
                }
                node.args.add(literal);
                node.paramCount = n + 2;
            } else {
                node.args.remove(paramCount - 1);
                node.paramCount = paramCount - 1;
            }
        }
    }

    private ExpressionNode rewriteConcat(ExpressionNode parent) throws SqlException {
        this.traversalAlgo.traverse(parent, this.rewriteConcat0Ref);
        return parent;
    }

    private void rewriteConcat0(ExpressionNode node) {
        if (node.type == 1 && SqlKeywords.isConcatOperator(node.token)) {
            node.type = 8;
            node.token = "concat";
            this.addConcatArgs(node.args, node.rhs);
            this.addConcatArgs(node.args, node.lhs);
            node.paramCount = node.args.size();
        }
    }

    private ExpressionNode rewriteCount(ExpressionNode parent) throws SqlException {
        this.traversalAlgo.traverse(parent, this.rewriteCount0Ref);
        return parent;
    }

    private void rewriteCount0(ExpressionNode node) {
        if (node.type == 8 && SqlKeywords.isCountKeyword(node.token) && node.paramCount == 1) {
            ExpressionNode that = node.rhs;
            if (Chars.equals(that.token, '*') && that.rhs == null && node.lhs == null) {
                that.paramCount = 0;
                node.rhs = null;
                node.paramCount = 0;
            }
        }
    }

    private ExpressionNode rewriteKnownStatements(ExpressionNode parent) throws SqlException {
        return this.rewriteConcat(this.rewriteCase(this.rewriteCount(this.rewriteTypeQualifier(parent))));
    }

    private ExpressionNode rewriteTypeQualifier(ExpressionNode parent) throws SqlException {
        this.traversalAlgo.traverse(parent, this.rewriteTypeQualifier0Ref);
        return parent;
    }

    private void rewriteTypeQualifier0(ExpressionNode node) {
        if (node.type == 1 && SqlKeywords.isColonColonKeyword(node.token) && node.paramCount == 2) {
            ExpressionNode that = node.rhs;
            if (that.type == 4) {
                that.type = 5;
            }
        }
    }

    private int toColumnType(GenericLexer lexer, CharSequence tok) throws SqlException {
        int type = ColumnType.columnTypeOf(tok);
        if (type == -1) {
            throw SqlException.$(lexer.lastTokenPosition(), "unsupported column type: ").put(tok);
        }
        return type;
    }

    @NotNull
    private CharSequence tok(GenericLexer lexer, String expectedList) throws SqlException {
        int pos = lexer.getPosition();
        CharSequence tok = this.optTok(lexer);
        if (tok == null) {
            throw SqlException.position(pos).put(expectedList).put(" expected");
        }
        return tok;
    }

    @NotNull
    private CharSequence tokIncludingLocalBrace(GenericLexer lexer, String expectedList) throws SqlException {
        int pos = lexer.getPosition();
        CharSequence tok = SqlUtil.fetchNext(lexer);
        if (tok == null) {
            throw SqlException.position(pos).put(expectedList).put(" expected");
        }
        return tok;
    }

    private void validateLiteral(int pos, CharSequence tok) throws SqlException {
        switch (tok.charAt(0)) {
            case '\'': 
            case '(': 
            case ')': 
            case ',': 
            case '`': {
                throw SqlException.position(pos).put("literal expected");
            }
        }
    }

    static {
        tableAliasStop.add("where");
        tableAliasStop.add("latest");
        tableAliasStop.add("join");
        tableAliasStop.add("inner");
        tableAliasStop.add("left");
        tableAliasStop.add("outer");
        tableAliasStop.add("asof");
        tableAliasStop.add("splice");
        tableAliasStop.add("lt");
        tableAliasStop.add("cross");
        tableAliasStop.add("sample");
        tableAliasStop.add("order");
        tableAliasStop.add("on");
        tableAliasStop.add("timestamp");
        tableAliasStop.add("limit");
        tableAliasStop.add(")");
        tableAliasStop.add(";");
        tableAliasStop.add("union");
        tableAliasStop.add("group");
        tableAliasStop.add("except");
        tableAliasStop.add("intersect");
        columnAliasStop.add("from");
        columnAliasStop.add(",");
        columnAliasStop.add("over");
        groupByStopSet.add("order");
        groupByStopSet.add(")");
        groupByStopSet.add(",");
        joinStartSet.put("left", 1);
        joinStartSet.put("join", 1);
        joinStartSet.put("inner", 1);
        joinStartSet.put("outer", 2);
        joinStartSet.put("cross", 3);
        joinStartSet.put("asof", 4);
        joinStartSet.put("splice", 5);
        joinStartSet.put("lt", 6);
        joinStartSet.put(",", 3);
        setOperations.add("union");
        setOperations.add("except");
        setOperations.add("intersect");
    }
}

