/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.griffin.CharacterStore;
import io.questdb.griffin.CharacterStoreEntry;
import io.questdb.griffin.OperatorExpression;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.QueryColumn;
import io.questdb.std.CharSequenceHashSet;
import io.questdb.std.Chars;
import io.questdb.std.GenericLexer;
import io.questdb.std.LowerCaseCharSequenceObjHashMap;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjectPool;

public class SqlUtil {
    static final CharSequenceHashSet disallowedAliases = new CharSequenceHashSet();

    public static CharSequence fetchNext(GenericLexer lexer) {
        int blockCount = 0;
        boolean lineComment = false;
        while (lexer.hasNext()) {
            CharSequence cs = lexer.next();
            if (lineComment) {
                if (!Chars.equals(cs, '\n') && !Chars.equals(cs, '\r')) continue;
                lineComment = false;
                continue;
            }
            if (Chars.equals((CharSequence)"--", cs)) {
                lineComment = true;
                continue;
            }
            if (Chars.equals((CharSequence)"/*", cs)) {
                ++blockCount;
                continue;
            }
            if (Chars.equals((CharSequence)"*/", cs) && blockCount > 0) {
                --blockCount;
                continue;
            }
            if (blockCount != 0 || !GenericLexer.WHITESPACE.excludes(cs)) continue;
            return cs;
        }
        return null;
    }

    static ExpressionNode nextLiteral(ObjectPool<ExpressionNode> pool, CharSequence token, int position) {
        return pool.next().of(4, token, 0, position);
    }

    static CharSequence createColumnAlias(CharacterStore store, CharSequence base, int indexOfDot, LowerCaseCharSequenceObjHashMap<QueryColumn> aliasToColumnMap) {
        CharSequence alias;
        boolean disallowed = disallowedAliases.contains(base);
        if (indexOfDot == -1 && !disallowed && aliasToColumnMap.excludes(base)) {
            return base;
        }
        CharacterStoreEntry characterStoreEntry = store.newEntry();
        if (indexOfDot == -1) {
            if (disallowed) {
                characterStoreEntry.put("column");
            } else {
                characterStoreEntry.put(base);
            }
        } else if (indexOfDot + 1 == base.length()) {
            characterStoreEntry.put("column");
        } else {
            characterStoreEntry.put(base, indexOfDot + 1, base.length());
        }
        int len = characterStoreEntry.length();
        int sequence = 0;
        do {
            if (sequence > 0) {
                characterStoreEntry.trimTo(len);
                characterStoreEntry.put(sequence);
            }
            ++sequence;
        } while (!aliasToColumnMap.excludes(alias = characterStoreEntry.toImmutable()));
        return alias;
    }

    static QueryColumn nextColumn(ObjectPool<QueryColumn> queryColumnPool, ObjectPool<ExpressionNode> sqlNodePool, CharSequence alias, CharSequence column) {
        return queryColumnPool.next().of(alias, SqlUtil.nextLiteral(sqlNodePool, column, 0));
    }

    static long expectMicros(CharSequence tok, int position) throws SqlException {
        int k = -1;
        int len = tok.length();
        for (int i = 0; i < len; ++i) {
            char c = tok.charAt(i);
            if (c >= '0' && c <= '9') continue;
            k = i;
            break;
        }
        if (k == -1) {
            throw SqlException.$(position + len, "expected interval qualifier in ").put(tok);
        }
        try {
            long interval = Numbers.parseLong(tok, 0, k);
            int nChars = len - k;
            if (nChars > 2) {
                throw SqlException.$(position + k, "expected 1/2 letter interval qualifier in ").put(tok);
            }
            switch (tok.charAt(k)) {
                case 's': {
                    if (nChars != 1) break;
                    return interval * 1000000L;
                }
                case 'm': {
                    if (nChars == 1) {
                        return interval * 60000000L;
                    }
                    if (tok.charAt(k + 1) != 's') break;
                    return interval * 1000L;
                }
                case 'h': {
                    if (nChars != 1) break;
                    return interval * 3600000000L;
                }
                case 'd': {
                    if (nChars != 1) break;
                    return interval * 86400000000L;
                }
            }
        }
        catch (NumericException numericException) {
            // empty catch block
        }
        throw SqlException.$(position + len, "invalid interval qualifier ").put(tok);
    }

    static {
        int n = OperatorExpression.operators.size();
        for (int i = 0; i < n; ++i) {
            disallowedAliases.add(OperatorExpression.operators.getQuick((int)i).token);
        }
    }
}

