/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.FunctionParser;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlKeywords;
import io.questdb.griffin.model.AliasTranslator;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.IntervalUtils;
import io.questdb.griffin.model.IntrinsicModel;
import io.questdb.std.CharSequenceHashSet;
import io.questdb.std.CharSequenceIntHashMap;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.Mutable;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectPool;
import io.questdb.std.datetime.microtime.TimestampFormatUtils;
import io.questdb.std.str.FlyweightCharSequence;
import java.util.ArrayDeque;

final class WhereClauseParser
implements Mutable {
    private static final int INTRINSIC_OP_IN = 1;
    private static final int INTRINSIC_OP_GREATER = 2;
    private static final int INTRINSIC_OP_GREATER_EQ = 3;
    private static final int INTRINSIC_OP_LESS = 4;
    private static final int INTRINSIC_OP_LESS_EQ = 5;
    private static final int INTRINSIC_OP_EQUAL = 6;
    private static final int INTRINSIC_OP_NOT_EQ = 7;
    private static final int INTRINSIC_OP_NOT = 8;
    private static final int INTRINSIC_OP_BETWEEN = 9;
    private static final CharSequenceIntHashMap intrinsicOps = new CharSequenceIntHashMap();
    private final ArrayDeque<ExpressionNode> stack = new ArrayDeque();
    private final ObjList<ExpressionNode> keyNodes = new ObjList();
    private final ObjList<ExpressionNode> keyExclNodes = new ObjList();
    private final ObjList<ExpressionNode> tempNodes = new ObjList();
    private final ObjectPool<IntrinsicModel> models = new ObjectPool<IntrinsicModel>(IntrinsicModel.FACTORY, 8);
    private final CharSequenceHashSet tempKeys = new CharSequenceHashSet();
    private final IntList tempPos = new IntList();
    private final CharSequenceHashSet tempK = new CharSequenceHashSet();
    private final IntList tempP = new IntList();
    private final ObjectPool<FlyweightCharSequence> csPool = new ObjectPool<FlyweightCharSequence>(FlyweightCharSequence.FACTORY, 64);
    private CharSequence timestamp;
    private CharSequence preferredKeyColumn;

    WhereClauseParser() {
    }

    @Override
    public void clear() {
        this.models.clear();
        this.stack.clear();
        this.keyNodes.clear();
        this.keyExclNodes.clear();
        this.csPool.clear();
        this.tempNodes.clear();
    }

    private static void checkNodeValid(ExpressionNode node) throws SqlException {
        if (node.lhs == null || node.rhs == null) {
            throw SqlException.$(node.position, "Argument expected");
        }
    }

    private static boolean nodesEqual(ExpressionNode left, ExpressionNode right) {
        return !(left.type != 4 && left.type != 2 || right.type != 4 && right.type != 2 || !Chars.equals(left.token, right.token));
    }

    private boolean analyzeEquals(AliasTranslator translator, IntrinsicModel model, ExpressionNode node, RecordMetadata m, FunctionParser functionParser, SqlExecutionContext executionContext) throws SqlException {
        WhereClauseParser.checkNodeValid(node);
        return this.analyzeEquals0(translator, model, node, node.lhs, node.rhs, m, functionParser, executionContext) || this.analyzeEquals0(translator, model, node, node.rhs, node.lhs, m, functionParser, executionContext);
    }

    /*
     * Unable to fully structure code
     */
    private boolean analyzeEquals0(AliasTranslator translator, IntrinsicModel model, ExpressionNode node, ExpressionNode a, ExpressionNode b, RecordMetadata m, FunctionParser functionParser, SqlExecutionContext executionContext) throws SqlException {
        block18: {
            block19: {
                if (WhereClauseParser.nodesEqual(a, b)) {
                    node.intrinsicValue = 1;
                    return true;
                }
                if (a.type != 4 || b.type != 2 && !WhereClauseParser.isFunc(b)) break block18;
                if (!this.isTimestamp(a)) break block19;
                if (b.type == 2) {
                    model.intersectTimestamp(b.token, 1, b.token.length() - 1, b.position);
                    node.intrinsicValue = 1;
                    return true;
                }
                function = functionParser.parseFunction(b, m, executionContext);
                this.checkFunctionCanBeTimestamp(m, executionContext, function);
                if (function.isConstant()) {
                    value = WhereClauseParser.getTimestampFromConstFunction(function);
                    if (value == -9223372036854775808L) {
                        model.intersectEmpty();
                    } else {
                        model.intersectIntervals(value, value);
                    }
                    node.intrinsicValue = 1;
                    return true;
                }
                if (function.isRuntimeConstant()) {
                    model.intersectEquals(function);
                    node.intrinsicValue = 1;
                    return true;
                }
                break block18;
            }
            column = translator.translateAlias(a.token);
            index = m.getColumnIndexQuiet(column);
            if (index == -1) {
                throw SqlException.invalidColumn(a.position, a.token);
            }
            switch (m.getColumnType(index)) {
                case 4: 
                case 5: 
                case 10: 
                case 11: {
                    preferred = Chars.equalsIgnoreCaseNc(this.preferredKeyColumn, column);
                    indexed = m.isColumnIndexed(index);
                    if (!preferred && (!indexed || this.preferredKeyColumn != null)) break;
                    v0 = value = SqlKeywords.isNullKeyword(b.token) != false ? null : this.unquote(b.token);
                    if (!Chars.equalsIgnoreCaseNc(model.keyColumn, column)) ** GOTO lbl58
                    if (model.keyValues.contains(value)) {
                        if (model.keyValues.size() > 1) {
                            model.keyValues.clear();
                            model.keyValuePositions.clear();
                            model.keyValues.add(value);
                            model.keyValuePositions.add(b.position);
                            node.intrinsicValue = 1;
                        }
                    } else {
                        if (model.keyExcludedValues.contains(value)) {
                            if (model.keyExcludedValues.size() > 1) {
                                removedIndex = model.keyExcludedValues.remove(value);
                                if (removedIndex > -1) {
                                    model.keyExcludedValuePositions.removeIndex(index);
                                }
                            } else {
                                model.keyExcludedValues.clear();
                                model.keyExcludedValuePositions.clear();
                            }
                            this.removeNodes(b, this.keyExclNodes);
                        }
                        node.intrinsicValue = 1;
                        model.intrinsicValue = 2;
                        return false;
lbl58:
                        // 1 sources

                        if (model.keyColumn == null || m.getIndexValueBlockCapacity(index) > m.getIndexValueBlockCapacity(model.keyColumn)) {
                            model.keyColumn = column;
                            model.keyValues.clear();
                            model.keyValuePositions.clear();
                            model.keyExcludedValues.clear();
                            model.keyExcludedValuePositions.clear();
                            model.keyValues.add(value);
                            model.keyValuePositions.add(b.position);
                            this.resetNodes();
                            node.intrinsicValue = 1;
                        }
                    }
                    this.keyNodes.add(node);
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private boolean analyzeGreater(IntrinsicModel model, ExpressionNode node, boolean equalsTo, FunctionParser functionParser, RecordMetadata metadata, SqlExecutionContext executionContext) throws SqlException {
        WhereClauseParser.checkNodeValid(node);
        if (WhereClauseParser.nodesEqual(node.lhs, node.rhs)) {
            model.intrinsicValue = 2;
            return false;
        }
        if (this.timestamp == null) {
            return false;
        }
        if (node.lhs.type == 4 && Chars.equals(node.lhs.token, this.timestamp)) {
            return this.analyzeTimestampGreater(model, node, equalsTo, functionParser, metadata, executionContext, node.rhs);
        }
        if (node.rhs.type == 4 && Chars.equals(node.rhs.token, this.timestamp)) {
            return this.analyzeTimestampLess(model, node, equalsTo, functionParser, metadata, executionContext, node.lhs);
        }
        return false;
    }

    private boolean analyzeTimestampGreater(IntrinsicModel model, ExpressionNode node, boolean equalsTo, FunctionParser functionParser, RecordMetadata metadata, SqlExecutionContext executionContext, ExpressionNode compareWithNode) throws SqlException {
        if (compareWithNode.type == 2) {
            long lo;
            try {
                lo = this.parseFullOrPartialDate(equalsTo, compareWithNode, true);
            }
            catch (NumericException e) {
                throw SqlException.invalidDate(compareWithNode.position);
            }
            model.intersectIntervals(lo, Long.MAX_VALUE);
            node.intrinsicValue = 1;
            return true;
        }
        if (WhereClauseParser.isFunc(compareWithNode)) {
            Function function = functionParser.parseFunction(compareWithNode, metadata, executionContext);
            this.checkFunctionCanBeTimestamp(metadata, executionContext, function);
            if (function.isConstant()) {
                long lo = WhereClauseParser.getTimestampFromConstFunction(function);
                if (lo == Long.MIN_VALUE) {
                    model.intersectEmpty();
                } else {
                    model.intersectIntervals(lo + (long)WhereClauseParser.adjustComparison(equalsTo, true), Long.MAX_VALUE);
                }
                node.intrinsicValue = 1;
                return true;
            }
            if (function.isRuntimeConstant()) {
                model.intersectIntervals(function, Long.MAX_VALUE, WhereClauseParser.adjustComparison(equalsTo, true));
                node.intrinsicValue = 1;
                return true;
            }
        }
        return false;
    }

    private static boolean isFunc(ExpressionNode compareWithNode) {
        return compareWithNode.type == 8 || compareWithNode.type == 6 || compareWithNode.type == 1;
    }

    private static long getTimestampFromConstFunction(Function function) throws SqlException {
        if (function.getType() != 10) {
            return function.getTimestamp(null);
        }
        CharSequence str = function.getStr(null);
        return WhereClauseParser.parseStringAsTimestamp(str, function.getPosition());
    }

    private void checkFunctionCanBeTimestamp(RecordMetadata metadata, SqlExecutionContext executionContext, Function function) throws SqlException {
        if (function.getType() == -1) {
            int timestampType = metadata.getColumnType(metadata.getTimestampIndex());
            function.assignType(timestampType, executionContext.getBindVariableService());
        } else if (!WhereClauseParser.canCastToTimestamp(function.getType())) {
            throw SqlException.invalidDate(function.getPosition());
        }
    }

    private boolean analyzeBetween(AliasTranslator translator, IntrinsicModel model, ExpressionNode node, RecordMetadata m, FunctionParser functionParser, RecordMetadata metadata, SqlExecutionContext executionContext) throws SqlException {
        ExpressionNode col = node.args.getLast();
        if (col.type != 4) {
            return false;
        }
        CharSequence column = translator.translateAlias(col.token);
        if (m.getColumnIndexQuiet(column) == -1) {
            throw SqlException.invalidColumn(col.position, col.token);
        }
        return this.analyzeBetween0(model, col, node, false, functionParser, metadata, executionContext);
    }

    private boolean analyzeIn(AliasTranslator translator, IntrinsicModel model, ExpressionNode node, RecordMetadata metadata) throws SqlException {
        ExpressionNode col;
        if (node.paramCount < 2) {
            throw SqlException.$(node.position, "Too few arguments for 'in'");
        }
        ExpressionNode expressionNode = col = node.paramCount < 3 ? node.lhs : node.args.getLast();
        if (col.type != 4) {
            return false;
        }
        CharSequence column = translator.translateAlias(col.token);
        if (metadata.getColumnIndexQuiet(column) == -1) {
            throw SqlException.invalidColumn(col.position, col.token);
        }
        return this.analyzeInInterval(model, col, node, false) || this.analyzeListOfValues(model, column, metadata, node) || this.analyzeInLambda(model, column, metadata, node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean analyzeBetween0(IntrinsicModel model, ExpressionNode col, ExpressionNode between, boolean isNegated, FunctionParser functionParser, RecordMetadata metadata, SqlExecutionContext executionContext) throws SqlException {
        if (!this.isTimestamp(col)) {
            return false;
        }
        ExpressionNode lo = between.args.getQuick(1);
        ExpressionNode hi = between.args.getQuick(0);
        try {
            model.setBetweenNegated(isNegated);
            boolean isBetweenTranslated = this.translateBetweenToTimestampModel(model, functionParser, metadata, executionContext, lo);
            if (isBetweenTranslated) {
                isBetweenTranslated = this.translateBetweenToTimestampModel(model, functionParser, metadata, executionContext, hi);
            }
            if (isBetweenTranslated) {
                between.intrinsicValue = 1;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            model.clearBetweenTempParsing();
        }
        return false;
    }

    private boolean translateBetweenToTimestampModel(IntrinsicModel model, FunctionParser functionParser, RecordMetadata metadata, SqlExecutionContext executionContext, ExpressionNode lo) throws SqlException {
        if (lo.type == 2) {
            model.setBetweenBoundary(WhereClauseParser.parseTokenAsTimestamp(lo));
            return true;
        }
        if (WhereClauseParser.isFunc(lo)) {
            Function f1 = functionParser.parseFunction(lo, metadata, executionContext);
            this.checkFunctionCanBeTimestamp(metadata, executionContext, f1);
            if (f1.isConstant()) {
                long timestamp = WhereClauseParser.getTimestampFromConstFunction(f1);
                model.setBetweenBoundary(timestamp);
            } else if (f1.isRuntimeConstant()) {
                model.setBetweenBoundary(f1);
            } else {
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean canCastToTimestamp(int type) {
        return type == 7 || type == 6 || type == 10;
    }

    private static long parseTokenAsTimestamp(ExpressionNode lo) throws SqlException {
        try {
            if (!SqlKeywords.isNullKeyword(lo.token)) {
                return IntervalUtils.parseFloorPartialDate(lo.token, 1, lo.token.length() - 1);
            }
            return Long.MIN_VALUE;
        }
        catch (NumericException ignore) {
            throw SqlException.invalidDate(lo.position);
        }
    }

    private static long parseStringAsTimestamp(CharSequence str, int position) throws SqlException {
        try {
            return IntervalUtils.parseFloorPartialDate(str);
        }
        catch (NumericException ignore) {
            throw SqlException.invalidDate(position);
        }
    }

    private boolean analyzeInInterval(IntrinsicModel model, ExpressionNode col, ExpressionNode in, boolean isNegated) throws SqlException {
        if (!this.isTimestamp(col)) {
            return false;
        }
        if (in.paramCount == 2) {
            ExpressionNode lo = in.rhs;
            if (lo.type == 2) {
                if (!isNegated) {
                    model.intersectIntervals(lo.token, 1, lo.token.length() - 1, lo.position);
                } else {
                    model.subtractIntervals(lo.token, 1, lo.token.length() - 1, lo.position);
                }
                in.intrinsicValue = 1;
                return true;
            }
        } else if (!model.hasIntervalFilters() || isNegated) {
            ExpressionNode inListItem;
            int i;
            int n = in.args.size() - 1;
            for (i = 0; i < n; ++i) {
                inListItem = in.args.getQuick(i);
                if (inListItem.type == 2) continue;
                return false;
            }
            for (i = 0; i < n; ++i) {
                inListItem = in.args.getQuick(i);
                long ts = WhereClauseParser.parseTokenAsTimestamp(inListItem);
                if (!isNegated) {
                    if (i == 0) {
                        model.intersectIntervals(ts, ts);
                        continue;
                    }
                    model.unionIntervals(ts, ts);
                    continue;
                }
                model.subtractIntervals(ts, ts);
            }
            in.intrinsicValue = 1;
            return true;
        }
        return false;
    }

    private boolean analyzeInLambda(IntrinsicModel model, CharSequence columnName, RecordMetadata meta, ExpressionNode node) throws SqlException {
        int columnIndex = meta.getColumnIndex(columnName);
        boolean preferred = Chars.equalsIgnoreCaseNc(this.preferredKeyColumn, columnName);
        if (preferred || this.preferredKeyColumn == null && meta.isColumnIndexed(columnIndex)) {
            if (this.preferredKeyColumn != null && !Chars.equalsIgnoreCase(columnName, this.preferredKeyColumn)) {
                return false;
            }
            if (node.rhs == null || node.rhs.type != 65) {
                return false;
            }
            if (model.keyColumn != null && !Chars.equalsIgnoreCase(model.keyColumn, columnName) && meta.getIndexValueBlockCapacity(columnIndex) <= meta.getIndexValueBlockCapacity(model.keyColumn)) {
                return false;
            }
            if (Chars.equalsIgnoreCaseNc(model.keyColumn, columnName) && model.keySubQuery != null || node.paramCount > 2) {
                throw SqlException.$(node.position, "Multiple lambda expressions not supported");
            }
            model.keyValues.clear();
            model.keyValuePositions.clear();
            model.keyValuePositions.add(node.position);
            model.keySubQuery = node.rhs.queryModel;
            return this.revertProcessedNodes(this.keyNodes, model, columnName, node);
        }
        return false;
    }

    private boolean analyzeLess(IntrinsicModel model, ExpressionNode node, boolean equalsTo, FunctionParser functionParser, RecordMetadata metadata, SqlExecutionContext executionContext) throws SqlException {
        WhereClauseParser.checkNodeValid(node);
        if (WhereClauseParser.nodesEqual(node.lhs, node.rhs)) {
            model.intrinsicValue = 2;
            return false;
        }
        if (this.timestamp == null) {
            return false;
        }
        if (node.lhs.type == 4 && Chars.equals(node.lhs.token, this.timestamp)) {
            return this.analyzeTimestampLess(model, node, equalsTo, functionParser, metadata, executionContext, node.rhs);
        }
        if (node.rhs.type == 4 && Chars.equals(node.rhs.token, this.timestamp)) {
            return this.analyzeTimestampGreater(model, node, equalsTo, functionParser, metadata, executionContext, node.lhs);
        }
        return false;
    }

    private boolean analyzeTimestampLess(IntrinsicModel model, ExpressionNode node, boolean equalsTo, FunctionParser functionParser, RecordMetadata metadata, SqlExecutionContext executionContext, ExpressionNode compareWithNode) throws SqlException {
        if (compareWithNode.type == 2) {
            try {
                long hi = this.parseFullOrPartialDate(equalsTo, compareWithNode, false);
                model.intersectIntervals(Long.MIN_VALUE, hi);
                node.intrinsicValue = 1;
            }
            catch (NumericException e) {
                throw SqlException.invalidDate(compareWithNode.position);
            }
            return true;
        }
        if (WhereClauseParser.isFunc(compareWithNode)) {
            Function function = functionParser.parseFunction(compareWithNode, metadata, executionContext);
            this.checkFunctionCanBeTimestamp(metadata, executionContext, function);
            if (function.isConstant()) {
                long hi = WhereClauseParser.getTimestampFromConstFunction(function);
                if (hi == Long.MIN_VALUE) {
                    model.intersectEmpty();
                } else {
                    model.intersectIntervals(Long.MIN_VALUE, hi + (long)WhereClauseParser.adjustComparison(equalsTo, false));
                }
                node.intrinsicValue = 1;
                return true;
            }
            if (function.isRuntimeConstant()) {
                model.intersectIntervals(Long.MIN_VALUE, function, WhereClauseParser.adjustComparison(equalsTo, false));
                node.intrinsicValue = 1;
                return true;
            }
        }
        return false;
    }

    private static short adjustComparison(boolean equalsTo, boolean isLo) {
        return (short)(equalsTo ? 0 : (isLo ? 1 : -1));
    }

    private boolean analyzeListOfValues(IntrinsicModel model, CharSequence columnName, RecordMetadata meta, ExpressionNode node) {
        int columnIndex = meta.getColumnIndex(columnName);
        boolean newColumn = true;
        boolean preferred = Chars.equalsIgnoreCaseNc(this.preferredKeyColumn, columnName);
        if (preferred || this.preferredKeyColumn == null && meta.isColumnIndexed(columnIndex)) {
            if (model.keyColumn != null && (newColumn = !Chars.equals(model.keyColumn, columnName)) && meta.getIndexValueBlockCapacity(columnIndex) <= meta.getIndexValueBlockCapacity(model.keyColumn)) {
                return false;
            }
            int i = node.paramCount - 1;
            this.tempKeys.clear();
            this.tempPos.clear();
            if (i == 1) {
                if (node.rhs == null || node.rhs.type != 2 && node.rhs.type != 6) {
                    return false;
                }
                if (this.tempKeys.add(this.unquote(node.rhs.token))) {
                    this.tempPos.add(node.position);
                }
            } else {
                --i;
                while (i > -1) {
                    ExpressionNode c = node.args.getQuick(i);
                    if (c.type != 2 && c.type != 6) {
                        return false;
                    }
                    if (SqlKeywords.isNullKeyword(c.token)) {
                        if (this.tempKeys.add(null)) {
                            this.tempPos.add(c.position);
                        }
                    } else if (this.tempKeys.add(this.unquote(c.token))) {
                        this.tempPos.add(c.position);
                    }
                    --i;
                }
            }
            if (newColumn) {
                model.keyValues.clear();
                model.keyValuePositions.clear();
                model.keyValues.addAll(this.tempKeys);
                model.keyValuePositions.addAll(this.tempPos);
                return this.revertProcessedNodes(this.keyNodes, model, columnName, node);
            }
            if (model.keyValues.size() == 0) {
                model.keyValues.addAll(this.tempKeys);
                model.keyValuePositions.addAll(this.tempPos);
            }
            if (model.keySubQuery == null) {
                this.replaceAllWithOverlap(model, true);
                this.keyNodes.add(node);
                node.intrinsicValue = 1;
                return true;
            }
        }
        return false;
    }

    private boolean analyzeNotEquals(AliasTranslator translator, IntrinsicModel model, ExpressionNode node, RecordMetadata m) throws SqlException {
        WhereClauseParser.checkNodeValid(node);
        return this.analyzeNotEquals0(translator, model, node, node.lhs, node.rhs, m) || this.analyzeNotEquals0(translator, model, node, node.rhs, node.lhs, m);
    }

    /*
     * Unable to fully structure code
     */
    private boolean analyzeNotEquals0(AliasTranslator translator, IntrinsicModel model, ExpressionNode node, ExpressionNode a, ExpressionNode b, RecordMetadata m) throws SqlException {
        block15: {
            if (Chars.equals(a.token, b.token)) {
                model.intrinsicValue = 2;
                return true;
            }
            if (a.type != 4 || b.type != 2) break block15;
            if (this.isTimestamp(a)) {
                model.subtractIntervals(b.token, 1, b.token.length() - 1, b.position);
                node.intrinsicValue = 1;
                return true;
            }
            column = translator.translateAlias(a.token);
            index = m.getColumnIndexQuiet(column);
            if (index == -1) {
                throw SqlException.invalidColumn(a.position, a.token);
            }
            switch (m.getColumnType(index)) {
                case 4: 
                case 5: 
                case 10: 
                case 11: {
                    if (!m.isColumnIndexed(index)) ** GOTO lbl60
                    preferred = Chars.equalsIgnoreCaseNc(this.preferredKeyColumn, column);
                    indexed = m.isColumnIndexed(index);
                    if (!indexed || this.preferredKeyColumn != null) ** GOTO lbl57
                    v0 = value = SqlKeywords.isNullKeyword(b.token) != false ? null : this.unquote(b.token);
                    if (!Chars.equalsIgnoreCaseNc(model.keyColumn, column)) ** GOTO lbl44
                    if (model.keyExcludedValues.contains(value)) {
                        if (model.keyExcludedValues.size() > 1) {
                            model.keyExcludedValues.clear();
                            model.keyExcludedValuePositions.clear();
                            model.keyExcludedValues.add(value);
                            model.keyExcludedValuePositions.add(b.position);
                            node.intrinsicValue = 1;
                            return true;
                        }
                    } else {
                        if (model.keyValues.contains(value)) {
                            if (model.keyValues.size() > 1) {
                                removedIndex = model.keyValues.remove(value);
                                if (removedIndex > -1) {
                                    model.keyValuePositions.removeIndex(index);
                                }
                                model.keyValuePositions.remove(b.position);
                            } else {
                                model.keyValues.clear();
                                model.keyValuePositions.clear();
                            }
                            this.removeNodes(b, this.keyNodes);
                        }
                        node.intrinsicValue = 1;
                        model.intrinsicValue = 2;
                        return false;
lbl44:
                        // 1 sources

                        if (model.keyColumn == null || m.getIndexValueBlockCapacity(index) > m.getIndexValueBlockCapacity(model.keyColumn)) {
                            model.keyColumn = column;
                            model.keyValues.clear();
                            model.keyValuePositions.clear();
                            model.keyExcludedValues.clear();
                            model.keyExcludedValuePositions.clear();
                            model.keyExcludedValues.add(value);
                            model.keyExcludedValuePositions.add(b.position);
                            this.resetNodes();
                            node.intrinsicValue = 1;
                        }
                    }
                    this.keyExclNodes.add(node);
                    return true;
lbl57:
                    // 1 sources

                    if (preferred) {
                        this.keyExclNodes.add(node);
                        return false;
                    }
lbl60:
                    // 3 sources

                    return false;
                }
            }
        }
        return false;
    }

    private boolean analyzeNotIn(AliasTranslator translator, IntrinsicModel model, ExpressionNode notNode, RecordMetadata m) throws SqlException {
        ExpressionNode col;
        ExpressionNode node = notNode.rhs;
        if (node.paramCount < 2) {
            throw SqlException.$(node.position, "Too few arguments for 'in'");
        }
        ExpressionNode expressionNode = col = node.paramCount < 3 ? node.lhs : node.args.getLast();
        if (col.type != 4) {
            throw SqlException.$(col.position, "Column name expected");
        }
        CharSequence column = translator.translateAlias(col.token);
        if (m.getColumnIndexQuiet(column) == -1) {
            throw SqlException.invalidColumn(col.position, col.token);
        }
        boolean ok = this.analyzeInInterval(model, col, node, true);
        if (ok) {
            notNode.intrinsicValue = 1;
        } else {
            this.analyzeNotListOfValues(model, column, m, node, notNode);
        }
        return ok;
    }

    private boolean analyzeNotBetween(AliasTranslator translator, IntrinsicModel model, ExpressionNode notNode, RecordMetadata m, FunctionParser functionParser, RecordMetadata metadata, SqlExecutionContext executionContext) throws SqlException {
        ExpressionNode node = notNode.rhs;
        ExpressionNode col = node.args.getLast();
        if (col.type != 4) {
            return false;
        }
        CharSequence column = translator.translateAlias(col.token);
        if (m.getColumnIndexQuiet(column) == -1) {
            throw SqlException.invalidColumn(col.position, col.token);
        }
        boolean ok = this.analyzeBetween0(model, col, node, true, functionParser, metadata, executionContext);
        if (ok) {
            notNode.intrinsicValue = 1;
        } else {
            this.analyzeNotListOfValues(model, column, m, node, notNode);
        }
        return ok;
    }

    private void analyzeNotListOfValues(IntrinsicModel model, CharSequence columnName, RecordMetadata meta, ExpressionNode node, ExpressionNode notNode) {
        int columnIndex = meta.getColumnIndex(columnName);
        boolean newColumn = true;
        boolean preferred = Chars.equalsIgnoreCaseNc(this.preferredKeyColumn, columnName);
        if (preferred || this.preferredKeyColumn == null && meta.isColumnIndexed(columnIndex)) {
            if (model.keyColumn != null && (newColumn = !Chars.equals(model.keyColumn, columnName)) && meta.getIndexValueBlockCapacity(columnIndex) <= meta.getIndexValueBlockCapacity(model.keyColumn)) {
                return;
            }
            int i = node.paramCount - 1;
            this.tempKeys.clear();
            this.tempPos.clear();
            if (i == 1) {
                if (node.rhs == null || node.rhs.type != 2) {
                    return;
                }
                if (this.tempKeys.add(this.unquote(node.rhs.token))) {
                    this.tempPos.add(node.position);
                }
            } else {
                --i;
                while (i > -1) {
                    ExpressionNode c = node.args.getQuick(i);
                    if (c.type != 2) {
                        return;
                    }
                    if (SqlKeywords.isNullKeyword(c.token)) {
                        if (this.tempKeys.add(null)) {
                            this.tempPos.add(c.position);
                        }
                    } else if (this.tempKeys.add(this.unquote(c.token))) {
                        this.tempPos.add(c.position);
                    }
                    --i;
                }
            }
            if (newColumn) {
                model.keyExcludedValues.clear();
                model.keyExcludedValuePositions.clear();
                model.keyExcludedValues.addAll(this.tempKeys);
                model.keyExcludedValuePositions.addAll(this.tempPos);
                this.revertProcessedNodes(this.keyExclNodes, model, columnName, notNode);
                return;
            }
            if (model.keyExcludedValues.size() == 0) {
                model.keyExcludedValues.addAll(this.tempKeys);
                model.keyExcludedValuePositions.addAll(this.tempPos);
            }
            if (model.keySubQuery == null) {
                this.replaceAllWithOverlap(model, false);
                this.keyExclNodes.add(notNode);
                notNode.intrinsicValue = 1;
            }
        }
    }

    private void applyKeyExclusions(AliasTranslator translator, IntrinsicModel model) {
        if (model.keyColumn != null && model.keyValues.size() > 0 && this.keyExclNodes.size() > 0) {
            int n = this.keyExclNodes.size();
            block0: for (int i = 0; i < n; ++i) {
                ExpressionNode col;
                ExpressionNode node;
                ExpressionNode parent = this.keyExclNodes.getQuick(i);
                ExpressionNode expressionNode = node = SqlKeywords.isNotKeyword(parent.token) ? parent.rhs : parent;
                if (node.paramCount == 2) {
                    ExpressionNode val;
                    if (node.lhs.type == 4) {
                        col = node.lhs;
                        val = node.rhs;
                    } else {
                        col = node.rhs;
                        val = node.lhs;
                    }
                    CharSequence column = translator.translateAlias(col.token);
                    if (Chars.equals(column, model.keyColumn)) {
                        model.excludeValue(val);
                        parent.intrinsicValue = 1;
                        if (model.intrinsicValue == 2) break;
                    }
                }
                if (node.paramCount <= 2) continue;
                col = node.args.getQuick(node.paramCount - 1);
                CharSequence column = translator.translateAlias(col.token);
                if (!Chars.equals(column, model.keyColumn)) continue;
                for (int j = node.paramCount - 2; j > -1; --j) {
                    ExpressionNode val = node.args.getQuick(j);
                    model.excludeValue(val);
                    if (model.intrinsicValue == 2) break block0;
                }
                parent.intrinsicValue = 1;
            }
        }
        this.keyExclNodes.clear();
    }

    private ExpressionNode collapseIntrinsicNodes(ExpressionNode node) {
        if (node == null || node.intrinsicValue == 1) {
            return null;
        }
        node.lhs = this.collapseIntrinsicNodes(this.collapseNulls0(node.lhs));
        node.rhs = this.collapseIntrinsicNodes(this.collapseNulls0(node.rhs));
        return this.collapseNulls0(node);
    }

    private ExpressionNode collapseNulls0(ExpressionNode node) {
        if (node == null || node.intrinsicValue == 1) {
            return null;
        }
        if (node.queryModel == null && SqlKeywords.isAndKeyword(node.token)) {
            if (node.lhs == null || node.lhs.intrinsicValue == 1) {
                return node.rhs;
            }
            if (node.rhs == null || node.rhs.intrinsicValue == 1) {
                return node.lhs;
            }
        }
        return node;
    }

    IntrinsicModel extract(AliasTranslator translator, ExpressionNode node, RecordMetadata m, CharSequence preferredKeyColumn, int timestampIndex, FunctionParser functionParser, RecordMetadata metadata, SqlExecutionContext executionContext) throws SqlException {
        this.timestamp = timestampIndex < 0 ? null : m.getColumnName(timestampIndex);
        this.preferredKeyColumn = preferredKeyColumn;
        IntrinsicModel model = this.models.next();
        if (this.removeAndIntrinsics(translator, model, node, m, functionParser, metadata, executionContext)) {
            return model;
        }
        ExpressionNode root = node;
        while (!this.stack.isEmpty() || node != null) {
            if (node != null) {
                if (SqlKeywords.isAndKeyword(node.token)) {
                    if (!this.removeAndIntrinsics(translator, model, node.rhs, m, functionParser, metadata, executionContext)) {
                        this.stack.push(node.rhs);
                    }
                    node = this.removeAndIntrinsics(translator, model, node.lhs, m, functionParser, metadata, executionContext) ? null : node.lhs;
                    continue;
                }
                node = this.stack.poll();
                continue;
            }
            node = this.stack.poll();
        }
        this.applyKeyExclusions(translator, model);
        model.filter = this.collapseIntrinsicNodes(root);
        return model;
    }

    private boolean isTimestamp(ExpressionNode n) {
        return Chars.equalsNc(n.token, this.timestamp);
    }

    private long parseFullOrPartialDate(boolean equalsTo, ExpressionNode node, boolean isLo) throws NumericException {
        long ts;
        int len = node.token.length();
        try {
            ts = IntervalUtils.parseFloorPartialDate(node.token, 1, len - 1);
            if (!equalsTo) {
                ts += isLo ? 1L : -1L;
            }
        }
        catch (NumericException e) {
            long inc = equalsTo ? 0L : (isLo ? 1L : -1L);
            ts = TimestampFormatUtils.tryParse(node.token, 1, node.token.length() - 1) + inc;
        }
        return ts;
    }

    private boolean removeAndIntrinsics(AliasTranslator translator, IntrinsicModel model, ExpressionNode node, RecordMetadata m, FunctionParser functionParser, RecordMetadata metadata, SqlExecutionContext executionContext) throws SqlException {
        switch (intrinsicOps.get(node.token)) {
            case 1: {
                return this.analyzeIn(translator, model, node, m);
            }
            case 2: {
                return this.analyzeGreater(model, node, false, functionParser, metadata, executionContext);
            }
            case 3: {
                return this.analyzeGreater(model, node, true, functionParser, metadata, executionContext);
            }
            case 4: {
                return this.analyzeLess(model, node, false, functionParser, metadata, executionContext);
            }
            case 5: {
                return this.analyzeLess(model, node, true, functionParser, metadata, executionContext);
            }
            case 6: {
                return this.analyzeEquals(translator, model, node, m, functionParser, executionContext);
            }
            case 7: {
                return this.analyzeNotEquals(translator, model, node, m);
            }
            case 8: {
                return SqlKeywords.isInKeyword(node.rhs.token) && this.analyzeNotIn(translator, model, node, m) || SqlKeywords.isBetweenKeyword(node.rhs.token) && this.analyzeNotBetween(translator, model, node, m, functionParser, metadata, executionContext);
            }
            case 9: {
                return this.analyzeBetween(translator, model, node, m, functionParser, metadata, executionContext);
            }
        }
        return false;
    }

    private void removeNodes(ExpressionNode b, ObjList<ExpressionNode> nodes) {
        int i;
        this.tempNodes.clear();
        int size = nodes.size();
        for (i = 0; i < size; ++i) {
            ExpressionNode expressionNode = nodes.get(i);
            if ((expressionNode.lhs == null || !Chars.equals(expressionNode.lhs.token, b.token)) && (expressionNode.rhs == null || !Chars.equals(expressionNode.rhs.token, b.token))) continue;
            expressionNode.intrinsicValue = 1;
            this.tempNodes.add(expressionNode);
        }
        size = this.tempNodes.size();
        for (i = 0; i < size; ++i) {
            nodes.remove(this.tempNodes.get(i));
        }
    }

    private void replaceAllWithOverlap(IntrinsicModel model, boolean includedValues) {
        IntList positions;
        CharSequenceHashSet values;
        if (includedValues) {
            values = model.keyValues;
            positions = model.keyValuePositions;
        } else {
            values = model.keyExcludedValues;
            positions = model.keyExcludedValuePositions;
        }
        this.tempK.clear();
        this.tempP.clear();
        int k = this.tempKeys.size();
        for (int i = 0; i < k; ++i) {
            if (!values.contains(this.tempKeys.get(i)) || !this.tempK.add(this.tempKeys.get(i))) continue;
            this.tempP.add(this.tempPos.get(i));
        }
        if (this.tempK.size() > 0) {
            values.clear();
            positions.clear();
            values.addAll(this.tempK);
            positions.addAll(this.tempP);
        } else {
            model.intrinsicValue = 2;
        }
    }

    private void resetNodes() {
        int n;
        int k = this.keyNodes.size();
        for (n = 0; n < k; ++n) {
            this.keyNodes.getQuick((int)n).intrinsicValue = 0;
        }
        this.keyNodes.clear();
        k = this.keyExclNodes.size();
        for (n = 0; n < k; ++n) {
            this.keyExclNodes.getQuick((int)n).intrinsicValue = 0;
        }
        this.keyExclNodes.clear();
    }

    private boolean revertProcessedNodes(ObjList<ExpressionNode> nodes, IntrinsicModel model, CharSequence columnName, ExpressionNode node) {
        int k = nodes.size();
        for (int n = 0; n < k; ++n) {
            nodes.getQuick((int)n).intrinsicValue = 0;
        }
        nodes.clear();
        model.keyColumn = columnName;
        nodes.add(node);
        node.intrinsicValue = 1;
        return true;
    }

    private CharSequence unquote(CharSequence value) {
        if (Chars.isQuoted(value)) {
            return this.csPool.next().of(value, 1, value.length() - 2);
        }
        return value;
    }

    static {
        intrinsicOps.put("in", 1);
        intrinsicOps.put(">", 2);
        intrinsicOps.put(">=", 3);
        intrinsicOps.put("<", 4);
        intrinsicOps.put("<=", 5);
        intrinsicOps.put("=", 6);
        intrinsicOps.put("!=", 7);
        intrinsicOps.put("not", 8);
        intrinsicOps.put("between", 9);
    }
}

