/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.analytic;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.RecordChain;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.RecordComparator;
import io.questdb.griffin.engine.analytic.AnalyticFunction;
import io.questdb.griffin.engine.orderby.LongTreeChain;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.Nullable;

public class CachedAnalyticRecordCursorFactory
implements RecordCursorFactory {
    private final RecordChain recordChain;
    private final RecordCursorFactory base;
    private final ObjList<LongTreeChain> orderedSources;
    private final int orderedGroupCount;
    private final ObjList<ObjList<AnalyticFunction>> orderedFunctions;
    @Nullable
    private final ObjList<AnalyticFunction> unorderedFunctions;
    private final ObjList<AnalyticFunction> allFunctions;
    private final ObjList<RecordComparator> comparators;
    private final GenericRecordMetadata metadata;
    private final Record recordChainRecord;
    private boolean closed = false;

    public CachedAnalyticRecordCursorFactory(CairoConfiguration configuration, RecordCursorFactory base, RecordSink recordSink, GenericRecordMetadata metadata, ColumnTypes chainMetadata, ObjList<RecordComparator> comparators, ObjList<ObjList<AnalyticFunction>> orderedFunctions, @Nullable ObjList<AnalyticFunction> unorderedFunctions) {
        int i;
        this.base = base;
        this.orderedGroupCount = comparators.size();
        assert (this.orderedGroupCount == orderedFunctions.size());
        this.orderedSources = new ObjList(this.orderedGroupCount);
        this.orderedFunctions = orderedFunctions;
        this.comparators = comparators;
        this.recordChain = new RecordChain(chainMetadata, recordSink, configuration.getSqlAnalyticStorePageSize(), configuration.getSqlAnalyticStoreMaxPages());
        for (i = 0; i < this.orderedGroupCount; ++i) {
            this.orderedSources.add(new LongTreeChain(configuration.getSqlAnalyticTreeKeyPageSize(), configuration.getSqlAnalyticTreeKeyMaxPages(), configuration.getSqlAnalyticRowIdPageSize(), configuration.getSqlAnalyticRowIdMaxPages()));
        }
        this.allFunctions = new ObjList();
        int n = orderedFunctions.size();
        for (i = 0; i < n; ++i) {
            this.allFunctions.addAll(orderedFunctions.getQuick(i));
        }
        if (unorderedFunctions != null) {
            this.allFunctions.addAll(unorderedFunctions);
        }
        this.metadata = metadata;
        this.recordChainRecord = this.recordChain.getRecord();
        this.unorderedFunctions = unorderedFunctions;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        Misc.free(this.base);
        Misc.free(this.recordChain);
        Misc.freeObjList(this.orderedSources);
        Misc.freeObjList(this.allFunctions);
        this.closed = true;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) {
        int i;
        this.recordChain.clear();
        this.clearTrees();
        this.resetFunctions();
        RecordCursor baseCursor = this.base.getCursor(executionContext);
        long offset = -1L;
        Record record = baseCursor.getRecord();
        Record chainRightRecord = this.recordChain.getRecordB();
        if (this.orderedGroupCount > 0) {
            while (baseCursor.hasNext()) {
                offset = this.recordChain.put(record, offset);
                this.recordChain.recordAt(this.recordChainRecord, offset);
                for (i = 0; i < this.orderedGroupCount; ++i) {
                    this.orderedSources.getQuick(i).put(this.recordChainRecord, this.recordChain, chainRightRecord, this.comparators.getQuick(i));
                }
            }
        } else {
            while (baseCursor.hasNext()) {
                offset = this.recordChain.put(record, offset);
            }
        }
        if (this.orderedGroupCount > 0) {
            for (i = 0; i < this.orderedGroupCount; ++i) {
                LongTreeChain tree = this.orderedSources.getQuick(i);
                ObjList<AnalyticFunction> functions = this.orderedFunctions.getQuick(i);
                LongTreeChain.TreeCursor cursor = tree.getCursor();
                int functionCount = functions.size();
                while (cursor.hasNext()) {
                    offset = cursor.next();
                    this.recordChain.recordAt(this.recordChainRecord, offset);
                    for (int j = 0; j < functionCount; ++j) {
                        functions.getQuick(j).pass1(this.recordChainRecord, offset, this.recordChain);
                    }
                }
            }
        }
        if (this.unorderedFunctions != null) {
            int n = this.unorderedFunctions.size();
            for (int j = 0; j < n; ++j) {
                AnalyticFunction f = this.unorderedFunctions.getQuick(j);
                this.recordChain.toTop();
                while (this.recordChain.hasNext()) {
                    f.pass1(this.recordChainRecord, this.recordChainRecord.getRowId(), this.recordChain);
                }
            }
        }
        this.recordChain.toTop();
        return this.recordChain;
    }

    private void resetFunctions() {
        int n = this.allFunctions.size();
        for (int i = 0; i < n; ++i) {
            this.allFunctions.getQuick(i).reset();
        }
    }

    private void clearTrees() {
        for (int i = 0; i < this.orderedGroupCount; ++i) {
            this.orderedSources.getQuick(i).clear();
        }
    }

    @Override
    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return this.base.recordCursorSupportsRandomAccess();
    }
}

