/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions;

import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.SqlExecutionContext;

public interface BinaryFunction
extends Function {
    @Override
    default public void close() {
        this.getLeft().close();
        this.getRight().close();
    }

    @Override
    default public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
        this.getLeft().init(symbolTableSource, executionContext);
        this.getRight().init(symbolTableSource, executionContext);
    }

    @Override
    default public boolean isConstant() {
        return this.getLeft().isConstant() && this.getRight().isConstant();
    }

    @Override
    default public void toTop() {
        this.getLeft().toTop();
        this.getRight().toTop();
    }

    public Function getLeft();

    public Function getRight();

    @Override
    default public boolean isRuntimeConstant() {
        Function l = this.getLeft();
        Function r = this.getRight();
        return l.isConstant() && r.isRuntimeConstant() || r.isConstant() && l.isRuntimeConstant() || l.isRuntimeConstant() && r.isRuntimeConstant();
    }
}

