/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions;

import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.groupby.GroupByUtils;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;

public interface MultiArgFunction
extends Function {
    public static void init(ObjList<? extends Function> args, SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
        Function.init(args, symbolTableSource, executionContext);
    }

    @Override
    default public void close() {
        Misc.freeObjList(this.getArgs());
    }

    @Override
    default public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
        MultiArgFunction.init(this.getArgs(), symbolTableSource, executionContext);
    }

    @Override
    default public void toTop() {
        GroupByUtils.toTop(this.getArgs());
    }

    public ObjList<Function> getArgs();

    @Override
    default public boolean isConstant() {
        ObjList<Function> args = this.getArgs();
        int n = args.size();
        for (int i = 0; i < n; ++i) {
            if (args.getQuick(i).isConstant()) continue;
            return false;
        }
        return true;
    }

    @Override
    default public boolean isRuntimeConstant() {
        ObjList<Function> args = this.getArgs();
        int n = args.size();
        for (int i = 0; i < n; ++i) {
            Function function = args.getQuick(i);
            if (function.isRuntimeConstant() || function.isConstant()) continue;
            return false;
        }
        return true;
    }
}

