/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions;

import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.SqlExecutionContext;

public interface TernaryFunction
extends Function {
    @Override
    default public void close() {
        this.getLeft().close();
        this.getCenter().close();
        this.getRight().close();
    }

    @Override
    default public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
        this.getLeft().init(symbolTableSource, executionContext);
        this.getCenter().init(symbolTableSource, executionContext);
        this.getRight().init(symbolTableSource, executionContext);
    }

    @Override
    default public boolean isConstant() {
        return this.getLeft().isConstant() && this.getCenter().isConstant() && this.getRight().isConstant();
    }

    @Override
    default public boolean isRuntimeConstant() {
        boolean arc = this.getLeft().isRuntimeConstant();
        boolean brc = this.getCenter().isRuntimeConstant();
        boolean crc = this.getRight().isRuntimeConstant();
        boolean ac = this.getLeft().isConstant();
        boolean bc = this.getCenter().isConstant();
        boolean cc = this.getRight().isConstant();
        return !(!ac && !arc || !bc && !brc || !cc && !crc || !arc && !brc && !crc);
    }

    @Override
    default public void toTop() {
        this.getLeft().toTop();
        this.getCenter().toTop();
        this.getRight().toTop();
    }

    public Function getLeft();

    public Function getCenter();

    public Function getRight();
}

