/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.bind;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.BindVariableService;
import io.questdb.cairo.sql.Function;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlKeywords;
import io.questdb.griffin.engine.functions.bind.BinBindVariable;
import io.questdb.griffin.engine.functions.bind.BooleanBindVariable;
import io.questdb.griffin.engine.functions.bind.ByteBindVariable;
import io.questdb.griffin.engine.functions.bind.CharBindVariable;
import io.questdb.griffin.engine.functions.bind.DateBindVariable;
import io.questdb.griffin.engine.functions.bind.DoubleBindVariable;
import io.questdb.griffin.engine.functions.bind.FloatBindVariable;
import io.questdb.griffin.engine.functions.bind.IntBindVariable;
import io.questdb.griffin.engine.functions.bind.Long256BindVariable;
import io.questdb.griffin.engine.functions.bind.LongBindVariable;
import io.questdb.griffin.engine.functions.bind.ShortBindVariable;
import io.questdb.griffin.engine.functions.bind.StrBindVariable;
import io.questdb.griffin.engine.functions.bind.TimestampBindVariable;
import io.questdb.griffin.model.IntervalUtils;
import io.questdb.std.BinarySequence;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.Chars;
import io.questdb.std.Long256;
import io.questdb.std.Long256FromCharSequenceDecoder;
import io.questdb.std.Long256Impl;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectPool;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.datetime.millitime.DateFormatCompiler;
import io.questdb.std.datetime.millitime.DateFormatUtils;
import org.jetbrains.annotations.Nullable;

public class BindVariableServiceImpl
implements BindVariableService {
    private static final DateFormat[] DATE_FORMATS;
    private static final int DATE_FORMATS_SIZE;
    private static final DateFormat[] TIMESTAMP_FORMATS;
    private static final int TIMESTAMP_FORMATS_SIZE;
    private final CharSequenceObjHashMap<Function> namedVariables = new CharSequenceObjHashMap();
    private final ObjList<Function> indexedVariables = new ObjList();
    private final ObjectPool<DoubleBindVariable> doubleVarPool;
    private final ObjectPool<FloatBindVariable> floatVarPool;
    private final ObjectPool<IntBindVariable> intVarPool;
    private final ObjectPool<LongBindVariable> longVarPool;
    private final ObjectPool<TimestampBindVariable> timestampVarPool;
    private final ObjectPool<DateBindVariable> dateVarPool;
    private final ObjectPool<ShortBindVariable> shortVarPool;
    private final ObjectPool<ByteBindVariable> byteVarPool;
    private final ObjectPool<BooleanBindVariable> booleanVarPool;
    private final ObjectPool<StrBindVariable> strVarPool;
    private final ObjectPool<CharBindVariable> charVarPool;
    private final ObjectPool<Long256BindVariable> long256VarPool;

    public BindVariableServiceImpl(CairoConfiguration configuration) {
        int poolSize = configuration.getBindVariablePoolSize();
        this.doubleVarPool = new ObjectPool<DoubleBindVariable>(DoubleBindVariable::new, poolSize);
        this.floatVarPool = new ObjectPool<FloatBindVariable>(FloatBindVariable::new, poolSize);
        this.intVarPool = new ObjectPool<IntBindVariable>(IntBindVariable::new, poolSize);
        this.longVarPool = new ObjectPool<LongBindVariable>(LongBindVariable::new, poolSize);
        this.timestampVarPool = new ObjectPool<TimestampBindVariable>(TimestampBindVariable::new, poolSize);
        this.dateVarPool = new ObjectPool<DateBindVariable>(DateBindVariable::new, poolSize);
        this.shortVarPool = new ObjectPool<ShortBindVariable>(ShortBindVariable::new, poolSize);
        this.byteVarPool = new ObjectPool<ByteBindVariable>(ByteBindVariable::new, poolSize);
        this.booleanVarPool = new ObjectPool<BooleanBindVariable>(BooleanBindVariable::new, poolSize);
        this.strVarPool = new ObjectPool<StrBindVariable>(() -> new StrBindVariable(configuration.getFloatToStrCastScale()), poolSize);
        this.charVarPool = new ObjectPool<CharBindVariable>(CharBindVariable::new, 8);
        this.long256VarPool = new ObjectPool<Long256BindVariable>(Long256BindVariable::new, 8);
    }

    public static long parseDate(CharSequence value) throws NumericException {
        int hi = value.length();
        for (int i = 0; i < DATE_FORMATS_SIZE; ++i) {
            try {
                return DATE_FORMATS[i].parse(value, 0, hi, DateFormatUtils.enLocale);
            }
            catch (NumericException numericException) {
                continue;
            }
        }
        return Numbers.parseLong(value, 0, hi);
    }

    @Override
    public void clear() {
        this.namedVariables.clear();
        this.indexedVariables.clear();
        this.doubleVarPool.clear();
        this.floatVarPool.clear();
        this.intVarPool.clear();
        this.longVarPool.clear();
        this.timestampVarPool.clear();
        this.dateVarPool.clear();
        this.shortVarPool.clear();
        this.byteVarPool.clear();
        this.booleanVarPool.clear();
        this.strVarPool.clear();
        this.charVarPool.clear();
        this.long256VarPool.clear();
    }

    @Override
    public int define(int index, int type, int position) throws SqlException {
        switch (type) {
            case 0: {
                this.setBoolean(index);
                return type;
            }
            case 1: {
                this.setByte(index);
                return type;
            }
            case 2: {
                this.setShort(index);
                return type;
            }
            case 3: {
                this.setChar(index);
                return type;
            }
            case 4: {
                this.setInt(index);
                return type;
            }
            case 5: {
                this.setLong(index);
                return type;
            }
            case 6: {
                this.setDate(index);
                return type;
            }
            case 7: {
                this.setTimestamp(index);
                return type;
            }
            case 8: {
                this.setFloat(index);
                return type;
            }
            case 9: {
                this.setDouble(index);
                return type;
            }
            case 10: 
            case 11: 
            case 16: {
                this.setStr(index);
                return 10;
            }
            case 12: {
                this.setLong256(index);
                return type;
            }
            case 13: {
                this.setBin(index);
                return type;
            }
        }
        throw SqlException.$(position, "bind variable cannot be used [contextType=").put(ColumnType.nameOf(type)).put(", index=").put(index).put(']');
    }

    @Override
    public Function getFunction(CharSequence name) {
        assert (name != null);
        assert (Chars.startsWith(name, ':'));
        return this.namedVariables.valueAt(this.namedVariables.keyIndex(name, 1, name.length()));
    }

    @Override
    public Function getFunction(int index) {
        int n = this.indexedVariables.size();
        if (index < n) {
            return this.indexedVariables.getQuick(index);
        }
        return null;
    }

    @Override
    public int getIndexedVariableCount() {
        return this.indexedVariables.size();
    }

    @Override
    public void setBin(CharSequence name, BinarySequence value) throws SqlException {
        int index = this.namedVariables.keyIndex(name);
        if (index > -1) {
            this.namedVariables.putAt(index, name, new BinBindVariable(value));
        } else {
            Function function = this.namedVariables.valueAtQuick(index);
            if (function instanceof BinBindVariable) {
                ((BinBindVariable)function).value = value;
            } else {
                throw SqlException.$(0, "bind variable '").put(name).put("' is already defined as ").put(ColumnType.nameOf(function.getType()));
            }
        }
    }

    @Override
    public void setBin(int index) throws SqlException {
        this.setBin(index, null);
    }

    @Override
    public void setBin(int index, BinarySequence value) throws SqlException {
        this.indexedVariables.extendPos(index + 1);
        Function function = this.indexedVariables.getQuick(index);
        if (function == null) {
            this.indexedVariables.setQuick(index, new BinBindVariable(value));
        } else if (function instanceof BinBindVariable) {
            ((BinBindVariable)function).value = value;
        } else {
            throw SqlException.$(0, "bind variable at ").put(index).put(" is already defined as ").put(ColumnType.nameOf(function.getType()));
        }
    }

    @Override
    public void setBoolean(CharSequence name, boolean value) throws SqlException {
        int index = this.namedVariables.keyIndex(name);
        if (index > -1) {
            BooleanBindVariable function = this.booleanVarPool.next();
            this.namedVariables.putAt(index, name, function);
            function.value = value;
        } else {
            BindVariableServiceImpl.setBoolean0(this.namedVariables.valueAtQuick(index), value, -1, name);
        }
    }

    @Override
    public void setBoolean(int index) throws SqlException {
        this.setBoolean(index, false);
    }

    @Override
    public void setBoolean(int index, boolean value) throws SqlException {
        this.indexedVariables.extendPos(index + 1);
        Function function = this.indexedVariables.getQuick(index);
        if (function != null) {
            BindVariableServiceImpl.setBoolean0(function, value, index, null);
        } else {
            function = this.booleanVarPool.next();
            this.indexedVariables.setQuick(index, function);
            ((BooleanBindVariable)function).value = value;
        }
    }

    @Override
    public void setByte(CharSequence name, byte value) throws SqlException {
        int index = this.namedVariables.keyIndex(name);
        if (index > -1) {
            ByteBindVariable function = this.byteVarPool.next();
            this.namedVariables.putAt(index, name, function);
            function.value = value;
        } else {
            BindVariableServiceImpl.setByte0(this.namedVariables.valueAtQuick(index), value, -1, name);
        }
    }

    @Override
    public void setByte(int index, byte value) throws SqlException {
        this.indexedVariables.extendPos(index + 1);
        Function function = this.indexedVariables.getQuick(index);
        if (function != null) {
            BindVariableServiceImpl.setByte0(function, value, index, null);
        } else {
            function = this.byteVarPool.next();
            this.indexedVariables.setQuick(index, function);
            ((ByteBindVariable)function).value = value;
        }
    }

    @Override
    public void setChar(CharSequence name, char value) throws SqlException {
        int index = this.namedVariables.keyIndex(name);
        if (index > -1) {
            CharBindVariable function = this.charVarPool.next();
            this.namedVariables.putAt(index, name, function);
            function.value = value;
        } else {
            BindVariableServiceImpl.setChar0(this.namedVariables.valueAtQuick(index), value, -1, name);
        }
    }

    @Override
    public void setChar(int index) throws SqlException {
        this.setChar(index, '\u0000');
    }

    @Override
    public void setChar(int index, char value) throws SqlException {
        this.indexedVariables.extendPos(index + 1);
        Function function = this.indexedVariables.getQuick(index);
        if (function != null) {
            BindVariableServiceImpl.setChar0(function, value, index, null);
        } else {
            function = this.charVarPool.next();
            this.indexedVariables.setQuick(index, function);
            ((CharBindVariable)function).value = value;
        }
    }

    @Override
    public void setDate(CharSequence name, long value) throws SqlException {
        int index = this.namedVariables.keyIndex(name);
        if (index > -1) {
            DateBindVariable function = this.dateVarPool.next();
            this.namedVariables.putAt(index, name, function);
            function.value = value;
        } else {
            BindVariableServiceImpl.setLong0(this.namedVariables.valueAtQuick(index), value, -1, name, 6);
        }
    }

    @Override
    public void setDate(int index) throws SqlException {
        this.setDate(index, Long.MIN_VALUE);
    }

    @Override
    public void setDate(int index, long value) throws SqlException {
        this.indexedVariables.extendPos(index + 1);
        Function function = this.indexedVariables.getQuick(index);
        if (function != null) {
            BindVariableServiceImpl.setLong0(function, value, index, null, 6);
        } else {
            function = this.dateVarPool.next();
            this.indexedVariables.setQuick(index, function);
            ((DateBindVariable)function).value = value;
        }
    }

    @Override
    public void setDouble(CharSequence name, double value) throws SqlException {
        int index = this.namedVariables.keyIndex(name);
        if (index > -1) {
            DoubleBindVariable function = this.doubleVarPool.next();
            this.namedVariables.putAt(index, name, function);
            function.value = value;
        } else {
            BindVariableServiceImpl.setDouble0(this.namedVariables.valueAtQuick(index), value, -1, name);
        }
    }

    @Override
    public void setDouble(int index) throws SqlException {
        this.setDouble(index, Double.NaN);
    }

    @Override
    public void setDouble(int index, double value) throws SqlException {
        this.indexedVariables.extendPos(index + 1);
        Function function = this.indexedVariables.getQuick(index);
        if (function != null) {
            BindVariableServiceImpl.setDouble0(function, value, index, null);
        } else {
            function = this.doubleVarPool.next();
            this.indexedVariables.setQuick(index, function);
            ((DoubleBindVariable)function).value = value;
        }
    }

    @Override
    public void setFloat(CharSequence name, float value) throws SqlException {
        int index = this.namedVariables.keyIndex(name);
        if (index > -1) {
            FloatBindVariable function = this.floatVarPool.next();
            this.namedVariables.putAt(index, name, function);
            function.value = value;
        } else {
            BindVariableServiceImpl.setFloat0(this.namedVariables.valueAtQuick(index), value, -1, name);
        }
    }

    @Override
    public void setFloat(int index) throws SqlException {
        this.setFloat(index, Float.NaN);
    }

    @Override
    public void setFloat(int index, float value) throws SqlException {
        this.indexedVariables.extendPos(index + 1);
        Function function = this.indexedVariables.getQuick(index);
        if (function != null) {
            BindVariableServiceImpl.setFloat0(function, value, index, null);
        } else {
            function = this.floatVarPool.next();
            this.indexedVariables.setQuick(index, function);
            ((FloatBindVariable)function).value = value;
        }
    }

    @Override
    public void setInt(CharSequence name, int value) throws SqlException {
        int index = this.namedVariables.keyIndex(name);
        if (index > -1) {
            IntBindVariable function = this.intVarPool.next();
            this.namedVariables.putAt(index, name, function);
            function.value = value;
        } else {
            BindVariableServiceImpl.setInt0(this.namedVariables.valueAtQuick(index), value, -1, name);
        }
    }

    @Override
    public void setInt(int index) throws SqlException {
        this.setInt(index, Integer.MIN_VALUE);
    }

    @Override
    public void setInt(int index, int value) throws SqlException {
        this.indexedVariables.extendPos(index + 1);
        Function function = this.indexedVariables.getQuick(index);
        if (function != null) {
            BindVariableServiceImpl.setInt0(function, value, index, null);
        } else {
            function = this.intVarPool.next();
            this.indexedVariables.setQuick(index, function);
            ((IntBindVariable)function).value = value;
        }
    }

    @Override
    public void setLong(CharSequence name, long value) throws SqlException {
        int index = this.namedVariables.keyIndex(name);
        if (index > -1) {
            LongBindVariable function = this.longVarPool.next();
            this.namedVariables.putAt(index, name, function);
            function.value = value;
        } else {
            BindVariableServiceImpl.setLong0(this.namedVariables.valueAtQuick(index), value, -1, name, 5);
        }
    }

    @Override
    public void setLong(int index) throws SqlException {
        this.setLong(index, Long.MIN_VALUE);
    }

    @Override
    public void setLong(int index, long value) throws SqlException {
        this.indexedVariables.extendPos(index + 1);
        Function function = this.indexedVariables.getQuick(index);
        if (function != null) {
            BindVariableServiceImpl.setLong0(function, value, index, null, 5);
        } else {
            function = this.longVarPool.next();
            this.indexedVariables.setQuick(index, function);
            ((LongBindVariable)function).value = value;
        }
    }

    @Override
    public void setLong256(CharSequence name, long l0, long l1, long l2, long l3) throws SqlException {
        int index = this.namedVariables.keyIndex(name);
        if (index > -1) {
            Long256BindVariable function = this.long256VarPool.next();
            this.namedVariables.putAt(index, name, function);
            function.value.setAll(l0, l1, l2, l3);
        } else {
            BindVariableServiceImpl.setLong2560(this.namedVariables.valueAtQuick(index), l0, l1, l2, l3, -1, name);
        }
    }

    @Override
    public void setLong256(CharSequence name, Long256 value) throws SqlException {
        int index = this.namedVariables.keyIndex(name);
        if (index > -1) {
            Long256BindVariable function = this.long256VarPool.next();
            this.namedVariables.putAt(index, name, function);
            function.value.copyFrom(value);
        } else {
            BindVariableServiceImpl.setLong2560(this.namedVariables.valueAtQuick(index), value.getLong0(), value.getLong1(), value.getLong2(), value.getLong3(), -1, name);
        }
    }

    @Override
    public void setLong256(int index) throws SqlException {
        this.setLong256(index, Long.MIN_VALUE, Long.MIN_VALUE, Long.MIN_VALUE, Long.MIN_VALUE);
    }

    @Override
    public void setLong256(int index, long l0, long l1, long l2, long l3) throws SqlException {
        this.indexedVariables.extendPos(index + 1);
        Function function = this.indexedVariables.getQuick(index);
        if (function != null) {
            BindVariableServiceImpl.setLong2560(function, l0, l1, l2, l3, index, null);
        } else {
            function = this.long256VarPool.next();
            this.indexedVariables.setQuick(index, function);
            ((Long256BindVariable)function).setValue(l0, l1, l2, l3);
        }
    }

    @Override
    public void setLong256(CharSequence name) throws SqlException {
        this.setLong256(name, Long256Impl.NULL_LONG256);
    }

    @Override
    public void setShort(int index) throws SqlException {
        this.setShort(index, (short)0);
    }

    @Override
    public void setShort(int index, short value) throws SqlException {
        this.indexedVariables.extendPos(index + 1);
        Function function = this.indexedVariables.getQuick(index);
        if (function != null) {
            BindVariableServiceImpl.setShort0(function, value, index, null);
        } else {
            function = this.shortVarPool.next();
            this.indexedVariables.setQuick(index, function);
            ((ShortBindVariable)function).value = value;
        }
    }

    @Override
    public void setShort(CharSequence name, short value) throws SqlException {
        int index = this.namedVariables.keyIndex(name);
        if (index > -1) {
            ShortBindVariable function = this.shortVarPool.next();
            this.namedVariables.putAt(index, name, function);
            function.value = value;
        } else {
            BindVariableServiceImpl.setShort0(this.namedVariables.valueAtQuick(index), value, -1, name);
        }
    }

    @Override
    public void setStr(int index) throws SqlException {
        this.setStr(index, null);
    }

    @Override
    public void setStr(int index, CharSequence value) throws SqlException {
        this.indexedVariables.extendPos(index + 1);
        Function function = this.indexedVariables.getQuick(index);
        if (function != null) {
            BindVariableServiceImpl.setStr0(function, value, index, null);
        } else {
            function = this.strVarPool.next();
            this.indexedVariables.setQuick(index, function);
            ((StrBindVariable)function).setValue(value);
        }
    }

    @Override
    public void setStr(CharSequence name, CharSequence value) throws SqlException {
        int index = this.namedVariables.keyIndex(name);
        if (index > -1) {
            StrBindVariable function = this.strVarPool.next();
            this.namedVariables.putAt(index, name, function);
            function.setValue(value);
        } else {
            BindVariableServiceImpl.setStr0(this.namedVariables.valueAtQuick(index), value, -1, name);
        }
    }

    @Override
    public void setTimestamp(int index) throws SqlException {
        this.setTimestamp(index, Long.MIN_VALUE);
    }

    @Override
    public void setTimestamp(int index, long value) throws SqlException {
        this.indexedVariables.extendPos(index + 1);
        Function function = this.indexedVariables.getQuick(index);
        if (function != null) {
            BindVariableServiceImpl.setTimestamp0(function, value, index);
        } else {
            function = this.timestampVarPool.next();
            this.indexedVariables.setQuick(index, function);
            ((TimestampBindVariable)function).value = value;
        }
    }

    @Override
    public void setTimestamp(CharSequence name, long value) throws SqlException {
        int index = this.namedVariables.keyIndex(name);
        if (index > -1) {
            TimestampBindVariable function = this.timestampVarPool.next();
            this.namedVariables.putAt(index, name, function);
            function.value = value;
        } else {
            BindVariableServiceImpl.setLong0(this.namedVariables.valueAtQuick(index), value, -1, name, 7);
        }
    }

    @Override
    public void setByte(int index) throws SqlException {
        this.setByte(index, (byte)0);
    }

    private static long parseTimestamp(CharSequence value) throws NumericException {
        int hi = value.length();
        for (int i = 0; i < TIMESTAMP_FORMATS_SIZE; ++i) {
            try {
                return TIMESTAMP_FORMATS[i].parse(value, 0, hi, DateFormatUtils.enLocale);
            }
            catch (NumericException numericException) {
                continue;
            }
        }
        return IntervalUtils.parseFloorPartialDate(value);
    }

    private static void reportError(Function function, int srcType, int index, @Nullable CharSequence name) throws SqlException {
        if (name == null) {
            throw SqlException.$(0, "bind variable at ").put(index).put(" is defined as ").put(ColumnType.nameOf(function.getType())).put(" and cannot accept ").put(ColumnType.nameOf(srcType));
        }
        throw SqlException.$(0, "bind variable '").put(name).put("' is defined as ").put(ColumnType.nameOf(function.getType())).put(" and cannot accept ").put(ColumnType.nameOf(srcType));
    }

    private static void setDouble0(Function function, double value, int index, @Nullable CharSequence name) throws SqlException {
        int functionType = function.getType();
        switch (functionType) {
            case 9: {
                ((DoubleBindVariable)function).value = value;
                break;
            }
            case 10: {
                if (value == value) {
                    ((StrBindVariable)function).setValue(value);
                    break;
                }
                ((StrBindVariable)function).setValue(null);
                break;
            }
            default: {
                BindVariableServiceImpl.reportError(function, 9, index, name);
            }
        }
    }

    private static void setFloat0(Function function, float value, int index, @Nullable CharSequence name) throws SqlException {
        int functionType = function.getType();
        switch (functionType) {
            case 8: {
                ((FloatBindVariable)function).value = value;
                break;
            }
            case 9: {
                ((DoubleBindVariable)function).value = value;
                break;
            }
            case 10: {
                if (value == value) {
                    ((StrBindVariable)function).setValue(value);
                    break;
                }
                ((StrBindVariable)function).setValue(null);
                break;
            }
            default: {
                BindVariableServiceImpl.reportError(function, 8, index, name);
            }
        }
    }

    private static void setInt0(Function function, int value, int index, @Nullable CharSequence name) throws SqlException {
        int functionType = function.getType();
        switch (functionType) {
            case 4: {
                ((IntBindVariable)function).value = value;
                break;
            }
            case 5: {
                ((LongBindVariable)function).value = value != Integer.MIN_VALUE ? (long)value : Long.MIN_VALUE;
                break;
            }
            case 7: {
                ((TimestampBindVariable)function).value = value != Integer.MIN_VALUE ? (long)value : Long.MIN_VALUE;
                break;
            }
            case 6: {
                ((DateBindVariable)function).value = value != Integer.MIN_VALUE ? (long)value : Long.MIN_VALUE;
                break;
            }
            case 8: {
                ((FloatBindVariable)function).value = value != Integer.MIN_VALUE ? (float)value : Float.NaN;
                break;
            }
            case 9: {
                ((DoubleBindVariable)function).value = value != Integer.MIN_VALUE ? (double)value : Double.NaN;
                break;
            }
            case 10: {
                ((StrBindVariable)function).setValue(value);
                break;
            }
            default: {
                BindVariableServiceImpl.reportError(function, 4, index, name);
            }
        }
    }

    private static void setLong0(Function function, long value, int index, @Nullable CharSequence name, int srcType) throws SqlException {
        int functionType = function.getType();
        switch (functionType) {
            case 4: {
                ((IntBindVariable)function).value = (int)value;
                break;
            }
            case 5: {
                ((LongBindVariable)function).value = value;
                break;
            }
            case 7: {
                ((TimestampBindVariable)function).value = value;
                break;
            }
            case 6: {
                ((DateBindVariable)function).value = value;
                break;
            }
            case 8: {
                ((FloatBindVariable)function).value = value != Long.MIN_VALUE ? (float)value : Float.NaN;
                break;
            }
            case 9: {
                ((DoubleBindVariable)function).value = value != Long.MIN_VALUE ? (double)value : Double.NaN;
                break;
            }
            case 10: {
                ((StrBindVariable)function).setValue(value);
                break;
            }
            default: {
                BindVariableServiceImpl.reportError(function, srcType, index, name);
            }
        }
    }

    private static void setTimestamp0(Function function, long value, int index) throws SqlException {
        int functionType = function.getType();
        switch (functionType) {
            case 4: {
                ((IntBindVariable)function).value = (int)value;
                break;
            }
            case 5: {
                ((LongBindVariable)function).value = value;
                break;
            }
            case 7: {
                ((TimestampBindVariable)function).value = value;
                break;
            }
            case 6: {
                ((DateBindVariable)function).value = value != Long.MIN_VALUE ? value / 1000L : value;
                break;
            }
            case 8: {
                ((FloatBindVariable)function).value = value != Long.MIN_VALUE ? (float)value : Float.NaN;
                break;
            }
            case 9: {
                ((DoubleBindVariable)function).value = value != Long.MIN_VALUE ? (double)value : Double.NaN;
                break;
            }
            case 10: {
                ((StrBindVariable)function).setValue(value);
                break;
            }
            default: {
                BindVariableServiceImpl.reportError(function, 7, index, null);
            }
        }
    }

    private static void setBoolean0(Function function, boolean value, int index, @Nullable CharSequence name) throws SqlException {
        int functionType = function.getType();
        switch (functionType) {
            case 0: {
                ((BooleanBindVariable)function).value = value;
                break;
            }
            case 10: {
                ((StrBindVariable)function).setValue(Boolean.toString(value));
                break;
            }
            default: {
                BindVariableServiceImpl.reportError(function, 0, index, name);
            }
        }
    }

    private static void setChar0(Function function, char value, int index, @Nullable CharSequence name) throws SqlException {
        int functionType = function.getType();
        switch (functionType) {
            case 3: {
                ((CharBindVariable)function).value = value;
                break;
            }
            case 10: {
                ((StrBindVariable)function).setValue(value);
                break;
            }
            default: {
                BindVariableServiceImpl.reportError(function, 3, index, name);
            }
        }
    }

    private static void setLong2560(Function function, long l0, long l1, long l2, long l3, int index, @Nullable CharSequence name) throws SqlException {
        int functionType = function.getType();
        switch (functionType) {
            case 12: {
                ((Long256BindVariable)function).setValue(l0, l1, l2, l3);
                break;
            }
            case 10: {
                ((StrBindVariable)function).setValue(l0, l1, l2, l3);
                break;
            }
            default: {
                BindVariableServiceImpl.reportError(function, 12, index, name);
            }
        }
    }

    private static void setShort0(Function function, short value, int index, @Nullable CharSequence name) throws SqlException {
        int functionType = function.getType();
        switch (functionType) {
            case 2: {
                ((ShortBindVariable)function).value = value;
                break;
            }
            case 4: {
                ((IntBindVariable)function).value = value;
                break;
            }
            case 5: {
                ((LongBindVariable)function).value = value;
                break;
            }
            case 7: {
                ((TimestampBindVariable)function).value = value;
                break;
            }
            case 6: {
                ((DateBindVariable)function).value = value;
                break;
            }
            case 8: {
                ((FloatBindVariable)function).value = value;
                break;
            }
            case 9: {
                ((DoubleBindVariable)function).value = value;
                break;
            }
            case 10: {
                ((StrBindVariable)function).setValue(value);
                break;
            }
            case 1: {
                ((ByteBindVariable)function).value = (byte)value;
                break;
            }
            case 3: {
                ((CharBindVariable)function).value = (char)value;
                break;
            }
            default: {
                BindVariableServiceImpl.reportError(function, 2, index, name);
            }
        }
    }

    private static void setByte0(Function function, byte value, int index, @Nullable CharSequence name) throws SqlException {
        int functionType = function.getType();
        switch (functionType) {
            case 1: {
                ((ByteBindVariable)function).value = value;
                break;
            }
            case 2: {
                ((ShortBindVariable)function).value = value;
                break;
            }
            case 4: {
                ((IntBindVariable)function).value = value;
                break;
            }
            case 5: {
                ((LongBindVariable)function).value = value;
                break;
            }
            case 7: {
                ((TimestampBindVariable)function).value = value;
                break;
            }
            case 6: {
                ((DateBindVariable)function).value = value;
                break;
            }
            case 8: {
                ((FloatBindVariable)function).value = value;
                break;
            }
            case 9: {
                ((DoubleBindVariable)function).value = value;
                break;
            }
            case 10: {
                ((StrBindVariable)function).setValue(value);
                break;
            }
            default: {
                BindVariableServiceImpl.reportError(function, 1, index, name);
            }
        }
    }

    private static void setStr0(Function function, CharSequence value, int index, @Nullable CharSequence name) throws SqlException {
        int functionType = function.getType();
        try {
            switch (functionType) {
                case 0: {
                    ((BooleanBindVariable)function).value = SqlKeywords.isTrueKeyword(value);
                    break;
                }
                case 1: {
                    ((ByteBindVariable)function).value = (byte)Numbers.parseShort(value);
                    break;
                }
                case 2: {
                    ((ShortBindVariable)function).value = Numbers.parseShort(value);
                    break;
                }
                case 3: {
                    ((CharBindVariable)function).value = (char)(Chars.nonEmpty(value) ? Numbers.parseShort(value) : (short)0);
                    break;
                }
                case 4: {
                    ((IntBindVariable)function).value = value != null ? Numbers.parseInt(value) : Integer.MIN_VALUE;
                    break;
                }
                case 5: {
                    ((LongBindVariable)function).value = value != null ? Numbers.parseLong(value) : Long.MIN_VALUE;
                    break;
                }
                case 7: {
                    ((TimestampBindVariable)function).value = value != null ? BindVariableServiceImpl.parseTimestamp(value) : Long.MIN_VALUE;
                    break;
                }
                case 6: {
                    ((DateBindVariable)function).value = value != null ? BindVariableServiceImpl.parseDate(value) : Long.MIN_VALUE;
                    break;
                }
                case 8: {
                    ((FloatBindVariable)function).value = value != null ? Numbers.parseFloat(value) : Float.NaN;
                    break;
                }
                case 9: {
                    ((DoubleBindVariable)function).value = value != null ? Numbers.parseDouble(value) : Double.NaN;
                    break;
                }
                case 10: {
                    ((StrBindVariable)function).setValue(value);
                    break;
                }
                case 12: {
                    if (value != null) {
                        Long256FromCharSequenceDecoder.decode(value, 0, value.length(), ((Long256BindVariable)function).value);
                        break;
                    }
                    ((Long256BindVariable)function).value.copyFrom(Long256Impl.NULL_LONG256);
                    break;
                }
                default: {
                    BindVariableServiceImpl.reportError(function, 10, index, name);
                    break;
                }
            }
        }
        catch (NumericException e) {
            throw SqlException.$(0, "could not parse [value='").put(value).put("', as=").put(ColumnType.nameOf(functionType)).put(", index=").put(index).put(']');
        }
    }

    static {
        DateFormatCompiler milliCompiler = new DateFormatCompiler();
        DateFormat pgDateTimeFormat = milliCompiler.compile("yyyy-MM-dd HH:mm:ssz");
        DATE_FORMATS = new DateFormat[]{pgDateTimeFormat, DateFormatUtils.PG_DATE_Z_FORMAT, DateFormatUtils.PG_DATE_MILLI_TIME_Z_FORMAT, DateFormatUtils.UTC_FORMAT};
        DATE_FORMATS_SIZE = DATE_FORMATS.length;
        TIMESTAMP_FORMATS = new DateFormat[]{DateFormatUtils.PG_DATE_Z_FORMAT, DateFormatUtils.PG_DATE_MILLI_TIME_Z_FORMAT, pgDateTimeFormat};
        TIMESTAMP_FORMATS_SIZE = TIMESTAMP_FORMATS.length;
    }
}

