/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.bind;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.ScalarFunction;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.BinarySequence;
import io.questdb.std.Long256;
import io.questdb.std.Misc;
import io.questdb.std.str.CharSink;

public class NamedParameterLinkFunction
implements ScalarFunction {
    private final String variableName;
    private final int type;
    private final int position;
    private Function base;

    public NamedParameterLinkFunction(String variableName, int type, int position) {
        this.variableName = variableName;
        this.type = type;
        this.position = position;
    }

    @Override
    public void close() {
        this.base = Misc.free(this.base);
    }

    @Override
    public char getChar(Record rec) {
        return this.getBase().getChar(rec);
    }

    @Override
    public BinarySequence getBin(Record rec) {
        return this.getBase().getBin(rec);
    }

    @Override
    public long getBinLen(Record rec) {
        return this.getBase().getBinLen(rec);
    }

    @Override
    public boolean getBool(Record rec) {
        return this.getBase().getBool(rec);
    }

    @Override
    public byte getByte(Record rec) {
        return this.getBase().getByte(rec);
    }

    @Override
    public long getDate(Record rec) {
        return this.getBase().getDate(rec);
    }

    @Override
    public double getDouble(Record rec) {
        return this.getBase().getDouble(rec);
    }

    @Override
    public float getFloat(Record rec) {
        return this.getBase().getFloat(rec);
    }

    @Override
    public int getInt(Record rec) {
        return this.getBase().getInt(rec);
    }

    @Override
    public long getLong(Record rec) {
        return this.getBase().getLong(rec);
    }

    @Override
    public Long256 getLong256A(Record rec) {
        return this.getBase().getLong256A(rec);
    }

    @Override
    public Long256 getLong256B(Record rec) {
        return this.getBase().getLong256B(rec);
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public RecordCursorFactory getRecordCursorFactory() {
        return this.getBase().getRecordCursorFactory();
    }

    @Override
    public short getShort(Record rec) {
        return this.getBase().getShort(rec);
    }

    @Override
    public CharSequence getStr(Record rec) {
        return this.getBase().getStr(rec);
    }

    @Override
    public void getStr(Record rec, CharSink sink) {
        this.getBase().getStr(rec, sink);
    }

    @Override
    public CharSequence getStrB(Record rec) {
        return this.getBase().getStrB(rec);
    }

    @Override
    public int getStrLen(Record rec) {
        return this.getBase().getStrLen(rec);
    }

    @Override
    public CharSequence getSymbol(Record rec) {
        return this.getBase().getSymbol(rec);
    }

    @Override
    public CharSequence getSymbolB(Record rec) {
        return this.getBase().getSymbolB(rec);
    }

    @Override
    public long getTimestamp(Record rec) {
        return this.getBase().getTimestamp(rec);
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void getLong256(Record rec, CharSink sink) {
        this.getBase().getLong256(rec, sink);
    }

    @Override
    public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
        this.base = executionContext.getBindVariableService().getFunction(this.variableName);
        if (this.base == null) {
            throw CairoException.instance(0).put("undefined bind variable: ").put(this.variableName);
        }
        assert (this.base.getType() == this.type);
        this.base.init(symbolTableSource, executionContext);
    }

    private Function getBase() {
        assert (this.base != null);
        return this.base;
    }
}

