/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.bool;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.std.CharSequenceHashSet;
import io.questdb.std.ObjList;

public class AllNotEqStrFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "<>all(Ss[])";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function arrayFunction = args.getQuick(1);
        int arraySize = arrayFunction.getArrayLength();
        if (arraySize == 0) {
            return new BooleanConstant(position, true);
        }
        CharSequenceHashSet set = new CharSequenceHashSet();
        for (int i = 0; i < arraySize; ++i) {
            set.add(arrayFunction.getStr(null, i));
        }
        Function var = args.getQuick(0);
        if (var.isConstant()) {
            CharSequence str = var.getStr(null);
            return new BooleanConstant(position, str != null && set.excludes(str));
        }
        return new AllNotEqualStrFunction(position, var, set);
    }

    private static class AllNotEqualStrFunction
    extends BooleanFunction
    implements UnaryFunction {
        private final Function arg;
        private final CharSequenceHashSet set;

        private AllNotEqualStrFunction(int position, Function arg, CharSequenceHashSet set) {
            super(position);
            this.arg = arg;
            this.set = set;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            CharSequence str = this.arg.getStr(rec);
            return str != null && this.set.excludes(str);
        }
    }
}

