/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.bool;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.griffin.engine.functions.TernaryFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.std.ObjList;

public class BetweenTimestampFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "between(NNN)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function arg = args.getQuick(0);
        Function fromFn = args.getQuick(1);
        Function toFn = args.getQuick(2);
        if (fromFn.isConstant() && toFn.isConstant()) {
            long fromFnTimestamp = fromFn.getTimestamp(null);
            long toFnTimestamp = toFn.getTimestamp(null);
            if (fromFnTimestamp == Long.MIN_VALUE || toFnTimestamp == Long.MIN_VALUE) {
                return BooleanConstant.FALSE;
            }
            return new ConstFunc(position, arg, fromFnTimestamp, toFnTimestamp);
        }
        return new VarBetweenFunction(position, arg, fromFn, toFn);
    }

    private static class VarBetweenFunction
    extends NegatableBooleanFunction
    implements TernaryFunction {
        private final Function arg;
        private final Function from;
        private final Function to;

        public VarBetweenFunction(int position, Function left, Function from, Function to) {
            super(position);
            this.arg = left;
            this.from = from;
            this.to = to;
        }

        @Override
        public boolean getBool(Record rec) {
            long value = this.arg.getTimestamp(rec);
            if (value == Long.MIN_VALUE) {
                return false;
            }
            long fromTs = this.from.getTimestamp(rec);
            if (fromTs == Long.MIN_VALUE) {
                return false;
            }
            long toTs = this.to.getTimestamp(rec);
            if (toTs == Long.MIN_VALUE) {
                return false;
            }
            return Math.min(fromTs, toTs) <= value && value <= Math.max(fromTs, toTs);
        }

        @Override
        public Function getLeft() {
            return this.from;
        }

        @Override
        public Function getCenter() {
            return this.arg;
        }

        @Override
        public Function getRight() {
            return this.to;
        }
    }

    private static class ConstFunc
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final Function left;
        private final long from;
        private final long to;

        public ConstFunc(int position, Function left, long from, long to) {
            super(position);
            this.left = left;
            this.from = Math.min(from, to);
            this.to = Math.max(from, to);
        }

        @Override
        public boolean getBool(Record rec) {
            long timestamp = this.left.getTimestamp(rec);
            if (timestamp == Long.MIN_VALUE) {
                return false;
            }
            return this.from <= timestamp && timestamp <= this.to;
        }

        @Override
        public Function getArg() {
            return this.left;
        }
    }
}

