/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.bool;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.std.CharSequenceHashSet;
import io.questdb.std.Chars;
import io.questdb.std.IntHashSet;
import io.questdb.std.ObjList;

public class InSymbolCursorFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "in(KC)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Record.CharSequenceFunction func;
        SymbolFunction symbolFunction = (SymbolFunction)args.getQuick(0);
        Function cursorFunction = args.getQuick(1);
        int zeroColumnType = cursorFunction.getRecordCursorFactory().getMetadata().getColumnType(0);
        if (zeroColumnType != 10 && zeroColumnType != 11) {
            throw SqlException.position(position).put("supported column types are STRING and SYMBOL, found: ").put(ColumnType.nameOf(zeroColumnType));
        }
        Record.CharSequenceFunction charSequenceFunction = func = zeroColumnType == 10 ? Record.GET_STR : Record.GET_SYM;
        if (symbolFunction.getStaticSymbolTable() != null) {
            return new SymbolInCursorFunction(position, symbolFunction, cursorFunction, func);
        }
        return new StrInCursorFunction(position, symbolFunction, cursorFunction, func);
    }

    private static class StrInCursorFunction
    extends BooleanFunction
    implements BinaryFunction {
        private final Function valueArg;
        private final Function cursorArg;
        private final CharSequenceHashSet valueSetA = new CharSequenceHashSet();
        private final CharSequenceHashSet valueSetB = new CharSequenceHashSet();
        private final Record.CharSequenceFunction func;
        private CharSequenceHashSet valueSet;

        public StrInCursorFunction(int position, Function valueArg, Function cursorArg, Record.CharSequenceFunction func) {
            super(position);
            this.valueArg = valueArg;
            this.cursorArg = cursorArg;
            this.valueSet = this.valueSetA;
            this.func = func;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.valueSet.contains(this.valueArg.getSymbol(rec));
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
            this.valueArg.init(symbolTableSource, executionContext);
            this.cursorArg.init(symbolTableSource, executionContext);
            CharSequenceHashSet valueSet = this.valueSet == this.valueSetA ? this.valueSetB : this.valueSetA;
            valueSet.clear();
            RecordCursorFactory factory = this.cursorArg.getRecordCursorFactory();
            try (RecordCursor cursor = factory.getCursor(executionContext);){
                Record record = cursor.getRecord();
                while (cursor.hasNext()) {
                    CharSequence value = this.func.get(record, 0);
                    if (value == null) {
                        valueSet.addNull();
                        continue;
                    }
                    int toIndex = valueSet.keyIndex(value);
                    if (toIndex <= -1) continue;
                    int index = this.valueSet.keyIndex(value);
                    if (index < 0) {
                        valueSet.addAt(toIndex, this.valueSet.keyAt(index));
                        continue;
                    }
                    valueSet.addAt(toIndex, Chars.toString(value));
                }
            }
            this.valueSet = valueSet;
        }

        @Override
        public Function getLeft() {
            return this.valueArg;
        }

        @Override
        public Function getRight() {
            return this.cursorArg;
        }
    }

    private static class SymbolInCursorFunction
    extends BooleanFunction
    implements BinaryFunction {
        private final SymbolFunction valueArg;
        private final Function cursorArg;
        private final IntHashSet symbolKeys = new IntHashSet();
        private final Record.CharSequenceFunction func;

        public SymbolInCursorFunction(int position, SymbolFunction valueArg, Function cursorArg, Record.CharSequenceFunction func) {
            super(position);
            this.valueArg = valueArg;
            this.cursorArg = cursorArg;
            this.func = func;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.symbolKeys.keyIndex(this.valueArg.getInt(rec) + 1) < 0;
        }

        @Override
        public Function getLeft() {
            return this.valueArg;
        }

        @Override
        public Function getRight() {
            return this.cursorArg;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
            this.valueArg.init(symbolTableSource, executionContext);
            this.cursorArg.init(symbolTableSource, executionContext);
            this.symbolKeys.clear();
            StaticSymbolTable symbolTable = this.valueArg.getStaticSymbolTable();
            assert (symbolTable != null);
            RecordCursorFactory factory = this.cursorArg.getRecordCursorFactory();
            try (RecordCursor cursor = factory.getCursor(executionContext);){
                Record record = cursor.getRecord();
                while (cursor.hasNext()) {
                    int key = symbolTable.keyOf(this.func.get(record, 0));
                    if (key == -2) continue;
                    this.symbolKeys.add(key + 1);
                }
            }
        }
    }
}

