/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.bool;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.model.IntervalUtils;
import io.questdb.std.LongList;
import io.questdb.std.ObjList;

public class InTimestampStrFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "in(NS)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function rightFn = args.getQuick(1);
        if (rightFn.isConstant()) {
            return new EqTimestampStrConstantFunction(position, args.getQuick(0), rightFn.getStr(null), rightFn.getPosition());
        }
        return new EqTimestampStrFunction(position, args.getQuick(0), rightFn);
    }

    private static void parseAndApplyIntervalEx(CharSequence seq, LongList out, int position) throws SqlException {
        IntervalUtils.parseIntervalEx(seq, 0, seq.length(), position, out, (short)1);
        IntervalUtils.applyLastEncodedIntervalEx(out);
    }

    private static class EqTimestampStrFunction
    extends NegatableBooleanFunction
    implements BinaryFunction {
        private final Function left;
        private final Function right;
        private final LongList intervals = new LongList();

        public EqTimestampStrFunction(int position, Function left, Function right) {
            super(position);
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean getBool(Record rec) {
            CharSequence timestampAsString = this.right.getStr(rec);
            this.intervals.clear();
            try {
                InTimestampStrFunctionFactory.parseAndApplyIntervalEx(timestampAsString, this.intervals, this.right.getPosition());
            }
            catch (SqlException e) {
                return false;
            }
            return this.negated != IntervalUtils.isInIntervals(this.intervals, this.left.getTimestamp(rec));
        }

        @Override
        public Function getLeft() {
            return this.left;
        }

        @Override
        public Function getRight() {
            return this.right;
        }
    }

    private static class EqTimestampStrConstantFunction
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final Function left;
        private final LongList intervals = new LongList();

        public EqTimestampStrConstantFunction(int position, Function left, CharSequence right, int rightPosition) throws SqlException {
            super(position);
            this.left = left;
            InTimestampStrFunctionFactory.parseAndApplyIntervalEx(right, this.intervals, rightPosition);
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != IntervalUtils.isInIntervals(this.intervals, this.left.getTimestamp(rec));
        }

        @Override
        public Function getArg() {
            return this.left;
        }
    }
}

