/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.bool;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.MultiArgFunction;
import io.questdb.griffin.model.IntervalUtils;
import io.questdb.std.LongList;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;

public class InTimestampTimestampFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "in(NV)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        boolean allConst = true;
        int n = args.size();
        for (int i = 1; i < n; ++i) {
            Function func = args.getQuick(i);
            switch (func.getType()) {
                case 4: 
                case 5: 
                case 7: 
                case 10: {
                    break;
                }
                default: {
                    throw SqlException.position(0).put("cannot compare TIMESTAMP with type ").put(ColumnType.nameOf(func.getType()));
                }
            }
            if (func.isConstant()) continue;
            allConst = false;
            break;
        }
        if (allConst) {
            return new InTimestampConstFunction(position, args.getQuick(0), this.parseToTs(args));
        }
        return new InTimestampVarFunction(position, new ObjList<Function>(args));
    }

    private LongList parseToTs(ObjList<Function> args) throws SqlException {
        LongList res = new LongList(args.size() - 1);
        res.extendAndSet(args.size() - 2, 0L);
        int n = args.size();
        for (int i = 1; i < n; ++i) {
            Function func = args.getQuick(i);
            long val = Long.MIN_VALUE;
            switch (func.getType()) {
                case 4: 
                case 5: 
                case 7: {
                    val = func.getTimestamp(null);
                    break;
                }
                case 10: {
                    CharSequence tsValue = func.getStr(null);
                    val = tsValue != null ? InTimestampTimestampFunctionFactory.tryParseTimestamp(tsValue, func.getPosition()) : Long.MIN_VALUE;
                }
            }
            res.setQuick(i - 1, val);
        }
        res.sort();
        return res;
    }

    public static long tryParseTimestamp(CharSequence seq, int position) throws SqlException {
        try {
            return IntervalUtils.parseFloorPartialDate(seq, 0, seq.length());
        }
        catch (NumericException e) {
            throw SqlException.invalidDate(position);
        }
    }

    private static class InTimestampConstFunction
    extends BooleanFunction {
        private final Function tsFunc;
        private final LongList inList;

        public InTimestampConstFunction(int position, Function tsFunc, LongList longList) {
            super(position);
            this.tsFunc = tsFunc;
            this.inList = longList;
        }

        @Override
        public boolean getBool(Record rec) {
            long ts = this.tsFunc.getTimestamp(rec);
            if (ts == Long.MIN_VALUE) {
                return false;
            }
            return this.inList.binarySearch(ts) >= 0;
        }
    }

    private static class InTimestampVarFunction
    extends BooleanFunction
    implements MultiArgFunction {
        private final ObjList<Function> args;

        public InTimestampVarFunction(int position, ObjList<Function> args) {
            super(position);
            this.args = args;
        }

        @Override
        public ObjList<Function> getArgs() {
            return this.args;
        }

        @Override
        public boolean getBool(Record rec) {
            long ts = this.args.getQuick(0).getTimestamp(rec);
            if (ts == Long.MIN_VALUE) {
                return false;
            }
            int n = this.args.size();
            for (int i = 1; i < n; ++i) {
                Function func = this.args.getQuick(i);
                long val = Long.MIN_VALUE;
                switch (func.getType()) {
                    case 4: 
                    case 5: 
                    case 7: {
                        val = func.getTimestamp(rec);
                        break;
                    }
                    case 10: {
                        CharSequence str = func.getStr(rec);
                        long l = val = str != null ? IntervalUtils.tryParseTimestamp(str) : Long.MIN_VALUE;
                    }
                }
                if (val != ts) continue;
                return true;
            }
            return false;
        }
    }
}

