/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.Long256Function;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.Long256;
import io.questdb.std.Long256Impl;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;

public class CastBooleanToLong256FunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Th)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new Func(position, args.getQuick(0));
    }

    private static class Func
    extends Long256Function
    implements UnaryFunction {
        private final Function arg;
        private final Long256Impl long256a = new Long256Impl();
        private final Long256Impl long256b = new Long256Impl();

        public Func(int position, Function arg) {
            super(position);
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public Long256 getLong256A(Record rec) {
            this.long256a.setLong0(this.arg.getLong(rec));
            return this.long256a;
        }

        @Override
        public Long256 getLong256B(Record rec) {
            this.long256b.setLong0(this.arg.getLong(rec));
            return this.long256b;
        }

        @Override
        public void getLong256(Record rec, CharSink sink) {
            Numbers.appendLong256(this.arg.getLong(rec), 0L, 0L, 0L, sink);
        }
    }
}

