/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.StrConstant;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;

public class CastBooleanToStrFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Ts)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function func = args.getQuick(0);
        if (func.isConstant()) {
            return new StrConstant(position, func.getStr(null));
        }
        return new Func(position, args.getQuick(0));
    }

    private static class Func
    extends StrFunction
    implements UnaryFunction {
        private final Function arg;

        public Func(int position, Function arg) {
            super(position);
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public CharSequence getStr(Record rec) {
            return this.arg.getStr(rec);
        }

        @Override
        public CharSequence getStrB(Record rec) {
            return this.arg.getStrB(rec);
        }

        @Override
        public void getStr(Record rec, CharSink sink) {
            this.arg.getStr(rec, sink);
        }
    }
}

