/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.StrConstant;
import io.questdb.std.Chars;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.StringSink;

public class CastShortToStrFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Es)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function intFunc = args.getQuick(0);
        if (intFunc.isConstant()) {
            StringSink sink = Misc.getThreadLocalBuilder();
            sink.put(intFunc.getShort(null));
            return new StrConstant(position, Chars.toString(sink));
        }
        return new Func(position, args.getQuick(0));
    }

    private static class Func
    extends StrFunction
    implements UnaryFunction {
        private final Function arg;
        private final StringSink sinkA = new StringSink();
        private final StringSink sinkB = new StringSink();

        public Func(int position, Function arg) {
            super(position);
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public CharSequence getStr(Record rec) {
            this.sinkA.clear();
            this.sinkA.put(this.arg.getShort(rec));
            return this.sinkA;
        }

        @Override
        public CharSequence getStrB(Record rec) {
            this.sinkB.clear();
            this.sinkB.put(this.arg.getShort(rec));
            return this.sinkB;
        }

        @Override
        public void getStr(Record rec, CharSink sink) {
            sink.put(this.arg.getShort(rec));
        }
    }
}

