/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.AbstractUnaryTimestampFunction;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.microtime.TimestampFormatUtils;

public class CastSymbolToTimestampFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Kn)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new Func(position, args.getQuick(0));
    }

    private static class Func
    extends AbstractUnaryTimestampFunction {
        public Func(int position, Function arg) {
            super(position, arg);
        }

        @Override
        public long getTimestamp(Record rec) {
            CharSequence value = this.arg.getSymbol(rec);
            try {
                return value == null ? Long.MIN_VALUE : TimestampFormatUtils.parseUTCTimestamp(value);
            }
            catch (NumericException e) {
                return Long.MIN_VALUE;
            }
        }
    }
}

