/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.sql.DelegatingRecordImpl;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.CursorFunction;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Chars;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;
import io.questdb.std.str.NativeLPSZ;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractClassCatalogueFunctionFactory
implements FunctionFactory {
    private static final Log LOG = LogFactory.getLog(AbstractClassCatalogueFunctionFactory.class);
    private static final RecordMetadata METADATA;
    private static final String[] relNames;
    private static final int[] relNamespaces;
    private static final int[] oids;
    private static final char[] relkinds;
    private static final int[] relOwners;
    private static final int fixedClassLen;
    private static final int[][] intColumns;

    @Override
    public boolean isCursor() {
        return true;
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new CursorFunction(position, new ClassCatalogueCursorFactory(configuration, METADATA));
    }

    static {
        relNames = new String[]{"pg_class"};
        relNamespaces = new int[]{11};
        oids = new int[]{1259};
        relkinds = new char[]{'r'};
        relOwners = new int[]{0};
        fixedClassLen = relNames.length;
        intColumns = new int[][]{null, relNamespaces, null, relOwners, oids};
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("relname", 10, null));
        metadata.add(new TableColumnMetadata("relnamespace", 4, null));
        metadata.add(new TableColumnMetadata("relkind", 3, null));
        metadata.add(new TableColumnMetadata("relowner", 4, null));
        metadata.add(new TableColumnMetadata("oid", 4, null));
        metadata.add(new TableColumnMetadata("relpartbound", 10, null));
        METADATA = metadata;
    }

    private static class ClassCatalogueCursor
    implements NoRandomAccessRecordCursor {
        private final Path path;
        private final FilesFacade ff;
        private final DelegatingRecordImpl record = new DelegatingRecordImpl();
        private final DiskReadingRecord diskReadingRecord = new DiskReadingRecord();
        private final StaticReadingRecord staticReadingRecord = new StaticReadingRecord();
        private final NativeLPSZ nativeLPSZ = new NativeLPSZ();
        private final int plimit;
        private final int[] intValues = new int[5];
        private final long tempMem;
        private long findFileStruct = 0L;
        private int fixedRelPos = -1;

        public ClassCatalogueCursor(CairoConfiguration configuration, Path path, long tempMem) {
            this.ff = configuration.getFilesFacade();
            this.path = path;
            this.path.of(configuration.getRoot()).$();
            this.plimit = this.path.length();
            this.record.of(this.staticReadingRecord);
            this.intValues[1] = 2200;
            this.intValues[3] = 0;
            this.intValues[4] = 0;
            this.tempMem = tempMem;
        }

        @Override
        public void close() {
            if (this.findFileStruct != 0L) {
                this.ff.findClose(this.findFileStruct);
                this.findFileStruct = 0L;
            }
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public boolean hasNext() {
            if (++this.fixedRelPos < fixedClassLen) {
                return true;
            }
            this.record.of(this.diskReadingRecord);
            if (this.findFileStruct == 0L) {
                this.findFileStruct = this.ff.findFirst(this.path.trimTo(this.plimit).$());
                if (this.findFileStruct > 0L) {
                    return this.next0();
                }
                this.findFileStruct = 0L;
                return false;
            }
            if (this.ff.findNext(this.findFileStruct) > 0) {
                return this.next0();
            }
            return false;
        }

        @Override
        public void toTop() {
            if (this.findFileStruct != 0L) {
                this.ff.findClose(this.findFileStruct);
                this.findFileStruct = 0L;
            }
            this.fixedRelPos = -1;
            this.record.of(this.staticReadingRecord);
        }

        @Override
        public long size() {
            return -1L;
        }

        private boolean next0() {
            do {
                long pname = this.ff.findName(this.findFileStruct);
                this.nativeLPSZ.of(pname);
                if (this.ff.findType(this.findFileStruct) != 4 || !Chars.notDots(this.nativeLPSZ)) continue;
                this.path.trimTo(this.plimit);
                if (!this.ff.exists(this.path.concat(pname).concat("_meta").$())) continue;
                long fd = this.ff.openRO(this.path);
                if (fd > -1L) {
                    if (this.ff.read(fd, this.tempMem, 4L, 16L) == 4L) {
                        this.intValues[4] = Unsafe.getUnsafe().getInt(this.tempMem);
                        this.ff.close(fd);
                        return true;
                    }
                    LOG.error().$("Could not read table id [fd=").$(fd).$(", errno=").$(this.ff.errno()).$(']').$();
                    this.ff.close(fd);
                } else {
                    LOG.error().$("could not read metadata [file=").$(this.path).$(']').$();
                }
                this.intValues[4] = -1;
                return true;
            } while (this.ff.findNext(this.findFileStruct) > 0);
            this.ff.findClose(this.findFileStruct);
            this.findFileStruct = 0L;
            return false;
        }

        private class DiskReadingRecord
        implements Record {
            private final StringSink utf8SinkA = new StringSink();
            private final StringSink utf8SinkB = new StringSink();

            private DiskReadingRecord() {
            }

            @Override
            public char getChar(int col) {
                return 'r';
            }

            @Override
            public int getInt(int col) {
                return ClassCatalogueCursor.this.intValues[col];
            }

            @Override
            public CharSequence getStr(int col) {
                if (col == 0) {
                    return this.getName(this.utf8SinkA);
                }
                return null;
            }

            @Override
            public CharSequence getStrB(int col) {
                if (col == 0) {
                    return this.getName(this.utf8SinkB);
                }
                return null;
            }

            @Override
            public int getStrLen(int col) {
                if (col == 0) {
                    CharSequence cs = this.getStr(col);
                    return cs != null ? cs.length() : -1;
                }
                return -1;
            }

            @Nullable
            private CharSequence getName(StringSink utf8SinkA) {
                utf8SinkA.clear();
                if (Chars.utf8DecodeZ(ClassCatalogueCursor.this.ff.findName(ClassCatalogueCursor.this.findFileStruct), utf8SinkA)) {
                    return utf8SinkA;
                }
                return null;
            }
        }

        private class StaticReadingRecord
        implements Record {
            private StaticReadingRecord() {
            }

            @Override
            public char getChar(int col) {
                return relkinds[ClassCatalogueCursor.this.fixedRelPos];
            }

            @Override
            public int getInt(int col) {
                return intColumns[col][ClassCatalogueCursor.this.fixedRelPos];
            }

            @Override
            public CharSequence getStr(int col) {
                if (col == 0) {
                    return relNames[ClassCatalogueCursor.this.fixedRelPos];
                }
                return null;
            }

            @Override
            public CharSequence getStrB(int col) {
                return this.getStr(col);
            }

            @Override
            public int getStrLen(int col) {
                if (col == 0) {
                    return relNames[ClassCatalogueCursor.this.fixedRelPos].length();
                }
                return -1;
            }
        }
    }

    private static class ClassCatalogueCursorFactory
    extends AbstractRecordCursorFactory {
        private final Path path = new Path();
        private final ClassCatalogueCursor cursor;
        private final long tempMem = Unsafe.malloc(4L);

        public ClassCatalogueCursorFactory(CairoConfiguration configuration, RecordMetadata metadata) {
            super(metadata);
            this.cursor = new ClassCatalogueCursor(configuration, this.path, this.tempMem);
        }

        @Override
        public void close() {
            Misc.free(this.path);
            Unsafe.free(this.tempMem, 4L);
        }

        @Override
        public RecordCursor getCursor(SqlExecutionContext executionContext) {
            this.cursor.toTop();
            return this.cursor;
        }

        @Override
        public boolean recordCursorSupportsRandomAccess() {
            return false;
        }
    }
}

