/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.CursorFunction;
import io.questdb.griffin.engine.functions.catalogue.DescriptionCatalogueFunctionFactory;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Chars;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;
import io.questdb.std.str.NativeLPSZ;
import io.questdb.std.str.Path;

public class AttrDefCatalogueFunctionFactory
implements FunctionFactory {
    private static final Log LOG = LogFactory.getLog(DescriptionCatalogueFunctionFactory.class);
    static final RecordMetadata METADATA;

    @Override
    public String getSignature() {
        return "pg_catalog.pg_attrdef()";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new CursorFunction(position, new AttrDefCatalogueCursorFactory(configuration, METADATA));
    }

    static {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("adrelid", 4, null));
        metadata.add(new TableColumnMetadata("adnum", 2, null));
        metadata.add(new TableColumnMetadata("adbin", 10, null));
        METADATA = metadata;
    }

    private static class AttrDefCatalogueCursor
    implements NoRandomAccessRecordCursor {
        private final Path path;
        private final FilesFacade ff;
        private final DiskReadingRecord diskReadingRecord = new DiskReadingRecord();
        private final NativeLPSZ nativeLPSZ = new NativeLPSZ();
        private final int plimit;
        private final long tempMem;
        private int tableId = -1;
        private long findFileStruct = 0L;
        private int columnIndex = 0;
        private boolean readNextFileFromDisk = true;
        private int columnCount;
        private boolean hasNextFile = true;
        private boolean foundMetadataFile = false;

        public AttrDefCatalogueCursor(CairoConfiguration configuration, Path path, long tempMem) {
            this.ff = configuration.getFilesFacade();
            this.path = path;
            this.path.of(configuration.getRoot()).$();
            this.plimit = this.path.length();
            this.tempMem = tempMem;
        }

        @Override
        public void close() {
            if (this.findFileStruct != 0L) {
                this.ff.findClose(this.findFileStruct);
                this.findFileStruct = 0L;
            }
        }

        @Override
        public Record getRecord() {
            return this.diskReadingRecord;
        }

        @Override
        public boolean hasNext() {
            if (this.findFileStruct == 0L) {
                this.findFileStruct = this.ff.findFirst(this.path.trimTo(this.plimit).$());
                if (this.findFileStruct > 0L) {
                    return this.next0();
                }
                this.findFileStruct = 0L;
                return false;
            }
            return this.next0();
        }

        @Override
        public void toTop() {
            if (this.findFileStruct != 0L) {
                this.ff.findClose(this.findFileStruct);
                this.findFileStruct = 0L;
            }
        }

        @Override
        public long size() {
            return -1L;
        }

        private boolean next0() {
            do {
                if (this.readNextFileFromDisk) {
                    this.foundMetadataFile = false;
                    long pname = this.ff.findName(this.findFileStruct);
                    if (this.hasNextFile) {
                        this.nativeLPSZ.of(pname);
                        if (this.ff.findType(this.findFileStruct) == 4 && Chars.notDots(this.nativeLPSZ)) {
                            this.path.trimTo(this.plimit);
                            if (this.ff.exists(this.path.concat(pname).concat("_meta").$())) {
                                long fd = this.ff.openRO(this.path);
                                if (fd > -1L) {
                                    if (this.ff.read(fd, this.tempMem, 4L, 16L) == 4L) {
                                        this.tableId = Unsafe.getUnsafe().getInt(this.tempMem);
                                        if (this.ff.read(fd, this.tempMem, 4L, 0L) == 4L) {
                                            this.foundMetadataFile = true;
                                            this.columnCount = Unsafe.getUnsafe().getInt(this.tempMem);
                                        } else {
                                            LOG.error().$("Could not read column count [fd=").$(fd).$(", errno=").$(this.ff.errno()).$(']').$();
                                        }
                                    } else {
                                        LOG.error().$("Could not read table id [fd=").$(fd).$(", errno=").$(this.ff.errno()).$(']').$();
                                    }
                                    this.ff.close(fd);
                                } else {
                                    LOG.error().$("could not read metadata [file=").$(this.path).$(']').$();
                                }
                            }
                        }
                        boolean bl = this.hasNextFile = this.ff.findNext(this.findFileStruct) > 0;
                    }
                }
                if (!this.foundMetadataFile) continue;
                for (int i = 0; i < this.columnCount; ++i) {
                    if (this.columnIndex != i) continue;
                    this.diskReadingRecord.columnNumber = (short)(i + 1);
                    ++this.columnIndex;
                    if (this.columnIndex == this.columnCount) {
                        this.readNextFileFromDisk = true;
                        this.columnIndex = 0;
                    } else {
                        this.readNextFileFromDisk = false;
                    }
                    return true;
                }
            } while (this.hasNextFile);
            this.ff.findClose(this.findFileStruct);
            this.findFileStruct = 0L;
            this.hasNextFile = true;
            this.foundMetadataFile = false;
            this.tableId = -1;
            return false;
        }

        private class DiskReadingRecord
        implements Record {
            public short columnNumber = 0;

            private DiskReadingRecord() {
            }

            @Override
            public int getInt(int col) {
                return AttrDefCatalogueCursor.this.tableId;
            }

            @Override
            public short getShort(int col) {
                return this.columnNumber;
            }

            @Override
            public CharSequence getStr(int col) {
                return "";
            }

            @Override
            public CharSequence getStrB(int col) {
                return this.getStr(col);
            }

            @Override
            public int getStrLen(int col) {
                return this.getStr(col).length();
            }
        }
    }

    private static class AttrDefCatalogueCursorFactory
    extends AbstractRecordCursorFactory {
        private final Path path = new Path();
        private final AttrDefCatalogueCursor cursor;
        private final long tempMem = Unsafe.malloc(4L);

        public AttrDefCatalogueCursorFactory(CairoConfiguration configuration, RecordMetadata metadata) {
            super(metadata);
            this.cursor = new AttrDefCatalogueCursor(configuration, this.path, this.tempMem);
        }

        @Override
        public void close() {
            Misc.free(this.path);
            Unsafe.free(this.tempMem, 4L);
        }

        @Override
        public RecordCursor getCursor(SqlExecutionContext executionContext) {
            this.cursor.toTop();
            return this.cursor;
        }

        @Override
        public boolean recordCursorSupportsRandomAccess() {
            return false;
        }
    }
}

