/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.vm.MappedReadOnlyMemory;
import io.questdb.cairo.vm.SinglePageMappedReadOnlyPageMemory;
import io.questdb.cairo.vm.VmUtils;
import io.questdb.cutlass.pgwire.PGOids;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.CursorFunction;
import io.questdb.std.Chars;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.str.NativeLPSZ;
import io.questdb.std.str.Path;

public class AttributeCatalogueFunctionFactory
implements FunctionFactory {
    private static final RecordMetadata METADATA;

    @Override
    public String getSignature() {
        return "pg_catalog.pg_attribute()";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new CursorFunction(position, new AttributeCatalogueCursorFactory(configuration, METADATA));
    }

    static {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("attrelid", 4, null));
        metadata.add(new TableColumnMetadata("attname", 10, null));
        metadata.add(new TableColumnMetadata("attnum", 2, null));
        metadata.add(new TableColumnMetadata("atttypid", 4, null));
        metadata.add(new TableColumnMetadata("attnotnull", 0, null));
        metadata.add(new TableColumnMetadata("atttypmod", 4, null));
        metadata.add(new TableColumnMetadata("attlen", 2, null));
        metadata.add(new TableColumnMetadata("attidentity", 3, null));
        metadata.add(new TableColumnMetadata("attisdropped", 0, null));
        METADATA = metadata;
    }

    private static class AttributeClassCatalogueCursor
    implements NoRandomAccessRecordCursor {
        private final Path path;
        private final FilesFacade ff;
        private final DiskReadingRecord diskReadingRecord = new DiskReadingRecord();
        private final NativeLPSZ nativeLPSZ = new NativeLPSZ();
        private final int plimit;
        private final MappedReadOnlyMemory metaMem;
        private long findFileStruct = 0L;
        private int columnIndex = 0;
        private int tableId = 1000;
        private boolean readNextFileFromDisk = true;
        private int columnCount;
        private boolean hasNextFile = true;
        private boolean foundMetadataFile = false;

        public AttributeClassCatalogueCursor(CairoConfiguration configuration, Path path, MappedReadOnlyMemory metaMem) {
            this.ff = configuration.getFilesFacade();
            this.path = path;
            this.path.of(configuration.getRoot()).$();
            this.plimit = this.path.length();
            this.metaMem = metaMem;
        }

        @Override
        public void close() {
            if (this.findFileStruct != 0L) {
                this.ff.findClose(this.findFileStruct);
                this.findFileStruct = 0L;
            }
            this.metaMem.close();
        }

        @Override
        public Record getRecord() {
            return this.diskReadingRecord;
        }

        @Override
        public boolean hasNext() {
            if (this.findFileStruct == 0L) {
                this.findFileStruct = this.ff.findFirst(this.path.trimTo(this.plimit).$());
                if (this.findFileStruct > 0L) {
                    return this.next0();
                }
                this.findFileStruct = 0L;
                return false;
            }
            return this.next0();
        }

        @Override
        public void toTop() {
            if (this.findFileStruct != 0L) {
                this.ff.findClose(this.findFileStruct);
                this.findFileStruct = 0L;
            }
        }

        @Override
        public long size() {
            return -1L;
        }

        private boolean next0() {
            do {
                if (this.readNextFileFromDisk) {
                    this.foundMetadataFile = false;
                    long pname = this.ff.findName(this.findFileStruct);
                    if (this.hasNextFile) {
                        this.nativeLPSZ.of(pname);
                        if (this.ff.findType(this.findFileStruct) == 4 && Chars.notDots(this.nativeLPSZ)) {
                            this.path.trimTo(this.plimit);
                            this.path.concat(pname);
                            if (this.ff.exists(this.path.concat("_meta").$())) {
                                this.foundMetadataFile = true;
                                this.metaMem.of(this.ff, this.path, this.ff.getPageSize(), this.ff.length(this.path));
                                this.columnCount = this.metaMem.getInt(0L);
                                this.tableId = this.metaMem.getInt(16L);
                            }
                        }
                        boolean bl = this.hasNextFile = this.ff.findNext(this.findFileStruct) > 0;
                    }
                }
                if (!this.foundMetadataFile) continue;
                long offset = TableUtils.getColumnNameOffset(this.columnCount);
                for (int i = 0; i < this.columnCount; ++i) {
                    CharSequence name = this.metaMem.getStr(offset);
                    if (this.columnIndex == i) {
                        int type;
                        this.diskReadingRecord.intValues[3] = type = PGOids.TYPE_OIDS.get(TableUtils.getColumnType(this.metaMem, i));
                        this.diskReadingRecord.name = name;
                        this.diskReadingRecord.shortValues[2] = (short)(i + 1);
                        this.diskReadingRecord.shortValues[6] = (short)PGOids.PG_TYPE_TO_SIZE_MAP.get(type);
                        this.diskReadingRecord.intValues[0] = this.tableId;
                        ++this.columnIndex;
                        if (this.columnIndex == this.columnCount) {
                            this.readNextFileFromDisk = true;
                            this.columnIndex = 0;
                        } else {
                            this.readNextFileFromDisk = false;
                        }
                        return true;
                    }
                    offset += (long)VmUtils.getStorageLength(name);
                }
            } while (this.hasNextFile);
            this.ff.findClose(this.findFileStruct);
            this.findFileStruct = 0L;
            this.hasNextFile = true;
            this.foundMetadataFile = false;
            return false;
        }

        static class DiskReadingRecord
        implements Record {
            public CharSequence name = null;
            public final short[] shortValues = new short[9];
            public final int[] intValues = new int[9];
            public int type = -1;

            DiskReadingRecord() {
            }

            @Override
            public short getShort(int col) {
                return this.shortValues[col];
            }

            @Override
            public int getInt(int col) {
                return this.intValues[col];
            }

            @Override
            public CharSequence getStr(int col) {
                return this.name;
            }

            @Override
            public CharSequence getStrB(int col) {
                return this.name;
            }

            @Override
            public boolean getBool(int col) {
                return false;
            }

            @Override
            public char getChar(int col) {
                return '\u0000';
            }

            @Override
            public int getStrLen(int col) {
                return this.getStr(col).length();
            }
        }
    }

    private static class AttributeCatalogueCursorFactory
    extends AbstractRecordCursorFactory {
        private final Path path = new Path();
        private final MappedReadOnlyMemory metaMem = new SinglePageMappedReadOnlyPageMemory();
        private final AttributeClassCatalogueCursor cursor;

        public AttributeCatalogueCursorFactory(CairoConfiguration configuration, RecordMetadata metadata) {
            super(metadata);
            this.cursor = new AttributeClassCatalogueCursor(configuration, this.path, this.metaMem);
        }

        @Override
        public void close() {
            Misc.free(this.path);
            Misc.free(this.metaMem);
        }

        @Override
        public RecordCursor getCursor(SqlExecutionContext executionContext) {
            this.cursor.toTop();
            return this.cursor;
        }

        @Override
        public boolean recordCursorSupportsRandomAccess() {
            return false;
        }
    }
}

