/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlKeywords;
import io.questdb.griffin.engine.functions.catalogue.StringToStringArrayFunction;
import io.questdb.griffin.engine.functions.constants.IntConstant;
import io.questdb.griffin.engine.functions.date.ToPgDateFunctionFactory;
import io.questdb.griffin.engine.functions.date.ToTimestampFunctionFactory;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.ObjList;

public class ClassResolveFunctionFactory
implements FunctionFactory {
    private static final CharSequenceObjHashMap<IntConstant> map = new CharSequenceObjHashMap();

    @Override
    public String getSignature() {
        return "::(ss)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function nameFunction = args.getQuick(0);
        CharSequence type = args.getQuick(1).getStr(null);
        if (SqlKeywords.isRegclassKeyword(type)) {
            IntConstant func = map.get(nameFunction.getStr(null));
            if (func != null) {
                return func;
            }
            throw SqlException.$(nameFunction.getPosition(), "unsupported class");
        }
        if (SqlKeywords.isRegprocKeyword(type) || SqlKeywords.isRegprocedureKeyword(type)) {
            return new IntConstant(0, 289208840);
        }
        if (SqlKeywords.isTimestampKeyword(type)) {
            return new ToTimestampFunctionFactory.ToTimestampFunction(nameFunction.getPosition(), nameFunction);
        }
        if (SqlKeywords.isDateKeyword(type)) {
            return new ToPgDateFunctionFactory.ToPgDateFunction(nameFunction.getPosition(), nameFunction);
        }
        if (SqlKeywords.isTextArrayKeyword(type)) {
            return new StringToStringArrayFunction(nameFunction.getPosition(), nameFunction.getStr(null));
        }
        throw SqlException.$(args.getQuick(1).getPosition(), "unsupported type");
    }

    static {
        map.put("pg_namespace", new IntConstant(0, 2615));
        map.put("pg_class", new IntConstant(0, 1259));
    }
}

