/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.IntFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.ObjList;

public class NullIfIFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "nullif(Ii)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new NullIfIFunction(position, args.getQuick(0), args.getQuick(1).getInt(null));
    }

    private static class NullIfIFunction
    extends IntFunction
    implements UnaryFunction {
        private final Function value;
        private final int replacement;

        public NullIfIFunction(int position, Function value, int replacement) {
            super(position);
            this.value = value;
            this.replacement = replacement;
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public int getInt(Record rec) {
            int val = this.value.getInt(rec);
            return val != Integer.MIN_VALUE ? val : this.replacement;
        }
    }
}

