/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.StrArrayFunction;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;

public class PrefixedCurrentSchemasFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "pg_catalog.current_schemas(T)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new CurrentSchemaFunction(position);
    }

    private static class CurrentSchemaFunction
    extends StrArrayFunction {
        public CurrentSchemaFunction(int position) {
            super(position);
        }

        @Override
        public int getArrayLength() {
            return 1;
        }

        @Override
        public CharSequence getStr(Record rec, int arrayIndex) {
            return "public";
        }

        @Override
        public void getStr(Record rec, CharSink sink, int arrayIndex) {
            sink.put(this.getStr(rec, arrayIndex));
        }

        @Override
        public CharSequence getStrB(Record rec, int arrayIndex) {
            return this.getStr(rec, arrayIndex);
        }

        @Override
        public int getStrLen(Record rec, int arrayIndex) {
            return this.getStr(rec, arrayIndex).length();
        }

        @Override
        public boolean isConstant() {
            return true;
        }
    }
}

