/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableReaderMetadata;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.CursorFunction;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.ObjList;
import io.questdb.std.str.NativeLPSZ;
import io.questdb.std.str.Path;

public class TableMetadataCursorFactory
implements FunctionFactory {
    private static final RecordMetadata METADATA;
    private static final int idColumn;
    private static final int nameColumn;
    private static final int partitionByColumn;
    private static final int maxUncommittedRowsColumn;
    private static final int o3CommitHysteresisMicroSecColumn;
    private static final int designatedTimestampColumn;
    private static final Log LOG;

    @Override
    public String getSignature() {
        return "tables()";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        return new CursorFunction(position, new TableMetadataCursor(configuration.getFilesFacade(), configuration.getRoot()));
    }

    static {
        LOG = LogFactory.getLog(TableMetadataCursorFactory.class);
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("id", 4, null));
        idColumn = metadata.getColumnCount() - 1;
        metadata.add(new TableColumnMetadata("name", 10, null));
        nameColumn = metadata.getColumnCount() - 1;
        metadata.add(new TableColumnMetadata("designatedTimestamp", 10, null));
        designatedTimestampColumn = metadata.getColumnCount() - 1;
        metadata.add(new TableColumnMetadata("partitionBy", 10, null));
        partitionByColumn = metadata.getColumnCount() - 1;
        metadata.add(new TableColumnMetadata("o3MaxUncommittedRows", 4, null));
        maxUncommittedRowsColumn = metadata.getColumnCount() - 1;
        metadata.add(new TableColumnMetadata("o3CommitHysteresisMicros", 5, null));
        o3CommitHysteresisMicroSecColumn = metadata.getColumnCount() - 1;
        METADATA = metadata;
    }

    private static class TableMetadataCursor
    implements RecordCursorFactory {
        private final FilesFacade ff;
        private Path path;
        private final TableListRecordCursor cursor;

        public TableMetadataCursor(FilesFacade ff, CharSequence dbRoot) {
            this.ff = ff;
            this.path = new Path().of(dbRoot).$();
            this.cursor = new TableListRecordCursor();
        }

        @Override
        public RecordCursor getCursor(SqlExecutionContext executionContext) {
            return this.cursor.of(executionContext);
        }

        @Override
        public RecordMetadata getMetadata() {
            return METADATA;
        }

        @Override
        public boolean recordCursorSupportsRandomAccess() {
            return false;
        }

        @Override
        public void close() {
            if (null != this.path) {
                this.path.close();
                this.path = null;
            }
        }

        private class TableListRecordCursor
        implements RecordCursor {
            private final NativeLPSZ nativeLPSZ = new NativeLPSZ();
            private final TableListRecord record = new TableListRecord();
            private long findPtr = 0L;
            private TableReaderMetadata metaReader;

            private TableListRecordCursor() {
            }

            @Override
            public void close() {
                if (this.findPtr > 0L) {
                    TableMetadataCursor.this.ff.findClose(this.findPtr);
                    this.findPtr = 0L;
                }
                if (this.metaReader != null) {
                    this.metaReader.close();
                }
            }

            @Override
            public Record getRecord() {
                return this.record;
            }

            @Override
            public boolean hasNext() {
                int type;
                do {
                    if (this.findPtr == 0L) {
                        this.findPtr = TableMetadataCursor.this.ff.findFirst(TableMetadataCursor.this.path);
                        if (this.findPtr <= 0L) {
                            return false;
                        }
                    } else if (TableMetadataCursor.this.ff.findNext(this.findPtr) <= 0) {
                        return false;
                    }
                    this.nativeLPSZ.of(TableMetadataCursor.this.ff.findName(this.findPtr));
                } while ((type = TableMetadataCursor.this.ff.findType(this.findPtr)) != 4 || this.nativeLPSZ.charAt(0) == '.' || !this.record.open(this.nativeLPSZ));
                return true;
            }

            public TableListRecordCursor of(SqlExecutionContext executionContext) {
                this.toTop();
                if (this.metaReader == null) {
                    this.metaReader = new TableReaderMetadata(executionContext.getCairoEngine().getConfiguration().getFilesFacade());
                }
                return this;
            }

            @Override
            public Record getRecordB() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void recordAt(Record record, long atRowId) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void toTop() {
                this.close();
            }

            @Override
            public long size() {
                return -1L;
            }

            public class TableListRecord
            implements Record {
                private int tableId;
                private int maxUncommittedRows;
                private long o3CommitHysteresisMicroSec;
                private int partitionBy;

                @Override
                public CharSequence getStr(int col) {
                    if (col == nameColumn) {
                        return TableListRecordCursor.this.nativeLPSZ;
                    }
                    if (col == partitionByColumn) {
                        return PartitionBy.toString(this.partitionBy);
                    }
                    if (col == designatedTimestampColumn && TableListRecordCursor.this.metaReader.getTimestampIndex() > -1) {
                        return TableListRecordCursor.this.metaReader.getColumnName(TableListRecordCursor.this.metaReader.getTimestampIndex());
                    }
                    return null;
                }

                @Override
                public CharSequence getStrB(int col) {
                    return this.getStr(col);
                }

                @Override
                public int getInt(int col) {
                    if (col == idColumn) {
                        return this.tableId;
                    }
                    if (col == maxUncommittedRowsColumn) {
                        return this.maxUncommittedRows;
                    }
                    return Integer.MIN_VALUE;
                }

                @Override
                public long getLong(int col) {
                    if (col == o3CommitHysteresisMicroSecColumn) {
                        return this.o3CommitHysteresisMicroSec;
                    }
                    return Long.MIN_VALUE;
                }

                @Override
                public int getStrLen(int col) {
                    return this.getStr(col).length();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean open(NativeLPSZ tableName) {
                    int pathLen = TableMetadataCursor.this.path.length();
                    try {
                        TableMetadataCursor.this.path.chop$().concat(tableName).concat("_meta").$();
                        TableListRecordCursor.this.metaReader.of(TableMetadataCursor.this.path.$());
                        this.tableId = TableListRecordCursor.this.metaReader.getId();
                        this.maxUncommittedRows = TableListRecordCursor.this.metaReader.getMaxUncommittedRows();
                        this.o3CommitHysteresisMicroSec = TableListRecordCursor.this.metaReader.getO3CommitHysteresisMicros();
                        this.partitionBy = TableListRecordCursor.this.metaReader.getPartitionBy();
                    }
                    catch (CairoException e) {
                        LOG.info().$("cannot query table metadata [table=").$(tableName).$(", error=").$(e.getFlyweightMessage()).$(", errno=").$(e.getErrno()).I$();
                        boolean bl = false;
                        return bl;
                    }
                    finally {
                        TableMetadataCursor.this.path.trimTo(pathLen).$();
                    }
                    return true;
                }
            }
        }
    }
}

