/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cutlass.pgwire.PGOids;

class TypeCatalogueCursor
implements NoRandomAccessRecordCursor {
    static final RecordMetadata METADATA;
    private static final int rowCount;
    private final TypeCatalogueRecord record = new TypeCatalogueRecord();
    public final int[] intValues = new int[METADATA.getColumnCount()];
    private int row = -1;

    public TypeCatalogueCursor() {
        this.intValues[4] = 2200;
    }

    @Override
    public void close() {
        this.row = -1;
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public boolean hasNext() {
        if (++this.row < rowCount) {
            this.intValues[0] = PGOids.PG_TYPE_OIDS.get(this.row);
            this.intValues[8] = Integer.MIN_VALUE;
            this.intValues[9] = 0;
            this.intValues[10] = 0;
            this.intValues[11] = 0;
            this.intValues[12] = 0;
            return true;
        }
        return false;
    }

    @Override
    public void toTop() {
        this.row = -1;
    }

    @Override
    public long size() {
        return rowCount;
    }

    static {
        rowCount = PGOids.PG_TYPE_OIDS.size();
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("oid", 4, null));
        metadata.add(new TableColumnMetadata("typname", 10, null));
        metadata.add(new TableColumnMetadata("typbasetype", 4, null));
        metadata.add(new TableColumnMetadata("typarray", 4, null));
        metadata.add(new TableColumnMetadata("typnamespace", 4, null));
        metadata.add(new TableColumnMetadata("typnotnull", 0, null));
        metadata.add(new TableColumnMetadata("typtypmod", 4, null));
        metadata.add(new TableColumnMetadata("typtype", 3, null));
        metadata.add(new TableColumnMetadata("typrelid", 4, null));
        metadata.add(new TableColumnMetadata("typelem", 4, null));
        metadata.add(new TableColumnMetadata("typreceive", 4, null));
        metadata.add(new TableColumnMetadata("typdelim", 4, null));
        metadata.add(new TableColumnMetadata("typinput", 4, null));
        METADATA = metadata;
    }

    class TypeCatalogueRecord
    implements Record {
        TypeCatalogueRecord() {
        }

        @Override
        public int getInt(int col) {
            return TypeCatalogueCursor.this.intValues[col];
        }

        @Override
        public CharSequence getStr(int col) {
            return PGOids.PG_TYPE_TO_NAME[TypeCatalogueCursor.this.row];
        }

        @Override
        public CharSequence getStrB(int col) {
            return this.getStr(col);
        }

        @Override
        public int getStrLen(int col) {
            return this.getStr(col).length();
        }

        @Override
        public char getChar(int col) {
            return 'b';
        }

        @Override
        public boolean getBool(int col) {
            return false;
        }
    }
}

