/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.conditional;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.conditional.CaseCommon;
import io.questdb.griffin.engine.functions.conditional.CaseFunctionPicker;
import io.questdb.griffin.engine.functions.constants.Constants;
import io.questdb.std.ObjList;

public class CaseFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "case(V)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        int i;
        Function elseBranch;
        int n = args.size();
        int returnType = -1;
        ObjList<Function> vars = new ObjList<Function>(n);
        ObjList<Function> argsToPoke = new ObjList<Function>(n);
        if (n % 2 == 1) {
            elseBranch = args.getQuick(n - 1);
            --n;
        } else {
            elseBranch = null;
        }
        for (i = 0; i < n; i += 2) {
            Function bool = args.getQuick(i);
            Function value = args.getQuick(i + 1);
            if (bool.getType() != 0) {
                throw SqlException.position(bool.getPosition()).put("BOOLEAN expected, found ").put(ColumnType.nameOf(bool.getType()));
            }
            returnType = CaseCommon.getCommonType(returnType, value.getType(), value.getPosition());
            vars.add(bool);
            vars.add(value);
            argsToPoke.add(bool);
            argsToPoke.add(value);
        }
        if (elseBranch != null) {
            returnType = CaseCommon.getCommonType(returnType, elseBranch.getType(), elseBranch.getPosition());
            argsToPoke.add(elseBranch);
        }
        for (i = 1; i < n; i += 2) {
            vars.setQuick(i, CaseCommon.getCastFunction((Function)vars.getQuick(i), returnType, configuration, sqlExecutionContext));
        }
        if (elseBranch != null) {
            elseBranch = CaseCommon.getCastFunction(elseBranch, returnType, configuration, sqlExecutionContext);
        }
        int argsLen = vars.size();
        Function elseB = elseBranch != null ? elseBranch : Constants.getNullConstant(returnType);
        CaseFunctionPicker picker = record -> {
            for (int i = 0; i < argsLen; i += 2) {
                if (!((Function)vars.getQuick(i)).getBool(record)) continue;
                return (Function)vars.getQuick(i + 1);
            }
            return elseB;
        };
        return CaseCommon.getCaseFunction(position, returnType, picker, argsToPoke);
    }
}

