/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.conditional;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.DateFunction;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.functions.FloatFunction;
import io.questdb.griffin.engine.functions.IntFunction;
import io.questdb.griffin.engine.functions.Long256Function;
import io.questdb.griffin.engine.functions.LongFunction;
import io.questdb.griffin.engine.functions.MultiArgFunction;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.griffin.engine.functions.conditional.CaseCommon;
import io.questdb.std.Long256;
import io.questdb.std.Long256Impl;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;

public class CoalesceFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "coalesce(V)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        if (args.size() < 2) {
            throw SqlException.$(position, "coalesce can be used with 2 or more arguments");
        }
        if (args.size() > 2) {
            args = new ObjList<Function>(args);
        }
        int argsSize = args.size();
        int returnType = -1;
        for (int i = 0; i < argsSize; ++i) {
            returnType = CaseCommon.getCommonType(returnType, args.getQuick(i).getType(), args.getQuick(i).getPosition());
        }
        switch (returnType) {
            case 9: {
                return argsSize == 2 ? new TwoDoubleCoalesceFunction(position, args) : new DoubleCoalesceFunction(position, args, argsSize);
            }
            case 6: {
                return argsSize == 2 ? new TwoDateCoalesceFunction(position, args) : new DateCoalesceFunction(position, args, argsSize);
            }
            case 7: {
                return argsSize == 2 ? new TwoTimestampCoalesceFunction(position, args) : new TimestampCoalesceFunction(position, args);
            }
            case 5: {
                return argsSize == 2 ? new TwoLongCoalesceFunction(position, args) : new LongCoalesceFunction(position, args, argsSize);
            }
            case 12: {
                return argsSize == 2 ? new TwoLong256CoalesceFunction(position, args) : new Long256CoalesceFunction(position, args);
            }
            case 4: {
                return argsSize == 2 ? new TwoIntCoalesceFunction(position, args) : new IntCoalesceFunction(position, args, argsSize);
            }
            case 8: {
                return argsSize == 2 ? new TwoFloatCoalesceFunction(position, args) : new FloatCoalesceFunction(position, args, argsSize);
            }
            case 10: 
            case 11: {
                if (argsSize == 2) {
                    int type0 = args.getQuick(0).getType();
                    if (type0 != args.getQuick(1).getType()) {
                        return new TwoSymStrCoalesceFunction(position, args);
                    }
                    if (type0 == 11) {
                        return new TwoSymCoalesceFunction(position, args);
                    }
                    return new TwoStrCoalesceFunction(position, args);
                }
                return new SymStrCoalesceFunction(position, args, argsSize);
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return args.getQuick(0);
            }
        }
        throw SqlException.$(position, "coalesce cannot be used with ").put(ColumnType.nameOf(returnType)).put(" data type");
    }

    private static boolean isNotNull(Long256 value) {
        return value != null && value != Long256Impl.NULL_LONG256 && (value.getLong0() != Long.MIN_VALUE || value.getLong1() != Long.MIN_VALUE || value.getLong2() != Long.MIN_VALUE || value.getLong3() != Long.MIN_VALUE);
    }

    private static class SymStrCoalesceFunction
    extends StrFunction
    implements MultiArgFunction {
        private final ObjList<Function> args;
        private final int size;

        public SymStrCoalesceFunction(int position, ObjList<Function> args, int size) {
            super(position);
            this.args = args;
            this.size = size;
        }

        @Override
        public ObjList<Function> getArgs() {
            return this.args;
        }

        @Override
        public CharSequence getStr(Record rec) {
            for (int i = 0; i < this.size; ++i) {
                CharSequence value;
                Function arg = this.args.getQuick(i);
                CharSequence charSequence = value = arg.getType() == 11 ? arg.getSymbol(rec) : arg.getStr(rec);
                if (value == null) continue;
                return value;
            }
            return null;
        }

        @Override
        public CharSequence getStrB(Record rec) {
            for (int i = 0; i < this.size; ++i) {
                CharSequence value;
                Function arg = this.args.getQuick(i);
                CharSequence charSequence = value = arg.getType() == 11 ? arg.getSymbolB(rec) : arg.getStrB(rec);
                if (value == null) continue;
                return value;
            }
            return null;
        }
    }

    private static class TwoStrCoalesceFunction
    extends StrFunction
    implements BinaryFunction {
        private final Function args0;
        private final Function args1;

        @Override
        public Function getLeft() {
            return this.args0;
        }

        @Override
        public Function getRight() {
            return this.args1;
        }

        public TwoStrCoalesceFunction(int position, ObjList<Function> args) {
            super(position);
            assert (args.size() == 2);
            this.args0 = args.getQuick(0);
            this.args1 = args.getQuick(1);
        }

        @Override
        public CharSequence getStr(Record rec) {
            CharSequence value = this.args0.getStr(rec);
            if (value != null) {
                return value;
            }
            return this.args1.getStr(rec);
        }

        @Override
        public CharSequence getStrB(Record rec) {
            CharSequence value = this.args0.getStrB(rec);
            if (value != null) {
                return value;
            }
            return this.args1.getStrB(rec);
        }
    }

    private static class TwoSymCoalesceFunction
    extends StrFunction
    implements BinaryFunction {
        private final Function args0;
        private final Function args1;

        @Override
        public Function getLeft() {
            return this.args0;
        }

        @Override
        public Function getRight() {
            return this.args1;
        }

        public TwoSymCoalesceFunction(int position, ObjList<Function> args) {
            super(position);
            assert (args.size() == 2);
            this.args0 = args.getQuick(0);
            this.args1 = args.getQuick(1);
        }

        @Override
        public CharSequence getStr(Record rec) {
            CharSequence value = this.args0.getSymbol(rec);
            if (value != null) {
                return value;
            }
            return this.args1.getSymbol(rec);
        }

        @Override
        public CharSequence getStrB(Record rec) {
            CharSequence value = this.args0.getSymbolB(rec);
            if (value != null) {
                return value;
            }
            return this.args1.getSymbolB(rec);
        }
    }

    private static class TwoSymStrCoalesceFunction
    extends StrFunction
    implements BinaryFunction {
        private final Function args0;
        private final Function args1;
        private final boolean args0IsSymbol;
        private final boolean arg1IsSymbol;

        @Override
        public Function getLeft() {
            return this.args0;
        }

        @Override
        public Function getRight() {
            return this.args1;
        }

        public TwoSymStrCoalesceFunction(int position, ObjList<Function> args) {
            super(position);
            assert (args.size() == 2);
            this.args0 = args.getQuick(0);
            this.args1 = args.getQuick(1);
            this.args0IsSymbol = this.args0.getType() == 11;
            this.arg1IsSymbol = this.args1.getType() == 11;
        }

        @Override
        public CharSequence getStr(Record rec) {
            CharSequence value;
            CharSequence charSequence = value = this.args0IsSymbol ? this.args0.getSymbol(rec) : this.args0.getStr(rec);
            if (value != null) {
                return value;
            }
            return this.arg1IsSymbol ? this.args1.getSymbol(rec) : this.args1.getStr(rec);
        }

        @Override
        public CharSequence getStrB(Record rec) {
            CharSequence value;
            CharSequence charSequence = value = this.args0IsSymbol ? this.args0.getSymbolB(rec) : this.args0.getStrB(rec);
            if (value != null) {
                return value;
            }
            return this.arg1IsSymbol ? this.args1.getSymbolB(rec) : this.args1.getStrB(rec);
        }
    }

    private static class IntCoalesceFunction
    extends IntFunction
    implements MultiArgFunction {
        private final ObjList<Function> args;
        private final int size;

        public IntCoalesceFunction(int position, ObjList<Function> args, int size) {
            super(position);
            this.args = args;
            this.size = size;
        }

        @Override
        public ObjList<Function> getArgs() {
            return this.args;
        }

        @Override
        public int getInt(Record rec) {
            for (int i = 0; i < this.size; ++i) {
                int value = this.args.getQuick(i).getInt(rec);
                if (value == Integer.MIN_VALUE) continue;
                return value;
            }
            return Integer.MIN_VALUE;
        }
    }

    private static class TwoIntCoalesceFunction
    extends IntFunction
    implements BinaryFunction {
        private final Function args0;
        private final Function args1;

        public TwoIntCoalesceFunction(int position, ObjList<Function> args) {
            super(position);
            assert (args.size() == 2);
            this.args0 = args.getQuick(0);
            this.args1 = args.getQuick(1);
        }

        @Override
        public int getInt(Record rec) {
            int value = this.args0.getInt(rec);
            if (value != Integer.MIN_VALUE) {
                return value;
            }
            return this.args1.getInt(rec);
        }

        @Override
        public Function getLeft() {
            return this.args0;
        }

        @Override
        public Function getRight() {
            return this.args1;
        }
    }

    private static class Long256CoalesceFunction
    extends Long256Function
    implements MultiArgFunction {
        private final ObjList<Function> args;
        private final int size;

        public Long256CoalesceFunction(int position, ObjList<Function> args) {
            super(position);
            this.args = args;
            this.size = args.size();
        }

        @Override
        public ObjList<Function> getArgs() {
            return this.args;
        }

        @Override
        public void getLong256(Record rec, CharSink sink) {
            for (int i = 0; i < this.size; ++i) {
                Long256 value = this.args.getQuick(i).getLong256A(rec);
                if (!CoalesceFunctionFactory.isNotNull(value)) continue;
                Numbers.appendLong256(value.getLong0(), value.getLong1(), value.getLong2(), value.getLong3(), sink);
                return;
            }
        }

        @Override
        public Long256 getLong256A(Record rec) {
            Long256 value = Long256Impl.NULL_LONG256;
            for (int i = 0; i < this.size; ++i) {
                value = this.args.getQuick(i).getLong256A(rec);
                if (!CoalesceFunctionFactory.isNotNull(value)) continue;
                return value;
            }
            return value;
        }

        @Override
        public Long256 getLong256B(Record rec) {
            Long256 value = Long256Impl.NULL_LONG256;
            for (int i = 0; i < this.size; ++i) {
                value = this.args.getQuick(i).getLong256B(rec);
                if (!CoalesceFunctionFactory.isNotNull(value)) continue;
                return value;
            }
            return value;
        }
    }

    private static class TwoLong256CoalesceFunction
    extends Long256Function
    implements BinaryFunction {
        private final Function args1;
        private final Function args0;

        public TwoLong256CoalesceFunction(int position, ObjList<Function> args) {
            super(position);
            assert (args.size() == 2);
            this.args0 = args.getQuick(0);
            this.args1 = args.getQuick(1);
        }

        @Override
        public Function getLeft() {
            return this.args0;
        }

        @Override
        public Function getRight() {
            return this.args1;
        }

        @Override
        public void getLong256(Record rec, CharSink sink) {
            Long256 value = this.args0.getLong256A(rec);
            if (CoalesceFunctionFactory.isNotNull(value)) {
                Numbers.appendLong256(value.getLong0(), value.getLong1(), value.getLong2(), value.getLong3(), sink);
            } else {
                value = this.args1.getLong256A(rec);
                Numbers.appendLong256(value.getLong0(), value.getLong1(), value.getLong2(), value.getLong3(), sink);
            }
        }

        @Override
        public Long256 getLong256A(Record rec) {
            Long256 value = this.args0.getLong256A(rec);
            if (CoalesceFunctionFactory.isNotNull(value)) {
                return value;
            }
            return this.args1.getLong256A(rec);
        }

        @Override
        public Long256 getLong256B(Record rec) {
            Long256 value = this.args0.getLong256B(rec);
            if (CoalesceFunctionFactory.isNotNull(value)) {
                return value;
            }
            return this.args1.getLong256B(rec);
        }
    }

    public static class LongCoalesceFunction
    extends LongFunction
    implements MultiArgFunction {
        private final ObjList<Function> args;
        private final int size;

        public LongCoalesceFunction(int position, ObjList<Function> args, int size) {
            super(position);
            this.args = args;
            this.size = size;
        }

        @Override
        public ObjList<Function> getArgs() {
            return this.args;
        }

        @Override
        public long getLong(Record rec) {
            for (int i = 0; i < this.size; ++i) {
                long value = this.args.getQuick(i).getLong(rec);
                if (value == Long.MIN_VALUE) continue;
                return value;
            }
            return Long.MIN_VALUE;
        }
    }

    public static class TwoLongCoalesceFunction
    extends LongFunction
    implements BinaryFunction {
        private final Function args0;
        private final Function args1;

        public TwoLongCoalesceFunction(int position, ObjList<Function> args) {
            super(position);
            assert (args.size() == 2);
            this.args0 = args.getQuick(0);
            this.args1 = args.getQuick(1);
        }

        @Override
        public Function getLeft() {
            return this.args0;
        }

        @Override
        public Function getRight() {
            return this.args1;
        }

        @Override
        public long getLong(Record rec) {
            long value = this.args0.getLong(rec);
            if (value != Long.MIN_VALUE) {
                return value;
            }
            return this.args1.getLong(rec);
        }
    }

    private static class TimestampCoalesceFunction
    extends TimestampFunction
    implements MultiArgFunction {
        private final ObjList<Function> args;
        private final int size;

        public TimestampCoalesceFunction(int position, ObjList<Function> args) {
            super(position);
            this.args = args;
            this.size = args.size();
        }

        @Override
        public ObjList<Function> getArgs() {
            return this.args;
        }

        @Override
        public long getTimestamp(Record rec) {
            for (int i = 0; i < this.size; ++i) {
                long value = this.args.getQuick(i).getTimestamp(rec);
                if (value == Long.MIN_VALUE) continue;
                return value;
            }
            return Long.MIN_VALUE;
        }
    }

    private static class TwoTimestampCoalesceFunction
    extends TimestampFunction
    implements BinaryFunction {
        private final Function args0;
        private final Function args1;

        public TwoTimestampCoalesceFunction(int position, ObjList<Function> args) {
            super(position);
            assert (args.size() == 2);
            this.args0 = args.getQuick(0);
            this.args1 = args.getQuick(1);
        }

        @Override
        public Function getLeft() {
            return this.args0;
        }

        @Override
        public Function getRight() {
            return this.args1;
        }

        @Override
        public long getTimestamp(Record rec) {
            long value = this.args0.getTimestamp(rec);
            if (value != Long.MIN_VALUE) {
                return value;
            }
            return this.args1.getTimestamp(rec);
        }
    }

    private static class DateCoalesceFunction
    extends DateFunction
    implements MultiArgFunction {
        private final ObjList<Function> args;
        private final int size;

        public DateCoalesceFunction(int position, ObjList<Function> args, int size) {
            super(position);
            this.args = args;
            this.size = size;
        }

        @Override
        public ObjList<Function> getArgs() {
            return this.args;
        }

        @Override
        public long getDate(Record rec) {
            for (int i = 0; i < this.size; ++i) {
                long value = this.args.getQuick(i).getDate(rec);
                if (value == Long.MIN_VALUE) continue;
                return value;
            }
            return Long.MIN_VALUE;
        }
    }

    private static class TwoDateCoalesceFunction
    extends DateFunction
    implements BinaryFunction {
        private final Function args0;
        private final Function args1;

        public TwoDateCoalesceFunction(int position, ObjList<Function> args) {
            super(position);
            assert (args.size() == 2);
            this.args0 = args.getQuick(0);
            this.args1 = args.getQuick(1);
        }

        @Override
        public long getDate(Record rec) {
            long value = this.args0.getDate(rec);
            if (value != Long.MIN_VALUE) {
                return value;
            }
            return this.args1.getDate(rec);
        }

        @Override
        public Function getLeft() {
            return this.args0;
        }

        @Override
        public Function getRight() {
            return this.args1;
        }
    }

    private static class FloatCoalesceFunction
    extends FloatFunction
    implements MultiArgFunction {
        private final ObjList<Function> args;
        private final int size;

        public FloatCoalesceFunction(int position, ObjList<Function> args, int size) {
            super(position);
            this.args = args;
            this.size = size;
        }

        @Override
        public ObjList<Function> getArgs() {
            return this.args;
        }

        @Override
        public float getFloat(Record rec) {
            for (int i = 0; i < this.size; ++i) {
                float value = this.args.getQuick(i).getFloat(rec);
                if (value != value) continue;
                return value;
            }
            return Float.NaN;
        }
    }

    private static class TwoFloatCoalesceFunction
    extends FloatFunction
    implements BinaryFunction {
        private final Function args0;
        private final Function args1;

        public TwoFloatCoalesceFunction(int position, ObjList<Function> args) {
            super(position);
            assert (args.size() == 2);
            this.args0 = args.getQuick(0);
            this.args1 = args.getQuick(1);
        }

        @Override
        public float getFloat(Record rec) {
            float value = this.args0.getFloat(rec);
            if (value == value) {
                return value;
            }
            return this.args1.getFloat(rec);
        }

        @Override
        public Function getLeft() {
            return this.args0;
        }

        @Override
        public Function getRight() {
            return this.args1;
        }
    }

    private static class DoubleCoalesceFunction
    extends DoubleFunction
    implements MultiArgFunction {
        private final ObjList<Function> args;
        private final int size;

        public DoubleCoalesceFunction(int position, ObjList<Function> args, int size) {
            super(position);
            this.args = args;
            this.size = size;
        }

        @Override
        public ObjList<Function> getArgs() {
            return this.args;
        }

        @Override
        public double getDouble(Record rec) {
            for (int i = 0; i < this.size; ++i) {
                double value = this.args.getQuick(i).getDouble(rec);
                if (value != value) continue;
                return value;
            }
            return Double.NaN;
        }
    }

    private static class TwoDoubleCoalesceFunction
    extends DoubleFunction
    implements BinaryFunction {
        private final Function args0;
        private final Function args1;

        public TwoDoubleCoalesceFunction(int position, ObjList<Function> args) {
            super(position);
            assert (args.size() == 2);
            this.args0 = args.getQuick(0);
            this.args1 = args.getQuick(1);
        }

        @Override
        public double getDouble(Record rec) {
            double value = this.args0.getDouble(rec);
            if (value == value) {
                return value;
            }
            return this.args1.getDouble(rec);
        }

        @Override
        public Function getLeft() {
            return this.args0;
        }

        @Override
        public Function getRight() {
            return this.args1;
        }
    }
}

