/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.constants;

import io.questdb.griffin.TypeConstant;
import io.questdb.griffin.engine.functions.constants.BinTypeConstant;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.griffin.engine.functions.constants.BooleanTypeConstant;
import io.questdb.griffin.engine.functions.constants.ByteConstant;
import io.questdb.griffin.engine.functions.constants.ByteTypeConstant;
import io.questdb.griffin.engine.functions.constants.CharConstant;
import io.questdb.griffin.engine.functions.constants.CharTypeConstant;
import io.questdb.griffin.engine.functions.constants.ConstantFunction;
import io.questdb.griffin.engine.functions.constants.DateConstant;
import io.questdb.griffin.engine.functions.constants.DateTypeConstant;
import io.questdb.griffin.engine.functions.constants.DoubleConstant;
import io.questdb.griffin.engine.functions.constants.DoubleTypeConstant;
import io.questdb.griffin.engine.functions.constants.FloatConstant;
import io.questdb.griffin.engine.functions.constants.FloatTypeConstant;
import io.questdb.griffin.engine.functions.constants.IntConstant;
import io.questdb.griffin.engine.functions.constants.IntTypeConstant;
import io.questdb.griffin.engine.functions.constants.Long256NullConstant;
import io.questdb.griffin.engine.functions.constants.Long256TypeConstant;
import io.questdb.griffin.engine.functions.constants.LongConstant;
import io.questdb.griffin.engine.functions.constants.LongTypeConstant;
import io.questdb.griffin.engine.functions.constants.NullBinConstant;
import io.questdb.griffin.engine.functions.constants.ShortConstant;
import io.questdb.griffin.engine.functions.constants.ShortTypeConstant;
import io.questdb.griffin.engine.functions.constants.StrConstant;
import io.questdb.griffin.engine.functions.constants.StrTypeConstant;
import io.questdb.griffin.engine.functions.constants.SymbolConstant;
import io.questdb.griffin.engine.functions.constants.SymbolTypeConstant;
import io.questdb.griffin.engine.functions.constants.TimestampConstant;
import io.questdb.griffin.engine.functions.constants.TimestampTypeConstant;
import io.questdb.std.ObjList;

public final class Constants {
    private static final ObjList<ConstantFunction> nullConstants = new ObjList();
    private static final ObjList<TypeConstant> typeConstants = new ObjList();

    public static ConstantFunction getNullConstant(int columnType) {
        return nullConstants.getQuick(columnType);
    }

    public static TypeConstant getTypeConstant(int columnType) {
        return typeConstants.getQuick(columnType);
    }

    static {
        nullConstants.extendAndSet(4, new IntConstant(0, Integer.MIN_VALUE));
        nullConstants.extendAndSet(10, new StrConstant(0, null));
        nullConstants.extendAndSet(11, new SymbolConstant(0, null, Integer.MIN_VALUE));
        nullConstants.extendAndSet(5, new LongConstant(0, Long.MIN_VALUE));
        nullConstants.extendAndSet(6, new DateConstant(0, Long.MIN_VALUE));
        nullConstants.extendAndSet(7, new TimestampConstant(0, Long.MIN_VALUE));
        nullConstants.extendAndSet(1, new ByteConstant(0, 0));
        nullConstants.extendAndSet(2, new ShortConstant(0, 0));
        nullConstants.extendAndSet(3, new CharConstant(0, '\u0000'));
        nullConstants.extendAndSet(0, new BooleanConstant(0, false));
        nullConstants.extendAndSet(9, new DoubleConstant(0, Double.NaN));
        nullConstants.extendAndSet(8, new FloatConstant(0, Float.NaN));
        nullConstants.extendAndSet(13, new NullBinConstant());
        nullConstants.extendAndSet(12, new Long256NullConstant());
        typeConstants.extendAndSet(4, IntTypeConstant.INSTANCE);
        typeConstants.extendAndSet(10, StrTypeConstant.INSTANCE);
        typeConstants.extendAndSet(11, SymbolTypeConstant.INSTANCE);
        typeConstants.extendAndSet(5, LongTypeConstant.INSTANCE);
        typeConstants.extendAndSet(6, DateTypeConstant.INSTANCE);
        typeConstants.extendAndSet(7, TimestampTypeConstant.INSTANCE);
        typeConstants.extendAndSet(1, ByteTypeConstant.INSTANCE);
        typeConstants.extendAndSet(2, ShortTypeConstant.INSTANCE);
        typeConstants.extendAndSet(3, CharTypeConstant.INSTANCE);
        typeConstants.extendAndSet(0, BooleanTypeConstant.INSTANCE);
        typeConstants.extendAndSet(9, DoubleTypeConstant.INSTANCE);
        typeConstants.extendAndSet(8, FloatTypeConstant.INSTANCE);
        typeConstants.extendAndSet(13, BinTypeConstant.INSTANCE);
        typeConstants.extendAndSet(12, Long256TypeConstant.INSTANCE);
    }
}

