/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.constants;

import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.griffin.engine.functions.constants.ConstantFunction;
import io.questdb.std.Chars;

public class StrConstant
extends StrFunction
implements ConstantFunction {
    public static final StrConstant NULL = new StrConstant(0, null);
    private final String value;
    private final int length;

    public StrConstant(int position, CharSequence value) {
        super(position);
        if (value == null) {
            this.value = null;
            this.length = -1;
        } else {
            this.value = Chars.startsWith(value, '\'') ? Chars.toString(value, 1, value.length() - 1) : Chars.toString(value);
            this.length = this.value.length();
        }
    }

    @Override
    public CharSequence getStr(Record rec) {
        return this.value;
    }

    @Override
    public CharSequence getStrB(Record rec) {
        return this.value;
    }

    @Override
    public int getStrLen(Record rec) {
        return this.length;
    }
}

