/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.constants;

import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.griffin.engine.functions.constants.ConstantFunction;
import io.questdb.std.Chars;

public class SymbolConstant
extends SymbolFunction
implements ConstantFunction {
    private final String value;
    private final int index;

    public SymbolConstant(int position, CharSequence value, int index) {
        super(position);
        if (value == null) {
            this.value = null;
            this.index = Integer.MIN_VALUE;
        } else {
            this.value = Chars.startsWith(value, '\'') ? Chars.toString(value, 1, value.length() - 1) : Chars.toString(value);
            this.index = index;
        }
    }

    @Override
    public boolean isSymbolTableStatic() {
        return false;
    }

    @Override
    public int getInt(Record rec) {
        return this.index;
    }

    @Override
    public CharSequence getSymbol(Record rec) {
        return this.value;
    }

    @Override
    public CharSequence getSymbolB(Record rec) {
        return this.value;
    }

    @Override
    public CharSequence valueOf(int symbolKey) {
        return this.value;
    }

    @Override
    public CharSequence valueBOf(int key) {
        return this.value;
    }
}

