/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.microtime.Timestamps;

public class IsLeapYearFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "is_leap_year(N)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function arg = args.getQuick(0);
        return new Func(position, arg);
    }

    private static final class Func
    extends BooleanFunction
    implements UnaryFunction {
        private final Function arg;

        public Func(int position, Function arg) {
            super(position);
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            long value = this.arg.getTimestamp(rec);
            if (value == Long.MIN_VALUE) {
                return Boolean.FALSE;
            }
            int year = Timestamps.getYear(value);
            return Timestamps.isLeapYear(year);
        }
    }
}

