/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.std.ObjList;

public class NowFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "now()";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new Func(position);
    }

    private static class Func
    extends TimestampFunction
    implements Function {
        private SqlExecutionContext context;

        public Func(int position) {
            super(position);
        }

        @Override
        public long getTimestamp(Record rec) {
            return this.context.getNow();
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
            executionContext.initNow();
            this.context = executionContext;
        }

        @Override
        public boolean isRuntimeConstant() {
            return true;
        }
    }
}

