/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.microtime.MicrosecondClock;

public class SystimestampFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "systimestamp()";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new Func(position, configuration.getMicrosecondClock());
    }

    private static class Func
    extends TimestampFunction
    implements Function {
        private final MicrosecondClock clock;

        public Func(int position, MicrosecondClock clock) {
            super(position);
            this.clock = clock;
        }

        @Override
        public long getTimestamp(Record rec) {
            return this.clock.getTicks();
        }
    }
}

