/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.TernaryFunction;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.TimestampConstant;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.microtime.Timestamps;

public class TimestampAddFunctionFactory
implements FunctionFactory {
    private static final ObjList<LongAddIntFunction> addFunctions = new ObjList();
    private static final int addFunctionsMax;

    @Override
    public String getSignature() {
        return "dateadd(AIN)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function period = args.getQuick(0);
        Function interval = args.getQuick(1);
        if (period.isConstant()) {
            LongAddIntFunction func;
            char periodValue = period.getChar(null);
            if (periodValue < addFunctionsMax && (func = addFunctions.getQuick(periodValue)) != null) {
                if (interval.isConstant()) {
                    if (interval.getInt(null) != Integer.MIN_VALUE) {
                        return new AddLongIntVarConstFunction(position, args.getQuick(2), interval.getInt(null), func);
                    }
                    return new TimestampConstant(position, Long.MIN_VALUE);
                }
                return new AddLongIntVarVarFunction(position, args.getQuick(2), args.getQuick(1), func);
            }
            return new TimestampConstant(position, Long.MIN_VALUE);
        }
        return new DateAddFunc(position, args.getQuick(2), args.getQuick(0), args.getQuick(1));
    }

    static {
        addFunctions.extendAndSet(115, Timestamps::addSeconds);
        addFunctions.extendAndSet(109, Timestamps::addMinutes);
        addFunctions.extendAndSet(104, Timestamps::addHours);
        addFunctions.extendAndSet(100, Timestamps::addDays);
        addFunctions.extendAndSet(119, Timestamps::addWeeks);
        addFunctions.extendAndSet(77, Timestamps::addMonths);
        addFunctions.extendAndSet(121, Timestamps::addYear);
        addFunctionsMax = addFunctions.size();
    }

    private static class DateAddFunc
    extends TimestampFunction
    implements TernaryFunction {
        final Function left;
        final Function center;
        final Function right;

        public DateAddFunc(int position, Function left, Function center, Function right) {
            super(position);
            this.left = left;
            this.center = center;
            this.right = right;
        }

        @Override
        public Function getLeft() {
            return this.left;
        }

        @Override
        public Function getCenter() {
            return this.center;
        }

        @Override
        public Function getRight() {
            return this.right;
        }

        @Override
        public long getTimestamp(Record rec) {
            long l = this.left.getTimestamp(rec);
            char c = this.center.getChar(rec);
            int r = this.right.getInt(rec);
            if (l == Long.MIN_VALUE || r == Integer.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            return Timestamps.addPeriod(l, c, r);
        }
    }

    private static class AddLongIntVarConstFunction
    extends TimestampFunction
    implements UnaryFunction {
        private final Function arg;
        private final int interval;
        private final LongAddIntFunction func;

        public AddLongIntVarConstFunction(int position, Function left, int right, LongAddIntFunction func) {
            super(position);
            this.arg = left;
            this.interval = right;
            this.func = func;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public long getTimestamp(Record rec) {
            long l = this.arg.getTimestamp(rec);
            if (l == Long.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            return this.func.add(l, this.interval);
        }
    }

    private static class AddLongIntVarVarFunction
    extends TimestampFunction
    implements BinaryFunction {
        private final Function left;
        private final Function right;
        private final LongAddIntFunction func;

        public AddLongIntVarVarFunction(int position, Function left, Function right, LongAddIntFunction func) {
            super(position);
            this.left = left;
            this.right = right;
            this.func = func;
        }

        @Override
        public Function getLeft() {
            return this.left;
        }

        @Override
        public Function getRight() {
            return this.right;
        }

        @Override
        public long getTimestamp(Record rec) {
            long l = this.left.getTimestamp(rec);
            int r = this.right.getInt(rec);
            if (l == Long.MIN_VALUE || r == Integer.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            return this.func.add(l, r);
        }
    }

    @FunctionalInterface
    private static interface LongAddIntFunction {
        public long add(long var1, int var3);
    }
}

