/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.griffin.engine.functions.constants.TimestampConstant;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;

public class TimestampShuffleFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "timestamp_shuffle(nn)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        long start = args.getQuick(0).getTimestamp(null);
        long end = args.getQuick(1).getTimestamp(null);
        if (start == Long.MIN_VALUE || end == Long.MIN_VALUE) {
            return new TimestampConstant(args.getQuick(0).getPosition(), Long.MIN_VALUE);
        }
        return new TimestampShuffleFunction(position, start, end);
    }

    private static class TimestampShuffleFunction
    extends TimestampFunction {
        private final long start;
        private final long end;
        private Rnd rnd;

        public TimestampShuffleFunction(int position, long start, long end) {
            super(position);
            this.start = start;
            this.end = end;
        }

        @Override
        public void close() {
        }

        @Override
        public long getTimestamp(Record rec) {
            return this.start + this.rnd.nextPositiveLong() % (this.end - this.start);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
            this.rnd = executionContext.getRandom();
        }

        @Override
        public void toTop() {
            this.rnd.reset();
        }
    }
}

