/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.DateFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.datetime.DateLocale;
import io.questdb.std.datetime.millitime.DateFormatCompiler;

public class ToDateFunctionFactory
implements FunctionFactory {
    private static final ThreadLocal<DateFormatCompiler> tlCompiler = ThreadLocal.withInitial(DateFormatCompiler::new);

    @Override
    public String getSignature() {
        return "to_date(Ss)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function arg = args.getQuick(0);
        CharSequence pattern = args.getQuick(1).getStr(null);
        if (pattern == null) {
            throw SqlException.$(args.getQuick(1).getPosition(), "pattern is required");
        }
        return new ToDateFunction(position, arg, tlCompiler.get().compile(pattern), configuration.getDefaultDateLocale());
    }

    private static final class ToDateFunction
    extends DateFunction
    implements UnaryFunction {
        private final Function arg;
        private final DateFormat dateFormat;
        private final DateLocale locale;

        public ToDateFunction(int position, Function arg, DateFormat dateFormat, DateLocale locale) {
            super(position);
            this.arg = arg;
            this.dateFormat = dateFormat;
            this.locale = locale;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public long getDate(Record rec) {
            CharSequence value = this.arg.getStr(rec);
            try {
                if (value != null) {
                    return this.dateFormat.parse(value, this.locale);
                }
            }
            catch (NumericException numericException) {
                // empty catch block
            }
            return Long.MIN_VALUE;
        }
    }
}

