/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.microtime.TimestampFormatUtils;

public class ToTimestampFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "to_timestamp(S)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function arg = args.getQuick(0);
        return new ToTimestampFunction(position, arg);
    }

    public static final class ToTimestampFunction
    extends TimestampFunction
    implements UnaryFunction {
        private final Function arg;

        public ToTimestampFunction(int position, Function arg) {
            super(position);
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public long getTimestamp(Record rec) {
            CharSequence value = this.arg.getStr(rec);
            try {
                if (value != null) {
                    return TimestampFormatUtils.PG_TIMESTAMPZ_FORMAT.parse(value, TimestampFormatUtils.enLocale);
                }
            }
            catch (NumericException numericException) {
                // empty catch block
            }
            return Long.MIN_VALUE;
        }
    }
}

